/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import fr.proline.core.orm.msi.dto.DBioSequence;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.util.JsonSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DProteinMatch {
    public static final String OBSERVABLE_PEPTIDE_COUNT_KEY = "observable_peptide_count";
    private long m_id;
    private String m_accession;
    private Float m_score;
    private int m_peptideCount;
    private long m_resultSetId;
    private String m_description;
    private String m_geneName;
    private DBioSequence m_bioSequence = null;
    private Integer m_observablePeptidesCount = null;
    private HashMap<Long, DPeptideSet> peptideSetMap = null;
    private DPeptideMatch[] m_peptideMatches;
    private long[] m_peptideMatchesId;

    public DProteinMatch(long id, String accession, Float score, int peptideCount, long resultSetId, String description, String serializedProperties) {
        this.m_id = id;
        this.m_accession = accession;
        this.m_score = score;
        this.m_peptideCount = peptideCount;
        this.m_resultSetId = resultSetId;
        this.m_description = description;
        this.setObservablePeptidesCountFromSerializedProperties(serializedProperties);
    }

    public DProteinMatch(long id, String accession, Float score, int peptideCount, long resultSetId, String description, String geneName, String serializedProperties) {
        this.m_id = id;
        this.m_accession = accession;
        this.m_score = score;
        this.m_peptideCount = peptideCount;
        this.m_resultSetId = resultSetId;
        this.m_description = description;
        this.m_geneName = geneName;
        this.setObservablePeptidesCountFromSerializedProperties(serializedProperties);
    }

    public DProteinMatch(long id, String accession, Float score, int peptideCount, long resultSetId, String description, String geneName, String serializedProperties, long peptideSetId, Float peptideSetScore, int sequenceCount, int peptideSetPeptideCount, int peptideMatchCount, long resultSummaryId) {
        this.m_id = id;
        this.m_accession = accession;
        this.m_score = score;
        this.m_peptideCount = peptideCount;
        this.m_resultSetId = resultSetId;
        this.m_description = description;
        this.m_geneName = geneName;
        this.setObservablePeptidesCountFromSerializedProperties(serializedProperties);
        DPeptideSet peptideSet = new DPeptideSet(peptideSetId, peptideSetScore.floatValue(), sequenceCount, peptideSetPeptideCount, peptideMatchCount, resultSummaryId);
        this.setPeptideSet(peptideSet.getResultSummaryId(), peptideSet);
    }

    public DProteinMatch(long id, String accession, Float score, int peptideCount, long resultSetId, String description, String serializedProperties, long peptideSetId, Float peptideSetScore, int sequenceCount, int peptideSetPeptideCount, int peptideMatchCount, long resultSummaryId, String pepSetProperties) throws IOException {
        this.m_id = id;
        this.m_accession = accession;
        this.m_score = score;
        this.m_peptideCount = peptideCount;
        this.m_resultSetId = resultSetId;
        this.m_description = description;
        this.setObservablePeptidesCountFromSerializedProperties(serializedProperties);
        DPeptideSet peptideSet = new DPeptideSet(peptideSetId, peptideSetScore.floatValue(), sequenceCount, peptideSetPeptideCount, peptideMatchCount, resultSummaryId, pepSetProperties);
        this.setPeptideSet(peptideSet.getResultSummaryId(), peptideSet);
    }

    private void setObservablePeptidesCountFromSerializedProperties(String serializedProperties) {
        this.m_observablePeptidesCount = null;
        try {
            Object value;
            Map pmqSerializedMap;
            if (serializedProperties != null && (pmqSerializedMap = (Map)JsonSerializer.getMapper().readValue(serializedProperties, Map.class)) != null && (value = pmqSerializedMap.get(OBSERVABLE_PEPTIDE_COUNT_KEY)) != null) {
                this.m_observablePeptidesCount = Integer.parseInt(value.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Integer getObservablePeptidesCount() {
        return this.m_observablePeptidesCount;
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long pId) {
        this.m_id = pId;
    }

    public long getResultSetId() {
        return this.m_resultSetId;
    }

    public String getAccession() {
        return this.m_accession;
    }

    public void setAccession(String accession) {
        this.m_accession = accession;
    }

    public String getGeneName() {
        return this.m_geneName;
    }

    public void setGeneName(String geneName) {
        this.m_geneName = geneName;
    }

    public Float getScore() {
        return this.m_score;
    }

    public int getPeptideCount() {
        return this.m_peptideCount;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDBioSequence(DBioSequence bioSequence) {
        this.m_bioSequence = bioSequence;
    }

    public DBioSequence getDBioSequence() {
        return this.m_bioSequence;
    }

    public boolean isDBiosequenceSet() {
        return this.m_bioSequence != null;
    }

    public DPeptideMatch[] getPeptideMatches() {
        return this.m_peptideMatches;
    }

    public void setPeptideMatches(DPeptideMatch[] peptideMatches) {
        this.m_peptideMatches = peptideMatches;
    }

    public long[] getPeptideMatchesId() {
        return this.m_peptideMatchesId;
    }

    public void setPeptideMatchesId(long[] peptideMatchesId) {
        this.m_peptideMatchesId = peptideMatchesId;
    }

    public DPeptideSet getPeptideSet(Long resultSummaryId) {
        if (this.peptideSetMap == null) {
            return null;
        }
        return this.peptideSetMap.get(resultSummaryId);
    }

    public final void setPeptideSet(Long resultSummaryId, DPeptideSet peptideSet) {
        if (this.peptideSetMap == null) {
            this.peptideSetMap = new HashMap();
        }
        this.peptideSetMap.put(resultSummaryId, peptideSet);
    }
}

