/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.proline.core.orm.uds.PeaklistSoftware;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="spec_title_parsing_rule")
public class SpectrumTitleParsingRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="first_cycle")
    private String firstCycle;
    @Column(name="first_scan")
    private String firstScan;
    @Column(name="first_time")
    private String firstTime;
    @Column(name="last_cycle")
    private String lastCycle;
    @Column(name="last_scan")
    private String lastScan;
    @Column(name="last_time")
    private String lastTime;
    @Column(name="raw_file_identifier")
    private String rawFileIdentifier;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getFirstCycle() {
        return this.firstCycle;
    }

    public void setFirstCycle(String firstCycle) {
        this.firstCycle = firstCycle;
    }

    public String getFirstScan() {
        return this.firstScan;
    }

    public void setFirstScan(String firstScan) {
        this.firstScan = firstScan;
    }

    public String getFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(String firstTime) {
        this.firstTime = firstTime;
    }

    public String getLastCycle() {
        return this.lastCycle;
    }

    public void setLastCycle(String lastCycle) {
        this.lastCycle = lastCycle;
    }

    public String getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(String lastScan) {
        this.lastScan = lastScan;
    }

    public String getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(String lastTime) {
        this.lastTime = lastTime;
    }

    public String getRawFileIdentifier() {
        return this.rawFileIdentifier;
    }

    public void setRawFileIdentifier(String rawFileId) {
        this.rawFileIdentifier = rawFileId;
    }

    public static enum ParsingRule {
        EXTRACT_MSN_RULE(PeaklistSoftware.SoftwareRelease.EXTRACT_MSN, "(.+)\\.\\d+\\.\\d+\\.\\d+\\.dta", null, null, ".+\\.(\\d+)\\.\\d+\\.\\d+\\.dta", ".+\\.\\d+\\.(\\d+)\\.\\d+\\.dta", null, null),
        DATA_ANALYSIS_4_0_RULE(PeaklistSoftware.SoftwareRelease.DATA_ANALYSIS_4_0, null, null, null, null, null, "Cmpd.+MSn.+, (\\d+\\.\\d+) min", "Cmpd.+MSn.+, (\\d+\\.\\d+) min"),
        DATA_ANALYSIS_4_1_RULE(PeaklistSoftware.SoftwareRelease.DATA_ANALYSIS_4_1, null, null, null, "Cmpd.+MS\\d.+, \\d+\\.\\d+ min #(\\d+)", "Cmpd.+MS\\d.+, \\d+\\.\\d+ min #(\\d+)", "Cmpd.+MS\\d.+, (\\d+\\.\\d+) min", "Cmpd.+MS\\d.+, (\\d+\\.\\d+) min"),
        MASCOT_DLL_RULE(PeaklistSoftware.SoftwareRelease.MASCOT_DLL, "^File: (.+?)\\.wiff,", "Cycle\\(s\\): (\\d+) \\(Experiment \\d+\\)||Cycle\\(s\\): (\\d+), \\d+", "Cycle\\(s\\): (\\d+) \\(Experiment \\d+\\)||Cycle\\(s\\): \\d+, (\\d+)", null, null, "Elution: (.+?) to .+? min||.+Elution: (.+?) min", "Elution: .+? to (.+?) min||.+Elution: (.+?) min"),
        MASCOT_DISTILLER_RULE(PeaklistSoftware.SoftwareRelease.MASCOT_DISTILLER, "\\[.+\\\\(.+?)\\..+\\]", null, null, "in range (\\d+) \\(rt=||Scan (\\d+) \\(rt=", "\\) to (\\d+) \\(rt=||Scan (\\d+) \\(rt=", "in range \\d+ \\(rt=(\\d+.\\d+)\\)||\\(rt=(\\d+.\\d+)\\)", "\\) to \\d+ \\(rt=(\\d+.\\d+)\\)||\\(rt=(\\d+.\\d+)\\)"),
        MAX_QUANT_RULE(PeaklistSoftware.SoftwareRelease.MAX_QUANT, "^RawFile: (.+?) FinneganScanNumber:", null, null, "FinneganScanNumber: (\\d+)", "FinneganScanNumber: (\\d+)", null, null),
        PROLINE_RULE(PeaklistSoftware.SoftwareRelease.PROLINE, "raw_file_identifier:(\\w+?);", "first_cycle:(\\d+);", "last_cycle:(\\d+);", "first_scan:(\\d+);", "last_scan:(\\d+);", "first_time:(\\d+\\.\\d+);", "last_time:(\\d+\\.\\d+);"),
        PROTEIN_PILOT_RULE(PeaklistSoftware.SoftwareRelease.PROTEIN_PILOT, "File:\"(\\w+)\\.wiff\"", "Locus:\\d\\.\\d\\.\\d\\.(\\d+)\\.\\d+ File:", "Locus:\\d\\.\\d\\.\\d\\.(\\d+)\\.\\d+ File:", null, null, null, null),
        PROTEOME_DISCOVER_RULE(PeaklistSoftware.SoftwareRelease.PROTEOME_DISCOVER, null, null, null, "scans:.*?(\\d+),", "scans:.*?(\\d+),", null, null),
        PROTEO_WIZARD_2_0_RULE(PeaklistSoftware.SoftwareRelease.PROTEO_WIZARD_2_0, null, null, null, "scan=(\\d+)", "scan=(\\d+)", null, null),
        PROTEO_WIZARD_2_1_RULE(PeaklistSoftware.SoftwareRelease.PROTEO_WIZARD_2_1, "(.+)\\.\\d+\\.\\d+\\.\\d+$", null, null, ".+\\.(\\d+)\\.\\d+\\.\\d+$", ".+\\.\\d+\\.(\\d+)\\.\\d+$", null, null),
        PROTEO_WIZARD_3_0_RULE(PeaklistSoftware.SoftwareRelease.PROTEO_WIZARD_3_0, "File:\"(.+?)\\..+\",", null, null, "scan=(\\d+)", "scan=(\\d+)", null, null),
        SPECTRUM_MILL_RULE(PeaklistSoftware.SoftwareRelease.SPECTRUM_MILL, null, null, null, null, null, "Cmpd.+MSn.+, (\\d+\\.\\d+) min", "Cmpd.+MSn.+, (\\d+\\.\\d+) min"),
        MGFBOOST_RULE(PeaklistSoftware.SoftwareRelease.MGF_BOOST, "raw_file_identifier:(\\w+?);", "first_cycle:(\\d+);", "last_cycle:(\\d+);", "first_scan:(\\d+);", "last_scan:(\\d+);", "first_time:(\\d+\\.\\d+);", "last_time:(\\d+\\.\\d+);");

        private final PeaklistSoftware.SoftwareRelease m_peaklistSoftware;
        private final String m_rawFileIdentifierRegex;
        private final String m_firstCycleRegex;
        private final String m_lastCycleRegex;
        private final String m_firstScanRegex;
        private final String m_lastScanRegex;
        private final String m_firstTimeRegex;
        private final String m_lastTimeRegex;

        private ParsingRule(PeaklistSoftware.SoftwareRelease peaklistSoftware, String rawFileIdentifierRegex, String firstCycleRegex, String lastCycleRegex, String firstScanRegex, String lastScanRegex, String firstTimeRegex, String lastTimeRegex) {
            this.m_peaklistSoftware = peaklistSoftware;
            this.m_rawFileIdentifierRegex = rawFileIdentifierRegex;
            this.m_firstCycleRegex = firstCycleRegex;
            this.m_lastCycleRegex = lastCycleRegex;
            this.m_firstScanRegex = firstScanRegex;
            this.m_lastScanRegex = lastScanRegex;
            this.m_firstTimeRegex = firstTimeRegex;
            this.m_lastTimeRegex = lastTimeRegex;
        }

        public PeaklistSoftware.SoftwareRelease getPeaklistSoftware() {
            return this.m_peaklistSoftware;
        }

        public String getRawFileIdentifierRegex() {
            return this.m_rawFileIdentifierRegex;
        }

        public String getFirstCycleRegex() {
            return this.m_firstCycleRegex;
        }

        public String getLastCycleRegex() {
            return this.m_lastCycleRegex;
        }

        public String getFirstScanRegex() {
            return this.m_firstScanRegex;
        }

        public String getLastScanRegex() {
            return this.m_lastScanRegex;
        }

        public String getFirstTimeRegex() {
            return this.m_firstTimeRegex;
        }

        public String getLastTimeRegex() {
            return this.m_lastTimeRegex;
        }

        public String toString() {
            return this.name();
        }
    }
}

