/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.dto;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.MapAlignmentPK;
import fr.proline.core.orm.lcms.MapTime;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.ObjectTree;
import fr.proline.core.orm.uds.ObjectTreeSchema;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.util.JsonSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DDataset {
    private long m_id;
    private Project m_project;
    private String m_name;
    private String m_description;
    private int m_number;
    private int m_childrenCount;
    private Long m_resultSetId;
    private Long m_resultSummaryId;
    private ResultSummary m_resultSummary = null;
    private ResultSet m_resultSet = null;
    private DDatasetType m_type = null;
    private List<DMasterQuantitationChannel> m_masterQuantitationChannels;
    private List<MapAlignment> m_mapAlignments;
    private List<MapAlignment> m_mapReversedAlignments;
    private List<ProcessedMap> m_maps;
    private Long m_alnReferenceMapId;
    private ObjectTree m_postQuantProcessingConfig;
    private ObjectTree m_quantProcessingConfig;
    private ObjectTree m_lowlevelConfig;
    private Map<String, Object> postQuantProcessingConfigMap;
    private Map<String, Object> quantProcessingConfigMap;
    private Map<String, Object> m_lowlevelConfigMap;
    private GroupSetup groupSetup;

    public DDataset(long id, Project project, String name, Dataset.DatasetType type, int childrenCount, Long resultSetId, Long resultSummaryId, int number) {
        this.m_id = id;
        this.m_project = project;
        this.m_name = name;
        this.m_childrenCount = childrenCount;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_number = number;
        this.m_type = new DDatasetType(this, type, null, null);
    }

    public long getId() {
        return this.m_id;
    }

    public Project getProject() {
        return this.m_project;
    }

    public DDatasetType getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public int getChildrenCount() {
        return this.m_childrenCount;
    }

    public void setChildrenCount(int childrenCount) {
        this.m_childrenCount = childrenCount;
    }

    public Long getResultSetId() {
        return this.m_resultSetId;
    }

    public void setResultSetId(Long resultSetId) {
        this.m_resultSetId = resultSetId;
    }

    public Long getResultSummaryId() {
        return this.m_resultSummaryId;
    }

    public void setResultSummaryId(Long resultSummaryId) {
        this.m_resultSummaryId = resultSummaryId;
    }

    public int getNumber() {
        return this.m_number;
    }

    public boolean isIdentification() {
        return this.m_type.isIdentification();
    }

    public boolean isQuantitation() {
        return this.m_type.isQuantitation();
    }

    public boolean isTrash() {
        return this.m_type.isTrash();
    }

    public boolean isFolder() {
        return this.m_type.isFolder();
    }

    public boolean isAggregation() {
        return this.m_type.isAggregation();
    }

    public void setAggregation(Aggregation aggregation) {
        this.m_type.setAggregation(aggregation);
    }

    public Aggregation getAggregation() {
        return this.m_type.getAggregation();
    }

    public DDatasetType.AggregationInformation getAggregationInformation() {
        return this.m_type.getAggregationInformation();
    }

    public void setAggregationInformation(DDatasetType.AggregationInformation aggregationInformation) {
        this.m_type.setAggregationInformation(aggregationInformation);
    }

    public DDatasetType.QuantitationMethodInfo getQuantMethodInfo() {
        return this.m_type.getQuantMethodInfo();
    }

    public QuantitationMethod getQuantitationMethod() {
        return this.m_type.getQuantitationMethod();
    }

    public void setQuantitationMethod(QuantitationMethod quantitationMethod) {
        this.m_type.setQuantitationMethod(quantitationMethod);
    }

    public ResultSummary getResultSummary() {
        return this.m_resultSummary;
    }

    public void setResultSummary(ResultSummary resultSummary) {
        this.m_resultSummary = resultSummary;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.m_resultSet = resultSet;
    }

    public List<DMasterQuantitationChannel> getMasterQuantitationChannels() {
        return this.m_masterQuantitationChannels;
    }

    public void setMasterQuantitationChannels(List<DMasterQuantitationChannel> masterQuantitationChannels) {
        this.m_masterQuantitationChannels = masterQuantitationChannels;
    }

    public void setObjectTree(ObjectTree ot) {
        if (ot != null) {
            if (ot.getSchema().getName().equalsIgnoreCase(ObjectTreeSchema.SchemaName.POST_QUANT_PROCESSING_CONFIG.getKeyName())) {
                this.m_postQuantProcessingConfig = ot;
                this.postQuantProcessingConfigMap = null;
            } else if (ot.getSchema().getName().equalsIgnoreCase(ObjectTreeSchema.SchemaName.PROLINE_LOW_LEVEL_CONFIG.getKeyName())) {
                this.m_lowlevelConfig = ot;
                this.m_lowlevelConfigMap = null;
            } else if (ot.getSchema().getName().startsWith("quantitation")) {
                this.m_quantProcessingConfig = ot;
                this.quantProcessingConfigMap = null;
            }
        }
    }

    public ObjectTree getPostQuantProcessingConfig() {
        return this.m_postQuantProcessingConfig;
    }

    public ObjectTree getQuantProcessingConfig() {
        return this.m_quantProcessingConfig;
    }

    public ObjectTree getQuantLowLevelConfig() {
        return this.m_lowlevelConfig;
    }

    public Map<String, Object> getPostQuantProcessingConfigAsMap() throws Exception {
        if (this.postQuantProcessingConfigMap == null && this.m_postQuantProcessingConfig != null) {
            this.postQuantProcessingConfigMap = (Map)JsonSerializer.getMapper().readValue(this.getPostQuantProcessingConfig().getClobData(), Map.class);
        }
        return this.postQuantProcessingConfigMap;
    }

    public String getQuantLowLevelConfigAsString() throws Exception {
        if (this.m_lowlevelConfigMap == null && this.m_lowlevelConfig != null) {
            Config c = ConfigFactory.parseString((String)this.m_lowlevelConfig.getClobData());
            return c.root().render(ConfigRenderOptions.concise());
        }
        return "";
    }

    public Map<String, Object> getQuantLowLevelConfigAsMap() throws Exception {
        if (this.m_lowlevelConfigMap == null && this.m_lowlevelConfig != null) {
            Config c = ConfigFactory.parseString((String)this.m_lowlevelConfig.getClobData());
            String conciseStr = c.root().render(ConfigRenderOptions.concise());
            this.m_lowlevelConfigMap = (Map)JsonSerializer.getMapper().readValue(conciseStr, Map.class);
        }
        return this.m_lowlevelConfigMap;
    }

    public Map<String, Object> getQuantProcessingConfigAsMap() throws Exception {
        if (this.quantProcessingConfigMap == null && this.m_quantProcessingConfig != null) {
            this.quantProcessingConfigMap = (Map)JsonSerializer.getMapper().readValue(this.getQuantProcessingConfig().getClobData(), Map.class);
        }
        return this.quantProcessingConfigMap;
    }

    public GroupSetup getGroupSetup() {
        return this.groupSetup;
    }

    public void setGroupSetup(GroupSetup groupSetup) {
        this.groupSetup = groupSetup;
    }

    public Long getAlnReferenceMapId() {
        return this.m_alnReferenceMapId;
    }

    public void setAlnReferenceMapId(Long alnReferenceMapId) {
        this.m_alnReferenceMapId = alnReferenceMapId;
    }

    public List<MapAlignment> getMapAlignments() {
        return this.m_mapAlignments;
    }

    public void setMapAlignments(List<MapAlignment> allMapAlignments) {
        this.m_mapAlignments = allMapAlignments;
        this.updateReversedAlignments();
    }

    public void clearMapAlignments() {
        this.m_mapAlignments = null;
        this.m_mapReversedAlignments = null;
        this.m_alnReferenceMapId = -1L;
    }

    public List<ProcessedMap> getMaps() {
        return this.m_maps;
    }

    public void setMaps(List<ProcessedMap> allMaps) {
        this.m_maps = allMaps;
    }

    private void updateReversedAlignments() {
        this.m_mapReversedAlignments = new ArrayList<MapAlignment>();
        for (MapAlignment ma : this.m_mapAlignments) {
            MapAlignment reversedMap = new MapAlignment();
            MapAlignmentPK mapKey = new MapAlignmentPK();
            mapKey.setFromMapId(ma.getDestinationMap().getId());
            mapKey.setToMapId(ma.getSourceMap().getId());
            mapKey.setMassStart(ma.getId().getMassStart());
            mapKey.setMassEnd(ma.getId().getMassEnd());
            reversedMap.setId(mapKey);
            reversedMap.setDestinationMap(ma.getSourceMap());
            reversedMap.setSourceMap(ma.getDestinationMap());
            reversedMap.setMapSet(ma.getMapSet());
            int nbLandmarks = ma.getMapTimeList().size();
            Object[] revTimeList = new Double[nbLandmarks];
            Object[] revDeltaTimeList = new Double[nbLandmarks];
            ArrayList<MapTime> revMapTimeList = new ArrayList<MapTime>();
            for (int i = 0; i < nbLandmarks; ++i) {
                MapTime mapTime = ma.getMapTimeList().get(i);
                Double deltaTime = mapTime.getDeltaValue();
                Double targetMapTime = mapTime.getTime() + deltaTime;
                revTimeList[i] = targetMapTime;
                revDeltaTimeList[i] = -deltaTime.doubleValue();
                MapTime rmp = new MapTime((Double)revTimeList[i], (Double)revDeltaTimeList[i]);
                revMapTimeList.add(rmp);
            }
            String deltaS = StringUtils.join((Object[])revDeltaTimeList, (String)" ");
            String timeS = StringUtils.join((Object[])revTimeList, (String)" ");
            reversedMap.setMapTimeList(revMapTimeList);
            reversedMap.setDeltaTimeList(deltaS);
            reversedMap.setTimeList(timeS);
            reversedMap.setSerializedProperties(ma.getSerializedProperties());
            this.m_mapReversedAlignments.add(reversedMap);
        }
    }

    public List<MapAlignment> getMapReversedAlignments() {
        return this.m_mapReversedAlignments;
    }

    public List<MapAlignment> getMapAlignmentsFromMap(Long mapId) {
        ArrayList<MapAlignment> list = new ArrayList<MapAlignment>();
        for (MapAlignment ma : this.m_mapAlignments) {
            if (!ma.getSourceMap().getId().equals(mapId)) continue;
            list.add(ma);
        }
        for (MapAlignment ma : this.m_mapReversedAlignments) {
            if (!ma.getSourceMap().getId().equals(mapId)) continue;
            list.add(ma);
        }
        return list;
    }
}

