/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.proline.core.orm.uds.Dataset;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public final class DatasetRepository {
    private DatasetRepository() {
    }

    public static List<Dataset> findDatasetsByProject(EntityManager udsEm, long projectId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findDatasetByProject", Dataset.class);
        query.setParameter("id", (Object)projectId);
        return query.getResultList();
    }

    public static List<Dataset> findRootDatasetsByProject(EntityManager udsEm, long projectId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findRootDatasetByProject", Dataset.class);
        query.setParameter("id", (Object)projectId);
        return query.getResultList();
    }

    public static List<String> findDatasetNamesByProject(EntityManager udsEm, long projectId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findDatasetNamesByProject", String.class);
        query.setParameter("id", (Object)projectId);
        return query.getResultList();
    }

    public static List<String> findRootDatasetNamesByProject(EntityManager udsEm, long projectId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findRootDatasetNamesByProject", String.class);
        query.setParameter("id", (Object)projectId);
        return query.getResultList();
    }

    public static Dataset findDatasetByNameAndProject(EntityManager udsEm, long projectId, String name) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findDatasetByNameAndProject", Dataset.class);
        query.setParameter("id", (Object)projectId);
        query.setParameter("name", (Object)name);
        return (Dataset)query.getSingleResult();
    }

    public static Dataset findRootDatasetByNameAndProject(EntityManager udsEm, long projectId, String name) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findRootDatasetByNameAndProject", Dataset.class);
        query.setParameter("id", (Object)projectId);
        query.setParameter("name", (Object)name);
        return (Dataset)query.getSingleResult();
    }
}

