/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscShift2
extends Discrepancy {
    protected static double[] setC(double gam) {
        double[] C = new double[2];
        double v = gam * gam;
        C[0] = 0.5 * v;
        v *= v;
        C[1] = v / 12.0;
        return C;
    }

    protected static void setC(double[] C1, double[] C2, double[] gam, int s) {
        for (int i = 0; i < s; ++i) {
            double v = gam[i] * gam[i];
            C1[i] = 0.5 * v;
            v *= v;
            C2[i] = v / 12.0;
        }
    }

    public DiscShift2(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShift2(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShift2(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShift2(PointSet set) {
        super(set);
    }

    public DiscShift2() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShift2.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double[] C1 = new double[s];
        double[] C2 = new double[s];
        DiscShift2.setC(C1, C2, gamma, s);
        double pol1 = 0.16666666666666666;
        double pol2 = -0.03333333333333333;
        double prod = 1.0;
        for (int r = 0; r < s; ++r) {
            prod *= 1.0 + C1[r] * pol1 - C2[r] * pol2;
        }
        double disc = prod / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                prod = 1.0;
                for (int r = 0; r < s; ++r) {
                    double u = points[i][r] - points[j][r];
                    if (u < 0.0) {
                        u += 1.0;
                    }
                    pol1 = u * (u - 1.0) + 0.16666666666666666;
                    pol2 = ((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333;
                    prod *= 1.0 + C1[r] * pol1 - C2[r] * pol2;
                }
                sum += prod;
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n) - 1.0) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        return this.compute(T, n, 1.0);
    }

    @Override
    public double compute(double[] T, int n, double gamma) {
        double pol1 = 0.16666666666666666;
        double pol2 = -0.03333333333333333;
        double[] C = DiscShift2.setC(gamma);
        double C1 = C[0];
        double C2 = C[1];
        double disc = (C1 * pol1 - C2 * pol2) / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double u = T[i] - T[j];
                if (u < 0.0) {
                    u += 1.0;
                }
                pol1 = u * (u - 1.0) + 0.16666666666666666;
                pol2 = ((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333;
                sum += C1 * pol1 - C2 * pol2;
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

