/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map.control;

import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.control.AbstractLcMsViewerManipulator;
import fr.proline.mzscope.map.control.LcMsViewerController;
import fr.proline.studio.utils.IconManager;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class LcMsViewerNavigateManipulator
extends AbstractLcMsViewerManipulator {
    private int clickX = -1;
    private int clickY = -1;
    private int clickWidth = -1;
    private int clickHeight = -1;
    private LcMsViewport clickViewport = null;
    private JToggleButton button = null;
    private ImageIcon navigateIcon = IconManager.getIcon((IconManager.IconType)IconManager.IconType.NAVIGATE);
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor moveCursor = Cursor.getPredefinedCursor(13);

    public LcMsViewerNavigateManipulator(LcMsViewerController controller) {
        super(controller);
    }

    @Override
    public JToggleButton getUIButton() {
        if (this.button == null) {
            this.button = new JToggleButton();
            this.button.setIcon(this.navigateIcon);
        }
        return this.button;
    }

    @Override
    public void paintComponent(Graphics2D g) {
        if (this.isInteractive()) {
            this.getDrawingPanel().setCursor(moveCursor);
        } else {
            this.getDrawingPanel().setCursor(handCursor);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double wheel = e.getPreciseWheelRotation();
        double scale = 1.0 + wheel / 5.0;
        Point2D centerValues = this.getController().getUI().getDisplayViewport().pixel2value(e.getX(), e.getY(), this.getController().getUI().getCanvas().getWidth(), this.getController().getUI().getCanvas().getHeight());
        this.getController().getUI().setDisplayViewport(this.getController().getUI().getDisplayViewport().centerScale(centerValues.getX(), centerValues.getY(), scale, scale));
        this.getController().changeViewport(this.getController().getUI().getDisplayViewport());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.clickViewport = new LcMsViewport(this.getController().getUI().getDisplayViewport());
        this.clickX = e.getX();
        this.clickY = e.getY();
        this.clickWidth = this.getController().getUI().getCanvas().getWidth();
        this.clickHeight = this.getController().getUI().getCanvas().getHeight();
        this.setInteractive(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.clickViewport != null) {
            this.clickViewport = null;
            this.setInteractive(false);
            this.getController().changeViewport(this.getController().getUI().getDisplayViewport());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.clickViewport != null) {
            int x = e.getX();
            int y = e.getY();
            double tRt = (double)(this.clickX - x) / (double)this.clickWidth * (this.clickViewport.maxRt - this.clickViewport.minRt);
            double tMz = (double)(this.clickY - y) / (double)this.clickHeight * (this.clickViewport.maxMz - this.clickViewport.minMz);
            this.getController().getUI().setDisplayViewport(this.clickViewport.translate(tMz, tRt));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getController().getUI().updateMouseInformationUI(e.getX(), e.getY());
    }
}

