/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class WeightedDotProductScorer
implements Scorer {
    private static final Logger logger = LoggerFactory.getLogger(WeightedDotProductScorer.class);
    private static final int MAX_SCORED_ISOTOPES = 8;

    @Override
    public Tuple2<Double, TheoreticalIsotopePattern> score(SpectrumData currentSpectrum, double intialMz, int shift, int charge, double initialPpmTol) {
        double score = 0.0;
        double ppmTol = initialPpmTol;
        double mz = intialMz - (double)shift * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)mz, (int)charge);
        double scale = currentSpectrum.getIntensityList()[SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), intialMz)] / ((Float)pattern.mzAbundancePairs()[shift]._2).floatValue();
        Double ipMoz = mz;
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        for (int rank = 0; rank < pattern.mzAbundancePairs().length; ++rank) {
            ipMoz = rank == 0 ? ipMoz : ipMoz + IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), ipMoz);
            observed[rank] = 1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol ? (double)currentSpectrum.getIntensityList()[nearestPeakIdx] : (double)(-((Float)pattern.mzAbundancePairs()[rank]._2).floatValue()) * scale;
            expected[rank] = ((Float)pattern.mzAbundancePairs()[rank]._2).floatValue();
        }
        score = WeightedDotProductScorer.dotProduct(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)score, (Object)pattern);
    }

    public static double dotProduct(double[] observed, double[] expected) {
        int k;
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double dotProduct = 0.0;
        double sumWeight = 0.0;
        double[] weight = new double[]{0.25, 0.25, 0.25, 0.08, 0.06, 0.05, 0.04, 0.02};
        for (k = 0; k < Math.min(observed.length, 8); ++k) {
            sumWeight += weight[k];
        }
        for (k = 0; k < Math.min(observed.length, 8); ++k) {
            weight[k] = weight[k] / sumWeight;
            dotProduct += observed[k] * expected[k] * weight[k];
            sumExpected += expected[k] * expected[k] * weight[k];
            sumObserved += observed[k] * observed[k] * weight[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : dotProduct / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }
}

