/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.ui.ChromatogramPanel;
import fr.proline.mzscope.ui.IRawFileLoading;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.SpectrumPanel;
import fr.proline.mzscope.ui.WrappedChromatogramPanel;
import fr.proline.mzscope.ui.event.AxisRangeChromatogramListener;
import fr.proline.mzscope.utils.ButtonTabComponent;
import fr.proline.mzscope.utils.Display;
import fr.proline.mzscope.utils.MzScopeCallback;
import fr.proline.studio.tabs.IWrappedPanel;
import fr.proline.studio.tabs.TabsPanel;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedMultiRawFilePanel
extends JPanel
implements IRawFileViewer {
    private static final Logger logger = LoggerFactory.getLogger(TabbedMultiRawFilePanel.class);
    private JSplitPane splitPane;
    private TabsPanel chromatogramContainerPanel;
    private ChromatogramPanel currentChromatogramPanel;
    protected SpectrumPanel spectrumContainerPanel;
    protected Spectrum currentScan;
    private Display.Mode xicDisplayMode = Display.Mode.REPLACE;
    private JToolBar m_toolbarPanel;
    private JPanel m_multiRawFilePanel;
    private JButton m_buttonLayout;
    private JButton m_buttonZoom;
    private JToggleButton overlayBtn;
    private JToggleButton showMS2EventsButton;
    private static final String tooltipForceZoom = "Synchronize zoom on all plots";
    private static final String tooltipZoom = "Remove zoom synchronization on all plots";
    private final List<IRawFile> rawfiles;
    private final Map<IRawFile, IChromatogram> mapChromatogramForRawFile;
    private final Map<IRawFile, IRawFileLoading> mapRawFileLoading;
    private boolean isZoomSynchronized = true;
    private Double relativeXValue = Double.NaN;
    private Double zoomXLevel = Double.NaN;
    private Double relativeYValue = Double.NaN;
    private Double zoomYLevel = Double.NaN;
    private boolean forceFittedToCentroid;

    public TabbedMultiRawFilePanel(List<IRawFile> rawfiles) {
        this.rawfiles = rawfiles;
        this.mapChromatogramForRawFile = new HashMap<IRawFile, IChromatogram>();
        this.mapRawFileLoading = new HashMap<IRawFile, IRawFileLoading>();
        for (IRawFile rawFile : rawfiles) {
            this.mapChromatogramForRawFile.put(rawFile, null);
        }
        this.initComponents();
        this.spectrumContainerPanel.initComponents();
        this.displayTIC();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSplitPane(), "Center");
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setDividerLocation(160);
            this.splitPane.setOrientation(0);
            this.splitPane.setResizeWeight(0.5);
            this.splitPane.setCursor(new Cursor(0));
            this.splitPane.setDoubleBuffered(true);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setTopComponent(this.getMultiRawFilePanel());
            this.splitPane.setBottomComponent(this.getSpectrumContainerPanel());
        }
        return this.splitPane;
    }

    private JPanel getMultiRawFilePanel() {
        if (this.m_multiRawFilePanel == null) {
            this.m_multiRawFilePanel = new JPanel();
            this.m_multiRawFilePanel.setLayout(new BorderLayout());
            this.m_multiRawFilePanel.add((Component)this.getChromatogramContainerPanel(), "Center");
            this.m_multiRawFilePanel.add((Component)this.getToolBar(), "North");
        }
        return this.m_multiRawFilePanel;
    }

    private JToolBar getToolBar() {
        if (this.m_toolbarPanel == null) {
            this.m_toolbarPanel = new JToolBar();
            this.m_toolbarPanel.setFloatable(false);
            this.m_toolbarPanel.setRollover(true);
            this.m_toolbarPanel.add(this.getButtonLayout());
            this.m_toolbarPanel.addSeparator();
            this.m_toolbarPanel.add(this.getButtonForceZoom());
            this.m_toolbarPanel.addSeparator();
            JButton displayTICbtn = new JButton("TIC");
            displayTICbtn.setToolTipText("Display TIC IChromatogram");
            displayTICbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedMultiRawFilePanel.this.displayTIC();
                }
            });
            this.m_toolbarPanel.add(displayTICbtn);
            JButton displayBPIbtn = new JButton("BPC");
            displayBPIbtn.setToolTipText("Display Base Peak IChromatogram");
            displayBPIbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedMultiRawFilePanel.this.displayBPI();
                }
            });
            this.m_toolbarPanel.add(displayBPIbtn);
            this.m_toolbarPanel.add(this.getOverlayBtn());
        }
        return this.m_toolbarPanel;
    }

    private JButton getButtonLayout() {
        if (this.m_buttonLayout == null) {
            this.m_buttonLayout = new JButton();
            this.m_buttonLayout.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.GRID));
            this.m_buttonLayout.setToolTipText("Change the presentation: tabs/grid");
            this.m_buttonLayout.addActionListener(e -> this.chromatogramContainerPanel.changeLayout());
        }
        return this.m_buttonLayout;
    }

    private JButton getButtonForceZoom() {
        if (this.m_buttonZoom == null) {
            this.m_buttonZoom = new JButton();
            this.m_buttonZoom.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ZOOM_FIT));
            this.updateZoomValues();
            this.m_buttonZoom.addActionListener(e -> this.synchronizeZoom());
        }
        return this.m_buttonZoom;
    }

    private TabsPanel getChromatogramContainerPanel() {
        if (this.chromatogramContainerPanel == null) {
            this.chromatogramContainerPanel = new TabsPanel();
            this.chromatogramContainerPanel.setName("chromatogramContainerPanel");
            long id = 0L;
            for (IRawFile rawFile : this.rawfiles) {
                ButtonTabComponent buttonTabComp = new ButtonTabComponent(rawFile.getName());
                IRawFileLoading rawFileLoading = waitingState -> buttonTabComp.setWaitingState(waitingState);
                this.mapRawFileLoading.put(rawFile, rawFileLoading);
                buttonTabComp.addCloseTabListener(new ButtonTabComponent.CloseTabListener(){

                    @Override
                    public void closeTab(ButtonTabComponent buttonTabComponent) {
                        int index = TabbedMultiRawFilePanel.this.chromatogramContainerPanel.indexOfTabHeaderComponent((Component)buttonTabComponent);
                        if (index != -1) {
                            TabbedMultiRawFilePanel.this.chromatogramContainerPanel.removeTabAt(index);
                            TabbedMultiRawFilePanel.this.rawfiles.remove(index);
                        }
                    }
                });
                WrappedChromatogramPanel wpanel = new WrappedChromatogramPanel(id++, rawFile.getName(), this.getChromatogramPanel(rawFile));
                wpanel.setTabHeaderComponent(buttonTabComp);
                this.chromatogramContainerPanel.addTab((IWrappedPanel)wpanel);
            }
        }
        this.chromatogramContainerPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TabbedMultiRawFilePanel.this.chromatogramContainerPanel.getSelectedIndex() != -1) {
                    TabbedMultiRawFilePanel.this.currentChromatogramPanel = (ChromatogramPanel)TabbedMultiRawFilePanel.this.chromatogramContainerPanel.getComponentAt(TabbedMultiRawFilePanel.this.chromatogramContainerPanel.getSelectedIndex());
                }
            }
        });
        if (this.chromatogramContainerPanel.getTabCount() > 0) {
            this.chromatogramContainerPanel.setSelectedIndex(0);
            this.currentChromatogramPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(0);
        }
        return this.chromatogramContainerPanel;
    }

    private ChromatogramPanel getChromatogramPanel(final IRawFile rawFile) {
        ChromatogramPanel chromatogramPanel = new ChromatogramPanel();
        chromatogramPanel.setName("chromatogramPanel");
        chromatogramPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TabbedMultiRawFilePanel.this.currentChromatogramPanel = (ChromatogramPanel)evt.getSource();
                TabbedMultiRawFilePanel.this.displayScan(rawFile.getSpectrumId(((Float)evt.getNewValue()).floatValue()));
            }
        });
        chromatogramPanel.addListener(new AxisRangeChromatogramListener(){

            @Override
            public void updateAxisRange(double[] oldX, double[] newX, double[] oldY, double[] newY) {
                TabbedMultiRawFilePanel.this.synchronizeAxisRange(rawFile, oldX, newX, oldY, newY);
            }
        });
        return chromatogramPanel;
    }

    private JPanel getSpectrumContainerPanel() {
        if (this.spectrumContainerPanel == null) {
            this.spectrumContainerPanel = new SpectrumPanel(this);
            this.spectrumContainerPanel.setName("spectrumContainerPanel");
            this.spectrumContainerPanel.setLayout(new BorderLayout());
        }
        return this.spectrumContainerPanel;
    }

    @Override
    public IRawFile getCurrentRawfile() {
        IChromatogram c = this.getCurrentChromatogram();
        if (c != null) {
            for (Map.Entry<IRawFile, IChromatogram> entrySet : this.mapChromatogramForRawFile.entrySet()) {
                if (!c.equals(entrySet.getValue())) continue;
                return entrySet.getKey();
            }
        }
        return this.rawfiles.get(0);
    }

    @Override
    public List<IRawFile> getAllRawfiles() {
        return this.rawfiles;
    }

    @Override
    public void extractAndDisplay(final ExtractionRequest params, final Display display, MzScopeCallback callback) {
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            int count = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : TabbedMultiRawFilePanel.this.rawfiles) {
                    TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(true);
                    IChromatogram c = rawFile.getXIC(params);
                    ++this.count;
                    this.publish(c);
                }
                return this.count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    TabbedMultiRawFilePanel.this.displayChromatogram(chunks.get(k), display);
                }
            }

            @Override
            protected void done() {
                try {
                    logger.info("{} TIC chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    TabbedMultiRawFilePanel.this.rawfiles.stream().forEach(rawFile -> TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(false));
                }
            }
        };
        worker.execute();
    }

    @Override
    public Color displayChromatogram(IChromatogram chromato, Display display) {
        String rawFileName = chromato.getRawFilename();
        int nbTab = this.chromatogramContainerPanel.getTabCount();
        Color c = null;
        for (int t = 0; t < nbTab; ++t) {
            String tabTitle = this.chromatogramContainerPanel.getTitleAt(t);
            if (!tabTitle.equals(rawFileName)) continue;
            ChromatogramPanel chromatoPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(t);
            c = chromatoPanel.displayChromatogram(chromato, display);
            this.mapChromatogramForRawFile.put(this.getRawFile(rawFileName), chromato);
            if (!this.isZoomSynchronized || this.zoomXLevel.isNaN() || this.zoomYLevel.isNaN()) continue;
            chromatoPanel.updateAxisRange(this.zoomXLevel, this.relativeXValue, this.zoomYLevel, this.relativeYValue);
        }
        return c;
    }

    @Override
    public void displayChromatograms(Map<IRawFile, IChromatogram> chromatogramByRawFile, Display display) {
        int nbTab = this.chromatogramContainerPanel.getTabCount();
        for (Map.Entry<IRawFile, IChromatogram> entrySet : chromatogramByRawFile.entrySet()) {
            IRawFile rawFile = entrySet.getKey();
            IChromatogram chromato = entrySet.getValue();
            for (int t = 0; t < nbTab; ++t) {
                String tabTitle = this.chromatogramContainerPanel.getTitleAt(t);
                if (!tabTitle.equals(rawFile.getName())) continue;
                ChromatogramPanel chromatoPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(t);
                chromatoPanel.displayChromatogram(chromato, new Display(Display.Mode.REPLACE));
                this.mapChromatogramForRawFile.put(rawFile, chromato);
            }
        }
    }

    @Override
    public void displayPeakel(IPeakel f) {
    }

    @Override
    public void displayScan(long index) {
        IRawFile selectedRawFile = this.getCurrentRawfile();
        if (selectedRawFile != null && (this.currentScan == null || index != (long)this.currentScan.getIndex().intValue())) {
            int idP;
            this.currentScan = selectedRawFile.getSpectrum((int)index, this.forceFittedToCentroid);
            if (this.currentScan != null) {
                this.spectrumContainerPanel.displayScan(this.currentScan);
            }
            if ((idP = this.rawfiles.indexOf(selectedRawFile)) != -1) {
                this.chromatogramContainerPanel.setSelectedIndex(idP);
            }
        }
    }

    @Override
    public void setReferenceSpectrum(Spectrum spectrum, Float scaleFactor) {
        this.spectrumContainerPanel.setReferenceSpectrum(spectrum, scaleFactor);
    }

    private IRawFile getRawFile(String fileName) {
        for (IRawFile rawFile : this.rawfiles) {
            if (!rawFile.getName().equals(fileName)) continue;
            return rawFile;
        }
        return null;
    }

    @Override
    public Color getPlotColor(String rawFilename) {
        return CyclicColorPalette.getColor((int)1);
    }

    @Override
    public IChromatogram getCurrentChromatogram() {
        return this.currentChromatogramPanel == null ? null : this.currentChromatogramPanel.getCurrentChromatogram();
    }

    @Override
    public Iterable<IChromatogram> getAllChromatograms() {
        int nbTab = this.chromatogramContainerPanel.getTabCount();
        ArrayList<IChromatogram> list = new ArrayList<IChromatogram>();
        for (int t = 0; t < nbTab; ++t) {
            ChromatogramPanel chromatoPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(t);
            chromatoPanel.getChromatograms().forEach(c -> list.add((IChromatogram)c));
        }
        return list;
    }

    private void displayTIC() {
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            int count = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : TabbedMultiRawFilePanel.this.rawfiles) {
                    TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(true);
                    IChromatogram c = rawFile.getTIC(-1);
                    ++this.count;
                    this.publish(c);
                }
                return this.count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    logger.info("display  chromato");
                    TabbedMultiRawFilePanel.this.displayChromatogram(chunks.get(k), new Display(Display.Mode.REPLACE));
                }
            }

            @Override
            protected void done() {
                try {
                    logger.info("{} TIC chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    for (IRawFile rawFile : TabbedMultiRawFilePanel.this.rawfiles) {
                        TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private void displayBPI() {
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            int count = 0;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : TabbedMultiRawFilePanel.this.rawfiles) {
                    TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(true);
                    IChromatogram c = rawFile.getBPI();
                    ++this.count;
                    this.publish(c);
                }
                return this.count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    logger.info("display  chromato");
                    TabbedMultiRawFilePanel.this.displayChromatogram(chunks.get(k), new Display(Display.Mode.REPLACE));
                }
            }

            @Override
            protected void done() {
                try {
                    logger.info("{} BPI chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    for (IRawFile rawFile : TabbedMultiRawFilePanel.this.rawfiles) {
                        TabbedMultiRawFilePanel.this.mapRawFileLoading.get(rawFile).setWaitingState(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private void synchronizeZoom() {
        this.isZoomSynchronized = !this.isZoomSynchronized;
        this.updateZoomValues();
    }

    private void updateZoomValues() {
        this.m_buttonZoom.setToolTipText(this.isZoomSynchronized ? tooltipZoom : tooltipForceZoom);
        if (!this.isZoomSynchronized) {
            this.relativeXValue = Double.NaN;
            this.zoomXLevel = Double.NaN;
            this.relativeYValue = Double.NaN;
            this.zoomYLevel = Double.NaN;
        }
    }

    private void synchronizeAxisRange(IRawFile rawFile, double[] oldX, double[] newX, double[] oldY, double[] newY) {
        if (this.isZoomSynchronized) {
            double newMinX = newX[0];
            double newMaxX = newX[1];
            double oldMinY = oldY[0];
            double oldMaxY = oldY[1];
            double newMinY = newY[0];
            double newMaxY = newY[1];
            int nbTab = this.chromatogramContainerPanel.getTabCount();
            IChromatogram referenceChromato = null;
            for (int t = 0; t < nbTab; ++t) {
                String tabTitle = this.chromatogramContainerPanel.getTitleAt(t);
                if (!tabTitle.equals(rawFile.getName())) continue;
                ChromatogramPanel chromatoPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(t);
                referenceChromato = chromatoPanel.getCurrentChromatogram();
            }
            double zoomXRange = newMaxX - newMinX;
            double relativeXMinPosition = newMinX / (referenceChromato.getElutionEndTime() - referenceChromato.getElutionStartTime());
            this.zoomYLevel = (newMaxY - newMinY) * 100.0 / (oldMaxY - oldMinY);
            this.relativeYValue = 100.0 * (newMinY + (newMaxY - newMinY) / 2.0 - oldMinY) / (oldMaxY - oldMinY);
            for (int t = 0; t < nbTab; ++t) {
                String tabTitle = this.chromatogramContainerPanel.getTitleAt(t);
                if (tabTitle.equals(rawFile.getName())) continue;
                ChromatogramPanel chromatoPanel = (ChromatogramPanel)this.chromatogramContainerPanel.getComponentAt(t);
                chromatoPanel.updateAxisRange2(zoomXRange, relativeXMinPosition, this.zoomYLevel, this.relativeYValue);
            }
        }
    }

    protected JToggleButton getOverlayBtn() {
        if (this.overlayBtn == null) {
            this.overlayBtn = new JToggleButton();
            this.overlayBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OVERLAY));
            this.overlayBtn.setSelected(false);
            this.overlayBtn.setName("cbXicOverlay");
            this.overlayBtn.setToolTipText("Overlay extracted chromatograms. This can also be done by using the Alt key");
            this.overlayBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedMultiRawFilePanel.this.xicDisplayMode = ((AbstractButton)e.getSource()).isSelected() ? Display.Mode.OVERLAY : Display.Mode.REPLACE;
                }
            });
        }
        return this.overlayBtn;
    }

    protected AbstractButton getShowMS2Button() {
        if (this.showMS2EventsButton == null) {
            this.showMS2EventsButton = new JToggleButton("MS2", false);
            this.showMS2EventsButton.setToolTipText("Show or hide MS2 Events");
            this.showMS2EventsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedMultiRawFilePanel.this.displayMsMsEvents(TabbedMultiRawFilePanel.this.showMS2EventsButton.isSelected());
                }
            });
        }
        return this.showMS2EventsButton;
    }

    private void displayMsMsEvents(boolean showMsMsEvents) {
        if (showMsMsEvents) {
            // empty if block
        }
    }

    @Override
    public Display.Mode getChromatogramDisplayMode() {
        return this.xicDisplayMode;
    }

    @Override
    public Spectrum getCurrentSpectrum() {
        return this.currentScan;
    }

    @Override
    public void changeForceFittedToCentroid() {
        this.forceFittedToCentroid = !this.forceFittedToCentroid;
    }
}

