/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;
import org.jdesktop.swingx.JXComboBox;

public class WaveletSmootherParamDialog
extends DefaultDialog {
    JComboBox waveletScanParameter;
    JComboBox waveletListCombo;
    JTextField m_nbrPoint;
    JCheckBox checkBox;
    JSpinner sp;
    JLabel thresholdLabel;
    public static final String MAX_CORRELATION = "Correlation max";
    public static final String MIN_CORRELATION = "Correlation min";
    public static final String BOTH_SMOOTHNESS_AND_CORRELATION = "smoothness + correlation";
    public static final String MAX_SNR = "Best SNR";
    public static final String MIN_ENERGY_DIFF = "Min energy difference";
    public static final String MIN_EUCLIDEAN_DISTANCE = "Min euclidean distance";
    String[] waveletParameters = new String[]{"Correlation max", "Correlation min", "smoothness + correlation", "Best SNR", "Min energy difference", "Min euclidean distance"};
    Wavelet[] arrayOfWavelet = WaveletBuilder.create2arr();

    public WaveletSmootherParamDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Smoothing parameters for wavelet denoising");
        this.setInternalComponent(this.createInternalPanel());
    }

    private String[] getWaveletNames(Wavelet[] arrayOfWavelet) {
        String[] listOfWaveletNames = new String[arrayOfWavelet.length];
        for (int k = 0; k < arrayOfWavelet.length; ++k) {
            listOfWaveletNames[k] = arrayOfWavelet[k].getName();
        }
        return listOfWaveletNames;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JLabel nbrPointLabel = new JLabel("scan parameters ");
        internalPanel.add((Component)nbrPointLabel, c);
        ++c.gridy;
        c.weightx = 1.0;
        this.waveletScanParameter = new JXComboBox((Object[])this.waveletParameters);
        internalPanel.add((Component)this.waveletScanParameter, c);
        JLabel userLabel = new JLabel("Select wavelet: ");
        ++c.gridy;
        internalPanel.add((Component)userLabel, c);
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(false);
        this.checkBox.addActionListener(e -> {
            boolean isSelected = this.checkBox.isSelected();
            this.waveletScanParameter.setEnabled(!isSelected);
            this.waveletListCombo.setEnabled(isSelected);
            if (!isSelected) {
                this.waveletListCombo.setForeground(Color.BLACK);
            }
        });
        ++c.gridy;
        internalPanel.add((Component)this.checkBox, c);
        this.waveletListCombo = new JComboBox<String>(this.getWaveletNames(this.arrayOfWavelet));
        this.waveletListCombo.setEnabled(this.checkBox.isSelected());
        this.waveletListCombo.setSelectedItem(this.arrayOfWavelet[7].getName());
        ++c.gridy;
        internalPanel.add((Component)this.waveletListCombo, c);
        this.thresholdLabel = new JLabel("threshold cutOff");
        this.thresholdLabel.setToolTipText("");
        ++c.gridy;
        internalPanel.add((Component)this.thresholdLabel, c);
        SpinnerNumberModel model = new SpinnerNumberModel(1.5, 0.0, 10.0, 0.1);
        this.sp = new JSpinner(model);
        ++c.gridy;
        internalPanel.add((Component)this.sp, c);
        return internalPanel;
    }

    public String getMethod() {
        return this.waveletScanParameter.getSelectedItem().toString();
    }

    public String getWaveletSelected() {
        return this.waveletListCombo.getSelectedItem().toString();
    }

    public double getJSpinnerValue() {
        return (Double)this.sp.getValue();
    }

    public boolean getUserChoice() {
        return this.checkBox.isSelected();
    }

    protected boolean okCalled() {
        return true;
    }
}

