/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.utils;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyEventDispatcherDecorator {
    private static Logger logger;
    private static List<KeyEventDispatcher> listeners;

    public static boolean processKeyEvent(KeyEvent evt) {
        for (KeyEventDispatcher listener : listeners) {
            Point mouseCoords;
            if (!JComponent.class.isAssignableFrom(listener.getClass()) || (mouseCoords = ((JComponent)((Object)listener)).getMousePosition()) == null) continue;
            listener.dispatchKeyEvent(evt);
        }
        return false;
    }

    public static boolean addKeyEventListener(KeyEventDispatcher listener) {
        if (!JComponent.class.isAssignableFrom(listener.getClass())) {
            throw new UnsupportedOperationException("Only JComponent KeyEventDispatcher Listeners are supported");
        }
        return listeners.add(listener);
    }

    public static boolean removeKeyEventListener(KeyEventDispatcher listener) {
        return listeners.remove(listener);
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                return KeyEventDispatcherDecorator.processKeyEvent(e);
            }
        });
        logger = LoggerFactory.getLogger(KeyEventDispatcherDecorator.class);
        listeners = new ArrayList<KeyEventDispatcher>();
    }
}

