/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import jwave.datatypes.Super;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public abstract class Space
extends Super {
    protected int _noOfRows;
    protected int _noOfCols;
    protected int _noOfLvls;
    protected int _offSetRow;
    protected int _offSetCol;
    protected int _offSetLvl;

    public Space() {
        this._offSetRow = 0;
        this._offSetCol = 0;
        this._offSetLvl = 0;
        this._noOfRows = 0;
        this._noOfCols = 0;
        this._noOfLvls = 0;
    }

    public Space(Space space) {
        this._offSetRow = space._offSetRow;
        this._offSetCol = space._offSetCol;
        this._offSetLvl = space._offSetLvl;
        this._noOfRows = space._noOfRows;
        this._noOfCols = space._noOfCols;
        this._noOfLvls = space._noOfLvls;
    }

    public Space(int noOfRows, int noOfCols, int noOfLvls) {
        this._offSetRow = 0;
        this._offSetCol = 0;
        this._offSetLvl = 0;
        this._noOfRows = noOfRows;
        this._noOfCols = noOfCols;
        this._noOfLvls = noOfLvls;
    }

    public Space(int offSetRow, int offSetCol, int offSetLvl, int noOfRows, int noOfCols, int noOfLvls) {
        this._offSetRow = offSetRow;
        this._offSetCol = offSetCol;
        this._offSetLvl = offSetLvl;
        this._noOfRows = noOfRows;
        this._noOfCols = noOfCols;
        this._noOfLvls = noOfLvls;
    }

    public int getNoOfRows() {
        return this._noOfRows;
    }

    public int getNoOfCols() {
        return this._noOfCols;
    }

    public int getNoOfLvls() {
        return this._noOfLvls;
    }

    public int getOffSetRow() {
        return this._offSetRow;
    }

    public int getOffSetCol() {
        return this._offSetCol;
    }

    public int getOffSetLvl() {
        return this._offSetLvl;
    }

    protected void check(int k) throws JWaveException {
        if (k < 0) {
            throw new JWaveFailure("Space - i is smaller than zero");
        }
        if (k == this._noOfLvls) {
            throw new JWaveFailure("Space - i is equal to noOfLvls: " + this._noOfLvls);
        }
        if (k > this._noOfLvls) {
            throw new JWaveFailure("Space - i is greater than noOfLvls: " + this._noOfLvls);
        }
    }

    protected void check(int j, int k) throws JWaveException {
        if (j < 0) {
            throw new JWaveFailure("Space - i is smaller than zero");
        }
        if (j == this._noOfCols) {
            throw new JWaveFailure("Space - i is equal to noOfCols: " + this._noOfCols);
        }
        if (j > this._noOfCols) {
            throw new JWaveFailure("Space - i is greater than noOfCols: " + this._noOfCols);
        }
        this.check(k);
    }

    protected void check(int i, int j, int k) throws JWaveException {
        if (i < 0) {
            throw new JWaveFailure("Space - i is smaller than zero");
        }
        if (i == this._noOfRows) {
            throw new JWaveFailure("Space - i is equal to noOfRows: " + this._noOfRows);
        }
        if (i > this._noOfRows) {
            throw new JWaveFailure("Space - i is greater than noOfRows: " + this._noOfRows);
        }
        this.check(j, k);
    }

    public abstract double get(int var1, int var2, int var3) throws JWaveException;

    public abstract void set(int var1, int var2, int var3, double var4) throws JWaveException;
}

