/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import java.util.Arrays;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.WaveletTransform;
import jwave.transforms.wavelets.Wavelet;

public class WaveletPacketTransform
extends WaveletTransform {
    public WaveletPacketTransform(Wavelet wavelet) {
        super(wavelet);
        this._name = "Wavelet Packet Transform";
    }

    @Override
    public double[] forward(double[] arrTime, int level) throws JWaveException {
        if (!this.isBinary(arrTime.length)) {
            throw new JWaveFailure("given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int noOfLevels = this.calcExponent(arrTime.length);
        if (level < 0 || level > noOfLevels) {
            throw new JWaveFailure("WaveletPacketTransform#forward - given level is out of range for given array");
        }
        double[] arrHilb = new double[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            arrHilb[i] = arrTime[i];
        }
        int k = arrTime.length;
        int h = arrTime.length;
        int transformWavelength = this._wavelet.getTransformWavelength();
        for (int l = 0; h >= transformWavelength && l < level; h >>= 1, ++l) {
            int g = k / h;
            for (int p = 0; p < g; ++p) {
                double[] iBuf = new double[h];
                for (int i = 0; i < h; ++i) {
                    iBuf[i] = arrHilb[i + p * h];
                }
                double[] oBuf = this._wavelet.forward(iBuf, h);
                for (int i = 0; i < h; ++i) {
                    arrHilb[i + p * h] = oBuf[i];
                }
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb, int level) throws JWaveException {
        if (!this.isBinary(arrHilb.length)) {
            throw new JWaveFailure("given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int noOfLevels = this.calcExponent(arrHilb.length);
        if (level < 0 || level > noOfLevels) {
            throw new JWaveFailure("WaveletPacketTransform#reverse - given level is out of range for given array");
        }
        int length = arrHilb.length;
        double[] arrTime = Arrays.copyOf(arrHilb, length);
        int transformWavelength = this._wavelet.getTransformWavelength();
        int k = arrTime.length;
        int h = transformWavelength;
        int steps = this.calcExponent(length);
        for (int l = level; l < steps; ++l) {
            h <<= 1;
        }
        while (h <= arrTime.length && h >= transformWavelength) {
            int g = k / h;
            for (int p = 0; p < g; ++p) {
                double[] iBuf = new double[h];
                for (int i = 0; i < h; ++i) {
                    iBuf[i] = arrTime[i + p * h];
                }
                double[] oBuf = this._wavelet.reverse(iBuf, h);
                for (int i = 0; i < h; ++i) {
                    arrTime[i + p * h] = oBuf[i];
                }
            }
            h <<= 1;
        }
        return arrTime;
    }
}

