/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.IIntBuffer;
import com.ximpleware.arrayList;

public class FastIntBuffer
implements IIntBuffer {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private arrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int exp;
    private int r;

    public FastIntBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new arrayList();
    }

    public FastIntBuffer(int e) {
        if (e < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << e;
        this.exp = e;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList();
    }

    public final void append(int[] int_array) {
        int lastBufferIndex;
        int[] lastBuffer;
        if (this.bufferArrayList.size == 0) {
            lastBuffer = new int[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            lastBufferIndex = 0;
            this.capacity = this.pageSize;
        } else {
            lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size - 1);
            lastBuffer = (int[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + int_array.length < this.capacity) {
            if (this.size + int_array.length < lastBufferIndex + 1 << this.exp) {
                System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, int_array.length);
            } else {
                int z;
                int offset = this.pageSize - (this.size & this.r);
                System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, offset);
                int l = int_array.length - offset;
                int k = l >> this.exp;
                for (z = 1; z <= k; ++z) {
                    System.arraycopy(int_array, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, this.pageSize);
                    offset += this.pageSize;
                }
                System.arraycopy(int_array, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, l & this.r);
            }
            this.size += int_array.length;
            return;
        }
        int n = (int_array.length + this.size >> this.exp) + ((int_array.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n; ++i) {
            int[] newBuffer = new int[this.pageSize];
            if (i < n - 1) {
                System.arraycopy(int_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, this.pageSize);
            } else {
                System.arraycopy(int_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, int_array.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(newBuffer);
        }
        this.size += int_array.length;
        this.capacity += n * this.pageSize;
    }

    public final void append(int i) {
        if (this.size < this.capacity) {
            ((int[])this.bufferArrayList.oa[this.size >> this.exp])[this.size & this.r] = i;
            ++this.size;
        } else {
            int[] newBuffer = new int[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(newBuffer);
            newBuffer[0] = i;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public int[] getIntArray(int startingOffset, int len) {
        if (this.size <= 0 || startingOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (startingOffset + len > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int[] result = new int[len];
        int first_index = startingOffset >> this.exp;
        int last_index = startingOffset + len >> this.exp;
        if ((startingOffset + len & this.r) == 0) {
            --last_index;
        }
        if (first_index == last_index) {
            System.arraycopy((int[])this.bufferArrayList.get(first_index), startingOffset & this.r, result, 0, len);
        } else {
            int int_array_offset = 0;
            for (int i = first_index; i <= last_index; ++i) {
                int[] currentChunk = (int[])this.bufferArrayList.get(i);
                if (i == first_index) {
                    System.arraycopy(currentChunk, startingOffset & this.r, result, 0, this.pageSize - (startingOffset & this.r));
                    int_array_offset += this.pageSize - (startingOffset & this.r);
                    continue;
                }
                if (i == last_index) {
                    System.arraycopy(currentChunk, 0, result, int_array_offset, len - int_array_offset);
                    continue;
                }
                System.arraycopy(currentChunk, 0, result, int_array_offset, this.pageSize);
                int_array_offset += this.pageSize;
            }
        }
        return result;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final int intAt(int index) {
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return ((int[])this.bufferArrayList.get(pageNum))[offset];
    }

    public final void modifyEntry(int index, int newValue) {
        ((int[])this.bufferArrayList.oa[index >> this.exp])[index & this.r] = newValue;
    }

    public final int size() {
        return this.size;
    }

    public int[] toIntArray() {
        if (this.size > 0) {
            int s = this.size;
            int[] resultArray = new int[this.size];
            int array_offset = 0;
            int i = 0;
            while (s > 0) {
                System.arraycopy((int[])this.bufferArrayList.get(i), 0, resultArray, array_offset, s < this.pageSize ? s : this.pageSize);
                s -= this.pageSize;
                array_offset += this.pageSize;
                ++i;
            }
            return resultArray;
        }
        return null;
    }

    public final void clear() {
        this.size = 0;
    }

    public final boolean resize(int newSz) {
        if (newSz <= this.capacity && newSz >= 0) {
            this.size = newSz;
            return true;
        }
        return false;
    }

    public void sort(int order) {
        switch (order) {
            case 0: {
                if (this.size <= 0) break;
                this.quickSort_ascending(0, this.size - 1);
                break;
            }
            case 1: {
                if (this.size <= 0) break;
                this.quickSort_descending(0, this.size - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sort type undefined");
            }
        }
    }

    void quickSort_ascending(int lo, int hi) {
        int i = lo;
        int j = hi;
        int x = this.intAt((lo + hi) / 2);
        while (true) {
            if (this.intAt(i) < x) {
                ++i;
                continue;
            }
            while (this.intAt(j) > x) {
                --j;
            }
            if (i <= j) {
                int h = this.intAt(i);
                this.modifyEntry(i, this.intAt(j));
                this.modifyEntry(j, h);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.quickSort_ascending(lo, j);
        }
        if (i < hi) {
            this.quickSort_ascending(i, hi);
        }
    }

    void quickSort_descending(int lo, int hi) {
        int i = lo;
        int j = hi;
        int x = this.intAt((lo + hi) / 2);
        while (true) {
            if (this.intAt(i) > x) {
                ++i;
                continue;
            }
            while (this.intAt(j) < x) {
                --j;
            }
            if (i <= j) {
                int h = this.intAt(i);
                this.modifyEntry(i, this.intAt(j));
                this.modifyEntry(j, h);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.quickSort_descending(lo, j);
        }
        if (i < hi) {
            this.quickSort_descending(i, hi);
        }
    }
}

