/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.MatrixR064;

public final class FixedWeightsPortfolio
extends EquilibriumModel {
    private final MatrixR064 myWeights;

    public FixedWeightsPortfolio(FinancePortfolio.Context aContext, FinancePortfolio weightsPortfolio) {
        super(aContext);
        this.myWeights = (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{weightsPortfolio.getWeights()});
    }

    public FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium, MatrixR064 assetWeightsInColumn) {
        super(aMarketEquilibrium);
        this.myWeights = assetWeightsInColumn;
    }

    private FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myWeights = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio.Context targetReturns) {
        this.calibrate(this.myWeights, targetReturns.getAssetReturns());
    }

    public void calibrate(List<? extends Comparable<?>> targetReturns) {
        this.calibrate(this.myWeights, (MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{targetReturns}));
    }

    @Override
    protected MatrixR064 calculateAssetReturns() {
        return this.calculateAssetReturns(this.myWeights);
    }

    @Override
    protected MatrixR064 calculateAssetWeights() {
        return this.myWeights;
    }
}

