/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;

public class PolynomialQ128
extends AbstractPolynomial<RationalNumber> {
    public PolynomialQ128(int degree) {
        super((Array1D)Array1D.Q128.make(degree + 1));
    }

    PolynomialQ128(Array1D<RationalNumber> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, GenericStore.Q128, QR.Q128);
    }

    @Override
    public RationalNumber integrate(RationalNumber fromPoint, RationalNumber toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        RationalNumber fromVal = primitive.invoke(fromPoint);
        RationalNumber toVal = primitive.invoke(toPoint);
        return toVal.subtract(fromVal);
    }

    @Override
    public RationalNumber invoke(RationalNumber arg) {
        int power = this.degree();
        RationalNumber retVal = (RationalNumber)this.get(power);
        while (--power >= 0) {
            retVal = ((RationalNumber)this.get(power)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, RationalNumber.valueOf(coefficients.get(p)));
        }
    }

    @Override
    protected RationalNumber getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return (RationalNumber)((RationalNumber)this.get(nextIndex)).multiply(nextIndex);
    }

    @Override
    protected RationalNumber getPrimitiveFactor(int power) {
        if (power <= 0) {
            return RationalNumber.ZERO;
        }
        return (RationalNumber)((RationalNumber)this.get(power - 1)).divide(power);
    }

    @Override
    protected AbstractPolynomial<RationalNumber> makeInstance(int size) {
        return new PolynomialQ128((Array1D)Array1D.Q128.make(size));
    }
}

