/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.structure.Access1D;

public final class PolynomialR128
extends AbstractPolynomial<Quadruple> {
    public PolynomialR128(int degree) {
        super((Array1D)Array1D.R128.make(degree + 1));
    }

    PolynomialR128(Array1D<Quadruple> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, GenericStore.R128, QR.R128);
    }

    @Override
    public Quadruple integrate(Quadruple fromPoint, Quadruple toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        Quadruple fromVal = primitive.invoke(fromPoint);
        Quadruple toVal = primitive.invoke(toPoint);
        return toVal.subtract(fromVal);
    }

    @Override
    public Quadruple invoke(Quadruple arg) {
        int power = this.degree();
        Quadruple retVal = (Quadruple)this.get(power);
        while (--power >= 0) {
            retVal = ((Quadruple)this.get(power)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, Quadruple.valueOf(coefficients.get(p)));
        }
    }

    @Override
    protected Quadruple getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return (Quadruple)((Quadruple)this.get(nextIndex)).multiply(nextIndex);
    }

    @Override
    protected Quadruple getPrimitiveFactor(int power) {
        if (power <= 0) {
            return Quadruple.ZERO;
        }
        return (Quadruple)((Quadruple)this.get(power - 1)).divide(power);
    }

    @Override
    protected AbstractPolynomial<Quadruple> makeInstance(int size) {
        return new PolynomialR128((Array1D)Array1D.R128.make(size));
    }
}

