/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.File;
import java.io.IOException;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.ArrayR032;
import org.ojalgo.array.DenseArray;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.DataInterpreter;
import org.ojalgo.netio.DataReader;
import org.ojalgo.structure.Access2D;

public abstract class IDX {
    public static ArrayAnyD<Double> parse(File filePath) {
        return IDX.parse(filePath, ArrayR032.FACTORY);
    }

    public static ArrayAnyD<Double> parse(File file, DenseArray.Factory<Double> factory) {
        ArrayAnyD<Double> arrayAnyD;
        block8: {
            DataReader<ArrayAnyD<Double>> reader = DataReader.of(file, DataInterpreter.newIDX(factory));
            try {
                arrayAnyD = reader.read();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException cause) {
                    throw new RuntimeException(cause);
                }
            }
            reader.close();
        }
        return arrayAnyD;
    }

    public static ArrayAnyD<Double> parse(String filePath) {
        return IDX.parse(new File(filePath));
    }

    public static ArrayAnyD<Double> parse(String filePath, DenseArray.Factory<Double> arrayFactory) {
        return IDX.parse(new File(filePath), arrayFactory);
    }

    public static void print(Access2D<?> image, BasicLogger printer) {
        IDX.print(image, printer, true);
    }

    public static void print(Access2D<?> image, BasicLogger printer, boolean transpose) {
        double maxValue = 0.0;
        int i = 0;
        while ((long)i < image.count()) {
            maxValue = Math.max(maxValue, image.doubleValue(i));
            ++i;
        }
        IDX.print(image, printer, transpose, maxValue);
    }

    public static void print(Access2D<?> image, BasicLogger printer, boolean transpose, double maxExpectedValue) {
        double oneThird = maxExpectedValue / 3.0;
        double twoThirds = 2.0 * maxExpectedValue / 3.0;
        long numbRows = image.countRows();
        long numbCols = image.countColumns();
        if (transpose) {
            for (long j = 0L; j < numbCols; ++j) {
                for (long i = 0L; i < numbRows; ++i) {
                    IDX.printPixel(image.doubleValue(i, j), printer, oneThird, twoThirds);
                }
                printer.println();
            }
        } else {
            for (long i = 0L; i < numbRows; ++i) {
                for (long j = 0L; j < numbCols; ++j) {
                    IDX.printPixel(image.doubleValue(i, j), printer, oneThird, twoThirds);
                }
                printer.println();
            }
        }
    }

    private static void printPixel(double gray, BasicLogger printer, double oneThird, double twoThirds) {
        if (gray < oneThird) {
            printer.print(" ");
        } else if (gray < twoThirds) {
            printer.print("+");
        } else {
            printer.print("X");
        }
    }
}

