/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexData;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

final class QPESolver
extends ConstrainedSolver {
    private boolean myFeasible = false;
    private final Primitive64Store myIterationX = (Primitive64Store)MATRIX_FACTORY.make((long)this.countVariables(), 1L);

    QPESolver(ConvexData<Double> convexSolverBuilder, Optimisation.Options optimisationOptions) {
        super(convexSolverBuilder, optimisationOptions);
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        boolean ok = super.initialise(kickStarter);
        if (kickStarter != null && kickStarter.getState().isFeasible()) {
            this.getSolutionX().fillMatching(kickStarter);
            this.myFeasible = true;
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
            this.myFeasible = false;
        }
        return ok;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        Primitive64Store tmpXL;
        MatrixStore<Double> invQAt;
        MatrixStore<MatrixStore<Double>> negS;
        MatrixStore<Double> iterA = this.getIterationA();
        MatrixStore<Double> iterB = this.getIterationB();
        MatrixStore<Double> iterC = this.getIterationC();
        boolean solved = false;
        Primitive64Store iterX = this.myIterationX;
        Primitive64Store iterL = this.getSolutionL();
        if (iterA.countRows() < iterA.countColumns() && (solved = this.isSolvableQ()) && (solved = this.computeGeneral(negS = iterA.multiply((Double)((Object)(invQAt = this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)iterA.transpose())))))))) {
            MatrixStore<Double> invQC = this.getSolutionQ(iterC, iterX);
            this.getSolutionGeneral(iterA.multiply((Double)((Object)invQC)).subtract(iterB), iterL);
            this.getSolutionQ(iterC.subtract((Double)((Object)iterA.transpose().multiply(iterL))), iterX);
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (Primitive64Store)MATRIX_FACTORY.make((long)(this.countVariables() + this.countIterationConstraints()), 1L)))) {
            iterX.fillMatching((Access1D<?>)((Object)tmpXL.limits(this.countVariables(), 1L)));
            iterL.fillMatching((Access1D<?>)((Object)tmpXL.offsets(this.countVariables(), 0L)));
        }
        if (solved) {
            this.setState(Optimisation.State.OPTIMAL);
            if (this.myFeasible) {
                this.getSolutionX().modifyMatching(PrimitiveMath.ADD, iterX);
            } else {
                this.getSolutionX().fillMatching(iterX);
            }
        } else if (this.myFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
        this.incrementIterationsCount();
    }

    @Override
    int countIterationConstraints() {
        return this.countEqualityConstraints();
    }

    @Override
    MatrixStore<Double> getIterationA() {
        return this.getMatrixAE();
    }

    @Override
    MatrixStore<Double> getIterationB() {
        if (this.myFeasible) {
            return MATRIX_FACTORY.makeZero(this.countEqualityConstraints(), 1L);
        }
        return this.getMatrixBE();
    }

    @Override
    MatrixStore<Double> getIterationC() {
        if (this.myFeasible) {
            PhysicalStore<Double> mtrxQ = this.getMatrixQ();
            MatrixStore<Double> mtrxC = this.getMatrixC();
            PhysicalStore<Double> solX = this.getSolutionX();
            return mtrxC.subtract((Double)((Object)mtrxQ.multiply((Double)((Object)solX))));
        }
        return this.getMatrixC();
    }
}

