/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.integer.ModelStrategy;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.type.context.NumberContext;

public interface IntegerStrategy {
    public static final ConfigurableStrategy DEFAULT = IntegerStrategy.newConfigurable();

    public static ConfigurableStrategy newConfigurable() {
        Comparator[] definitions = new Comparator[]{NodeKey.EARLIEST_SEQUENCE, NodeKey.LARGEST_DISPLACEMENT, NodeKey.SMALLEST_DISPLACEMENT, NodeKey.LATEST_SEQUENCE};
        return new ConfigurableStrategy(Parallelism.CORES.require(4), definitions, NumberContext.of(12, 8), NumberContext.of(7, 8), ModelStrategy.DefaultStrategy::new, new GMICutConfiguration());
    }

    public NumberContext getGapTolerance();

    public GMICutConfiguration getGMICutConfiguration();

    public NumberContext getIntegralityTolerance();

    public List<Comparator<NodeKey>> getWorkerPriorities();

    public ModelStrategy newModelStrategy(ExpressionsBasedModel var1);

    public static final class GMICutConfiguration {
        public final double fractionality;
        public final BigDecimal violation;

        public GMICutConfiguration() {
            this(PrimitiveMath.ELEVENTH, BigMath.TWELVE);
        }

        private GMICutConfiguration(double newAway, BigDecimal newExpansion) {
            this.fractionality = newAway;
            this.violation = newExpansion;
        }

        public GMICutConfiguration withFractionality(double newFractionality) {
            return new GMICutConfiguration(Math.min(Math.abs(newFractionality), 0.5), this.violation);
        }

        public GMICutConfiguration withViolation(BigDecimal newViolation) {
            return new GMICutConfiguration(this.fractionality, newViolation.abs());
        }
    }

    public static final class ConfigurableStrategy
    implements IntegerStrategy {
        private final BiFunction<ExpressionsBasedModel, IntegerStrategy, ModelStrategy> myFactory;
        private final NumberContext myGapTolerance;
        private final GMICutConfiguration myGMICutConfiguration;
        private final NumberContext myIntegralityTolerance;
        private final IntSupplier myParallelism;
        private final Comparator<NodeKey>[] myPriorityDefinitions;

        ConfigurableStrategy(IntSupplier parallelism, Comparator<NodeKey>[] definitions, NumberContext integrality, NumberContext gap, BiFunction<ExpressionsBasedModel, IntegerStrategy, ModelStrategy> factory, GMICutConfiguration configuration) {
            this.myParallelism = parallelism;
            this.myPriorityDefinitions = definitions;
            this.myIntegralityTolerance = integrality;
            this.myGapTolerance = gap;
            this.myFactory = factory;
            this.myGMICutConfiguration = configuration;
        }

        public ConfigurableStrategy addPriorityDefinitions(Comparator<NodeKey> ... additionalDefinitions) {
            int i;
            Comparator[] totalDefinitions = new Comparator[additionalDefinitions.length + this.myPriorityDefinitions.length];
            for (i = 0; i < additionalDefinitions.length; ++i) {
                totalDefinitions[i] = additionalDefinitions[i];
            }
            for (i = 0; i < this.myPriorityDefinitions.length; ++i) {
                totalDefinitions[additionalDefinitions.length + i] = this.myPriorityDefinitions[i];
            }
            return new ConfigurableStrategy(this.myParallelism, totalDefinitions, this.myIntegralityTolerance, this.myGapTolerance, this.myFactory, this.myGMICutConfiguration);
        }

        @Override
        public NumberContext getGapTolerance() {
            return this.myGapTolerance;
        }

        @Override
        public GMICutConfiguration getGMICutConfiguration() {
            return this.myGMICutConfiguration;
        }

        @Override
        public NumberContext getIntegralityTolerance() {
            return this.myIntegralityTolerance;
        }

        @Override
        public List<Comparator<NodeKey>> getWorkerPriorities() {
            int parallelism = this.myParallelism.getAsInt();
            ArrayList<Comparator<NodeKey>> retVal = new ArrayList<Comparator<NodeKey>>(parallelism);
            for (int i = 0; i < parallelism; ++i) {
                retVal.add(this.myPriorityDefinitions[i % this.myPriorityDefinitions.length]);
            }
            return retVal;
        }

        @Override
        public ModelStrategy newModelStrategy(ExpressionsBasedModel model) {
            return this.myFactory.apply(model, this);
        }

        public ConfigurableStrategy withGapTolerance(NumberContext newTolerance) {
            return new ConfigurableStrategy(this.myParallelism, this.myPriorityDefinitions, this.myIntegralityTolerance, newTolerance, this.myFactory, this.myGMICutConfiguration);
        }

        public ConfigurableStrategy withGMICutConfiguration(GMICutConfiguration newConfiguration) {
            return new ConfigurableStrategy(this.myParallelism, this.myPriorityDefinitions, this.myIntegralityTolerance, this.myGapTolerance, this.myFactory, newConfiguration);
        }

        public ConfigurableStrategy withModelStrategyFactory(BiFunction<ExpressionsBasedModel, IntegerStrategy, ModelStrategy> newFactory) {
            return new ConfigurableStrategy(this.myParallelism, this.myPriorityDefinitions, this.myIntegralityTolerance, this.myGapTolerance, newFactory, this.myGMICutConfiguration);
        }

        public ConfigurableStrategy withParallelism(IntSupplier newParallelism) {
            return new ConfigurableStrategy(newParallelism, this.myPriorityDefinitions, this.myIntegralityTolerance, this.myGapTolerance, this.myFactory, this.myGMICutConfiguration);
        }

        public ConfigurableStrategy withPriorityDefinitions(Comparator<NodeKey> ... newDefinitions) {
            return new ConfigurableStrategy(this.myParallelism, newDefinitions, this.myIntegralityTolerance, this.myGapTolerance, this.myFactory, this.myGMICutConfiguration);
        }
    }
}

