/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.scalar.SelfDeclaringScalar;
import org.ojalgo.type.context.NumberContext;

public abstract class ExactDecimal<S extends ExactDecimal<S>>
implements SelfDeclaringScalar<S> {
    private transient BigDecimal myDecimal = null;
    private final long myNumerator;

    protected static long extractUnscaledValue(BigDecimal decimal, NumberContext cntxt) {
        return decimal.setScale(cntxt.getScale(), cntxt.getRoundingMode()).unscaledValue().longValueExact();
    }

    protected ExactDecimal(long numerator) {
        this.myNumerator = numerator;
    }

    @Override
    public final S add(double scalarAddend) {
        return this.wrap(this.myNumerator + Math.round(scalarAddend * (double)this.descriptor().denominator()));
    }

    @Override
    public final S add(S scalarAddend) {
        return this.wrap(this.myNumerator + ((ExactDecimal)scalarAddend).numerator());
    }

    @Override
    public final int compareTo(S reference) {
        return Long.compare(this.myNumerator, ((ExactDecimal)reference).numerator());
    }

    @Override
    public final S conjugate() {
        return (S)this;
    }

    @Override
    public final S divide(double scalarDivisor) {
        return this.wrap(Math.round((double)this.myNumerator / scalarDivisor));
    }

    @Override
    public final S divide(S scalarDivisor) {
        return this.wrap(this.myNumerator * this.descriptor().denominator() / ((ExactDecimal)scalarDivisor).numerator());
    }

    @Override
    public final double doubleValue() {
        return this.myNumerator / this.descriptor().denominator();
    }

    @Override
    public final S enforce(NumberContext context) {
        BigDecimal decimal = this.toBigDecimal(context);
        NumberContext type = this.descriptor().context();
        decimal = decimal.setScale(type.getScale(), type.getRoundingMode());
        return this.wrap(decimal.unscaledValue().longValueExact());
    }

    @Override
    public final float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public final S get() {
        return (S)this;
    }

    @Override
    public final int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public final S invert() {
        return this.wrap(Math.round((double)this.descriptor().denominator() / this.doubleValue()));
    }

    @Override
    public final boolean isAbsolute() {
        return this.myNumerator >= 0L;
    }

    @Override
    public final boolean isSmall(double comparedTo) {
        return this.descriptor().context().isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public final long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public final S multiply(double scalarMultiplicand) {
        return this.wrap(Math.round((double)this.myNumerator * scalarMultiplicand));
    }

    @Override
    public final S multiply(S scalarMultiplicand) {
        return this.wrap(this.myNumerator * ((ExactDecimal)scalarMultiplicand).numerator() / this.descriptor().denominator());
    }

    @Override
    public final S negate() {
        return this.wrap(-this.myNumerator);
    }

    @Override
    public final double norm() {
        return PrimitiveMath.ABS.invoke(this.doubleValue());
    }

    @Override
    public S power(int power) {
        if (power == 0) {
            return this.wrap(this.descriptor().denominator());
        }
        if (power == 1) {
            return (S)this;
        }
        long numer = MissingMath.power(this.myNumerator, power);
        long denom = MissingMath.power(this.descriptor().denominator(), power - 1);
        return this.wrap(numer / denom);
    }

    @Override
    public final S signum() {
        if (this.myNumerator == 0L) {
            return this.wrap(0L);
        }
        if (this.myNumerator < 0L) {
            return this.wrap(-this.descriptor().denominator());
        }
        return this.wrap(this.descriptor().denominator());
    }

    @Override
    public final S subtract(double scalarSubtrahend) {
        return this.wrap(this.myNumerator - Math.round(scalarSubtrahend * (double)this.descriptor().denominator()));
    }

    @Override
    public final S subtract(S scalarSubtrahend) {
        return this.wrap(this.myNumerator - ((ExactDecimal)scalarSubtrahend).numerator());
    }

    @Override
    public final BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = new BigDecimal(this.myNumerator).divide(new BigDecimal(this.descriptor().denominator()), this.descriptor().context().getMathContext());
        }
        return this.myDecimal;
    }

    public final String toString() {
        return this.toBigDecimal().toPlainString();
    }

    @Override
    public final String toString(NumberContext context) {
        return this.toBigDecimal(context).toPlainString();
    }

    private final BigDecimal toBigDecimal(NumberContext context) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.descriptor().denominator()), context.getMathContext());
    }

    protected abstract Descriptor descriptor();

    protected abstract S wrap(long var1);

    final long numerator() {
        return this.myNumerator;
    }

    public static interface Factory<S extends ExactDecimal<S>>
    extends Scalar.Factory<S> {
        public Descriptor descriptor();
    }

    public static final class Descriptor {
        private final NumberContext myContext;
        private final long myDenominator;

        public Descriptor(int scale) {
            this.myContext = NumberContext.of(19, scale);
            this.myDenominator = Math.round(Math.pow(10.0, scale));
        }

        public long add(ExactDecimal<?> arg1, ExactDecimal<?> arg2) {
            BigDecimal deci1 = arg1.toBigDecimal();
            BigDecimal deci2 = arg2.toBigDecimal();
            BigDecimal resul = deci1.add(deci2);
            return ExactDecimal.extractUnscaledValue(resul, this.myContext);
        }

        public NumberContext context() {
            return this.myContext;
        }

        public long denominator() {
            return this.myDenominator;
        }

        public long divide(ExactDecimal<?> arg1, ExactDecimal<?> arg2) {
            BigDecimal deci1 = arg1.toBigDecimal();
            BigDecimal deci2 = arg2.toBigDecimal();
            BigDecimal resul = deci1.divide(deci2, this.myContext.getMathContext());
            return ExactDecimal.extractUnscaledValue(resul, this.myContext);
        }

        public long multiply(ExactDecimal<?> arg1, ExactDecimal<?> arg2) {
            BigDecimal deci1 = arg1.toBigDecimal();
            BigDecimal deci2 = arg2.toBigDecimal();
            BigDecimal resul = deci1.multiply(deci2);
            return ExactDecimal.extractUnscaledValue(resul, this.myContext);
        }

        public long subtract(ExactDecimal<?> arg1, ExactDecimal<?> arg2) {
            BigDecimal deci1 = arg1.toBigDecimal();
            BigDecimal deci2 = arg2.toBigDecimal();
            BigDecimal resul = deci1.subtract(deci2);
            return ExactDecimal.extractUnscaledValue(resul, this.myContext);
        }
    }
}

