/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import org.ojalgo.scalar.Amount;
import org.ojalgo.scalar.ExactDecimal;
import org.ojalgo.scalar.Quantity;
import org.ojalgo.scalar.Scalar;

public final class Price
extends ExactDecimal<Price> {
    public static final ExactDecimal.Descriptor DESCRIPTOR = new ExactDecimal.Descriptor(8);
    public static final Scalar.Factory<Price> FACTORY = new ExactDecimal.Factory<Price>(){

        @Override
        public Price cast(double value) {
            return Price.valueOf(value);
        }

        @Override
        public Price cast(Comparable<?> number) {
            return Price.valueOf(number);
        }

        public Price convert(double value) {
            return Price.valueOf(value);
        }

        public Price convert(Comparable<?> number) {
            return Price.valueOf(number);
        }

        @Override
        public ExactDecimal.Descriptor descriptor() {
            return DESCRIPTOR;
        }

        public Price one() {
            return ONE;
        }

        public Price zero() {
            return ZERO;
        }
    };
    private static final double DOUBLE_DENOMINATOR = 1.0E8;
    private static final long LONG_DENOMINATOR = 100000000L;
    public static final Price NEG = new Price(-100000000L);
    public static final Price ONE = new Price(100000000L);
    public static final Price TWO = new Price(200000000L);
    public static final Price ZERO = new Price();

    public static Price valueOf(double value) {
        return new Price(Math.round(value * 1.0E8));
    }

    public static Price valueOf(Comparable<?> number) {
        if (number == null) {
            return ZERO;
        }
        if (number instanceof Price) {
            return (Price)number;
        }
        return Price.valueOf(Scalar.doubleValue(number));
    }

    public Price() {
        super(0L);
    }

    Price(long numerator) {
        super(numerator);
    }

    @Override
    public Amount multiply(Quantity quanntity) {
        return new Amount(Amount.DESCRIPTOR.multiply(this, quanntity));
    }

    @Override
    protected ExactDecimal.Descriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected Price wrap(long numerator) {
        return new Price(numerator);
    }
}

