/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.scalar.SelfDeclaringScalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class RationalNumber
implements SelfDeclaringScalar<RationalNumber> {
    public static final Scalar.Factory<RationalNumber> FACTORY = new Scalar.Factory<RationalNumber>(){

        @Override
        public RationalNumber cast(Comparable<?> number) {
            return RationalNumber.valueOf(number);
        }

        @Override
        public RationalNumber cast(double value) {
            return RationalNumber.valueOf(value);
        }

        public RationalNumber convert(Comparable<?> number) {
            return RationalNumber.valueOf(number);
        }

        public RationalNumber convert(double value) {
            return RationalNumber.valueOf(value);
        }

        public RationalNumber one() {
            return ONE;
        }

        public RationalNumber zero() {
            return ZERO;
        }
    };
    public static final RationalNumber MAX_VALUE = new RationalNumber(Long.MAX_VALUE, 1L);
    public static final RationalNumber MIN_VALUE = new RationalNumber(Long.MIN_VALUE, 1L);
    public static final RationalNumber NaN = new RationalNumber(0L, 0L);
    public static final RationalNumber NEG = new RationalNumber(-1L, 1L);
    public static final RationalNumber NEGATIVE_INFINITY = new RationalNumber(-1L, 0L);
    public static final RationalNumber ONE = new RationalNumber(1L, 1L);
    public static final RationalNumber POSITIVE_INFINITY = new RationalNumber(1L, 0L);
    public static final RationalNumber TWO = new RationalNumber(2L, 1L);
    public static final RationalNumber ZERO = new RationalNumber(0L, 1L);
    private static final String DIVIDE = " / ";
    private static final String LEFT = "(";
    private static final int MAX_BITS = BigInteger.valueOf(Long.MAX_VALUE).bitLength();
    private static final String RIGHT = ")";
    private static final long SAFE_LIMIT = Math.round(Math.sqrt(4.611686018427388E18));
    private transient BigDecimal myDecimal = null;
    private final long myDenominator;
    private final long myNumerator;

    public static boolean isAbsolute(RationalNumber value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(RationalNumber value) {
        return value.getNumerator() != 0L && value.getDenominator() == 0L;
    }

    public static boolean isNaN(RationalNumber value) {
        return value.getNumerator() == 0L && value.getDenominator() == 0L;
    }

    public static boolean isSmall(double comparedTo, RationalNumber value) {
        return value.isSmall(comparedTo);
    }

    public static RationalNumber of(long numerator, long denominator) {
        if (denominator == 0L) {
            if (numerator > 0L) {
                return POSITIVE_INFINITY;
            }
            if (numerator < 0L) {
                return NEGATIVE_INFINITY;
            }
            return NaN;
        }
        if (numerator == 0L) {
            return ZERO;
        }
        long gcd = RationalNumber.gcd(numerator, denominator);
        if (gcd != 1L) {
            return new RationalNumber(numerator / gcd, denominator / gcd);
        }
        return new RationalNumber(numerator, denominator);
    }

    public static RationalNumber parse(CharSequence plainNumberString) {
        String string = plainNumberString.toString();
        BigDecimal number = new BigDecimal(string);
        return RationalNumber.valueOf(number);
    }

    public static RationalNumber rational(double d) {
        if (d < 0.0) {
            return RationalNumber.rational(-d, 1.0, 39).negate();
        }
        return RationalNumber.rational(d, 1.0, 39);
    }

    public static RationalNumber valueOf(Comparable<?> number) {
        BigInteger retDenom;
        BigInteger retNumer;
        if (number == null) {
            return ZERO;
        }
        if (number instanceof RationalNumber) {
            return (RationalNumber)number;
        }
        BigDecimal tmpBigD = TypeUtils.toBigDecimal(number);
        int scale = tmpBigD.scale();
        if (scale < 0) {
            retNumer = tmpBigD.unscaledValue().multiply(BigInteger.TEN.pow(-scale));
            retDenom = BigInteger.ONE;
        } else {
            retNumer = tmpBigD.unscaledValue();
            BigInteger gcd = retNumer.gcd(retDenom = BigInteger.TEN.pow(scale));
            if (gcd.compareTo(BigInteger.ONE) > 0) {
                retNumer = retNumer.divide(gcd);
                retDenom = retDenom.divide(gcd);
            }
        }
        int bits = Math.max(retNumer.bitLength(), retDenom.bitLength());
        if (bits > MAX_BITS) {
            int shift = bits - MAX_BITS;
            retNumer = retNumer.shiftRight(shift);
            retDenom = retDenom.shiftRight(shift);
        }
        return new RationalNumber(retNumer.longValue(), retDenom.longValue());
    }

    public static RationalNumber valueOf(double value) {
        if (Double.isNaN(value)) {
            return NaN;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        long bits = Double.doubleToLongBits(value);
        int s = bits >> 63 == 0L ? 1 : -1;
        int e = (int)(bits >> 52 & 0x7FFL);
        long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        int exponent = e - 1075;
        if (exponent >= 0) {
            long numerator = m << exponent;
            if (numerator >> exponent != m) {
                return s > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            }
            return new RationalNumber((long)s * numerator, 1L);
        }
        while ((m & 1L) == 0L && exponent < 0) {
            m >>= 1;
            ++exponent;
        }
        if (-exponent >= MAX_BITS) {
            BigInteger maxlong;
            BigInteger denom = BigInteger.ONE.shiftLeft(-exponent);
            BigInteger factor = denom.divide(maxlong = BigInteger.valueOf(Long.MAX_VALUE));
            if (factor.compareTo(maxlong) > 0) {
                return ZERO;
            }
            return new RationalNumber((long)s * m / factor.longValueExact(), Long.MAX_VALUE);
        }
        return new RationalNumber((long)s * m, 1L << -exponent);
    }

    public static RationalNumber valueOf(long value) {
        return RationalNumber.fromLong(value);
    }

    private static RationalNumber add(RationalNumber arg1, RationalNumber arg2) {
        BigInteger numer1 = BigInteger.valueOf(arg1.getNumerator());
        BigInteger denom1 = BigInteger.valueOf(arg1.getDenominator());
        BigInteger numer2 = BigInteger.valueOf(arg2.getNumerator());
        BigInteger denom2 = BigInteger.valueOf(arg2.getDenominator());
        BigInteger retNumer = numer1.multiply(denom2).add(numer2.multiply(denom1));
        BigInteger retDenom = denom1.multiply(denom2);
        return RationalNumber.of(retNumer, retDenom);
    }

    private static RationalNumber divide(RationalNumber arg1, RationalNumber arg2) {
        BigInteger numer1 = BigInteger.valueOf(arg1.getNumerator());
        BigInteger denom1 = BigInteger.valueOf(arg1.getDenominator());
        BigInteger numer2 = BigInteger.valueOf(arg2.getNumerator());
        BigInteger denom2 = BigInteger.valueOf(arg2.getDenominator());
        BigInteger retNumer = numer1.multiply(denom2);
        BigInteger retDenom = denom1.multiply(numer2);
        return RationalNumber.of(retNumer, retDenom);
    }

    private static RationalNumber fromLong(long d) {
        return RationalNumber.of(d, 1L);
    }

    private static long gcd(long a, long b) {
        long retVal = 1L;
        long value1 = Math.abs(a);
        long value2 = Math.abs(b);
        long tmpMax = Math.max(value1, value2);
        long tmpMin = Math.min(value1, value2);
        while (tmpMin != 0L) {
            retVal = tmpMin;
            tmpMin = tmpMax % tmpMin;
            tmpMax = retVal;
        }
        return b < 0L ? -retVal : retVal;
    }

    private static RationalNumber multiply(RationalNumber arg1, RationalNumber arg2) {
        BigInteger numer1 = BigInteger.valueOf(arg1.getNumerator());
        BigInteger denom1 = BigInteger.valueOf(arg1.getDenominator());
        BigInteger numer2 = BigInteger.valueOf(arg2.getNumerator());
        BigInteger denom2 = BigInteger.valueOf(arg2.getDenominator());
        BigInteger retNumer = numer1.multiply(numer2);
        BigInteger retDenom = denom1.multiply(denom2);
        return RationalNumber.of(retNumer, retDenom);
    }

    private static RationalNumber of(BigInteger numer, BigInteger denom) {
        int bits;
        BigInteger gcd = numer.gcd(denom);
        if (gcd.compareTo(BigInteger.ONE) > 0) {
            numer = numer.divide(gcd);
            denom = denom.divide(gcd);
        }
        if (denom.signum() == -1) {
            numer = numer.negate();
            denom = denom.negate();
        }
        if ((bits = Math.max(numer.bitLength(), denom.bitLength())) > MAX_BITS) {
            int shift = bits - MAX_BITS;
            numer = numer.shiftRight(shift);
            denom = denom.shiftRight(shift);
        }
        return RationalNumber.of(numer.longValueExact(), denom.longValueExact());
    }

    private static RationalNumber rational(double d, double error, int depthLimit) {
        assert (d >= 0.0);
        if (d > 9.223372036854776E18) {
            throw new ArithmeticException("Cannot fit a double into long!");
        }
        double a = Math.floor(d);
        RationalNumber approximation = RationalNumber.fromLong((long)a);
        double remainder = d - a;
        double newError = error * remainder;
        if (newError > PrimitiveMath.MACHINE_EPSILON && depthLimit > 0) {
            RationalNumber rationalRemainder = RationalNumber.rational(1.0 / remainder, newError, depthLimit - 1).invert();
            return approximation.add(rationalRemainder);
        }
        return approximation;
    }

    private static RationalNumber subtract(RationalNumber arg1, RationalNumber arg2) {
        BigInteger numer1 = BigInteger.valueOf(arg1.getNumerator());
        BigInteger denom1 = BigInteger.valueOf(arg1.getDenominator());
        BigInteger numer2 = BigInteger.valueOf(arg2.getNumerator());
        BigInteger denom2 = BigInteger.valueOf(arg2.getDenominator());
        BigInteger retNumer = numer1.multiply(denom2).subtract(numer2.multiply(denom1));
        BigInteger retDenom = denom1.multiply(denom2);
        return RationalNumber.of(retNumer, retDenom);
    }

    private static String toString(RationalNumber aNmbr) {
        StringBuilder retVal = new StringBuilder(LEFT);
        retVal.append(aNmbr.getNumerator());
        retVal.append(DIVIDE);
        retVal.append(aNmbr.getDenominator());
        return retVal.append(RIGHT).toString();
    }

    public RationalNumber() {
        this(0L, 1L);
    }

    private RationalNumber(long numerator, long denominator) {
        assert (denominator >= 0L);
        this.myNumerator = numerator;
        this.myDenominator = denominator;
        if (denominator == 0L && Math.abs(numerator) > 1L) {
            throw new ArithmeticException("n / 0, where abs(n) > 1");
        }
    }

    @Override
    public RationalNumber add(double arg) {
        return this.add(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber add(RationalNumber arg) {
        if (this.isNaN() || arg.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (!RationalNumber.isInfinite(arg) || this.sign() == arg.sign()) {
                return this;
            }
            return NaN;
        }
        if (Math.max(this.size(), arg.size()) <= SAFE_LIMIT) {
            if (this.myDenominator == arg.getDenominator()) {
                return new RationalNumber(this.myNumerator + arg.getNumerator(), this.myDenominator);
            }
            long retNumer = this.myNumerator * arg.getDenominator() + arg.getNumerator() * this.myDenominator;
            long retDenom = this.myDenominator * arg.getDenominator();
            return RationalNumber.of(retNumer, retDenom);
        }
        return RationalNumber.add(this, arg);
    }

    @Override
    public int compareTo(RationalNumber reference) {
        long refNumer = reference.getNumerator();
        long refDenom = reference.getDenominator();
        if (refDenom == 0L) {
            if (this.myDenominator == 0L) {
                return Long.compare(this.myNumerator, refNumer);
            }
            if (refNumer > 0L) {
                return -1;
            }
            return 1;
        }
        if (this.myDenominator == 0L) {
            if (this.myNumerator > 0L) {
                return 1;
            }
            return -1;
        }
        return this.toBigDecimal().compareTo(reference.toBigDecimal());
    }

    @Override
    public RationalNumber conjugate() {
        return this;
    }

    @Override
    public RationalNumber divide(double arg) {
        return this.divide(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber divide(RationalNumber arg) {
        if (this.isNaN() || arg.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (!RationalNumber.isInfinite(arg)) {
                return arg.sign() > 0 ? this : this.negate();
            }
            return NaN;
        }
        if (Math.max(this.size(), arg.size()) <= SAFE_LIMIT) {
            long retNumer = this.myNumerator * arg.getDenominator();
            long retDenom = this.myDenominator * arg.getNumerator();
            return RationalNumber.of(retNumer, retDenom);
        }
        return RationalNumber.divide(this, arg);
    }

    @Override
    public double doubleValue() {
        if (this.myDenominator == 0L) {
            switch (Long.compare(this.myNumerator, 0L)) {
                case 1: {
                    return Double.POSITIVE_INFINITY;
                }
                case -1: {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            return Double.NaN;
        }
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public RationalNumber enforce(NumberContext context) {
        return RationalNumber.valueOf(this.toBigDecimal(context.getMathContext()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RationalNumber)) {
            return false;
        }
        RationalNumber other = (RationalNumber)obj;
        return this.myDenominator == other.myDenominator && this.myNumerator == other.myNumerator;
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public RationalNumber get() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.myDenominator ^ this.myDenominator >>> 32);
        return 31 * result + (int)(this.myNumerator ^ this.myNumerator >>> 32);
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public RationalNumber invert() {
        return this.sign() >= 0 ? new RationalNumber(this.myDenominator, this.myNumerator) : new RationalNumber(-this.myDenominator, -this.myNumerator);
    }

    @Override
    public boolean isAbsolute() {
        return this.myNumerator >= 0L;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return BigScalar.CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public RationalNumber multiply(double arg) {
        return this.multiply(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber multiply(RationalNumber arg) {
        if (this.isNaN() || arg.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            return arg.sign() > 0 ? this : this.negate();
        }
        if (Math.max(this.size(), arg.size()) <= SAFE_LIMIT) {
            long retNumer = this.myNumerator * arg.getNumerator();
            long retDenom = this.myDenominator * arg.getDenominator();
            return RationalNumber.of(retNumer, retDenom);
        }
        return RationalNumber.multiply(this, arg);
    }

    @Override
    public RationalNumber negate() {
        return new RationalNumber(-this.myNumerator, this.myDenominator);
    }

    @Override
    public double norm() {
        return PrimitiveMath.ABS.invoke(this.doubleValue());
    }

    @Override
    public RationalNumber power(int power) {
        RationalNumber retVal = ONE;
        for (int p = 0; p < power; ++p) {
            retVal = retVal.multiply(this);
        }
        return retVal;
    }

    @Override
    public RationalNumber signum() {
        if (!this.isInfinite() && RationalNumber.isSmall(PrimitiveMath.ONE, this)) {
            return ZERO;
        }
        if (this.sign() == -1) {
            return NEG;
        }
        return ONE;
    }

    @Override
    public RationalNumber subtract(double arg) {
        return this.subtract(RationalNumber.valueOf(arg));
    }

    @Override
    public RationalNumber subtract(RationalNumber arg) {
        if (this.isNaN() || arg.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (!arg.isInfinite() || this.sign() != arg.sign()) {
                return this;
            }
            return NaN;
        }
        if (Math.max(this.size(), arg.size()) <= SAFE_LIMIT) {
            if (this.myDenominator == arg.getDenominator()) {
                return new RationalNumber(this.myNumerator - arg.getNumerator(), this.myDenominator);
            }
            long retNumer = this.myNumerator * arg.getDenominator() - arg.getNumerator() * this.myDenominator;
            long retDenom = this.myDenominator * arg.getDenominator();
            return RationalNumber.of(retNumer, retDenom);
        }
        return RationalNumber.subtract(this, arg);
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(BigScalar.CONTEXT.getMathContext());
        }
        return this.myDecimal;
    }

    public String toString() {
        return RationalNumber.toString(this);
    }

    @Override
    public String toString(NumberContext context) {
        return RationalNumber.toString(this.enforce(context));
    }

    private boolean isInfinite() {
        return RationalNumber.isInfinite(this);
    }

    private boolean isNaN() {
        return RationalNumber.isNaN(this);
    }

    private int sign() {
        return Long.compare(this.myNumerator, 0L);
    }

    private long size() {
        return Math.max(Math.abs(this.myNumerator), this.myDenominator);
    }

    private BigDecimal toBigDecimal(MathContext context) {
        if (this.myDenominator == 0L) {
            throw new NumberFormatException();
        }
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), context);
    }

    long getDenominator() {
        return this.myDenominator;
    }

    long getNumerator() {
        return this.myNumerator;
    }
}

