/*
 * Decompiled with CFR 0.152.
 */
package no.uib.olsdialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.rpc.ServiceException;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.olsdialog.OLSInputable;
import no.uib.olsdialog.util.BareBonesBrowserLaunch;
import no.uib.olsdialog.util.HelpDialog;
import no.uib.olsdialog.util.MyComboBoxRenderer;
import no.uib.olsdialog.util.SimpleNewtSelection;
import no.uib.olsdialog.util.TermHierarchyGraphViewer;
import no.uib.olsdialog.util.TreeBrowser;
import no.uib.olsdialog.util.Util;
import org.jdesktop.layout.GroupLayout;
import uk.ac.ebi.ols.soap.Query;
import uk.ac.ebi.ols.soap.QueryServiceLocator;
import uk.ac.ebi.ols.soap.model.DataHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLSDialog
extends JDialog {
    public static final boolean debug = false;
    private String field;
    private String selectedOntology;
    private int modifiedRow = -1;
    private OLSInputable olsInputable;
    private String mappedTerm;
    private Map<String, List<String>> preselectedOntologies;
    private Map<String, String> preselectedNames2Ids;
    private int keyPressedCounter = 0;
    private int waitingTime = 1000;
    private final int MINIMUM_WORD_LENGTH = 3;
    private String defaultOlsConnectionFailureErrorMessage = "An error occured when trying to contact the OLS. Make sure that\nyou are online. Also check your firewall (and proxy) settings.\n\nSee the Troubleshooting section at the OLS Dialog home page\nfor details: http://ols-dialog.googlecode.com.";
    public static final Integer OLS_DIALOG_TERM_NAME_SEARCH = 0;
    public static final Integer OLS_DIALOG_TERM_ID_SEARCH = 1;
    public static final Integer OLS_DIALOG_PSI_MOD_MASS_SEARCH = 2;
    public static final Integer OLS_DIALOG_BROWSE_ONTOLOGY = 3;
    private static Query olsConnection;
    private TreeBrowser treeBrowser;
    private String currentlySelectedBrowseOntologyAccessionNumber = null;
    private String currentlySelectedTermNameSearchAccessionNumber = null;
    private String currentlySelectedTermIdSearchAccessionNumber = null;
    private String currentlySelectedMassSearchAccessionNumber = null;
    private String lastSelectedOntology = null;
    private final int MAX_TOOL_TIP_LENGTH = 40;
    private Map<String, String> metadata;
    private String selectedRowHtmlTagFontColor = "#FFFFFF";
    private String notSelectedRowHtmlTagFontColor = "#0101DF";
    private JButton aboutJButton;
    private JPanel backgroundPanel;
    private JPanel browseJPanel;
    private JPanel browseOntologyJPanel;
    private JButton cancelJButton;
    private JTextPane definitionBrowseOntologyJTextPane;
    private JTextPane definitionMassSearchJTextPane;
    private JScrollPane definitionSelectedTermMassSearchScrollPane;
    private JTextPane definitionTermIdSearchJTextPane;
    private JScrollPane definitionTermNameIdSearchScrollPane;
    private JScrollPane definitionTermNameScrollPane;
    private JTextPane definitionTermNameSearchJTextPane;
    private JLabel dummyLabelJLabel;
    private JButton helpJButton;
    private JButton insertSelectedJButton;
    private JLabel massLabel;
    private JPanel massPanel;
    private JPanel massSearchJPanel;
    private JComboBox massTypeJComboBox;
    private JTextField modificationMassJTextField;
    private JButton modificationMassSearchJButton;
    private JLabel newtSpeciesTipsTermIdSearchJLabel;
    private JLabel newtSpeciesTipsTermNameSearchJLabel;
    private JTextField numberOfTermsTermNameSearchJTextField;
    private JScrollPane olsResultsMassSearchJScrollPane;
    private JTable olsResultsMassSearchJTable;
    private JScrollPane olsResultsTermIdSearchJScrollPane;
    private JTable olsResultsTermIdSearchJTable;
    private JScrollPane olsResultsTermNameSearchJScrollPane;
    private JTable olsResultsTermNameSearchJTable;
    private JComboBox ontologyJComboBox;
    private JLabel ontologyJLabel;
    private JLabel plussMinusLabel;
    private JTextField precisionJTextField;
    private JPanel searchParametersJPanel;
    private JLabel searchResultsMassSearchLabel;
    private JLabel searchResultsTermIdLabel;
    private JLabel searchResultsTermNameJLabel;
    private JLabel searchTermMassSearchLabel;
    private JLabel searchTermTermIdLabel;
    private JTabbedPane searchTypeJTabbedPane;
    private JLabel selectedTermBrowseLabel;
    private JLabel selectedTermTermNameJLabel;
    private JScrollPane termDetailsBrowseOntologyJScrollPane;
    private JTable termDetailsBrowseOntologyJTable;
    private JScrollPane termDetailsMassSearchJScrollPane;
    private JTable termDetailsMassSearchJTable;
    private JScrollPane termDetailsTermIdSearchJScrollPane;
    private JTable termDetailsTermIdSearchJTable;
    private JScrollPane termDetailsTermNameSearchJScrollPane;
    private JTable termDetailsTermNameSearchJTable;
    private JLabel termIdLabel;
    private JPanel termIdPanel;
    private JButton termIdSearchJButton;
    private JPanel termIdSearchJPanel;
    private JTextField termIdSearchJTextField;
    private JLabel termNameJLabel;
    private JPanel termNameJPanel;
    private JPanel termNameSearchJPanel;
    private JTextField termNameSearchJTextField;
    private JScrollPane treeScrollPane;
    private JLabel typeLabel;
    private JLabel viewTermHierarchyBrowseOntologyJLabel;
    private JLabel viewTermHierarchyMassSearchJLabel;
    private JLabel viewTermHierarchyTermIdSearchJLabel;
    private JLabel viewTermHierarchyTermNameSearchJLabel;

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, Map<String, List<String>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, String term, Map<String, List<String>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, -1, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Map<String, List<String>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, null);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Map<String, List<String>> preselectedOntologies) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, null, null, OLS_DIALOG_TERM_NAME_SEARCH, preselectedOntologies);
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<String>> preselectedOntologies) {
        super((Frame)parent, modal);
        this.olsInputable = olsInputable;
        this.field = field;
        this.selectedOntology = selectedOntology;
        this.modifiedRow = modifiedRow;
        this.mappedTerm = term;
        this.preselectedOntologies = preselectedOntologies == null ? new HashMap<String, List<String>>() : preselectedOntologies;
        this.setUpFrame(searchType);
        boolean error = this.openOlsConnectionAndInsertOntologyNames();
        if (error) {
            this.dispose();
        } else {
            this.insertValues(modificationMass, modificationAccuracy, searchType);
            this.setLocationRelativeTo(parent);
            this.setVisible(true);
        }
    }

    public OLSDialog(JFrame parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, null);
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType, Map<String, List<String>> preselectedOntologies) {
        super((Dialog)parent, modal);
        this.olsInputable = olsInputable;
        this.field = field;
        this.selectedOntology = selectedOntology;
        this.modifiedRow = modifiedRow;
        this.mappedTerm = term;
        this.preselectedOntologies = preselectedOntologies == null ? new HashMap<String, List<String>>() : preselectedOntologies;
        this.setUpFrame(searchType);
        boolean error = this.openOlsConnectionAndInsertOntologyNames();
        if (error) {
            this.dispose();
        } else {
            this.insertValues(modificationMass, modificationAccuracy, searchType);
            this.setLocationRelativeTo(parent);
            this.setVisible(true);
        }
    }

    public OLSDialog(JDialog parent, OLSInputable olsInputable, boolean modal, String field, String selectedOntology, int modifiedRow, String term, Double modificationMass, Double modificationAccuracy, Integer searchType) {
        this(parent, olsInputable, modal, field, selectedOntology, modifiedRow, term, modificationMass, modificationAccuracy, searchType, null);
    }

    private void insertValues(Double modificationMass, Double modificationAccuracy, Integer searchType) {
        if (this.mappedTerm != null) {
            this.termNameSearchJTextField.setText(this.mappedTerm);
            this.termNameSearchJTextFieldKeyReleased(null);
        }
        if (modificationAccuracy != null) {
            this.precisionJTextField.setText(modificationAccuracy.toString());
        }
        if (modificationMass != null) {
            this.modificationMassJTextField.setText(modificationMass.toString());
            this.modificationMassSearchJButtonActionPerformed(null);
        }
        this.updateBrowseOntologyView();
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.termNameSearchJTextField.requestFocus();
        } else if (searchType != OLS_DIALOG_BROWSE_ONTOLOGY && searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.modificationMassJTextField.requestFocus();
        }
    }

    private void setUpFrame(Integer searchType) {
        this.initComponents();
        this.olsResultsTermNameSearchJTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        this.olsResultsTermIdSearchJTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        this.olsResultsMassSearchJTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        this.olsResultsTermNameSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsTermNameSearchJScrollPane.getViewport().setOpaque(false);
        this.olsResultsTermIdSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsTermIdSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsMassSearchJScrollPane.getViewport().setOpaque(false);
        this.olsResultsMassSearchJScrollPane.getViewport().setOpaque(false);
        this.termDetailsBrowseOntologyJScrollPane.getViewport().setOpaque(false);
        this.setTitle("Ontology Lookup Service - (ols-dialog v" + this.getVersion() + ")");
        this.dummyLabelJLabel.setForeground(this.massSearchJPanel.getBackground());
        this.treeBrowser = new TreeBrowser(this);
        this.browseJPanel.add(this.treeBrowser);
        this.searchTypeJTabbedPane.setSelectedIndex(searchType);
        this.ontologyJComboBox.setRenderer(new MyComboBoxRenderer(null, 0));
        this.massTypeJComboBox.setRenderer(new MyComboBoxRenderer(null, 0));
        this.olsResultsTermNameSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsMassSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsTermIdSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsTermNameSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsMassSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsBrowseOntologyJTable.getTableHeader().setReorderingAllowed(false);
        this.termDetailsTermIdSearchJTable.getTableHeader().setReorderingAllowed(false);
        this.olsResultsTermNameSearchJTable.setSelectionMode(0);
        this.olsResultsMassSearchJTable.setSelectionMode(0);
        this.olsResultsTermIdSearchJTable.setSelectionMode(0);
    }

    public String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("ols-dialog.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("ols-dialog.version");
    }

    public Map<String, String> getOntologyRoots(String ontology) {
        return this.getOntologyRoots(ontology, null);
    }

    public Map<String, String> getOntologyRoots(String ontology, String parentTerm) {
        HashMap<String, String> retrievedValues = new HashMap<String, String>();
        try {
            HashMap roots = parentTerm == null ? olsConnection.getRootTerms(ontology) : olsConnection.getTermChildren(parentTerm, ontology, 1, null);
            if (roots != null) {
                retrievedValues.putAll(roots);
            }
        }
        catch (RemoteException e) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            e.printStackTrace();
        }
        return retrievedValues;
    }

    public void clearData(Integer searchType, boolean clearSearchResults, boolean clearMetaData) {
        JTextPane currentDefinitionsJTextPane = null;
        JTable currentTermDetailsJTable = null;
        JScrollPane currentTermDetailsJScrollPane = null;
        JTable currentSearchResultsJTable = null;
        JScrollPane currentSearchResultsJScrollPane = null;
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.currentlySelectedTermNameSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsTermNameSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsTermNameSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionTermNameSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermNameSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermNameSearchJScrollPane;
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.currentlySelectedMassSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsMassSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsMassSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionMassSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsMassSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsMassSearchJScrollPane;
            this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.currentlySelectedBrowseOntologyAccessionNumber = null;
            currentDefinitionsJTextPane = this.definitionBrowseOntologyJTextPane;
            currentTermDetailsJTable = this.termDetailsBrowseOntologyJTable;
            currentTermDetailsJScrollPane = this.termDetailsBrowseOntologyJScrollPane;
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.currentlySelectedTermIdSearchAccessionNumber = null;
            currentSearchResultsJTable = this.olsResultsTermIdSearchJTable;
            currentSearchResultsJScrollPane = this.olsResultsTermIdSearchJScrollPane;
            currentDefinitionsJTextPane = this.definitionTermIdSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermIdSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermIdSearchJScrollPane;
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        }
        if (clearMetaData) {
            currentDefinitionsJTextPane.setText("");
            while (currentTermDetailsJTable.getRowCount() > 0) {
                ((DefaultTableModel)currentTermDetailsJTable.getModel()).removeRow(0);
            }
            currentTermDetailsJScrollPane.getVerticalScrollBar().setValue(0);
        }
        if (clearSearchResults && searchType != OLS_DIALOG_BROWSE_ONTOLOGY) {
            while (currentSearchResultsJTable.getRowCount() > 0) {
                ((DefaultTableModel)currentSearchResultsJTable.getModel()).removeRow(0);
            }
            currentSearchResultsJScrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    public boolean loadChildren(TreeNode parent, String termId) {
        if (termId == null) {
            return false;
        }
        boolean error = false;
        String ontology = this.getCurrentOntologyLabel();
        HashMap childTerms = null;
        try {
            childTerms = olsConnection.getTermChildren(termId, ontology, 1, null);
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        if (!error && !childTerms.isEmpty()) {
            for (String tId : childTerms.keySet()) {
                this.treeBrowser.addNode(tId, childTerms.get(tId));
            }
            return true;
        }
        return false;
    }

    private String getOntologyLabelFromTermId(String termId) {
        Object ontologyLabel = termId.lastIndexOf(":") != -1 ? termId.substring(0, termId.lastIndexOf(":")) : (termId.lastIndexOf("_") != -1 ? termId.substring(0, termId.lastIndexOf("_")) : (termId.equalsIgnoreCase("No Root Terms Defined!") ? null : "NEWT"));
        return ontologyLabel;
    }

    public void loadMetaData(String termId, Integer searchType) {
        JTextPane currentDefinitionsJTextPane = null;
        JTable currentTermDetailsJTable = null;
        JScrollPane currentTermDetailsJScrollPane = null;
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            currentDefinitionsJTextPane = this.definitionTermNameSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermNameSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermNameSearchJScrollPane;
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            currentDefinitionsJTextPane = this.definitionMassSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsMassSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsMassSearchJScrollPane;
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            currentDefinitionsJTextPane = this.definitionBrowseOntologyJTextPane;
            currentTermDetailsJTable = this.termDetailsBrowseOntologyJTable;
            currentTermDetailsJScrollPane = this.termDetailsBrowseOntologyJScrollPane;
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            currentDefinitionsJTextPane = this.definitionTermIdSearchJTextPane;
            currentTermDetailsJTable = this.termDetailsTermIdSearchJTable;
            currentTermDetailsJScrollPane = this.termDetailsTermIdSearchJScrollPane;
        }
        this.clearData(searchType, false, true);
        if (termId == null) {
            return;
        }
        String ontology = this.getOntologyLabelFromTermId(termId);
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.currentlySelectedTermNameSearchAccessionNumber = termId;
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.currentlySelectedMassSearchAccessionNumber = termId;
            this.viewTermHierarchyMassSearchJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.currentlySelectedBrowseOntologyAccessionNumber = termId;
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(true);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.currentlySelectedTermIdSearchAccessionNumber = termId;
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(true);
        }
        boolean error = false;
        if (ontology != null && ontology.equalsIgnoreCase("NEWT")) {
            currentDefinitionsJTextPane.setText("Retreiving 'Term Details' is disabled for NEWT.");
            currentDefinitionsJTextPane.setCaretPosition(0);
            currentTermDetailsJTable.setEnabled(false);
            error = true;
        } else {
            currentTermDetailsJTable.setEnabled(true);
        }
        if (!error) {
            this.metadata = null;
            HashMap xRefs = null;
            try {
                this.metadata = olsConnection.getTermMetadata(termId, ontology);
                xRefs = olsConnection.getTermXrefs(termId, ontology);
            }
            catch (RemoteException ex) {
                JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
                Util.writeToErrorLog("Error when trying to access OLS: ");
                ex.printStackTrace();
                if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
                    this.currentlySelectedTermNameSearchAccessionNumber = null;
                } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
                    this.currentlySelectedMassSearchAccessionNumber = null;
                } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
                    this.currentlySelectedBrowseOntologyAccessionNumber = null;
                } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
                    this.currentlySelectedTermIdSearchAccessionNumber = termId;
                }
                error = true;
            }
            if (!error && !this.metadata.isEmpty()) {
                for (String key : this.metadata.keySet()) {
                    if (key != null && key.equalsIgnoreCase("definition")) {
                        currentDefinitionsJTextPane.setText("" + this.metadata.get(key));
                        currentDefinitionsJTextPane.setCaretPosition(0);
                        continue;
                    }
                    ((DefaultTableModel)currentTermDetailsJTable.getModel()).addRow(new Object[]{key, this.metadata.get(key)});
                }
                if (currentDefinitionsJTextPane.getText().equalsIgnoreCase("null")) {
                    currentDefinitionsJTextPane.setText("(no definition provided in CV term)");
                }
                for (String key : xRefs.keySet()) {
                    ((DefaultTableModel)currentTermDetailsJTable.getModel()).addRow(new Object[]{key, xRefs.get(key)});
                }
                currentTermDetailsJScrollPane.getVerticalScrollBar().setValue(0);
            } else if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
                this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
            } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
                this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
            } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
                this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
            } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
                this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
            }
        } else if (ontology != null && ontology.equalsIgnoreCase("NEWT")) {
            if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
                this.viewTermHierarchyTermNameSearchJLabel.setEnabled(true);
            } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
                this.viewTermHierarchyMassSearchJLabel.setEnabled(true);
            } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
                this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(true);
            } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
                this.viewTermHierarchyTermIdSearchJLabel.setEnabled(true);
            }
        } else if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        }
        if (searchType == OLS_DIALOG_TERM_NAME_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermNameSearchAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_PSI_MOD_MASS_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedMassSearchAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_BROWSE_ONTOLOGY) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedBrowseOntologyAccessionNumber != null);
        } else if (searchType == OLS_DIALOG_TERM_ID_SEARCH) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermIdSearchAccessionNumber != null);
        }
    }

    private void setTableToolTip(JTable table, Object value, int row, int column) {
        if (table != null) {
            if (table.getValueAt(row, column) != null) {
                if (column == 1 && table.getValueAt(row, column).toString().length() > 40) {
                    table.setToolTipText(this.buildToolTipText("" + value.toString(), 40));
                } else {
                    table.setToolTipText(null);
                }
            } else {
                table.setToolTipText(null);
            }
        } else {
            table.setToolTipText(null);
        }
    }

    private String buildToolTipText(String aToolTip, int maxToolTipLength) {
        String currentToolTip = "<html>";
        int indexOfLastSpace = 0;
        String currentToolTipLine = "";
        int currentStartIndex = 0;
        for (int i = 0; i < aToolTip.length(); ++i) {
            currentToolTipLine = currentToolTipLine + aToolTip.substring(i, i + 1);
            if (aToolTip.substring(i, i + 1).equalsIgnoreCase(" ")) {
                indexOfLastSpace = i;
            }
            if (currentToolTipLine.length() <= maxToolTipLength) continue;
            if (indexOfLastSpace == currentStartIndex) {
                currentToolTip = currentToolTip + aToolTip.substring(currentStartIndex, i + 1) + "-<br>";
                currentStartIndex = i + 1;
                indexOfLastSpace = i + 1;
                currentToolTipLine = "";
                continue;
            }
            currentToolTip = currentToolTip + aToolTip.substring(currentStartIndex, indexOfLastSpace) + "<br>";
            currentStartIndex = indexOfLastSpace;
            currentToolTipLine = "";
            i = currentStartIndex;
        }
        if (currentToolTipLine.length() > 0) {
            currentToolTip = currentToolTip + aToolTip.substring(currentStartIndex);
        }
        currentToolTip = currentToolTip + "</html>";
        return currentToolTip;
    }

    private boolean openOlsConnectionAndInsertOntologyNames() {
        boolean error = false;
        Vector<String> ontologyNamesAndKeys = new Vector<String>();
        this.preselectedNames2Ids = new HashMap<String, String>();
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            olsConnection = locator.getOntologyQuery();
            HashMap map = olsConnection.getOntologyNames();
            String ontologyToSelect = "";
            for (String key : map.keySet()) {
                String temp = map.get(key) + " [" + key + "]";
                if (this.preselectedOntologies.isEmpty()) {
                    ontologyNamesAndKeys.add(temp);
                } else if (this.preselectedOntologies.keySet().contains(key.toUpperCase())) {
                    if (this.preselectedOntologies.get(key.toUpperCase()) == null) {
                        ontologyNamesAndKeys.add(temp);
                    } else {
                        for (String ontologyTermId : this.preselectedOntologies.get(key.toUpperCase())) {
                            String ontologyTermName;
                            String suffix = ontologyTermName = olsConnection.getTermById(ontologyTermId, key);
                            if (ontologyTermName == null) {
                                suffix = ontologyTermId;
                            } else if (ontologyTermName.length() == 0) {
                                suffix = ontologyTermId;
                            }
                            String ontologyName = temp + " / " + suffix;
                            if (this.selectedOntology.equalsIgnoreCase(ontologyName)) {
                                ontologyToSelect = ontologyName;
                            }
                            ontologyNamesAndKeys.add(ontologyName);
                            this.preselectedNames2Ids.put(suffix, ontologyTermId);
                        }
                    }
                }
                if (!this.selectedOntology.equalsIgnoreCase(temp) && !this.selectedOntology.equalsIgnoreCase(key)) continue;
                ontologyToSelect = temp;
            }
            if (!this.preselectedOntologies.isEmpty() && this.preselectedOntologies.size() != ontologyNamesAndKeys.size()) {
                String msg = "Warning: One or more of your preselected ontologies have not been found in OLS";
                Util.writeToErrorLog(msg);
            }
            Collections.sort(ontologyNamesAndKeys);
            ontologyNamesAndKeys.add(0, "-- Search in All Ontologies available in the OLS registry --");
            if (this.preselectedOntologies.size() > 1) {
                ontologyNamesAndKeys.add(1, "-- Search in these preselected Ontologies --");
            }
            this.ontologyJComboBox.setModel(new DefaultComboBoxModel(ontologyNamesAndKeys));
            this.ontologyJComboBox.setSelectedItem(ontologyToSelect);
            this.hideOrShowNewtLinks();
            this.lastSelectedOntology = (String)this.ontologyJComboBox.getSelectedItem();
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "Failed to Contact the OLS", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        catch (ServiceException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "Failed to Contact the OLS", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        return error;
    }

    private void hideOrShowNewtLinks() {
        if (this.getCurrentOntologyLabel().equalsIgnoreCase("NEWT")) {
            this.newtSpeciesTipsTermNameSearchJLabel.setForeground(Color.BLUE);
            this.newtSpeciesTipsTermIdSearchJLabel.setForeground(Color.BLUE);
            this.newtSpeciesTipsTermNameSearchJLabel.setText("NEWT Species Tips");
            this.newtSpeciesTipsTermIdSearchJLabel.setText("NEWT Species Tips");
        } else {
            this.newtSpeciesTipsTermNameSearchJLabel.setText(" ");
            this.newtSpeciesTipsTermIdSearchJLabel.setText(" ");
        }
    }

    private void updateBrowseOntologyView() {
        this.setCursor(new Cursor(3));
        String ontology = this.getCurrentOntologyLabel();
        String parentTermName = this.getCurrentOntologyTermLabel();
        String parentTermId = this.preselectedNames2Ids.get(parentTermName);
        if (parentTermName != null && parentTermId != null) {
            this.treeBrowser.initialize("[" + parentTermId + "] " + parentTermName);
        } else {
            this.treeBrowser.initialize(ontology);
        }
        Map<String, String> rootTerms = this.getOntologyRoots(ontology, parentTermId);
        for (String termId : rootTerms.keySet()) {
            this.treeBrowser.addNode(termId, rootTerms.get(termId));
        }
        if (rootTerms.isEmpty()) {
            this.treeBrowser.addNode("No Root Terms Defined!", "");
        }
        this.treeBrowser.updateTree();
        this.treeBrowser.scrollToTop();
        this.currentlySelectedBrowseOntologyAccessionNumber = null;
        this.clearData(OLS_DIALOG_BROWSE_ONTOLOGY, true, true);
        this.setCursor(new Cursor(0));
    }

    public boolean addSecondLevelOfNodes(String termId, String ontology, DefaultMutableTreeNode parentNode) {
        boolean error = false;
        try {
            HashMap secondLevelChildTerms = olsConnection.getTermChildren(termId, ontology, 1, null);
            for (String tId2 : secondLevelChildTerms.keySet()) {
                this.treeBrowser.addNode(parentNode, tId2, secondLevelChildTerms.get(tId2), false);
            }
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
            error = true;
        }
        return error;
    }

    public String getCurrentOntologyLabel() {
        String ontology = (String)this.ontologyJComboBox.getSelectedItem();
        if (ontology.lastIndexOf("[") != -1) {
            ontology = ontology.substring(ontology.lastIndexOf("[") + 1, ontology.length());
        }
        if (ontology.lastIndexOf("]") != -1) {
            ontology = ontology.substring(0, ontology.lastIndexOf("]"));
        }
        return ontology;
    }

    public String getCurrentOntologyTermLabel() {
        String ontologyTerm = (String)this.ontologyJComboBox.getSelectedItem();
        ontologyTerm = ontologyTerm.lastIndexOf("/ ") != -1 ? ontologyTerm.substring(ontologyTerm.lastIndexOf("/ ") + 2, ontologyTerm.length()) : null;
        return ontologyTerm;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.insertSelectedJButton = new JButton();
        this.cancelJButton = new JButton();
        this.helpJButton = new JButton();
        this.aboutJButton = new JButton();
        this.searchParametersJPanel = new JPanel();
        this.searchTypeJTabbedPane = new JTabbedPane();
        this.termNameSearchJPanel = new JPanel();
        this.definitionTermNameScrollPane = new JScrollPane();
        this.definitionTermNameSearchJTextPane = new JTextPane();
        this.termDetailsTermNameSearchJScrollPane = new JScrollPane();
        this.termDetailsTermNameSearchJTable = new JTable();
        this.searchResultsTermNameJLabel = new JLabel();
        this.selectedTermTermNameJLabel = new JLabel();
        this.olsResultsTermNameSearchJScrollPane = new JScrollPane();
        this.olsResultsTermNameSearchJTable = new JTable();
        this.viewTermHierarchyTermNameSearchJLabel = new JLabel();
        this.termNameJPanel = new JPanel();
        this.termNameJLabel = new JLabel();
        this.termNameSearchJTextField = new JTextField();
        this.newtSpeciesTipsTermNameSearchJLabel = new JLabel();
        this.numberOfTermsTermNameSearchJTextField = new JTextField();
        this.termIdSearchJPanel = new JPanel();
        this.definitionTermNameIdSearchScrollPane = new JScrollPane();
        this.definitionTermIdSearchJTextPane = new JTextPane();
        this.termDetailsTermIdSearchJScrollPane = new JScrollPane();
        this.termDetailsTermIdSearchJTable = new JTable();
        this.searchResultsTermIdLabel = new JLabel();
        this.searchTermTermIdLabel = new JLabel();
        this.olsResultsTermIdSearchJScrollPane = new JScrollPane();
        this.olsResultsTermIdSearchJTable = new JTable();
        this.viewTermHierarchyTermIdSearchJLabel = new JLabel();
        this.termIdPanel = new JPanel();
        this.termIdLabel = new JLabel();
        this.termIdSearchJTextField = new JTextField();
        this.newtSpeciesTipsTermIdSearchJLabel = new JLabel();
        this.termIdSearchJButton = new JButton();
        this.massSearchJPanel = new JPanel();
        this.searchResultsMassSearchLabel = new JLabel();
        this.searchTermMassSearchLabel = new JLabel();
        this.definitionSelectedTermMassSearchScrollPane = new JScrollPane();
        this.definitionMassSearchJTextPane = new JTextPane();
        this.termDetailsMassSearchJScrollPane = new JScrollPane();
        this.termDetailsMassSearchJTable = new JTable();
        this.olsResultsMassSearchJScrollPane = new JScrollPane();
        this.olsResultsMassSearchJTable = new JTable();
        this.viewTermHierarchyMassSearchJLabel = new JLabel();
        this.massPanel = new JPanel();
        this.massLabel = new JLabel();
        this.modificationMassJTextField = new JTextField();
        this.plussMinusLabel = new JLabel();
        this.precisionJTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.massTypeJComboBox = new JComboBox();
        this.dummyLabelJLabel = new JLabel();
        this.modificationMassSearchJButton = new JButton();
        this.browseOntologyJPanel = new JPanel();
        this.selectedTermBrowseLabel = new JLabel();
        this.treeScrollPane = new JScrollPane();
        this.definitionBrowseOntologyJTextPane = new JTextPane();
        this.termDetailsBrowseOntologyJScrollPane = new JScrollPane();
        this.termDetailsBrowseOntologyJTable = new JTable();
        this.browseJPanel = new JPanel();
        this.viewTermHierarchyBrowseOntologyJLabel = new JLabel();
        this.ontologyJLabel = new JLabel();
        this.ontologyJComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(" Ontology Lookup Service - (ols-dialog v3.0)");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OLSDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.insertSelectedJButton.setText("Use Selected Term");
        this.insertSelectedJButton.setEnabled(false);
        this.insertSelectedJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.insertSelectedJButtonActionPerformed(evt);
            }
        });
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.setMaximumSize(new Dimension(121, 23));
        this.cancelJButton.setMinimumSize(new Dimension(121, 23));
        this.cancelJButton.setPreferredSize(new Dimension(121, 23));
        this.cancelJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/no/uib/olsdialog/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.helpJButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.aboutJButton.setIcon(new ImageIcon(this.getClass().getResource("/no/uib/olsdialog/icons/ols_transparent_small.GIF")));
        this.aboutJButton.setToolTipText("About");
        this.aboutJButton.setBorderPainted(false);
        this.aboutJButton.setContentAreaFilled(false);
        this.aboutJButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.aboutJButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.aboutJButtonMouseExited(evt);
            }
        });
        this.aboutJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.aboutJButtonActionPerformed(evt);
            }
        });
        this.searchParametersJPanel.setBorder(BorderFactory.createTitledBorder("Search Parameters"));
        this.searchParametersJPanel.setOpaque(false);
        this.searchTypeJTabbedPane.setBackground(new Color(230, 230, 230));
        this.searchTypeJTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OLSDialog.this.searchTypeJTabbedPaneStateChanged(evt);
            }
        });
        this.termNameSearchJPanel.setBackground(new Color(230, 230, 230));
        this.definitionTermNameSearchJTextPane.setEditable(false);
        this.definitionTermNameScrollPane.setViewportView(this.definitionTermNameSearchJTextPane);
        this.termDetailsTermNameSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsTermNameSearchJTable.setOpaque(false);
        this.termDetailsTermNameSearchJScrollPane.setViewportView(this.termDetailsTermNameSearchJTable);
        this.searchResultsTermNameJLabel.setText("Search Results");
        this.selectedTermTermNameJLabel.setText("Selected Term");
        this.olsResultsTermNameSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Accession", "CV Term"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.olsResultsTermNameSearchJTable.setOpaque(false);
        this.olsResultsTermNameSearchJTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseExited(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsTermNameSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsTermNameSearchJTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsTermNameSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsTermNameSearchJScrollPane.setViewportView(this.olsResultsTermNameSearchJTable);
        this.viewTermHierarchyTermNameSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyTermNameSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
        this.viewTermHierarchyTermNameSearchJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermNameSearchJLabelMouseExited(evt);
            }
        });
        this.termNameJPanel.setOpaque(false);
        this.termNameJLabel.setText("Term Name");
        this.termNameSearchJTextField.setHorizontalAlignment(0);
        this.termNameSearchJTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.termNameSearchJTextFieldKeyReleased(evt);
            }
        });
        this.newtSpeciesTipsTermNameSearchJLabel.setFont(this.newtSpeciesTipsTermNameSearchJLabel.getFont().deriveFont((float)this.newtSpeciesTipsTermNameSearchJLabel.getFont().getSize() - 1.0f));
        this.newtSpeciesTipsTermNameSearchJLabel.setForeground(new Color(0, 0, 255));
        this.newtSpeciesTipsTermNameSearchJLabel.setText("NEWT Species Tips");
        this.newtSpeciesTipsTermNameSearchJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermNameSearchJLabelMouseExited(evt);
            }
        });
        this.numberOfTermsTermNameSearchJTextField.setEditable(false);
        this.numberOfTermsTermNameSearchJTextField.setHorizontalAlignment(0);
        this.numberOfTermsTermNameSearchJTextField.setToolTipText("Number of Matching Terms");
        GroupLayout termNameJPanelLayout = new GroupLayout((Container)this.termNameJPanel);
        this.termNameJPanel.setLayout((LayoutManager)termNameJPanelLayout);
        termNameJPanelLayout.setHorizontalGroup((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(2).add((Component)this.newtSpeciesTipsTermNameSearchJLabel).add(1, (GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().add((Component)this.termNameJLabel, -2, 70, -2).addPreferredGap(1).add((Component)this.termNameSearchJTextField))).addPreferredGap(1).add((Component)this.numberOfTermsTermNameSearchJTextField, -2, 79, -2).addContainerGap()));
        termNameJPanelLayout.setVerticalGroup((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameJPanelLayout.createParallelGroup(4).add((Component)this.termNameJLabel).add((Component)this.numberOfTermsTermNameSearchJTextField, -2, 20, -2).add((Component)this.termNameSearchJTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.newtSpeciesTipsTermNameSearchJLabel)));
        termNameJPanelLayout.linkSize(new Component[]{this.numberOfTermsTermNameSearchJTextField, this.termNameSearchJTextField}, 2);
        GroupLayout termNameSearchJPanelLayout = new GroupLayout((Container)this.termNameSearchJPanel);
        this.termNameSearchJPanel.setLayout((LayoutManager)termNameSearchJPanelLayout);
        termNameSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termNameJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().add((Component)this.searchResultsTermNameJLabel).add(0, 0, Short.MAX_VALUE)).add(2, (Component)this.olsResultsTermNameSearchJScrollPane).add((Component)this.termDetailsTermNameSearchJScrollPane).add((GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().add((Component)this.selectedTermTermNameJLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.viewTermHierarchyTermNameSearchJLabel)).add(2, (Component)this.definitionTermNameScrollPane, -1, 580, Short.MAX_VALUE)).addContainerGap()));
        termNameSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termNameSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.termNameJPanel, -2, -1, -2).add(1, 1, 1).add((Component)this.searchResultsTermNameJLabel).addPreferredGap(0).add((Component)this.olsResultsTermNameSearchJScrollPane, -1, 138, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)termNameSearchJPanelLayout.createParallelGroup(3).add((Component)this.selectedTermTermNameJLabel).add((Component)this.viewTermHierarchyTermNameSearchJLabel)).addPreferredGap(0).add((Component)this.definitionTermNameScrollPane, -1, 85, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsTermNameSearchJScrollPane, -1, 92, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Term Name Search", this.termNameSearchJPanel);
        this.termIdSearchJPanel.setBackground(new Color(230, 230, 230));
        this.definitionTermIdSearchJTextPane.setEditable(false);
        this.definitionTermNameIdSearchScrollPane.setViewportView(this.definitionTermIdSearchJTextPane);
        this.termDetailsTermIdSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsTermIdSearchJTable.setOpaque(false);
        this.termDetailsTermIdSearchJScrollPane.setViewportView(this.termDetailsTermIdSearchJTable);
        this.searchResultsTermIdLabel.setText("Search Results");
        this.searchTermTermIdLabel.setText("Selected Term");
        this.olsResultsTermIdSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Accession", "CV Term"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.olsResultsTermIdSearchJTable.setOpaque(false);
        this.olsResultsTermIdSearchJTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseExited(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsTermIdSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsTermIdSearchJTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsTermIdSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsTermIdSearchJScrollPane.setViewportView(this.olsResultsTermIdSearchJTable);
        this.viewTermHierarchyTermIdSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyTermIdSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
        this.viewTermHierarchyTermIdSearchJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyTermIdSearchJLabelMouseExited(evt);
            }
        });
        this.termIdPanel.setOpaque(false);
        this.termIdPanel.setPreferredSize(new Dimension(600, 50));
        this.termIdLabel.setText("Term ID");
        this.termIdLabel.setPreferredSize(new Dimension(58, 14));
        this.termIdSearchJTextField.setHorizontalAlignment(0);
        this.termIdSearchJTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.termIdSearchJTextFieldKeyPressed(evt);
            }
        });
        this.newtSpeciesTipsTermIdSearchJLabel.setFont(this.newtSpeciesTipsTermIdSearchJLabel.getFont().deriveFont((float)this.newtSpeciesTipsTermIdSearchJLabel.getFont().getSize() - 1.0f));
        this.newtSpeciesTipsTermIdSearchJLabel.setForeground(new Color(0, 0, 255));
        this.newtSpeciesTipsTermIdSearchJLabel.setText("NEWT Species Tips");
        this.newtSpeciesTipsTermIdSearchJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.newtSpeciesTipsTermIdSearchJLabelMouseExited(evt);
            }
        });
        this.termIdSearchJButton.setText("Search");
        this.termIdSearchJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.termIdSearchJButtonActionPerformed(evt);
            }
        });
        GroupLayout termIdPanelLayout = new GroupLayout((Container)this.termIdPanel);
        this.termIdPanel.setLayout((LayoutManager)termIdPanelLayout);
        termIdPanelLayout.setHorizontalGroup((GroupLayout.Group)termIdPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termIdPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termIdPanelLayout.createParallelGroup(2).add((Component)this.newtSpeciesTipsTermIdSearchJLabel).add(1, (GroupLayout.Group)termIdPanelLayout.createSequentialGroup().add((Component)this.termIdLabel, -2, 70, -2).addPreferredGap(1).add((Component)this.termIdSearchJTextField, -1, 410, Short.MAX_VALUE))).addPreferredGap(1).add((Component)this.termIdSearchJButton, -2, 80, -2).addContainerGap()));
        termIdPanelLayout.setVerticalGroup((GroupLayout.Group)termIdPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termIdPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termIdPanelLayout.createParallelGroup(4).add((Component)this.termIdSearchJTextField, -2, -1, -2).add((Component)this.termIdLabel, -2, -1, -2).add((Component)this.termIdSearchJButton)).addPreferredGap(0).add((Component)this.newtSpeciesTipsTermIdSearchJLabel)));
        GroupLayout termIdSearchJPanelLayout = new GroupLayout((Container)this.termIdSearchJPanel);
        this.termIdSearchJPanel.setLayout((LayoutManager)termIdSearchJPanelLayout);
        termIdSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termIdPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().add((Component)this.searchResultsTermIdLabel).add(0, 509, Short.MAX_VALUE)).add(2, (Component)this.olsResultsTermIdSearchJScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.termDetailsTermIdSearchJScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.definitionTermNameIdSearchScrollPane, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().add((Component)this.searchTermTermIdLabel).addPreferredGap(0, 414, Short.MAX_VALUE).add((Component)this.viewTermHierarchyTermIdSearchJLabel))).addContainerGap()));
        termIdSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)termIdSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.termIdPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.searchResultsTermIdLabel).addPreferredGap(0).add((Component)this.olsResultsTermIdSearchJScrollPane, -1, 136, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)termIdSearchJPanelLayout.createParallelGroup(3).add((Component)this.searchTermTermIdLabel).add((Component)this.viewTermHierarchyTermIdSearchJLabel)).addPreferredGap(0).add((Component)this.definitionTermNameIdSearchScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsTermIdSearchJScrollPane, -1, 90, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Term ID Search", this.termIdSearchJPanel);
        this.massSearchJPanel.setBackground(new Color(230, 230, 230));
        this.searchResultsMassSearchLabel.setText("Search Results");
        this.searchTermMassSearchLabel.setText("Selected Term");
        this.definitionMassSearchJTextPane.setEditable(false);
        this.definitionSelectedTermMassSearchScrollPane.setViewportView(this.definitionMassSearchJTextPane);
        this.termDetailsMassSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsMassSearchJTable.setOpaque(false);
        this.termDetailsMassSearchJScrollPane.setViewportView(this.termDetailsMassSearchJTable);
        this.olsResultsMassSearchJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Accession", "CV Term"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.olsResultsMassSearchJTable.setOpaque(false);
        this.olsResultsMassSearchJTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseExited(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseReleased(evt);
            }
        });
        this.olsResultsMassSearchJTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableMouseMoved(evt);
            }
        });
        this.olsResultsMassSearchJTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                OLSDialog.this.olsResultsMassSearchJTableKeyReleased(evt);
            }
        });
        this.olsResultsMassSearchJScrollPane.setViewportView(this.olsResultsMassSearchJTable);
        this.viewTermHierarchyMassSearchJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyMassSearchJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        this.viewTermHierarchyMassSearchJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyMassSearchJLabelMouseExited(evt);
            }
        });
        this.massPanel.setOpaque(false);
        this.massPanel.setPreferredSize(new Dimension(444, 50));
        this.massLabel.setText("Mass");
        this.modificationMassJTextField.setHorizontalAlignment(0);
        this.modificationMassJTextField.setText("0.0");
        this.modificationMassJTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.modificationMassJTextFieldKeyPressed(evt);
            }
        });
        this.plussMinusLabel.setText("+-");
        this.plussMinusLabel.setToolTipText("Mass Accuracy");
        this.precisionJTextField.setHorizontalAlignment(0);
        this.precisionJTextField.setText("0.1");
        this.precisionJTextField.setToolTipText("Mass Accuracy");
        this.precisionJTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                OLSDialog.this.precisionJTextFieldKeyPressed(evt);
            }
        });
        this.typeLabel.setText("Type");
        this.massTypeJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"- Select -", "DiffAvg", "DiffMono", "MassAvg", "MassMono"}));
        this.massTypeJComboBox.setSelectedIndex(2);
        this.massTypeJComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.massTypeJComboBoxActionPerformed(evt);
            }
        });
        this.dummyLabelJLabel.setFont(this.dummyLabelJLabel.getFont().deriveFont((float)this.dummyLabelJLabel.getFont().getSize() - 1.0f));
        this.dummyLabelJLabel.setText(" ");
        this.modificationMassSearchJButton.setText("Search");
        this.modificationMassSearchJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OLSDialog.this.modificationMassSearchJButtonActionPerformed(evt);
            }
        });
        GroupLayout massPanelLayout = new GroupLayout((Container)this.massPanel);
        this.massPanel.setLayout((LayoutManager)massPanelLayout);
        massPanelLayout.setHorizontalGroup((GroupLayout.Group)massPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)massPanelLayout.createParallelGroup(2).add((GroupLayout.Group)massPanelLayout.createSequentialGroup().add((Component)this.dummyLabelJLabel).add(200, 200, 200)).add((GroupLayout.Group)massPanelLayout.createSequentialGroup().add((Component)this.massLabel, -2, 70, -2).addPreferredGap(1).add((Component)this.modificationMassJTextField).addPreferredGap(0).add((Component)this.plussMinusLabel).addPreferredGap(0).add((Component)this.precisionJTextField, -2, 81, -2).add(18, 18, 18).add((Component)this.typeLabel).add(18, 18, 18).add((Component)this.massTypeJComboBox, -2, -1, -2).addPreferredGap(0))).add((Component)this.modificationMassSearchJButton, -2, 80, -2).addContainerGap()));
        massPanelLayout.setVerticalGroup((GroupLayout.Group)massPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)massPanelLayout.createParallelGroup(3).add((Component)this.modificationMassSearchJButton).add((Component)this.massTypeJComboBox, -2, -1, -2).add((Component)this.typeLabel).add((Component)this.precisionJTextField, -2, -1, -2).add((Component)this.plussMinusLabel).add((Component)this.massLabel).add((Component)this.modificationMassJTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.dummyLabelJLabel)));
        GroupLayout massSearchJPanelLayout = new GroupLayout((Container)this.massSearchJPanel);
        this.massSearchJPanel.setLayout((LayoutManager)massSearchJPanelLayout);
        massSearchJPanelLayout.setHorizontalGroup((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (Component)this.termDetailsMassSearchJScrollPane).add(2, (Component)this.definitionSelectedTermMassSearchScrollPane).add(2, (Component)this.olsResultsMassSearchJScrollPane).add((GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add((Component)this.searchResultsMassSearchLabel).add((Component)this.searchTermMassSearchLabel)).addPreferredGap(0, 411, Short.MAX_VALUE).add((Component)this.viewTermHierarchyMassSearchJLabel))).addContainerGap()).add((Component)this.massPanel, -1, 600, Short.MAX_VALUE));
        massSearchJPanelLayout.setVerticalGroup((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)massSearchJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.massPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.searchResultsMassSearchLabel).addPreferredGap(0).add((Component)this.olsResultsMassSearchJScrollPane, -1, 136, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)massSearchJPanelLayout.createParallelGroup(3).add((Component)this.searchTermMassSearchLabel).add((Component)this.viewTermHierarchyMassSearchJLabel)).addPreferredGap(0).add((Component)this.definitionSelectedTermMassSearchScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsMassSearchJScrollPane, -1, 90, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("PSI-MOD Mass Search", this.massSearchJPanel);
        this.browseOntologyJPanel.setBackground(new Color(230, 230, 230));
        this.selectedTermBrowseLabel.setText("Selected Term");
        this.definitionBrowseOntologyJTextPane.setEditable(false);
        this.treeScrollPane.setViewportView(this.definitionBrowseOntologyJTextPane);
        this.termDetailsBrowseOntologyJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.termDetailsBrowseOntologyJTable.setOpaque(false);
        this.termDetailsBrowseOntologyJScrollPane.setViewportView(this.termDetailsBrowseOntologyJTable);
        this.browseJPanel.setOpaque(false);
        this.browseJPanel.setLayout(new BoxLayout(this.browseJPanel, 2));
        this.viewTermHierarchyBrowseOntologyJLabel.setForeground(new Color(0, 0, 255));
        this.viewTermHierarchyBrowseOntologyJLabel.setText("View Term Hierarchy");
        this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        this.viewTermHierarchyBrowseOntologyJLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OLSDialog.this.viewTermHierarchyBrowseOntologyJLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                OLSDialog.this.viewTermHierachyJLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                OLSDialog.this.viewTermHierachyJLabelMouseExited(evt);
            }
        });
        GroupLayout browseOntologyJPanelLayout = new GroupLayout((Container)this.browseOntologyJPanel);
        this.browseOntologyJPanel.setLayout((LayoutManager)browseOntologyJPanelLayout);
        browseOntologyJPanelLayout.setHorizontalGroup((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(2).add(1, (Component)this.browseJPanel, -1, 580, Short.MAX_VALUE).add(1, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().add((Component)this.selectedTermBrowseLabel).addPreferredGap(0, 414, Short.MAX_VALUE).add((Component)this.viewTermHierarchyBrowseOntologyJLabel)).add((Component)this.treeScrollPane, -1, 580, Short.MAX_VALUE).add((Component)this.termDetailsBrowseOntologyJScrollPane, -1, 580, Short.MAX_VALUE)).addContainerGap()));
        browseOntologyJPanelLayout.setVerticalGroup((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)browseOntologyJPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browseJPanel, -1, 213, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)browseOntologyJPanelLayout.createParallelGroup(3).add((Component)this.selectedTermBrowseLabel).add((Component)this.viewTermHierarchyBrowseOntologyJLabel)).addPreferredGap(0).add((Component)this.treeScrollPane, -1, 84, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.termDetailsBrowseOntologyJScrollPane, -1, 89, Short.MAX_VALUE).addContainerGap()));
        this.searchTypeJTabbedPane.addTab("Browse Ontology", this.browseOntologyJPanel);
        this.ontologyJLabel.setText("Ontology");
        this.ontologyJComboBox.setMaximumRowCount(30);
        this.ontologyJComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OLSDialog.this.ontologyJComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout searchParametersJPanelLayout = new GroupLayout((Container)this.searchParametersJPanel);
        this.searchParametersJPanel.setLayout((LayoutManager)searchParametersJPanelLayout);
        searchParametersJPanelLayout.setHorizontalGroup((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((Component)this.searchTypeJTabbedPane).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().add((Component)this.ontologyJLabel).add(18, 18, 18).add((Component)this.ontologyJComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        searchParametersJPanelLayout.setVerticalGroup((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(1).add((GroupLayout.Group)searchParametersJPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)searchParametersJPanelLayout.createParallelGroup(4).add((Component)this.ontologyJLabel).add((Component)this.ontologyJComboBox, -2, -1, -2)).add(32, 32, 32).add((Component)this.searchTypeJTabbedPane).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout((Container)this.backgroundPanel);
        this.backgroundPanel.setLayout((LayoutManager)backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(2).add((Component)this.searchParametersJPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.helpJButton, -2, 23, -2).addPreferredGap(0).add((Component)this.aboutJButton, -2, 25, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.insertSelectedJButton).addPreferredGap(0).add((Component)this.cancelJButton, -2, -1, -2))).addContainerGap()));
        backgroundPanelLayout.linkSize(new Component[]{this.cancelJButton, this.insertSelectedJButton}, 1);
        backgroundPanelLayout.setVerticalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.searchParametersJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add(1, 1, 1).add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(3).add((Component)this.cancelJButton, -2, -1, -2).add((Component)this.insertSelectedJButton))).add((Component)this.aboutJButton, -2, 24, -2).add((Component)this.helpJButton, -2, 24, -2)).addContainerGap()));
        backgroundPanelLayout.linkSize(new Component[]{this.cancelJButton, this.insertSelectedJButton}, 2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -2, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void ontologyJComboBoxItemStateChanged(ItemEvent evt) {
        String currentOntology;
        this.setCursor(new Cursor(3));
        if (this.ontologyJComboBox.getSelectedIndex() != 0 && !this.isPreselectedOption()) {
            if (this.getCurrentOntologyLabel().equalsIgnoreCase("EFO")) {
                this.termIdSearchJTextField.setText(this.getCurrentOntologyLabel() + "_");
            } else if (this.getCurrentOntologyLabel().equalsIgnoreCase("NEWT")) {
                this.termIdSearchJTextField.setText("");
            } else {
                this.termIdSearchJTextField.setText(this.getCurrentOntologyLabel() + ":");
            }
        } else {
            this.termIdSearchJTextField.setText("");
        }
        if (this.searchTypeJTabbedPane.getSelectedIndex() != OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue() && !(currentOntology = (String)this.ontologyJComboBox.getSelectedItem()).equalsIgnoreCase(this.lastSelectedOntology)) {
            this.lastSelectedOntology = (String)this.ontologyJComboBox.getSelectedItem();
            this.currentlySelectedBrowseOntologyAccessionNumber = null;
            this.currentlySelectedTermNameSearchAccessionNumber = null;
            this.currentlySelectedTermIdSearchAccessionNumber = null;
            this.insertSelectedJButton.setEnabled(false);
            if (this.ontologyJComboBox.getSelectedIndex() == 0 || this.getCurrentOntologyLabel().equalsIgnoreCase("NEWT") || this.isPreselectedOption()) {
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_BROWSE_ONTOLOGY, false);
                if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
                    this.searchTypeJTabbedPane.setSelectedIndex(OLS_DIALOG_TERM_NAME_SEARCH);
                    this.setCursor(new Cursor(0));
                    if (this.getCurrentOntologyLabel().equalsIgnoreCase("NEWT")) {
                        JOptionPane.showMessageDialog(this, "Browse Ontology is not available for NEWT.", "Browse Ontology Disabled", 1);
                    } else if (this.ontologyJComboBox.getSelectedIndex() == 0) {
                        JOptionPane.showMessageDialog(this, "Browse Ontology is not available when searching several ontologies.", "Browse Ontology Disabled", 1);
                    }
                    this.setCursor(new Cursor(3));
                }
            } else {
                this.searchTypeJTabbedPane.setEnabledAt(OLS_DIALOG_BROWSE_ONTOLOGY, true);
            }
            if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
                this.termNameSearchJTextField.requestFocus();
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
                this.termIdSearchJTextField.requestFocus();
            }
            this.hideOrShowNewtLinks();
            this.termNameSearchJTextFieldKeyReleased(null);
            this.updateBrowseOntologyView();
            this.clearData(OLS_DIALOG_TERM_ID_SEARCH, true, true);
            this.viewTermHierarchyTermNameSearchJLabel.setEnabled(false);
            this.viewTermHierarchyTermIdSearchJLabel.setEnabled(false);
            this.viewTermHierarchyBrowseOntologyJLabel.setEnabled(false);
        }
        this.setCursor(new Cursor(0));
    }

    private void termNameSearchJTextFieldKeyReleased(KeyEvent evt) {
        ++this.keyPressedCounter;
        new Thread("SearchThread"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public synchronized void run() {
                try {
                    this.wait(OLSDialog.this.waitingTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (OLSDialog.this.keyPressedCounter != 1) {
                    OLSDialog.this.keyPressedCounter--;
                    return;
                }
                OLSDialog.this.setCursor(new Cursor(3));
                OLSDialog.this.termNameSearchJTextField.setCursor(new Cursor(3));
                OLSDialog.this.insertSelectedJButton.setEnabled(false);
                OLSDialog.this.currentlySelectedTermNameSearchAccessionNumber = null;
                try {
                    OLSDialog.this.clearData(OLS_DIALOG_TERM_NAME_SEARCH, true, true);
                    if (OLSDialog.this.termNameSearchJTextField.getText().length() >= 3) {
                        String ontology = OLSDialog.this.getCurrentOntologyLabel();
                        if (OLSDialog.this.ontologyJComboBox.getSelectedIndex() == 0) {
                            ontology = null;
                        }
                        HashMap map = new HashMap();
                        if (OLSDialog.this.isPreselectedOption()) {
                            for (String preselectedOntology : OLSDialog.this.preselectedOntologies.keySet()) {
                                map.putAll(olsConnection.getTermsByName(OLSDialog.this.termNameSearchJTextField.getText(), preselectedOntology.toUpperCase(), false));
                            }
                        } else {
                            map = olsConnection.getTermsByName(OLSDialog.this.termNameSearchJTextField.getText(), ontology, false);
                        }
                        for (String key : map.keySet()) {
                            ((DefaultTableModel)OLSDialog.this.olsResultsTermNameSearchJTable.getModel()).addRow(new Object[]{OLSDialog.this.getOlsAccessionLink(key), map.get(key)});
                        }
                        Integer width = OLSDialog.this.getPreferredColumnWidth(OLSDialog.this.olsResultsTermNameSearchJTable, OLSDialog.this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex(), 6);
                        if (width != null) {
                            OLSDialog.this.olsResultsTermNameSearchJTable.getColumn("Accession").setMinWidth(width);
                            OLSDialog.this.olsResultsTermNameSearchJTable.getColumn("Accession").setMaxWidth(width);
                        } else {
                            OLSDialog.this.olsResultsTermNameSearchJTable.getColumn("Accession").setMinWidth(15);
                            OLSDialog.this.olsResultsTermNameSearchJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
                        }
                        OLSDialog.this.termNameSearchJTextField.requestFocus();
                        OLSDialog.this.setCursor(new Cursor(0));
                        OLSDialog.this.termNameSearchJTextField.setCursor(new Cursor(2));
                        OLSDialog.this.numberOfTermsTermNameSearchJTextField.setText("" + map.size());
                        if (OLSDialog.this.olsResultsTermNameSearchJTable.getRowCount() > 0) {
                            OLSDialog.this.olsResultsTermNameSearchJTable.scrollRectToVisible(OLSDialog.this.olsResultsTermNameSearchJTable.getCellRect(0, 0, false));
                        }
                        if (!map.isEmpty()) {
                            // empty if block
                        }
                    } else {
                        OLSDialog.this.numberOfTermsTermNameSearchJTextField.setText("-");
                    }
                }
                catch (RemoteException ex) {
                    JOptionPane.showMessageDialog(null, OLSDialog.this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
                    Util.writeToErrorLog("Error when trying to access OLS: ");
                    ex.printStackTrace();
                }
                OLSDialog.this.setCursor(new Cursor(0));
                OLSDialog.this.termNameSearchJTextField.setCursor(new Cursor(2));
                OLSDialog.this.keyPressedCounter = 0;
            }
        }.start();
    }

    private void insertSelectedJButtonActionPerformed(ActionEvent evt) {
        String ontologyShort;
        this.setCursor(new Cursor(3));
        String termId = null;
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            termId = "" + this.olsResultsTermNameSearchJTable.getValueAt(this.olsResultsTermNameSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            termId = this.currentlySelectedBrowseOntologyAccessionNumber;
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            termId = "" + this.olsResultsMassSearchJTable.getValueAt(this.olsResultsMassSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            termId = "" + this.olsResultsTermIdSearchJTable.getValueAt(this.olsResultsTermIdSearchJTable.getSelectedRow(), 0);
        }
        termId = termId.substring(termId.indexOf("termId=") + "termId=".length());
        termId = termId.substring(0, termId.indexOf("\""));
        String ontologyLong = (String)this.ontologyJComboBox.getSelectedItem();
        if (this.ontologyJComboBox.getSelectedIndex() == 0 || this.isPreselectedOption()) {
            ontologyShort = this.getOntologyLabelFromTermId(termId);
            if (ontologyShort == null) {
                ontologyShort = "NEWT";
                ontologyLong = "NEWT UniProt Taxonomy Database [NEWT]";
            } else {
                try {
                    HashMap ontologies = olsConnection.getOntologyNames();
                    ontologyLong = ontologies.get(ontologyShort).toString() + "[" + ontologyShort + "]";
                }
                catch (RemoteException ex) {
                    JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
                    Util.writeToErrorLog("Error when trying to access OLS: ");
                    ex.printStackTrace();
                    ontologyLong = "unknown";
                }
            }
        } else {
            ontologyShort = ontologyLong.substring(ontologyLong.lastIndexOf("[") + 1, ontologyLong.length() - 1);
        }
        try {
            String selectedValue = olsConnection.getTermById(termId, ontologyShort);
            if (this.olsInputable != null) {
                this.olsInputable.insertOLSResult(this.field, selectedValue, termId, ontologyShort, ontologyLong, this.modifiedRow, this.mappedTerm, this.metadata);
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void insertTermDetails(MouseEvent evt, JTable searchResultTable) {
        this.setCursor(new Cursor(3));
        int row = searchResultTable.getSelectedRow();
        if (row != -1) {
            this.insertSelectedJButton.setEnabled(true);
        } else {
            this.insertSelectedJButton.setEnabled(false);
        }
        boolean doSearch = true;
        if (evt != null && evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.insertSelectedJButtonActionPerformed(null);
            doSearch = false;
        }
        if (doSearch && row != -1) {
            Integer searchType = null;
            if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
                this.currentlySelectedTermNameSearchAccessionNumber = (String)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_TERM_NAME_SEARCH;
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
                this.currentlySelectedMassSearchAccessionNumber = (String)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_PSI_MOD_MASS_SEARCH;
            } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
                this.currentlySelectedTermIdSearchAccessionNumber = (String)searchResultTable.getValueAt(row, 0);
                searchType = OLS_DIALOG_TERM_ID_SEARCH;
            }
            String termID = (String)searchResultTable.getValueAt(row, 0);
            termID = termID.substring(termID.indexOf("termId=") + "termId=".length());
            termID = termID.substring(0, termID.indexOf("\""));
            this.loadMetaData(termID, searchType);
        }
        this.setCursor(new Cursor(0));
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        if (this.olsInputable != null) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, true, this.getClass().getResource("/no/uib/olsdialog/helpfiles/OLSDialog.html"));
        this.setCursor(new Cursor(0));
    }

    private void aboutJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, true, this.getClass().getResource("/no/uib/olsdialog/helpfiles/AboutOLS.html"));
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelJButtonActionPerformed(null);
    }

    public DataHolder[] getModificationsByMassDelta(String massDeltaType, double fromMass, double toMass) {
        DataHolder[] retval = null;
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            Query service = locator.getOntologyQuery();
            retval = service.getTermsByAnnotationData("MOD", massDeltaType, null, fromMass, toMass);
        }
        catch (ServiceException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        return retval;
    }

    private void modificationMassSearchJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.insertSelectedJButton.setEnabled(false);
        this.viewTermHierarchyMassSearchJLabel.setEnabled(false);
        this.clearData(OLS_DIALOG_PSI_MOD_MASS_SEARCH, true, true);
        boolean error = false;
        double currentModificationMass = 0.0;
        double currentAccuracy = 0.1;
        try {
            currentModificationMass = new Double(this.modificationMassJTextField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "The mass is not a number!", "Modification Mass", 1);
            this.modificationMassJTextField.requestFocus();
            error = true;
        }
        if (!error) {
            try {
                currentAccuracy = new Double(this.precisionJTextField.getText());
                if (currentAccuracy < 0.0) {
                    JOptionPane.showMessageDialog(null, "The precision has to be a positive value.", "Mass Accuracy", 1);
                    this.precisionJTextField.requestFocus();
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "The precision is not a number!", "Mass Accuracy", 1);
                this.precisionJTextField.requestFocus();
                error = true;
            }
        }
        if (!error) {
            String massType = this.massTypeJComboBox.getSelectedItem().toString();
            DataHolder[] results = this.getModificationsByMassDelta(massType, currentModificationMass - currentAccuracy, currentModificationMass + currentAccuracy);
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    ((DefaultTableModel)this.olsResultsMassSearchJTable.getModel()).addRow(new Object[]{this.getOlsAccessionLink(results[i].getTermId()), results[i].getTermName()});
                }
                Integer width = this.getPreferredColumnWidth(this.olsResultsMassSearchJTable, this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex(), 6);
                if (width != null) {
                    this.olsResultsMassSearchJTable.getColumn("Accession").setMinWidth(width);
                    this.olsResultsMassSearchJTable.getColumn("Accession").setMaxWidth(width);
                } else {
                    this.olsResultsMassSearchJTable.getColumn("Accession").setMinWidth(15);
                    this.olsResultsMassSearchJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
                }
            }
            this.setCursor(new Cursor(0));
            if (this.olsResultsMassSearchJTable.getRowCount() > 0) {
                this.olsResultsMassSearchJTable.scrollRectToVisible(this.olsResultsTermNameSearchJTable.getCellRect(0, 0, false));
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void massTypeJComboBoxActionPerformed(ActionEvent evt) {
        this.modificationMassSearchJButton.setEnabled(this.massTypeJComboBox.getSelectedIndex() != 0);
    }

    private void searchTypeJTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedMassSearchAccessionNumber != null);
            this.lastSelectedOntology = (String)this.ontologyJComboBox.getSelectedItem();
            this.ontologyJComboBox.setSelectedItem("Protein Modifications (PSI-MOD) [MOD]");
            this.ontologyJComboBox.setEnabled(false);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedBrowseOntologyAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermNameSearchAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            this.insertSelectedJButton.setEnabled(this.currentlySelectedTermIdSearchAccessionNumber != null);
            this.ontologyJComboBox.setSelectedItem(this.lastSelectedOntology);
            this.ontologyJComboBox.setEnabled(true);
        }
    }

    private void olsResultsTermNameSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsTermNameSearchJTableMouseClicked(null);
    }

    private void olsResultsTermNameSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsTermNameSearchJTable);
    }

    private void olsResultsMassSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsMassSearchJTableMouseClicked(null);
    }

    private void olsResultsMassSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsMassSearchJTable);
    }

    private void viewTermHierachyJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierachyJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void viewTermHierarchyBrowseOntologyJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyMassSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyMassSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyMassSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyTermNameSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermIdSearchJTableMouseClicked(MouseEvent evt) {
        this.insertTermDetails(evt, this.olsResultsTermIdSearchJTable);
    }

    private void olsResultsTermIdSearchJTableKeyReleased(KeyEvent evt) {
        this.olsResultsTermIdSearchJTableMouseClicked(null);
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseClicked(MouseEvent evt) {
        this.viewTermHierarchy();
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void viewTermHierarchyTermIdSearchJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void termIdSearchJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.termIdSearchJTextField.setCursor(new Cursor(3));
        this.insertSelectedJButton.setEnabled(false);
        this.currentlySelectedTermIdSearchAccessionNumber = null;
        try {
            this.clearData(OLS_DIALOG_TERM_ID_SEARCH, true, true);
            String ontology = this.getCurrentOntologyLabel();
            if (this.ontologyJComboBox.getSelectedIndex() == 0) {
                ontology = null;
            }
            String currentTermName = "";
            if (this.isPreselectedOption()) {
                for (String preselectedOntology : this.preselectedOntologies.keySet()) {
                    currentTermName = olsConnection.getTermById(this.termIdSearchJTextField.getText().trim(), preselectedOntology.toUpperCase());
                    if (currentTermName.length() <= 0) continue;
                    break;
                }
            } else {
                currentTermName = olsConnection.getTermById(this.termIdSearchJTextField.getText().trim(), ontology);
            }
            if (currentTermName == null) {
                JOptionPane.showMessageDialog(this, "No matching terms found.", "No Matching Terms", 1);
                this.termIdSearchJTextField.requestFocus();
            } else if (currentTermName.equalsIgnoreCase(this.termIdSearchJTextField.getText().trim())) {
                JOptionPane.showMessageDialog(this, "No matching terms found.", "No Matching Terms", 1);
                this.termIdSearchJTextField.requestFocus();
            } else {
                ((DefaultTableModel)this.olsResultsTermIdSearchJTable.getModel()).addRow(new Object[]{this.getOlsAccessionLink(this.termIdSearchJTextField.getText().trim()), currentTermName});
                Integer width = this.getPreferredColumnWidth(this.olsResultsTermIdSearchJTable, this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex(), 6);
                if (width != null) {
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMinWidth(width);
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMaxWidth(width);
                } else {
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMinWidth(15);
                    this.olsResultsTermIdSearchJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
                }
            }
            this.setCursor(new Cursor(0));
            this.termIdSearchJTextField.setCursor(new Cursor(2));
            if (this.olsResultsTermIdSearchJTable.getRowCount() > 0) {
                this.olsResultsTermIdSearchJTable.scrollRectToVisible(this.olsResultsTermIdSearchJTable.getCellRect(0, 0, false));
            }
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        this.setCursor(new Cursor(0));
        this.termIdSearchJTextField.setCursor(new Cursor(2));
    }

    private void modificationMassJTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.modificationMassSearchJButton.isEnabled()) {
            this.modificationMassSearchJButtonActionPerformed(null);
        }
    }

    private void precisionJTextFieldKeyPressed(KeyEvent evt) {
        this.modificationMassJTextFieldKeyPressed(evt);
    }

    private void termIdSearchJTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.termIdSearchJButton.isEnabled()) {
                this.termIdSearchJButtonActionPerformed(null);
            }
        } else {
            this.termIdSearchJButton.setEnabled(this.termIdSearchJTextField.getText().length() > 0);
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseClicked(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            new SimpleNewtSelection(this, true);
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseEntered(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(12));
        }
    }

    private void newtSpeciesTipsTermNameSearchJLabelMouseExited(MouseEvent evt) {
        if (this.newtSpeciesTipsTermNameSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(0));
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseClicked(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            new SimpleNewtSelection(this, true);
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseEntered(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(12));
        }
    }

    private void newtSpeciesTipsTermIdSearchJLabelMouseExited(MouseEvent evt) {
        if (this.newtSpeciesTipsTermIdSearchJLabel.getForeground() == Color.BLUE) {
            this.setCursor(new Cursor(0));
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermNameSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsTermNameSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermNameSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsTermNameSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsTermIdSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsTermIdSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermIdSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsTermIdSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsMassSearchJTableMouseMoved(MouseEvent evt) {
        int row = this.olsResultsMassSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsMassSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && this.olsResultsMassSearchJTable.getValueAt(row, column) != null) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void olsResultsTermNameSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermIdSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsMassSearchJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void olsResultsTermNameSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsTermNameSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermNameSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.olsResultsTermNameSearchJTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.olsResultsTermNameSearchJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void olsResultsTermIdSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsTermIdSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsTermIdSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsTermIdSearchJTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.olsResultsTermIdSearchJTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.olsResultsTermIdSearchJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void olsResultsMassSearchJTableMouseReleased(MouseEvent evt) {
        int row = this.olsResultsMassSearchJTable.rowAtPoint(evt.getPoint());
        int column = this.olsResultsMassSearchJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && column == this.olsResultsMassSearchJTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.olsResultsMassSearchJTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.olsResultsMassSearchJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void viewTermHierarchy() {
        this.setCursor(new Cursor(3));
        String accession = null;
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            accession = "" + this.olsResultsTermNameSearchJTable.getValueAt(this.olsResultsTermNameSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_BROWSE_ONTOLOGY.intValue()) {
            accession = this.currentlySelectedBrowseOntologyAccessionNumber;
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_PSI_MOD_MASS_SEARCH.intValue()) {
            accession = "" + this.olsResultsMassSearchJTable.getValueAt(this.olsResultsMassSearchJTable.getSelectedRow(), 0);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            accession = "" + this.olsResultsTermIdSearchJTable.getValueAt(this.olsResultsTermIdSearchJTable.getSelectedRow(), 0);
        }
        String selectedValue = "";
        String ontology = this.getCurrentOntologyLabel();
        try {
            selectedValue = olsConnection.getTermById(accession, ontology);
        }
        catch (RemoteException ex) {
            JOptionPane.showMessageDialog(this, this.defaultOlsConnectionFailureErrorMessage, "OLS Connection Error", 0);
            Util.writeToErrorLog("Error when trying to access OLS: ");
            ex.printStackTrace();
        }
        new TermHierarchyGraphViewer(this, true, accession, selectedValue, ontology);
        this.setCursor(new Cursor(0));
    }

    private boolean isPreselectedOption() {
        return this.preselectedOntologies.size() > 1 && this.ontologyJComboBox.getSelectedIndex() == 1;
    }

    public void insertNewtSelection(String termName, String termId) {
        if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_NAME_SEARCH.intValue()) {
            this.termNameSearchJTextField.setText(termName);
            this.termNameSearchJTextFieldKeyReleased(null);
        } else if (this.searchTypeJTabbedPane.getSelectedIndex() == OLS_DIALOG_TERM_ID_SEARCH.intValue()) {
            this.termIdSearchJTextField.setText(termId);
            this.termIdSearchJButtonActionPerformed(null);
        }
    }

    public String getOlsAccessionLink(String modAccession) {
        String accessionNumberWithLink = "<html><a href=\"http://www.ebi.ac.uk/ontology-lookup/?termId=" + modAccession + "\"" + "\"><font color=\"" + this.notSelectedRowHtmlTagFontColor + "\">" + modAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    public int getPreferredColumnWidth(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        return width += 2 * margin;
    }
}

