/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope;

import com.thoughtworks.xstream.XStream;
import fr.proline.mzscope.model.ExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.ui.RawFileManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromatogramsExporter {
    private static final Logger logger = LoggerFactory.getLogger(ChromatogramsExporter.class);
    private List<IonProperties> ions2Xtract = new ArrayList<IonProperties>();
    private String m_outputDir;

    public ChromatogramsExporter(List<IonProperties> ions, String outputDir) {
        this.ions2Xtract = ions;
        this.m_outputDir = outputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extractChromatoForAllFiles() {
        DecimalFormat df = new DecimalFormat("#.00");
        List allFiles = RawFileManager.getInstance().getAllFiles();
        int nbrError = 0;
        for (IRawFile nextRawFile : allFiles) {
            for (IonProperties nextIon : this.ions2Xtract) {
                BufferedWriter output = null;
                String chromatoFile = "";
                try {
                    ExtractionRequest.Builder builder = ExtractionRequest.builder((Object)this).setMinMz(nextIon.getMinMz()).setMaxMz(nextIon.getMaxMz());
                    if ((double)nextIon.startRT > 0.0 && (double)nextIon.stopRT > 0.0) {
                        builder.setElutionTimeLowerBound(nextIon.startRT * 60.0f).setElutionTimeUpperBound(nextIon.stopRT * 60.0f);
                    }
                    IChromatogram currentChromatogram = nextRawFile.getXIC(builder.build());
                    StringBuilder stb = new StringBuilder();
                    stb.append(this.m_outputDir).append('/');
                    stb.append("extracted_xic_").append(nextRawFile.getName()).append(df.format(currentChromatogram.getMinMz()).replace(',', '.')).append(".tsv");
                    chromatoFile = stb.toString();
                    logger.info("Extracting chromatogram to file " + chromatoFile);
                    File file = new File(chromatoFile);
                    output = new BufferedWriter(new FileWriter(file));
                    output.write("index\trt\tintensity\n");
                    for (int k = 0; k < currentChromatogram.getTime().length; ++k) {
                        stb = new StringBuilder();
                        stb.append(k).append("\t").append(currentChromatogram.getTime()[k]).append("\t").append(currentChromatogram.getIntensities()[k]);
                        stb.append("\n");
                        output.write(stb.toString());
                    }
                    logger.info("extracted IChromatogram in " + file.getAbsolutePath());
                }
                catch (IOException ex) {
                    ++nbrError;
                    logger.error("Unable to write IChromatogram " + chromatoFile, (Throwable)ex);
                }
                finally {
                    try {
                        if (output == null) continue;
                        output.close();
                    }
                    catch (IOException ex) {
                        logger.error("Unable to write current IChromatogram " + chromatoFile, (Throwable)ex);
                    }
                }
            }
        }
        return nbrError <= 0;
    }

    public static String usage() {
        return "'extract' (shortcut for ChromatogramsExporter) is a command line chromatogram extraction program . It extracts chromatograms from RAW files (as mzData or mzMl) for specified masses and time window.\nOne chromatogram file is written for each specified raw file and mass.\n\nextract options : \n\t<raw_path> :\n\t\t file path for single raw file extraction or path to directory containing raw files to treat\n\t<properties_filename> : \n\t\t properties file where ions to extract are defined\n\t<output_path> : {default= same as input directory}\n\t\t output directory where results are written\n\nProperties_filename is a XML file structured as in example file, sample_prop.xml \n";
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(ChromatogramsExporter.usage());
            System.exit(-1);
        }
        String filepath = args[0];
        String ionsList = args[1];
        String outputDir = "";
        if (args.length >= 3) {
            outputDir = args[2];
        }
        if (filepath == null || filepath.isEmpty()) {
            logger.warn("No path specified ");
            System.exit(-1);
        }
        if (ionsList == null || ionsList.isEmpty()) {
            logger.warn("No Ions specified ");
            System.exit(-1);
        }
        try {
            File specifiedFile = new File(filepath);
            List<File> rawFiles = new ArrayList<File>();
            if (outputDir.isEmpty()) {
                if (specifiedFile.isDirectory()) {
                    outputDir = filepath;
                    rawFiles = Arrays.asList(specifiedFile.listFiles());
                } else {
                    outputDir = specifiedFile.getParent();
                    rawFiles.add(specifiedFile);
                }
            }
            for (File rawFile : rawFiles) {
                RawFileManager.getInstance().addRawFile(rawFile);
            }
            File ionsPropertiesFile = new File(ionsList);
            XStream xStream = new XStream();
            xStream.alias("ion", IonProperties.class);
            List ionsToXtract = (List)xStream.fromXML(ionsPropertiesFile);
            ChromatogramsExporter chExporter = new ChromatogramsExporter(ionsToXtract, outputDir);
            chExporter.extractChromatoForAllFiles();
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("Error while extracting chromatogram ", (Throwable)e);
            System.exit(-1);
        }
    }

    static class IonProperties {
        double ppm;
        double ionMz;
        float startRT;
        float stopRT;

        public IonProperties(double ppm, double ionMz, float startRT, float stopRT) {
            this.ppm = ppm;
            this.ionMz = ionMz;
            this.startRT = startRT;
            this.stopRT = stopRT;
        }

        public double getPpm() {
            return this.ppm;
        }

        public void setPpm(double ppm) {
            this.ppm = ppm;
        }

        public double getIonMz() {
            return this.ionMz;
        }

        public void setIonMz(double ionMz) {
            this.ionMz = ionMz;
        }

        public float getStartRT() {
            return this.startRT;
        }

        public void setStartRT(float startRT) {
            this.startRT = startRT;
        }

        public float getStopRT() {
            return this.stopRT;
        }

        public void setStopRT(float stopRT) {
            this.stopRT = stopRT;
        }

        public double getMinMz() {
            return this.ionMz - this.ionMz * this.ppm / 1000000.0;
        }

        public double getMaxMz() {
            return this.ionMz + this.ionMz * this.ppm / 1000000.0;
        }
    }
}

