/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.studio.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCache {
    private static final String CACHE_DIR = "cache_mzscope";
    private static final String CACHEFILE_EXTENSION = ".ksm";
    private static final Logger logger = LoggerFactory.getLogger(MetricsCache.class);
    private static MetricsCache instance = null;
    private Kryo kryo = new Kryo();

    public static MetricsCache getInstance() {
        if (instance == null) {
            instance = new MetricsCache();
        }
        return instance;
    }

    private MetricsCache() {
        this.kryo.setRegistrationRequired(false);
    }

    protected File getCacheFolder() {
        File dir = new File(System.getProperty("user.dir"));
        File cache = new File(dir, CACHE_DIR);
        if (!cache.exists()) {
            cache.mkdir();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeQC(IRawFile rawFile, QCMetrics metrics) {
        FileOutputStream fos = null;
        try {
            File outputFile = new File(this.getCacheFolder(), rawFile.getName() + CACHEFILE_EXTENSION);
            fos = new FileOutputStream(outputFile);
            Output out = new Output(fos);
            this.kryo.writeObject(out, metrics);
            logger.info("QC info wrote into " + outputFile.getAbsolutePath());
            out.close();
            fos.close();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QCMetrics loadQC(IRawFile rawFile) {
        FileInputStream fis = null;
        try {
            File inputFile = new File(this.getCacheFolder(), rawFile.getName() + CACHEFILE_EXTENSION);
            if (inputFile.exists()) {
                fis = new FileInputStream(inputFile);
                Input input = new Input(fis);
                QCMetrics metrics = this.kryo.readObject(input, QCMetrics.class);
                logger.info("QC info loaded from " + inputFile.getAbsolutePath());
                input.close();
                QCMetrics qCMetrics = metrics;
                return qCMetrics;
            }
            QCMetrics qCMetrics = null;
            return qCMetrics;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QCMetrics> loadAllQC() {
        FileInputStream fis = null;
        ArrayList<QCMetrics> list = new ArrayList<QCMetrics>();
        try {
            for (File inputFile : this.getCacheFolder().listFiles()) {
                if (!inputFile.getName().endsWith(CACHEFILE_EXTENSION) || !inputFile.exists()) {
                    List<QCMetrics> list2 = null;
                    return list2;
                }
                fis = new FileInputStream(inputFile);
                Input input = new Input(fis);
                QCMetrics metrics = this.kryo.readObject(input, QCMetrics.class);
                logger.info("QC info loaded from " + inputFile.getAbsolutePath());
                input.close();
                list.add(metrics);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return list;
    }
}

