/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.ui;

import fr.profi.mzscope.MetricsCache;
import fr.profi.mzscope.ui.RawMinerFrame;
import fr.proline.mzscope.model.EmptyRawFile;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.ui.MzScopePanel;
import fr.proline.mzscope.ui.QCMetricsPanel;
import fr.proline.mzscope.ui.RawFileManager;
import fr.proline.mzscope.ui.RawFilesPanel;
import fr.proline.mzscope.ui.dialog.MzdbFilter;
import fr.proline.mzscope.ui.event.ExtractionEvent;
import fr.proline.mzscope.ui.event.ExtractionStateListener;
import fr.proline.mzscope.utils.IPopupMenuDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMinerPanel
extends JPanel
implements ExtractionStateListener,
IPopupMenuDelegate {
    private static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.mzScope.RawMinerPanel");
    private static final String LAST_DIR = "mzscope.last.raw.directory";
    private static final String LAST_PEAKEL_DIR = "mzscope.last.peakeldb.directory";
    private final RawMinerFrame parentFrame;
    private JFileChooser fileChooser = null;
    private JSplitPane mainSplitPane = null;
    private JSplitPane explorerSplitPane = null;
    private RawFilesPanel rawFilePanel = null;
    private MzScopePanel mzScopePanel = null;
    private JMenuItem detectPeakelsMI;
    private JMenuItem loadPeakelsMI;
    private JMenuItem extractFeaturesMI;
    private JMenuItem compareQCMI;
    private JMenuItem detectFeaturesMI;
    private JMenuItem closeAllFileMI;
    private JMenuItem closeRawFileMI;
    private JMenuItem viewRawFileMI;
    private ActionListener viewRawFileAction;
    private JMenuItem propertiesMI;
    private JMenuItem viewAllRawFilesMI;
    private JMenuItem viewLCMSMap;
    private JMenuItem export;

    public RawMinerPanel(RawMinerFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.createMainSplitPane();
    }

    private void createMainSplitPane() {
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setBorder(null);
            this.mainSplitPane.setDividerLocation(200);
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setLeftComponent(this.getExplorerPanel());
            this.mainSplitPane.setRightComponent((Component)this.getMzScopePanel());
        }
        return this.mainSplitPane;
    }

    private JComponent getExplorerPanel() {
        if (this.explorerSplitPane == null) {
            this.explorerSplitPane = new JSplitPane(0);
            this.explorerSplitPane.setBorder(null);
            this.explorerSplitPane.setDividerLocation(200);
            this.explorerSplitPane.setOneTouchExpandable(true);
            this.explorerSplitPane.setTopComponent((Component)this.getRawFilesPanel());
        }
        return this.explorerSplitPane;
    }

    private RawFilesPanel getRawFilesPanel() {
        if (this.rawFilePanel == null) {
            this.rawFilePanel = new RawFilesPanel((IPopupMenuDelegate)this);
        }
        return this.rawFilePanel;
    }

    protected MzScopePanel getMzScopePanel() {
        if (this.mzScopePanel == null) {
            this.mzScopePanel = new MzScopePanel((Frame)this.parentFrame);
            this.mzScopePanel.addExtractionListener((ExtractionStateListener)this);
        }
        return this.mzScopePanel;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setDialogTitle("Open mzDB file");
            this.fileChooser.addChoosableFileFilter((FileFilter)new MzdbFilter());
        }
        return this.fileChooser;
    }

    public void addRawFile(IRawFile rawfile) {
        this.rawFilePanel.addFile(rawfile);
    }

    public void closeRawFile(IRawFile rawfile) {
        this.mzScopePanel.closeRawFile(rawfile);
        this.rawFilePanel.removeFile(rawfile);
        if (!(rawfile instanceof EmptyRawFile)) {
            RawFileManager.getInstance().removeRawFile(rawfile);
        }
    }

    public void closeAllFiles() {
        boolean close = this.mzScopePanel.closeAllRaw();
        if (close) {
            this.rawFilePanel.removeAllFiles();
            RawFileManager.getInstance().removeAllFiles();
        }
    }

    public void extractionStateChanged(ExtractionEvent event) {
        this.parentFrame.setExtractFeaturesMIEnabled(event.getState() == ExtractionEvent.EXTRACTION_DONE);
        this.parentFrame.setDetectPeakelsMIEnabled(event.getState() == ExtractionEvent.EXTRACTION_DONE);
    }

    public void openRawFile() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String directory = prefs.get(LAST_DIR, this.getFileChooser().getCurrentDirectory().getAbsolutePath());
        this.fileChooser.setCurrentDirectory(new File(directory));
        this.fileChooser.setMultiSelectionEnabled(true);
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files;
            for (File file : files = this.fileChooser.getSelectedFiles()) {
                prefs.put(LAST_DIR, file.getParentFile().getAbsolutePath());
                IRawFile rawfile = RawFileManager.getInstance().addRawFile(file);
                this.rawFilePanel.addFile(rawfile);
            }
        } else {
            System.out.println("File access cancelled by user.");
        }
    }

    private boolean arePeakelEquals(IPeakel p1, IPeakel p2) {
        boolean result = (double)Math.abs(p1.getElutionTime() - p2.getElutionTime()) < 0.001;
        result = result && Math.abs(p1.getMz() - p2.getMz()) < 0.001;
        result = result && (double)Math.abs(p1.getApexIntensity() - p2.getApexIntensity()) < 0.001;
        return result;
    }

    public void exportChromatogram() {
        if (this.mzScopePanel.getCurrentRawFileViewer() != null) {
            try {
                DecimalFormat df = new DecimalFormat("#.00");
                Preferences prefs = Preferences.userNodeForPackage(this.getClass());
                IChromatogram currentChromatogram = this.mzScopePanel.getCurrentRawFileViewer().getCurrentChromatogram();
                StringBuilder stb = new StringBuilder();
                stb.append(prefs.get(LAST_DIR, this.fileChooser.getCurrentDirectory().getAbsolutePath())).append('\\');
                stb.append("extracted_xic_").append(df.format(currentChromatogram.getMinMz())).append(".tsv");
                JFileChooser saveFileChooser = new JFileChooser();
                saveFileChooser.setSelectedFile(new File(stb.toString()));
                int returnVal = saveFileChooser.showSaveDialog(this.parentFrame);
                if (returnVal == 0) {
                    File file = saveFileChooser.getSelectedFile();
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    output.write("index\trt\tintensity\n");
                    for (int k = 0; k < currentChromatogram.getTime().length; ++k) {
                        stb = new StringBuilder();
                        stb.append(k).append("\t").append(currentChromatogram.getTime()[k]).append("\t").append(currentChromatogram.getIntensities()[k]);
                        stb.append("\n");
                        output.write(stb.toString());
                    }
                    logger.info("extracted IChromatogram in " + file.getAbsolutePath());
                    output.close();
                }
            }
            catch (Exception e) {
                logger.error("Enable to write current IChromatogram", (Throwable)e);
            }
        }
    }

    public void initPopupMenu(JPopupMenu popupMenu) {
        this.viewRawFileAction = evt -> {
            List rawFiles = this.getRawFilesPanel().getSelectedValues();
            if (rawFiles.size() == 1) {
                this.mzScopePanel.displayRaw((IRawFile)rawFiles.get(0), true);
            } else {
                this.mzScopePanel.displayRaw(rawFiles);
            }
        };
        this.viewRawFileMI = new JMenuItem();
        this.viewRawFileMI.setText("View");
        this.viewRawFileMI.addActionListener(this.viewRawFileAction);
        popupMenu.add(this.viewRawFileMI);
        this.viewAllRawFilesMI = new JMenuItem();
        this.viewAllRawFilesMI.setText("View all");
        this.viewAllRawFilesMI.addActionListener(evt -> this.mzScopePanel.displayAllRaw());
        popupMenu.add(this.viewAllRawFilesMI);
        this.closeRawFileMI = new JMenuItem();
        this.closeRawFileMI.setText("Close mzDB file");
        this.closeRawFileMI.addActionListener(evt -> this.closeRawFile((IRawFile)this.getRawFilesPanel().getSelectedValues().get(0)));
        popupMenu.add(this.closeRawFileMI);
        popupMenu.addSeparator();
        this.closeAllFileMI = new JMenuItem();
        this.closeAllFileMI.setText("Close All mzDB files...");
        this.closeAllFileMI.addActionListener(evt -> this.closeAllFiles());
        popupMenu.add(this.closeAllFileMI);
        popupMenu.addSeparator();
        this.extractFeaturesMI = new JMenuItem();
        this.extractFeaturesMI.setText("Extract Features from MS2...");
        this.extractFeaturesMI.addActionListener(evt -> this.mzScopePanel.extractFeaturesFromMS2(this.getRawFilesPanel().getSelectedValues()));
        popupMenu.add(this.extractFeaturesMI);
        this.detectFeaturesMI = new JMenuItem();
        this.detectFeaturesMI.setText("Detect Features...");
        this.detectFeaturesMI.addActionListener(evt -> this.mzScopePanel.detectFeatures(this.getRawFilesPanel().getSelectedValues()));
        popupMenu.add(this.detectFeaturesMI);
        this.detectPeakelsMI = new JMenuItem();
        this.detectPeakelsMI.setText("Detect Peakels...");
        this.detectPeakelsMI.addActionListener(evt -> this.mzScopePanel.detectPeakels(this.getRawFilesPanel().getSelectedValues()));
        popupMenu.add(this.detectPeakelsMI);
        this.loadPeakelsMI = new JMenuItem();
        this.loadPeakelsMI.setText("Load Peakels...");
        this.loadPeakelsMI.addActionListener(evt -> {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            JFileChooser peakelChooser = new JFileChooser();
            peakelChooser.setDialogTitle("Load peakels");
            peakelChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".peakeldb") || f.getName().endsWith(".sqlite");
                }

                @Override
                public String getDescription() {
                    return "*.peakeldb, *.sqlite";
                }
            });
            String directory = prefs.get(LAST_PEAKEL_DIR, peakelChooser.getCurrentDirectory().getAbsolutePath());
            peakelChooser.setCurrentDirectory(new File(directory));
            int returnVal = peakelChooser.showOpenDialog((Component)this.mzScopePanel);
            if (returnVal == 0) {
                File file = peakelChooser.getSelectedFile();
                prefs.put(LAST_PEAKEL_DIR, file.getParentFile().getAbsolutePath());
                this.mzScopePanel.loadPeakels((IRawFile)this.getRawFilesPanel().getSelectedValues().get(0), file);
            }
        });
        popupMenu.add(this.loadPeakelsMI);
        this.viewLCMSMap = new JMenuItem();
        this.viewLCMSMap.setText("View LCMS Map...");
        this.viewLCMSMap.addActionListener(ae -> this.mzScopePanel.displayLCMSMap((IRawFile)this.getRawFilesPanel().getSelectedValues().get(0)));
        popupMenu.add(this.viewLCMSMap);
        this.compareQCMI = new JMenuItem();
        this.compareQCMI.setText("QC metrics");
        this.compareQCMI.addActionListener(evt -> {
            ArrayList<QCMetrics> metrics = new ArrayList<QCMetrics>();
            for (IRawFile file : this.getRawFilesPanel().getSelectedValues()) {
                metrics.add(this.getFileMetrics(file));
            }
            QCMetricsPanel panel = this.mzScopePanel.displayMetrics(metrics);
            JButton loadMetricsBtn = new JButton("#QC");
            loadMetricsBtn.setToolTipText("Load existing QC metrics from the internal cache");
            loadMetricsBtn.addActionListener(e -> this.loadMetricsFromCache(panel));
            panel.getToolBar().add(loadMetricsBtn);
        });
        popupMenu.add(this.compareQCMI);
        popupMenu.addSeparator();
        this.export = new JMenuItem();
        this.export.setText("Export...");
        this.export.addActionListener(ae -> this.mzScopePanel.export(this.getRawFilesPanel().getSelectedValues()));
        popupMenu.add(this.export);
        popupMenu.addSeparator();
        this.propertiesMI = new JMenuItem();
        this.propertiesMI.setText("Properties");
        this.propertiesMI.addActionListener(evt -> this.mzScopePanel.displayProperties(this.getRawFilesPanel().getSelectedValues()));
        popupMenu.add(this.propertiesMI);
    }

    public void updatePopupMenu() {
        List selectedRaws = this.getRawFilesPanel().getSelectedValues();
        int nbS = selectedRaws.size();
        boolean noEmptyRawFile = true;
        for (IRawFile rf : selectedRaws) {
            if (!(rf instanceof EmptyRawFile)) continue;
            noEmptyRawFile = false;
            break;
        }
        this.viewRawFileMI.setEnabled(noEmptyRawFile && nbS > 0);
        this.closeRawFileMI.setEnabled(noEmptyRawFile && nbS == 1);
        this.closeAllFileMI.setEnabled(noEmptyRawFile);
        this.viewAllRawFilesMI.setEnabled(noEmptyRawFile);
        this.loadPeakelsMI.setEnabled(noEmptyRawFile);
        this.detectFeaturesMI.setEnabled(noEmptyRawFile);
        this.compareQCMI.setEnabled(noEmptyRawFile);
        this.propertiesMI.setEnabled(noEmptyRawFile);
        this.extractFeaturesMI.setEnabled(noEmptyRawFile && nbS > 0);
        this.detectPeakelsMI.setEnabled(noEmptyRawFile && nbS > 0);
        this.viewLCMSMap.setEnabled(noEmptyRawFile && nbS == 1);
        this.export.setEnabled(noEmptyRawFile && nbS > 0);
    }

    public ActionListener getDefaultAction() {
        return this.viewRawFileAction;
    }

    private void loadMetricsFromCache(QCMetricsPanel panel) {
        MetricsCache.getInstance();
        panel.addMetrics(MetricsCache.getInstance().loadAllQC(), "cache");
    }

    private QCMetrics getFileMetrics(IRawFile rawFile) {
        QCMetrics metrics = MetricsCache.getInstance().loadQC(rawFile);
        if (metrics == null) {
            logger.info("QC metrics not found for file {}, they will be computed now", (Object)this.getName());
            metrics = rawFile.getFileMetrics();
            MetricsCache.getInstance().writeQC(rawFile, metrics);
        } else {
            metrics.setRawFile(rawFile);
        }
        return metrics;
    }
}

