/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.identification_parameters;

import com.compomics.cli.identification_parameters.IdentificationParametersInputBean;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.parameters.identification.IdentificationParameters;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;

public abstract class AbstractIdentificationParametersCli
implements Callable {
    private IdentificationParametersInputBean input;

    public void initiate(String[] args) {
        block9: {
            try {
                try {
                    SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
                    speciesFactory.initiate(this.getJarFilePath());
                }
                catch (Exception e) {
                    System.out.println("An error occurred while loading the species.");
                    e.printStackTrace();
                    System.exit(1);
                }
                Options lOptions = new Options();
                this.createOptionsCLI(lOptions);
                DefaultParser parser = new DefaultParser();
                try {
                    CommandLine line = parser.parse(lOptions, args);
                    if (line.getOptions().length == 0 || line.hasOption("h") || line.hasOption("help") || line.hasOption("usage")) {
                        PrintWriter lPrintWriter = new PrintWriter(System.out);
                        lPrintWriter.print(System.getProperty("line.separator") + "============================" + System.getProperty("line.separator"));
                        lPrintWriter.print("IdentificationParametersCLI" + System.getProperty("line.separator"));
                        lPrintWriter.print("============================" + System.getProperty("line.separator"));
                        lPrintWriter.print(AbstractIdentificationParametersCli.getHeader());
                        lPrintWriter.print(this.getOptionsAsString());
                        lPrintWriter.flush();
                        lPrintWriter.close();
                        System.exit(0);
                    }
                    if (!IdentificationParametersInputBean.isValidStartup(line, true)) {
                        System.out.println(System.getProperty("line.separator") + "Run -usage to see the list of supported options and their input.");
                        System.exit(1);
                    }
                    if (!IdentificationParametersInputBean.isValidModifications(line)) {
                        this.printModifications();
                        System.exit(1);
                        break block9;
                    }
                    this.input = new IdentificationParametersInputBean(line);
                    this.call();
                }
                catch (UnrecognizedOptionException e) {
                    System.out.println(System.getProperty("line.separator") + "Unrecognized option " + e.getOption() + ".");
                    System.out.println(System.getProperty("line.separator") + "Run -usage to see the list of supported options and their input.");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Object call() {
        try {
            if (this.input.isListMods().booleanValue() || this.input.isListEnzymes().booleanValue()) {
                if (this.input.isListMods().booleanValue()) {
                    this.printModifications();
                }
                if (this.input.isListEnzymes().booleanValue()) {
                    this.printEnzymes();
                }
            } else {
                File outputFile = this.input.getDestinationFile();
                IdentificationParameters identificationParameters = this.input.getIdentificationParameters();
                IdentificationParameters.saveIdentificationParameters(identificationParameters, outputFile);
                System.out.println(System.getProperty("line.separator") + "Identification parameters file created: " + outputFile.getAbsolutePath() + System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void printModifications() {
        Modification ptm;
        System.out.println(System.getProperty("line.separator") + "========================" + System.getProperty("line.separator") + "Available Modifications:" + System.getProperty("line.separator") + "========================" + System.getProperty("line.separator"));
        System.out.println("----------------------");
        System.out.println("Default Modifications:");
        System.out.println("----------------------");
        ModificationFactory ptmFactory = ModificationFactory.getInstance();
        for (String ptmName : ptmFactory.getDefaultModificationsOrdered()) {
            ptm = ptmFactory.getModification(ptmName);
            System.out.println(ptm);
        }
        System.out.println();
        if (!ptmFactory.getUserModifications().isEmpty()) {
            System.out.println("-------------------");
            System.out.println("User Modifications:");
            System.out.println("-------------------");
            for (String ptmName : ptmFactory.getUserModificationsOrdered()) {
                ptm = ptmFactory.getModification(ptmName);
                System.out.println(ptm);
            }
        }
        System.out.println();
    }

    public void printEnzymes() {
        System.out.println(System.getProperty("line.separator") + "========================" + System.getProperty("line.separator") + "Available Enzymes:" + System.getProperty("line.separator") + "========================" + System.getProperty("line.separator"));
        String format = "%-40s%s%n";
        for (Enzyme enzyme : EnzymeFactory.getInstance().getEnzymes()) {
            System.out.printf(format, enzyme.getName(), enzyme.getDescription());
        }
        System.out.println();
    }

    protected abstract String getJarFilePath();

    protected abstract void createOptionsCLI(Options var1);

    protected abstract String getOptionsAsString();

    public static String getHeader() {
        return System.getProperty("line.separator") + "IdentificationParametersCLI creates an identification parameters file." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Use the out option to specify the output file or the mods option to list the available modifications." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/compomics-utilities/wiki/IdentificationParametersCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://compomics.github.io/projects/compomics-utilities.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }
}

