/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.identification_parameters;

import com.compomics.cli.identification_parameters.IdentificationParametersCLIParams;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.modification.ModificationLocalizationScore;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.mass_spectrometry.FragmentationMethod;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.FractionParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.ProteinInferenceParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.AndromedaParameters;
import com.compomics.util.parameters.identification.tool_specific.CometParameters;
import com.compomics.util.parameters.identification.tool_specific.DirecTagParameters;
import com.compomics.util.parameters.identification.tool_specific.MetaMorpheusParameters;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import com.compomics.util.parameters.identification.tool_specific.MsgfParameters;
import com.compomics.util.parameters.identification.tool_specific.MyriMatchParameters;
import com.compomics.util.parameters.identification.tool_specific.NovorParameters;
import com.compomics.util.parameters.identification.tool_specific.OmssaParameters;
import com.compomics.util.parameters.identification.tool_specific.PNovoParameters;
import com.compomics.util.parameters.identification.tool_specific.PepnovoParameters;
import com.compomics.util.parameters.identification.tool_specific.TideParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class IdentificationParametersInputBean {
    private IdentificationParameters identificationParameters;
    private File inputFile;
    private File destinationFile;
    private Boolean listMods = false;
    private Boolean listEnzymes = false;
    private final ModificationFactory ptmFactory = ModificationFactory.getInstance();
    private final EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private final CommandLine commandLine;

    public static boolean isValidStartup(CommandLine aLine, boolean checkMandatoryParameters) {
        List<String> supportedInput;
        String arg;
        List supportedInput2;
        List<String> supportedInput22;
        Iterator iterator;
        Object args;
        ArrayList<String> possibleValues;
        String arg2;
        String arg22;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            return true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYMES.id)) {
            return true;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PREC_PPM.id, arg22 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.FRAG_PPM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PREC_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.FRAG_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FI.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.FI.id);
            possibleValues = new ArrayList<String>(3);
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(0));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(1));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(2));
            args = CommandLineUtils.splitInput(arg2);
            iterator = ((ArrayList)args).iterator();
            while (iterator.hasNext()) {
                String fiAsString = (String)iterator.next();
                if (CommandParameter.isInList(IdentificationParametersCLIParams.FI.id, fiAsString, possibleValues)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.RI.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.RI.id);
            possibleValues = new ArrayList(3);
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(3));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(4));
            possibleValues.add(PeptideFragmentIon.getSubTypeAsString(5));
            args = CommandLineUtils.splitInput(arg2);
            iterator = ((ArrayList)args).iterator();
            while (iterator.hasNext()) {
                String riAsString = (String)iterator.next();
                if (CommandParameter.isInList(IdentificationParametersCLIParams.RI.id, riAsString, possibleValues)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIGESTION.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIGESTION.id);
            possibleValues = new ArrayList(DigestionParameters.Specificity.values().length);
            for (DigestionParameters.CleavageParameter cleavageParameter : DigestionParameters.CleavageParameter.values()) {
                possibleValues.add(cleavageParameter.index + "");
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.DIGESTION.id, arg2, possibleValues)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            ArrayList<String> enzymes = CommandLineUtils.splitInput(arg2);
            for (String enzymeName : enzymes) {
                Enzyme enzyme = EnzymeFactory.getInstance().getEnzyme(enzymeName);
                if (enzyme != null) continue;
                System.out.println(System.getProperty("line.separator") + "Enzyme " + arg2 + " not recognized. Please add enzyme using the EnzymeCLI command." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
            ArrayList<String> mcsAsString = CommandLineUtils.splitInput(arg2);
            for (String mcAsString : mcsAsString) {
                if (CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MC.id, mcAsString, true)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SPECIFICITY.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SPECIFICITY.id);
            possibleValues = new ArrayList(DigestionParameters.Specificity.values().length);
            for (DigestionParameters.Specificity specificity : DigestionParameters.Specificity.values()) {
                possibleValues.add(specificity.index + "");
            }
            args = CommandLineUtils.splitInput(arg2);
            Iterator mcAsString = ((ArrayList)args).iterator();
            while (mcAsString.hasNext()) {
                String specificityAsString = (String)mcAsString.next();
                if (CommandParameter.isInList(IdentificationParametersCLIParams.SPECIFICITY.id, specificityAsString, possibleValues)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id);
            if (arg2.equals("")) {
                System.out.println(System.getProperty("line.separator") + "No input file specified!" + System.getProperty("line.separator"));
                return false;
            }
            File fileIn = new File(arg2);
            try {
                IdentificationParameters.getIdentificationParameters(fileIn);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while importing the parameters file " + fileIn + "." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OUT.id)) {
            if (aLine.getOptionValue(IdentificationParametersCLIParams.OUT.id).equals("")) {
                System.out.println(System.getProperty("line.separator") + "No output file specified!" + System.getProperty("line.separator"));
                return false;
            }
        } else if (checkMandatoryParameters) {
            System.out.println(System.getProperty("line.separator") + "No output file specified!" + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MIN_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MAX_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MIN_ISOTOPE.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MIN_ISOTOPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MIN_ISOTOPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MAX_ISOTOPE.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MAX_ISOTOPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MAX_ISOTOPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.OMSSA_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id), supportedInput22 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_NEUTRON.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_METHIONINE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_PTM_COMPLEXITY.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.XTANDEM_PTM_COMPLEXITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_PTM_COMPLEXITY.id), 0.0, 12.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.XTANDEM_EVALUE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id), supportedInput2 = Arrays.asList("all", "valid", "stochastic"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_HISTOGRAMS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.XTANDEM_OUTPUT_HISTOGRAMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_HISTOGRAMS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_DECOY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MSGF_DECOY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_DECOY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id), supportedInput2 = Arrays.asList("0", "1", "2", "3"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id), supportedInput2 = Arrays.asList("0", "1", "2", "3"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PROTOCOL.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_PROTOCOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PROTOCOL.id), supportedInput2 = Arrays.asList("0", "1", "2", "3", "4", "5"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_TERMINI.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MSGF_TERMINI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TERMINI.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MSGF_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MSGF_TASKS.id) && !CommandParameter.isInteger(IdentificationParametersCLIParams.MSGF_TASKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TASKS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY_RANKING.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_DECOY_RANKING.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY_RANKING.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_PERFORM_DEISOTOPING.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MS_AMANDA_PERFORM_DEISOTOPING.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_PERFORM_DEISOTOPING.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD.id), 0, 10)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_VAR_MOD.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_MAX_VAR_MOD.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_VAR_MOD.id), 0, 10)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD_SITES.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD_SITES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD_SITES.id), 0, 20)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES.id), 0, 5)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES_MODIFICATIONS.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES_MODIFICATIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES_MODIFICATIONS.id), 0, 5)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MIN_PEPTIDE_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MS_AMANDA_MIN_PEPTIDE_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MIN_PEPTIDE_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_PEPTIDE_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MS_AMANDA_MAX_PEPTIDE_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_PEPTIDE_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOADED_PROTEINS.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_LOADED_PROTEINS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOADED_PROTEINS.id), 1000, 500000)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOADED_SPECTRA.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.MS_AMANDA_LOADED_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOADED_SPECTRA.id), 1000, 500000)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_OUTPUT_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MS_AMANDA_OUTPUT_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_OUTPUT_FORMAT.id), supportedInput2 = Arrays.asList("csv", "mzIdentML"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id), supportedInput2 = Arrays.asList("mzIdentML", "pepXML"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REQ_PTMS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_REQ_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REQ_PTMS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id), supportedInput2 = Arrays.asList("0", "1", "2", "3"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id), supportedInput2 = Arrays.asList("1", "2", "8", "9"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id), supportedInput2 = Arrays.asList("0", "1", "2", "3", "4"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEP_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PEP_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id), 1, 5)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_METH.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_REMOVE_METH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_METH.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.COMET_OUTPUT.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.COMET_OUTPUT.id);
            supportedInput2 = new ArrayList<String>();
            for (CometParameters.CometOutputFormat cometOutputFormat : CometParameters.CometOutputFormat.values()) {
                supportedInput2.add((String)cometOutputFormat.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.COMET_OUTPUT.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PTMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id), supportedInput2 = Arrays.asList("none", "shuffle", "peptide-reverse", "protein-reverse"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id), supportedInput2 = Arrays.asList("N", "C", "NC"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_VERBOSITY.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_VERBOSITY.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_VERBOSITY.id), supportedInput2 = Arrays.asList("0", "10", "20", "30", "40", "50", "60"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id), supportedInput2 = Arrays.asList("full-digest", "partial-digest"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id), supportedInput2 = Arrays.asList("1", "2", "3", "all"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_CONCAT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_CONCAT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CONCAT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id), supportedInput2 = Arrays.asList("HCD", "CID", "ETD"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : AndromedaParameters.AndromedaDecoyMode.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MIN_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_PEP_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MAX_PEP_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_PEP_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TYPE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TYPE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusSearchType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TYPE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PARTITIONS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PARTITIONS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PARTITIONS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DISSOCIATION_TYPE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DISSOCIATION_TYPE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusDissociationType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_DISSOCIATION_TYPE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MODS_FOR_PEPTIDE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MODS_FOR_PEPTIDE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MODS_FOR_PEPTIDE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_INITIATOR_METHIONINE_BEHAVIOR.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_INITIATOR_METHIONINE_BEHAVIOR.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_INITIATOR_METHIONINE_BEHAVIOR.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SCORE_CUTOFF.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_SCORE_CUTOFF.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SCORE_CUTOFF.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_USE_DELTA_SCORE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_USE_DELTA_SCORE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_USE_DELTA_SCORE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_FRAGMENTATION_TERMINUS.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_FRAGMENTATION_TERMINUS.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_FRAGMENTATION_TERMINUS.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_FRAGMENTATION_SIZE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_MAX_FRAGMENTATION_SIZE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_FRAGMENTATION_SIZE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MASS_DIFF_ACCEPTOR_TYPE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MASS_DIFF_ACCEPTOR_TYPE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_MASS_DIFF_ACCEPTOR_TYPE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_MZID.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_MZID.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_MZID.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_PEPXML.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_PEPXML.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_PEPXML.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_INT_RATIO.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_INT_RATIO.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_INT_RATIO.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL_TYPE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL_TYPE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusToleranceType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL_TYPE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MS1_PEAKS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MS1_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MS1_PEAKS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MSMS_PEAKS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MSMS_PEAKS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MSMS_PEAKS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PEAKS_PER_WINDOWS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PEAKS_PER_WINDOWS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PEAKS_PER_WINDOWS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WINDOW_WITH_THOMPSON.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.META_MORPHEUS_WINDOW_WITH_THOMPSON.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WINDOW_WITH_THOMPSON.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_WINDOWS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_NUM_WINDOWS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_WINDOWS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MOD_PEPTIDES_ARE_DIFFERENT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_MOD_PEPTIDES_ARE_DIFFERENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MOD_PEPTIDES_ARE_DIFFERENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NO_ONE_HIT_WONDERS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_NO_ONE_HIT_WONDERS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NO_ONE_HIT_WONDERS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TARGET.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TARGET.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TARGET.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECOY_TYPE.id)) {
            arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECOY_TYPE.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : MetaMorpheusParameters.MetaMorpheusDecoyType.values()) {
                supportedInput2.add((String)enum_.toString());
            }
            if (!CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_DECOY_TYPE.id, arg2, supportedInput2)) {
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MOD_ISOFORMS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MOD_ISOFORMS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MOD_ISOFORMS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_VARIANT_DEPTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MIN_VARIANT_DEPTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_VARIANT_DEPTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_HETROZYGOUS_VARIANTS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.META_MORPHEUS_MAX_HETROZYGOUS_VARIANTS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_HETROZYGOUS_VARIANTS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_GPTM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.META_MORPHEUS_GPTM.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_GPTM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_GPTM_CATEGORIES.id)) {
            String combinedArgs = aLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_GPTM_CATEGORIES.id);
            supportedInput2 = new ArrayList<String>();
            for (Enum enum_ : ModificationCategory.values()) {
                supportedInput2.add((String)((ModificationCategory)enum_).toString());
            }
            for (String arg3 : CommandLineUtils.splitInput(combinedArgs)) {
                if (CommandParameter.isInList(IdentificationParametersCLIParams.META_MORPHEUS_GPTM_CATEGORIES.id, arg3, supportedInput2)) continue;
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id), 1, 20)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_ESTIMATE_CHARGE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_ESTIMATE_CHARGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_ESTIMATE_CHARGE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id), supportedInput2 = Arrays.asList("CID_IT_TRYP"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id) && !CommandParameter.inIntegerRange(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id), 0, 100)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECURSOR_ADJUSTMENT.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECURSOR_ADJUSTMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECURSOR_ADJUSTMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECURSOR_ADJUSTMENT.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECURSOR_ADJUSTMENT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECURSOR_ADJUSTMENT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_PRECURSOR_ADJUSTMENT_STEP.id) && !CommandParameter.isDouble(IdentificationParametersCLIParams.DIRECTAG_PRECURSOR_ADJUSTMENT_STEP.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_PRECURSOR_ADJUSTMENT_STEP.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id)) {
            // empty if block
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id), supportedInput2 = Arrays.asList("0", "1", "2"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id), supportedInput2 = Arrays.asList("HCD", "CID", "ETD"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id), supportedInput2 = Arrays.asList("HCD", "CID"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id), supportedInput2 = Arrays.asList("Trap", "TOF", "FT"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL_TYPE.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.ANNOTATION_LEVEL_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL_TYPE.id), supportedInput2 = (List)Arrays.asList(AnnotationParameters.IntensityThresholdType.values()).stream().map(object -> object.toString()).collect(Collectors.toCollection(ArrayList::new)))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id) && !CommandParameter.isSequenceMatchingType(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_ENZYMATIC_TAGS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SEQUENCE_MATCHING_ENZYMATIC_TAGS.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_ENZYMATIC_TAGS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MAX_PTMS_PER_TAG.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MAX_PTMS_PER_TAG.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MAX_PTMS_PER_TAG.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_AMINO_ACID_SCORE.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_AMINO_ACID_SCORE.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_AMINO_ACID_SCORE.id), true)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_TAG_LENGTH.id) && !CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_TAG_LENGTH.id, arg2 = aLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_TAG_LENGTH.id), true)) {
            return false;
        }
        Integer min = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id)) {
            String arg4 = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id, arg4, false)) {
                return false;
            }
            min = Integer.valueOf(arg4);
        }
        Integer max = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id, arg, false)) {
                return false;
            }
            max = Integer.valueOf(arg);
        }
        if (min != null && max != null && max <= min) {
            System.out.println(System.getProperty("line.separator") + IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id + " <= " + IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id + System.getProperty("line.separator"));
            return false;
        }
        min = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MIN.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MIN.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_MC_MIN.id, arg, true)) {
                return false;
            }
            min = Integer.valueOf(arg);
        }
        max = null;
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MAX.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MAX.id);
            if (!CommandParameter.isPositiveInteger(IdentificationParametersCLIParams.IMPORT_MC_MAX.id, arg, false)) {
                return false;
            }
            max = Integer.valueOf(arg);
        }
        if (min != null && max != null && max < min) {
            System.out.println(System.getProperty("line.separator") + IdentificationParametersCLIParams.IMPORT_MC_MAX.id + " < " + IdentificationParametersCLIParams.IMPORT_MC_MIN.id + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_SCORE.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_SCORE.id);
            try {
                int scoreId = Integer.valueOf(arg);
                ModificationLocalizationScore.getScore(scoreId);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "Error when parsing " + IdentificationParametersCLIParams.PTM_SCORE.id + ". Option found: " + arg + "." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_THRESHOLD.id) && !CommandParameter.isPositiveDouble(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_THRESHOLD.id), false)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id) && !CommandParameter.isSequenceMatchingType(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PTM_ALIGNMENT.id) && !CommandParameter.isInList(IdentificationParametersCLIParams.PTM_ALIGNMENT.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PTM_ALIGNMENT.id), supportedInput = Arrays.asList("0", "1"))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE_THRESHOLD.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE_THRESHOLD.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE_THRESHOLD.id), 0.0, 1.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PSM_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PSM_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PEPTIDE_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PEPTIDE_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FDR.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PSM_FDR.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FDR.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id) && !CommandParameter.inDoubleRange(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id), 0.0, 100.0)) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_TAG.id) && (arg = aLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_TAG.id)).equals("")) {
            System.out.println(System.getProperty("line.separator") + "FASTA decoy tag cannot be empty!" + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id) && !CommandParameter.isBooleanInput(IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id, arg = aLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id))) {
            return false;
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_FILE_TAG.id) && (arg = aLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_FILE_TAG.id)).equals("")) {
            System.out.println(System.getProperty("line.separator") + "FASTA decoy file tag cannot be empty!" + System.getProperty("line.separator"));
            return false;
        }
        return true;
    }

    public IdentificationParametersInputBean(CommandLine aLine) throws IOException, ClassNotFoundException {
        String arg;
        this.commandLine = aLine;
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MODS.id)) {
            this.listMods = true;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ENZYMES.id)) {
            this.listEnzymes = true;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id);
            this.inputFile = new File(arg);
            this.identificationParameters = IdentificationParameters.getIdentificationParameters(this.inputFile);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OUT.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OUT.id);
            if (!arg.endsWith(".par")) {
                arg = arg + ".par";
            }
            this.destinationFile = new File(arg);
        }
        this.updateIdentificationParameters();
    }

    /*
     * WARNING - void declaration
     */
    public void updateIdentificationParameters() {
        boolean value;
        Integer intValue;
        String arg;
        FastaParameters fastaPreferences;
        FractionParameters fractionSettings;
        Double value2;
        IdMatchValidationParameters idMatchValidationPreferences;
        String arg2;
        ModificationLocalizationParameters ptmScoringPreferences;
        Number value3;
        SequenceMatchingParameters sequenceMatchingPreferences;
        AnnotationParameters annotationSettings;
        void var19_193;
        void var19_191;
        NovorParameters novorParameters;
        PNovoParameters pNovoParameters;
        DirecTagParameters direcTagParameters;
        String arg3;
        PepnovoParameters pepnovoParameters;
        Object option;
        String arg4;
        MetaMorpheusParameters metaMorpheusParameters;
        Integer option2;
        String arg5;
        AndromedaParameters andromedaParameters;
        Number option3;
        String arg6;
        TideParameters tideParameters;
        Number option4;
        String arg7;
        CometParameters cometParameters;
        Integer option5;
        String arg8;
        MsAmandaParameters msAmandaParameters;
        Number option6;
        String arg9;
        MyriMatchParameters myriMatchParameters;
        Integer option7;
        String arg10;
        MsgfParameters msgfParameters;
        Number option8;
        XtandemParameters xtandemParameters;
        Number option9;
        OmssaParameters omssaParameters;
        Integer algorithmIndex;
        IdentificationAlgorithmParameter identificationAlgorithmParameter;
        String arg11;
        Modification modification;
        ArrayList<String> args;
        ModificationParameters ptmSettings;
        Integer option10;
        ArrayList<Integer> ions;
        DigestionParameters.Specificity specificity;
        Enzyme enzyme;
        String arg12;
        DigestionParameters digestionPreferences;
        Number option11;
        String arg13;
        SearchParameters searchParameters = null;
        if (this.identificationParameters != null) {
            searchParameters = this.identificationParameters.getSearchParameters();
        }
        if (searchParameters == null) {
            searchParameters = new SearchParameters();
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PREC_PPM.id)) {
            String arg14 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PREC_PPM.id);
            Integer option13 = Integer.valueOf(arg14);
            switch (option13) {
                case 1: {
                    searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                    break;
                }
                case 0: {
                    searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.PREC_PPM.id + ": " + arg14 + ". 0 or 1 expected.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FRAG_PPM.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FRAG_PPM.id);
            option11 = Integer.valueOf(arg13);
            if ((Integer)option11 == 1) {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PREC_TOL.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PREC_TOL.id);
            option11 = Double.valueOf(arg13);
            searchParameters.setPrecursorAccuracy((Double)option11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FRAG_TOL.id)) {
            arg13 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FRAG_TOL.id);
            option11 = Double.valueOf(arg13);
            searchParameters.setFragmentIonAccuracy((Double)option11);
        }
        if ((digestionPreferences = searchParameters.getDigestionParameters()) == null) {
            digestionPreferences = DigestionParameters.getDefaultParameters();
            searchParameters.setDigestionParameters(digestionPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIGESTION.id)) {
            String arg132 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIGESTION.id);
            Integer option12 = Integer.valueOf(arg132);
            DigestionParameters.CleavageParameter cleavagePreference = DigestionParameters.CleavageParameter.getCleavageParameters(option12);
            if (digestionPreferences.getCleavageParameter() != null && digestionPreferences.getCleavageParameter() != cleavagePreference) {
                digestionPreferences.clear();
            }
            digestionPreferences.setCleavageParameter(cleavagePreference);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ENZYME.id)) {
            if (digestionPreferences.hasEnzymes()) {
                digestionPreferences.clearEnzymes();
            }
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ENZYME.id);
            ArrayList<String> enzymes = CommandLineUtils.splitInput(arg12);
            ArrayList<Integer> mcs = null;
            Iterator<String> specificities = null;
            if (this.commandLine.hasOption(IdentificationParametersCLIParams.MC.id)) {
                arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MC.id);
                ArrayList<String> args3 = CommandLineUtils.splitInput(arg12);
                mcs = new ArrayList<Integer>(args3.size());
                for (String stringValue : args3) {
                    mcs.add(Integer.valueOf(stringValue));
                }
            }
            if (this.commandLine.hasOption(IdentificationParametersCLIParams.SPECIFICITY.id)) {
                arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SPECIFICITY.id);
                ArrayList<String> args2 = CommandLineUtils.splitInput(arg12);
                specificities = new ArrayList(args2.size());
                for (String stringValue : args2) {
                    ((ArrayList)((Object)specificities)).add((String)((Object)DigestionParameters.Specificity.getSpecificity(Integer.valueOf(stringValue))));
                }
            }
            for (int i = 0; i < enzymes.size(); ++i) {
                String enzymeName = enzymes.get(i);
                enzyme = this.enzymeFactory.getEnzyme(enzymeName);
                digestionPreferences.addEnzyme(enzyme);
                Integer mc = mcs != null ? (Integer)mcs.get(i) : Integer.valueOf(2);
                digestionPreferences.setnMissedCleavages(enzymeName, mc);
                specificity = specificities != null ? (DigestionParameters.Specificity)((Object)((ArrayList)((Object)specificities)).get(i)) : DigestionParameters.Specificity.specific;
                digestionPreferences.setSpecificity(enzymeName, specificity);
            }
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme && !digestionPreferences.hasEnzymes()) {
            String enzymeName = "Trypsin";
            Enzyme enzyme2 = this.enzymeFactory.getEnzyme(enzymeName);
            digestionPreferences.addEnzyme(enzyme2);
            digestionPreferences.setnMissedCleavages(enzymeName, 2);
            digestionPreferences.setSpecificity(enzymeName, DigestionParameters.Specificity.specific);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FI.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FI.id);
            ArrayList<String> args2 = CommandLineUtils.splitInput(arg12);
            ions = new ArrayList<Integer>(args2.size());
            for (String ionName : args2) {
                ions.add(PeptideFragmentIon.getIonType(ionName));
            }
            searchParameters.setForwardIons(ions);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.RI.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.RI.id);
            ArrayList<String> args3 = CommandLineUtils.splitInput(arg12);
            ions = new ArrayList(args3.size());
            for (String ionName : args3) {
                ions.add(PeptideFragmentIon.getIonType(ionName));
            }
            searchParameters.setRewindIons(ions);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MIN_CHARGE.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MIN_CHARGE.id);
            option10 = Integer.valueOf(arg12);
            searchParameters.setMinChargeSearched(option10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MAX_CHARGE.id)) {
            arg12 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MAX_CHARGE.id);
            option10 = Integer.valueOf(arg12);
            searchParameters.setMaxChargeSearched(option10);
        }
        if ((ptmSettings = searchParameters.getModificationParameters()) == null) {
            ptmSettings = new ModificationParameters();
            searchParameters.setModificationParameters(ptmSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            String arg122 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            ptmSettings.clearFixedModifications();
            args = CommandLineUtils.splitInput(arg122);
            for (String ptmName : args) {
                modification = this.ptmFactory.getModification(ptmName);
                ptmSettings.addFixedModification(modification);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            ptmSettings.clearVariableModifications();
            args = CommandLineUtils.splitInput(arg11);
            for (String ptmName : args) {
                modification = this.ptmFactory.getModification(ptmName);
                ptmSettings.addVariableModification(modification);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MIN_ISOTOPE.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MIN_ISOTOPE.id);
            Integer option112 = Integer.valueOf(arg11);
            searchParameters.setMinIsotopicCorrection(option112);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MAX_ISOTOPE.id)) {
            arg11 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MAX_ISOTOPE.id);
            Integer option12 = Integer.valueOf(arg11);
            searchParameters.setMaxIsotopicCorrection(option12);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.omssa.getIndex()))) == null) {
            omssaParameters = new OmssaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, omssaParameters);
        } else {
            omssaParameters = (OmssaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id)) {
            String arg15 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REMOVE_PREC.id);
            Integer option102 = Integer.valueOf(arg15);
            omssaParameters.setRemovePrecursor(option102 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id)) {
            String arg16 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SCALE_PREC.id);
            option9 = Integer.valueOf(arg16);
            omssaParameters.setScalePrecursor((Integer)option9 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id)) {
            String arg17 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ESTIMATE_CHARGE.id);
            option9 = Integer.valueOf(arg17);
            omssaParameters.setEstimateCharge((Integer)option9 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id)) {
            String arg18 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_EVALUE.id);
            option9 = Double.valueOf(arg18);
            omssaParameters.setMaxEValue((Double)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id)) {
            String arg19 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH.id);
            option9 = Integer.valueOf(arg19);
            omssaParameters.setHitListLength((Integer)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id)) {
            String arg20 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEP_LENGTH.id);
            option9 = Integer.valueOf(arg20);
            omssaParameters.setMinPeptideLength((Integer)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id)) {
            String arg21 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_PEP_LENGTH.id);
            option9 = Integer.valueOf(arg21);
            omssaParameters.setMaxPeptideLength((Integer)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORMAT.id)) {
            String arg22 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORMAT.id);
            option9 = Integer.valueOf(arg22);
            omssaParameters.setSelectedOutput(OmssaParameters.getOmssaOutputTypes()[(Integer)option9]);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id)) {
            String arg23 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SEQUENCES_IN_MEMORY.id);
            option9 = Integer.valueOf(arg23);
            omssaParameters.setMemoryMappedSequenceLibraries((Integer)option9 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_NEUTRON.id)) {
            String arg24 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_NEUTRON.id);
            option9 = Double.valueOf(arg24);
            omssaParameters.setNeutronThreshold((Double)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id)) {
            String arg25 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_LOW_INTENSITY.id);
            option9 = Double.valueOf(arg25);
            omssaParameters.setLowIntensityCutOff((Double)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id)) {
            String arg26 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HIGH_INTENSITY.id);
            option9 = Double.valueOf(arg26);
            omssaParameters.setHighIntensityCutOff((Double)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id)) {
            String arg27 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_INTENSITY_INCREMENT.id);
            option9 = Double.valueOf(arg27);
            omssaParameters.setIntensityCutOffIncrement((Double)option9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id)) {
            String arg28 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_WIDTH.id);
            int option14 = Integer.parseInt(arg28);
            omssaParameters.setSingleChargeWindow(option14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id)) {
            String arg29 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_WIDTH.id);
            int option15 = Integer.parseInt(arg29);
            omssaParameters.setDoubleChargeWindow(option15);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id)) {
            String arg30 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_SINGLE_WINDOW_PEAKS.id);
            int option16 = Integer.parseInt(arg30);
            omssaParameters.setnPeaksInSingleChargeWindow(option16);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id)) {
            String arg31 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_DOUBLE_WINDOW_PEAKS.id);
            int option17 = Integer.parseInt(arg31);
            omssaParameters.setnPeaksInDoubleChargeWindow(option17);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id)) {
            String arg32 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_INTENSE_PEAKS.id);
            int option18 = Integer.parseInt(arg32);
            omssaParameters.setnAnnotatedMostIntensePeaks(option18);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id)) {
            String arg33 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_ANNOTATED_PEAKS.id);
            int option19 = Integer.parseInt(arg33);
            omssaParameters.setMinAnnotatedPeaks(option19);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id)) {
            String arg34 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MIN_PEAKS.id);
            int option20 = Integer.parseInt(arg34);
            omssaParameters.setMinPeaks(option20);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_METHIONINE.id)) {
            String arg35 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_METHIONINE.id);
            int option21 = Integer.parseInt(arg35);
            omssaParameters.setCleaveNterMethionine(option21 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id)) {
            String arg36 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_LADDERS.id);
            int option22 = Integer.parseInt(arg36);
            omssaParameters.setMaxMzLadders(option22);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id)) {
            String arg37 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_CHARGE.id);
            int option23 = Integer.parseInt(arg37);
            omssaParameters.setMaxFragmentCharge(option23);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id)) {
            String arg38 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRACTION.id);
            Double option24 = Double.valueOf(arg38);
            omssaParameters.setFractionOfPeaksForChargeEstimation(option24);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id)) {
            String arg39 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PLUS_ONE.id);
            int option25 = Integer.parseInt(arg39);
            omssaParameters.setDetermineChargePlusOneAlgorithmically(option25 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id)) {
            String arg40 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_POSITIVE_IONS.id);
            int option26 = Integer.parseInt(arg40);
            omssaParameters.setSearchPositiveIons(option26 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id)) {
            String arg41 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_PREC_PER_SPECTRUM.id);
            int option27 = Integer.parseInt(arg41);
            omssaParameters.setMinPrecPerSpectrum(option27);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id)) {
            String arg42 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_FORWARD_IONS.id);
            int option28 = Integer.parseInt(arg42);
            omssaParameters.setSearchForwardFragmentFirst(option28 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id)) {
            String arg43 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_REWIND_IONS.id);
            int option29 = Integer.parseInt(arg43);
            omssaParameters.setSearchRewindFragments(option29 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id)) {
            String arg44 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_MAX_FRAG_SERIES.id);
            int option30 = Integer.parseInt(arg44);
            omssaParameters.setMaxFragmentPerSeries(option30);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id)) {
            String arg45 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CORRELATION_CORRECTION.id);
            int option31 = Integer.parseInt(arg45);
            omssaParameters.setUseCorrelationCorrectionScore(option31 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id)) {
            String arg46 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_CONSECUTIVE_ION_PROBABILITY.id);
            Double option32 = Double.valueOf(arg46);
            omssaParameters.setConsecutiveIonProbability(option32);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id)) {
            String arg47 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SEQUENCE_EVALUE.id);
            Double option33 = Double.valueOf(arg47);
            omssaParameters.setIterativeSequenceEvalue(option33);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id)) {
            String arg48 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_SPECTRUM_EVALUE.id);
            Double option34 = Double.valueOf(arg48);
            omssaParameters.setIterativeSpectrumEvalue(option34);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id)) {
            String arg49 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_ITERATIVE_REPLACE_EVALUE.id);
            Double option35 = Double.valueOf(arg49);
            omssaParameters.setIterativeReplaceEvalue(option35);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id)) {
            String arg50 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.OMSSA_HITLIST_LENGTH_CHARGE.id);
            int option36 = Integer.parseInt(arg50);
            omssaParameters.setMaxFragmentPerSeries(option36);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.xtandem.getIndex()))) == null) {
            xtandemParameters = new XtandemParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, xtandemParameters);
        } else {
            xtandemParameters = (XtandemParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id)) {
            String arg51 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_DYNAMIC_RANGE.id);
            Double option92 = Double.valueOf(arg51);
            xtandemParameters.setDynamicRange(option92);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id)) {
            String arg52 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NPEAKS.id);
            option8 = Integer.valueOf(arg52);
            xtandemParameters.setnPeaks((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id)) {
            String arg53 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_FRAG_MZ.id);
            option8 = Double.valueOf(arg53);
            xtandemParameters.setMinFragmentMz((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id)) {
            String arg54 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PEAKS.id);
            option8 = Integer.valueOf(arg54);
            xtandemParameters.setMinPeaksPerSpectrum((Integer)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id)) {
            String arg55 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_NOISE_SUPPRESSION.id);
            option8 = Integer.valueOf(arg55);
            xtandemParameters.setUseNoiseSuppression((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id)) {
            String arg56 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_MIN_PREC_MASS.id);
            option8 = Double.valueOf(arg56);
            xtandemParameters.setMinPrecursorMass((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR.id)) {
            String arg57 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR.id);
            option8 = Integer.valueOf(arg57);
            xtandemParameters.setParentMonoisotopicMassIsotopeError((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id)) {
            String arg58 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_ACETYL.id);
            option8 = Integer.valueOf(arg58);
            xtandemParameters.setProteinQuickAcetyl((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id)) {
            String arg59 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_QUICK_PYRO.id);
            option8 = Integer.valueOf(arg59);
            xtandemParameters.setQuickPyrolidone((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id)) {
            String arg60 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_STP_BIAS.id);
            option8 = Integer.valueOf(arg60);
            xtandemParameters.setStpBias((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_PTM_COMPLEXITY.id)) {
            String arg61 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_PTM_COMPLEXITY.id);
            option8 = Double.valueOf(arg61);
            xtandemParameters.setProteinPtmComplexity((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE.id)) {
            String arg62 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE.id);
            option8 = Integer.valueOf(arg62);
            xtandemParameters.setRefine((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id)) {
            String arg63 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_EVALUE.id);
            option8 = Double.valueOf(arg63);
            xtandemParameters.setMaximumExpectationValueRefinement((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id)) {
            String arg64 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_UNANTICIPATED_CLEAVAGE.id);
            option8 = Integer.valueOf(arg64);
            xtandemParameters.setRefineUnanticipatedCleavages((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id)) {
            String arg65 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SEMI.id);
            option8 = Integer.valueOf(arg65);
            xtandemParameters.setRefineSemi((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id)) {
            String arg66 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POTENTIAL_MOD_FULL_REFINEMENT.id);
            option8 = Integer.valueOf(arg66);
            xtandemParameters.setPotentialModificationsForFullRefinment((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id)) {
            String arg67 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_POINT_MUTATIONS.id);
            option8 = Integer.valueOf(arg67);
            xtandemParameters.setRefinePointMutations((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id)) {
            String arg68 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SNAPS.id);
            option8 = Integer.valueOf(arg68);
            xtandemParameters.setRefineSnaps((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id)) {
            String arg69 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_REFINE_SPECTRUM_SYNTHESIS.id);
            option8 = Integer.valueOf(arg69);
            xtandemParameters.setRefineSpectrumSynthesis((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_EVALUE.id)) {
            String arg70 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_EVALUE.id);
            option8 = Double.valueOf(arg70);
            xtandemParameters.setMaxEValue((Double)option8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id)) {
            String arg71 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_RESULTS.id);
            xtandemParameters.setOutputResults(arg71);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id)) {
            String arg72 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_PROTEINS.id);
            option8 = Integer.valueOf(arg72);
            xtandemParameters.setOutputProteins((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id)) {
            String arg73 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SEQUENCES.id);
            option8 = Integer.valueOf(arg73);
            xtandemParameters.setOutputSequences((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id)) {
            String arg74 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_SPECTRA.id);
            option8 = Integer.valueOf(arg74);
            xtandemParameters.setOutputSpectra((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_OUTPUT_HISTOGRAMS.id)) {
            String arg75 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_OUTPUT_HISTOGRAMS.id);
            option8 = Integer.valueOf(arg75);
            xtandemParameters.setOutputHistograms((Integer)option8 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id)) {
            String arg76 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.XTANDEM_SKYLINE.id);
            xtandemParameters.setSkylinePath(arg76);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.msgf.getIndex()))) == null) {
            msgfParameters = new MsgfParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, msgfParameters);
        } else {
            msgfParameters = (MsgfParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_DECOY.id)) {
            String arg112 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_DECOY.id);
            Integer option82 = Integer.valueOf(arg112);
            msgfParameters.setSearchDecoyDatabase(option82 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_INSTRUMENT.id);
            Integer instrumentID = Integer.valueOf(arg10);
            msgfParameters.setInstrumentID(instrumentID);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_FRAGMENTATION.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setFragmentationType(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_PROTOCOL.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PROTOCOL.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setProtocol(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MIN_PEP_LENGTH.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setMinPeptideLength(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_MAX_PEP_LENGTH.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setMaxPeptideLength(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_NUM_MATCHES.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setNumberOfSpectrumMarches(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_ADDITIONAL.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setAdditionalOutput(option7 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_TERMINI.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TERMINI.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setNumberTolerableTermini(option7);
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            enzyme = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme.getName();
            specificity = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity) {
                case specific: {
                    msgfParameters.setNumberTolerableTermini(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    msgfParameters.setNumberTolerableTermini(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity) + " not supported.");
                }
            }
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            msgfParameters.setNumberTolerableTermini(0);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_PTMS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_PTMS.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setNumberOfModificationsPerPeptide(option7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MSGF_TASKS.id)) {
            arg10 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MSGF_TASKS.id);
            option7 = Integer.valueOf(arg10);
            msgfParameters.setNumberOfTasks(option7);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.myriMatch.getIndex()))) == null) {
            myriMatchParameters = new MyriMatchParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, myriMatchParameters);
        } else {
            myriMatchParameters = (MyriMatchParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id)) {
            String arg102 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PEP_LENGTH.id);
            Integer option72 = Integer.valueOf(arg102);
            myriMatchParameters.setMinPeptideLength(option72);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEP_LENGTH.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setMaxPeptideLength((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MIN_PREC_MASS.id);
            option6 = Double.valueOf(arg9);
            myriMatchParameters.setMinPrecursorMass((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PREC_MASS.id);
            option6 = Double.valueOf(arg9);
            myriMatchParameters.setMaxPrecursorMass((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_MATCHES.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setNumberOfSpectrumMatches((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_PTMS.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setMaxDynamicMods((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_FRAGMENTATION.id);
            myriMatchParameters.setFragmentationRule(arg9);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TERMINI.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setMinTerminiCleavages((Integer)option6);
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            Enzyme enzyme3 = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme3.getName();
            DigestionParameters.Specificity specificity2 = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity2) {
                case specific: {
                    myriMatchParameters.setMinTerminiCleavages(2);
                    break;
                }
                case semiSpecific: 
                case specificNTermOnly: 
                case specificCTermOnly: {
                    myriMatchParameters.setMinTerminiCleavages(1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity2) + " not supported.");
                }
            }
        } else {
            myriMatchParameters.setMinTerminiCleavages(0);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_SMART_PLUS_THREE.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setUseSmartPlusThreeModel((Integer)option6 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_XCORR.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setComputeXCorr((Integer)option6 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_TIC_CUTOFF.id);
            option6 = Double.valueOf(arg9);
            myriMatchParameters.setTicCutoffPercentage((Double)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_INTENSTITY_CLASSES.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setNumIntensityClasses((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_CLASS_MULTIPLIER.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setClassSizeMultiplier((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_NUM_BATCHES.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setNumberOfBatches((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_MAX_PEAK_COUNT.id);
            option6 = Integer.valueOf(arg9);
            myriMatchParameters.setMaxPeakCount((Integer)option6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id)) {
            arg9 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MYRIMATCH_OUTPUT_FORMAT.id);
            myriMatchParameters.setOutputFormat(arg9);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.msAmanda.getIndex()))) == null) {
            msAmandaParameters = new MsAmandaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, msAmandaParameters);
        } else {
            msAmandaParameters = (MsAmandaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id)) {
            String arg92 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY.id);
            Integer option62 = Integer.valueOf(arg92);
            msAmandaParameters.setGenerateDecoyDatabase(option62 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_DECOY_RANKING.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_DECOY_RANKING.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setReportBothBestHitsForTD(option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_INSTRUMENT.id);
            msAmandaParameters.setInstrumentID(arg8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_RANK.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxRank(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MONOISOTOPIC.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMonoIsotopic(option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_PERFORM_DEISOTOPING.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_PERFORM_DEISOTOPING.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setPerformDeisotoping(option5 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxModifications(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_VAR_MOD.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_VAR_MOD.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxVariableModifications(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD_SITES.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_MOD_SITES.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxModificationSites(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxNeutralLosses(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES_MODIFICATIONS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_NEUTRAL_LOSSES_MODIFICATIONS.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxNeutralLossesPerModification(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MIN_PEPTIDE_LENGTH.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MIN_PEPTIDE_LENGTH.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMinPeptideLength(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_MAX_PEPTIDE_LENGTH.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_MAX_PEPTIDE_LENGTH.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxPeptideLength(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOADED_PROTEINS.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOADED_PROTEINS.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxLoadedProteins(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_LOADED_SPECTRA.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_LOADED_SPECTRA.id);
            option5 = Integer.valueOf(arg8);
            msAmandaParameters.setMaxLoadedSpectra(option5);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.MS_AMANDA_OUTPUT_FORMAT.id)) {
            arg8 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.MS_AMANDA_OUTPUT_FORMAT.id);
            msAmandaParameters.setOutputFormat(arg8);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.comet.getIndex()))) == null) {
            cometParameters = new CometParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, cometParameters);
        } else {
            cometParameters = (CometParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id)) {
            String arg82 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_NUM_MATCHES.id);
            Integer option52 = Integer.valueOf(arg82);
            cometParameters.setNumberOfSpectrumMatches(option52);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_PTMS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_PTMS.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setMaxVariableMods((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REQ_PTMS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REQ_PTMS.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setRequireVariableMods((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAKS.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setMinPeaks((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEAK_INTENSITY.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setMinPeakIntensity((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setRemovePrecursor((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_PRECURSOR_TOLERANCE.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setRemovePrecursorTolerance((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_LOWER.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setLowerClearMzRange((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_CLEAR_MZ_RANGE_UPPER.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setUpperClearMzRange((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_ENZYME_TYPE.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setEnzymeType((Integer)option4);
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            Enzyme enzyme4 = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme4.getName();
            DigestionParameters.Specificity specificity3 = digestionPreferences.getSpecificity(enzymeName);
            switch (specificity3) {
                case specific: {
                    cometParameters.setEnzymeType(2);
                    break;
                }
                case semiSpecific: {
                    cometParameters.setEnzymeType(1);
                    break;
                }
                case specificNTermOnly: {
                    cometParameters.setEnzymeType(8);
                    break;
                }
                case specificCTermOnly: {
                    cometParameters.setEnzymeType(9);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Specificity " + (Object)((Object)specificity3) + " not supported.");
                }
            }
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            cometParameters.setEnzymeType(2);
        } else {
            cometParameters.setEnzymeType(1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_ISOTOPE_CORRECTION.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setIsotopeCorrection((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PREC_MASS.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setMinPrecursorMass((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PREC_MASS.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setMaxPrecursorMass((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MIN_PEP_LENGTH.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MIN_PEP_LENGTH.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setMinPeptideLength((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_PEP_LENGTH.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_PEP_LENGTH.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setMaxPeptideLength((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_MAX_FRAGMENT_CHARGE.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setMaxFragmentCharge((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_REMOVE_METH.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_REMOVE_METH.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setRemoveMethionine((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_BATCH_SIZE.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setBatchSize((Integer)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_THEORETICAL_FRAGMENT_IONS.id);
            option4 = Integer.valueOf(arg7);
            cometParameters.setTheoreticalFragmentIonsSumOnly((Integer)option4 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_FRAGMENT_BIN_OFFSET.id);
            option4 = Double.valueOf(arg7);
            cometParameters.setFragmentBinOffset((Double)option4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.COMET_OUTPUT.id)) {
            arg7 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.COMET_OUTPUT.id);
            if (arg7.equalsIgnoreCase(CometParameters.CometOutputFormat.PepXML.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.PepXML);
            } else if (arg7.equalsIgnoreCase(CometParameters.CometOutputFormat.Percolator.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.Percolator);
            } else if (arg7.equalsIgnoreCase(CometParameters.CometOutputFormat.SQT.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.SQT);
            } else if (arg7.equalsIgnoreCase(CometParameters.CometOutputFormat.TXT.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.TXT);
            } else if (arg7.equalsIgnoreCase(CometParameters.CometOutputFormat.mzIdentML.toString())) {
                cometParameters.setSelectedOutputFormat(CometParameters.CometOutputFormat.mzIdentML);
            }
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.tide.getIndex()))) == null) {
            tideParameters = new TideParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, tideParameters);
        } else {
            tideParameters = (TideParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS.id)) {
            String arg72 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS.id);
            Integer option42 = Integer.valueOf(arg72);
            tideParameters.setMaxVariableModificationsPerPeptide(option42);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PTMS_PER_TYPE.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMaxVariableModificationsPerTypePerPeptide((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PEP_LENGTH.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMinPeptideLength((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PEP_LENGTH.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMaxPeptideLength((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_PREC_MASS.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMinPrecursorMass((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PREC_MASS.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMaxPrecursorMass((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_FORMAT.id);
            tideParameters.setDecoyFormat(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_KEEP_TERM_AA.id);
            tideParameters.setKeepTerminalAminoAcids(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DECOY_SEED.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setDecoySeed((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_OUTPUT_FOLDER.id);
            tideParameters.setOutputFolderName(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PRINT_PEPTIDES.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setPrintPeptides((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_VERBOSITY.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_VERBOSITY.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setVerbosity((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MONOISOTOPIC.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMonoisotopicPrecursor((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CLIP_N_TERM.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setClipNtermMethionine((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_DIGESTION_TYPE.id);
            tideParameters.setDigestionType(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_SP.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setComputeSpScore((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_PSMS.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setNumberOfSpectrumMatches((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_COMPUTE_P.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setComputeExactPValues((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_MZ.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMinSpectrumMz((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MAX_SPECTRUM_MZ.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMaxSpectrumMz((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MIN_SPECTRUM_PEAKS.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMinSpectrumPeaks((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_SPECTRUM_CHARGES.id);
            tideParameters.setSpectrumCharges(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setRemovePrecursor((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_PREC_TOL.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setRemovePrecursorTolerance((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_PROGRESS_INDICATOR.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setPrintProgressIndicatorSize((Integer)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_FLANKING.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setUseFlankingPeaks((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_USE_NEUTRAL_LOSSES.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setUseNeutralLossPeaks((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_WIDTH.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMzBinWidth((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_MZ_BIN_OFFSET.id);
            option3 = Double.valueOf(arg6);
            tideParameters.setMzBinOffset((Double)option3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_CONCAT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_CONCAT.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setConcatenatTargetDecoy((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_STORE_SPECTRA.id);
            tideParameters.setStoreSpectraFileName(arg6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_TEXT.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setTextOutput((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_SQT.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setSqtOutput((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PEPXML.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setPepXmlOutput((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_MZID.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setMzidOutput((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_EXPORT_PIN.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setPinOutput((Integer)option3 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id)) {
            arg6 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.TIDE_REMOVE_TEMP.id);
            option3 = Integer.valueOf(arg6);
            tideParameters.setRemoveTempFolders((Integer)option3 == 1);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.andromeda.getIndex()))) == null) {
            andromedaParameters = new AndromedaParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, andromedaParameters);
        } else {
            andromedaParameters = (AndromedaParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id)) {
            String arg62 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEPTIDE_MASS.id);
            Double option32 = Double.valueOf(arg62);
            andromedaParameters.setMaxPeptideMass(option32);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_COMBINATIONS.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setMaxCombinations(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_TOP_PEAKS_WINDOW.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setTopPeaksWindow(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_WATER.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setIncludeWater(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_INCL_AMMONIA.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setIncludeAmmonia(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_NEUTRAL_LOSSES.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setDependentLosses(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAGMENT_ALL.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setFragmentAll(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EMP_CORRECTION.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setEmpiricalCorrection(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_HIGHER_CHARGE.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setHigherCharge(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_FRAG_METHOD.id);
            if (arg5.equalsIgnoreCase("CID")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.CID);
            } else if (arg5.equalsIgnoreCase("HCD")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.HCD);
            } else if (arg5.equalsIgnoreCase("ETD")) {
                andromedaParameters.setFragmentationMethod(FragmentationMethod.ETD);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_MODS.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setMaxNumberOfModifications(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MIN_PEP_LENGTH.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setMinPeptideLengthNoEnzyme(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PEP_LENGTH.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setMaxPeptideLengthNoEnzyme(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_EQUAL_IL.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setEqualIL(option2 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_MAX_PSMS.id);
            option2 = Integer.valueOf(arg5);
            andromedaParameters.setNumberOfCandidates(option2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id)) {
            arg5 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANDROMEDA_DECOY_MODE.id);
            if (arg5.equalsIgnoreCase("none")) {
                andromedaParameters.setDecoyMode(AndromedaParameters.AndromedaDecoyMode.none);
            } else if (arg5.equalsIgnoreCase("reverse")) {
                andromedaParameters.setDecoyMode(AndromedaParameters.AndromedaDecoyMode.reverse);
            }
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.metaMorpheus.getIndex()))) == null) {
            metaMorpheusParameters = new MetaMorpheusParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, metaMorpheusParameters);
        } else {
            metaMorpheusParameters = (MetaMorpheusParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_PEP_LENGTH.id)) {
            String arg52 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_PEP_LENGTH.id);
            Integer option22 = Integer.valueOf(arg52);
            metaMorpheusParameters.setMinPeptideLength(option22);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_PEP_LENGTH.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_PEP_LENGTH.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMaxPeptideLength((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TYPE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TYPE.id);
            for (MetaMorpheusParameters.MetaMorpheusSearchType metaMorpheusSearchType : MetaMorpheusParameters.MetaMorpheusSearchType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusSearchType.toString())) continue;
                metaMorpheusParameters.setSearchType(metaMorpheusSearchType);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PARTITIONS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PARTITIONS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setTotalPartitions((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DISSOCIATION_TYPE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DISSOCIATION_TYPE.id);
            for (MetaMorpheusParameters.MetaMorpheusSearchType metaMorpheusSearchType : MetaMorpheusParameters.MetaMorpheusDissociationType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusSearchType.toString())) continue;
                metaMorpheusParameters.setDissociationType((MetaMorpheusParameters.MetaMorpheusDissociationType)((Object)metaMorpheusSearchType));
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MODS_FOR_PEPTIDE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MODS_FOR_PEPTIDE.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMaxModsForPeptide((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_INITIATOR_METHIONINE_BEHAVIOR.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_INITIATOR_METHIONINE_BEHAVIOR.id);
            for (MetaMorpheusParameters.MetaMorpheusSearchType metaMorpheusSearchType : MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusSearchType.toString())) continue;
                metaMorpheusParameters.setInitiatorMethionineBehavior((MetaMorpheusParameters.MetaMorpheusInitiatorMethionineBehaviorType)((Object)metaMorpheusSearchType));
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SCORE_CUTOFF.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SCORE_CUTOFF.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setScoreCutoff((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_USE_DELTA_SCORE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_USE_DELTA_SCORE.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setUseDeltaScore((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_FRAGMENTATION_TERMINUS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_FRAGMENTATION_TERMINUS.id);
            for (MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType metaMorpheusFragmentationTerminusType : MetaMorpheusParameters.MetaMorpheusFragmentationTerminusType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusFragmentationTerminusType.toString())) continue;
                metaMorpheusParameters.setFragmentationTerminus(metaMorpheusFragmentationTerminusType);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_FRAGMENTATION_SIZE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_FRAGMENTATION_SIZE.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setMaxFragmentSize((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INTERNAL_FRAGMENT_LENGTH.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMinAllowedInternalFragmentLength((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MASS_DIFF_ACCEPTOR_TYPE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MASS_DIFF_ACCEPTOR_TYPE.id);
            for (MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType metaMorpheusMassDiffAcceptorType : MetaMorpheusParameters.MetaMorpheusMassDiffAcceptorType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusMassDiffAcceptorType.toString())) continue;
                metaMorpheusParameters.setMassDiffAcceptorType(metaMorpheusMassDiffAcceptorType);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_MZID.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_MZID.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setWriteMzId((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_PEPXML.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WRITE_PEPXML.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setWritePepXml((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_USE_PROVIDED_PRECURSOR.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setUseProvidedPrecursorInfo((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DO_PREC_DECONVOLUTION.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DO_PREC_DECONVOLUTION.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setDoPrecursorDeconvolution((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_INT_RATIO.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_INT_RATIO.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setDeconvolutionIntensityRatio((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setDeconvolutionMassTolerance((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL_TYPE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECONVOLUTION_MASS_TOL_TYPE.id);
            for (MetaMorpheusParameters.MetaMorpheusToleranceType metaMorpheusToleranceType : MetaMorpheusParameters.MetaMorpheusToleranceType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusToleranceType.toString())) continue;
                metaMorpheusParameters.setDeconvolutionMassToleranceType(metaMorpheusToleranceType);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MS1_PEAKS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MS1_PEAKS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setTrimMs1Peaks((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MSMS_PEAKS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_TRIM_MSMS_PEAKS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setTrimMsMsPeaks((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PEAKS_PER_WINDOWS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_PEAKS_PER_WINDOWS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setNumberOfPeaksToKeepPerWindow((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_ALLOWED_INT_RATIO_TO_BASE_PEAK.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setMinAllowedIntensityRatioToBasePeak((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_WINDOW_WITH_THOMPSON.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_WINDOW_WITH_THOMPSON.id);
            option = Double.valueOf(arg4);
            metaMorpheusParameters.setWindowWidthThomsons((Double)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NUM_WINDOWS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NUM_WINDOWS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setNumberOfWindows((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NORMALIZE_PEAKS_ACROSS_ALL_WINDOWS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setNormalizePeaksAcrossAllWindows((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MOD_PEPTIDES_ARE_DIFFERENT.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MOD_PEPTIDES_ARE_DIFFERENT.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setModPeptidesAreDifferent((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_NO_ONE_HIT_WONDERS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_NO_ONE_HIT_WONDERS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setNoOneHitWonders((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TARGET.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_SEARCH_TARGET.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setSearchTarget((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_DECOY_TYPE.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_DECOY_TYPE.id);
            for (MetaMorpheusParameters.MetaMorpheusDecoyType metaMorpheusDecoyType : MetaMorpheusParameters.MetaMorpheusDecoyType.values()) {
                if (!arg4.equalsIgnoreCase(metaMorpheusDecoyType.toString())) continue;
                metaMorpheusParameters.setDecoyType(metaMorpheusDecoyType);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MOD_ISOFORMS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_MOD_ISOFORMS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMaxModificationIsoforms((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MIN_VARIANT_DEPTH.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MIN_VARIANT_DEPTH.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMinVariantDepth((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_MAX_HETROZYGOUS_VARIANTS.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_MAX_HETROZYGOUS_VARIANTS.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setMaxHeterozygousVariants((Integer)option);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_GPTM.id)) {
            arg4 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_GPTM.id);
            option = Integer.valueOf(arg4);
            metaMorpheusParameters.setRunGptm((Integer)option == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.META_MORPHEUS_GPTM_CATEGORIES.id)) {
            String combinedArgs = this.commandLine.getOptionValue(IdentificationParametersCLIParams.META_MORPHEUS_GPTM_CATEGORIES.id);
            ArrayList<ModificationCategory> gPtmModCategories = new ArrayList<ModificationCategory>();
            for (String arg77 : CommandLineUtils.splitInput(combinedArgs)) {
                for (ModificationCategory category : ModificationCategory.values()) {
                    if (!arg77.equalsIgnoreCase(category.toString()) || gPtmModCategories.contains((Object)category)) continue;
                    gPtmModCategories.add(category);
                }
            }
            metaMorpheusParameters.setGPtmCategories(gPtmModCategories);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.pepnovo.getIndex()))) == null) {
            pepnovoParameters = new PepnovoParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, pepnovoParameters);
        } else {
            pepnovoParameters = (PepnovoParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id)) {
            String arg42 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_HITLIST_LENGTH.id);
            Integer option37 = Integer.valueOf(arg42);
            pepnovoParameters.setHitListLength(option37);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_ESTIMATE_CHARGE.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_ESTIMATE_CHARGE.id);
            Integer option38 = Integer.valueOf(arg3);
            pepnovoParameters.setEstimateCharge(option38 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_CORRECT_PREC_MASS.id);
            Integer option39 = Integer.valueOf(arg3);
            pepnovoParameters.setCorrectPrecursorMass(option39 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            Integer option40 = Integer.valueOf(arg3);
            pepnovoParameters.setDiscardLowQualitySpectra(option40 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_DISCARD_SPECTRA.id);
            Integer option41 = Integer.valueOf(arg3);
            pepnovoParameters.setDiscardLowQualitySpectra(option41 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_FRAGMENTATION_MODEL.id);
            pepnovoParameters.setFragmentationModel(arg3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id)) {
            arg3 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPNOVO_GENERATE_BLAST.id);
            Integer option42 = Integer.valueOf(arg3);
            pepnovoParameters.setGenerateQuery(option42 == 1);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.direcTag.getIndex()))) == null) {
            direcTagParameters = new DirecTagParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, direcTagParameters);
        } else {
            direcTagParameters = (DirecTagParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id)) {
            String arg78 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TIC_CUTOFF_PERCENTAGE.id);
            Integer option43 = Integer.valueOf(arg78);
            direcTagParameters.setTicCutoffPercentage(option43.intValue());
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id)) {
            String arg79 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PEAK_COUNT.id);
            Integer option44 = Integer.valueOf(arg79);
            direcTagParameters.setMaxPeakCount(option44);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id)) {
            String arg80 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_INTENSITY_CLASSES.id);
            Integer option45 = Integer.valueOf(arg80);
            direcTagParameters.setNumIntensityClasses(option45);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id)) {
            String arg81 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ADJUST_PRECURSOR_MASS.id);
            Integer option46 = Integer.valueOf(arg81);
            direcTagParameters.setAdjustPrecursorMass(option46 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECURSOR_ADJUSTMENT.id)) {
            String arg82 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MIN_PRECURSOR_ADJUSTMENT.id);
            Double option47 = Double.valueOf(arg82);
            direcTagParameters.setMinPrecursorAdjustment(option47);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECURSOR_ADJUSTMENT.id)) {
            String arg83 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_PRECURSOR_ADJUSTMENT.id);
            Double option48 = Double.valueOf(arg83);
            direcTagParameters.setMaxPrecursorAdjustment(option48);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_PRECURSOR_ADJUSTMENT_STEP.id)) {
            String arg84 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_PRECURSOR_ADJUSTMENT_STEP.id);
            Double option49 = Double.valueOf(arg84);
            direcTagParameters.setPrecursorAdjustmentStep(option49);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id)) {
            String arg85 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_NUM_CHARGE_STATES.id);
            Integer option50 = Integer.valueOf(arg85);
            direcTagParameters.setNumChargeStates(option50);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id)) {
            String arg86 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_OUTPUT_SUFFIX.id);
            direcTagParameters.setOutputSuffix(arg86);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id)) {
            String arg87 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_USE_CHARGE_STATE_FROM_MS.id);
            Integer option51 = Integer.valueOf(arg87);
            direcTagParameters.setUseChargeStateFromMS(option51 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id)) {
            String arg88 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DUPLICATE_SPECTRA.id);
            Integer option52 = Integer.valueOf(arg88);
            direcTagParameters.setDuplicateSpectra(option52 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id)) {
            String arg89 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_DEISOTOPING_MODE.id);
            Integer option53 = Integer.valueOf(arg89);
            direcTagParameters.setDeisotopingMode(option53);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id)) {
            String arg90 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_ISOTOPE_MZ_TOLERANCE.id);
            Double option54 = Double.valueOf(arg90);
            direcTagParameters.setIsotopeMzTolerance(option54);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id)) {
            String arg91 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_MZ_TOLERANCE.id);
            Double option55 = Double.valueOf(arg91);
            direcTagParameters.setComplementMzTolerance(option55);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id)) {
            String arg92 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_TAG_LENGTH.id);
            Integer option56 = Integer.valueOf(arg92);
            direcTagParameters.setTagLength(option56);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id)) {
            String arg93 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_DYNAMIC_MODS.id);
            Integer option57 = Integer.valueOf(arg93);
            direcTagParameters.setMaxDynamicMods(option57);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id)) {
            String arg94 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MAX_TAG_COUNT.id);
            Integer option58 = Integer.valueOf(arg94);
            direcTagParameters.setMaxTagCount(option58);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id)) {
            String arg95 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_INTENSITY_SCORE_WEIGHT.id);
            Double option59 = Double.valueOf(arg95);
            direcTagParameters.setIntensityScoreWeight(option59);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id)) {
            String arg96 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_MZ_FIDELITY_SCORE_WEIGHT.id);
            Double option60 = Double.valueOf(arg96);
            direcTagParameters.setMzFidelityScoreWeight(option60);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id)) {
            String arg97 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.DIRECTAG_COMPLEMENT_SCORE_WEIGHT.id);
            Double option61 = Double.valueOf(arg97);
            direcTagParameters.setComplementScoreWeight(option61);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.pNovo.getIndex()))) == null) {
            pNovoParameters = new PNovoParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, pNovoParameters);
        } else {
            pNovoParameters = (PNovoParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id)) {
            String arg98 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_NUMBER_OF_PEPTIDES.id);
            Integer n = Integer.valueOf(arg98);
            pNovoParameters.setNumberOfPeptides(n);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id)) {
            String arg99 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_LOWER_PRECURSOR_MASS.id);
            Integer n = Integer.valueOf(arg99);
            pNovoParameters.setLowerPrecursorMass(n);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id)) {
            String arg100 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_UPPER_PRECURSOR_MASS.id);
            Integer n = Integer.valueOf(arg100);
            pNovoParameters.setUpperPrecursorMass(n);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id)) {
            String arg101 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PNOVO_ACTIVATION_TYPE.id);
            pNovoParameters.setActicationType(arg101);
        }
        if ((identificationAlgorithmParameter = searchParameters.getIdentificationAlgorithmParameter(algorithmIndex = Integer.valueOf(Advocate.novor.getIndex()))) == null) {
            novorParameters = new NovorParameters();
            searchParameters.setIdentificationAlgorithmParameter(algorithmIndex, novorParameters);
        } else {
            novorParameters = (NovorParameters)identificationAlgorithmParameter;
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id)) {
            String string = this.commandLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_FRAGMENTATION.id);
            novorParameters.setFragmentationMethod(string);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id)) {
            String string = this.commandLine.getOptionValue(IdentificationParametersCLIParams.NOVOR_MASS_ANALYZER.id);
            novorParameters.setMassAnalyzer(string);
        }
        Object var19_189 = null;
        if (this.identificationParameters != null) {
            GeneParameters geneParameters = this.identificationParameters.getGeneParameters();
        }
        if (var19_191 == null) {
            GeneParameters geneParameters = new GeneParameters();
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.USE_GENE_MAPPING.id)) {
            boolean value4;
            String arg102 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.USE_GENE_MAPPING.id);
            Integer intValue2 = Integer.valueOf(arg102);
            switch (intValue2) {
                case 1: {
                    boolean value42 = true;
                    break;
                }
                case 0: {
                    value4 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.USE_GENE_MAPPING.id + ": " + arg102 + ". 0 or 1 expected.");
                }
            }
            var19_193.setUseGeneMapping(value4);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id)) {
            boolean value5;
            String arg103 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id);
            Integer intValue3 = Integer.valueOf(arg103);
            switch (intValue3) {
                case 1: {
                    boolean value52 = true;
                    break;
                }
                case 0: {
                    value5 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.UPDATE_GENE_MAPPING.id + ": " + arg103 + ". 0 or 1 expected.");
                }
            }
            var19_193.setAutoUpdate(value5);
        }
        if (this.identificationParameters != null) {
            this.identificationParameters.setSearchParameters(searchParameters);
        } else {
            this.identificationParameters = new IdentificationParameters();
            this.identificationParameters.setGeneParameters((GeneParameters)var19_193);
            this.identificationParameters.setParametersFromSearch(searchParameters);
        }
        if (this.identificationParameters.getName() == null && this.destinationFile != null) {
            this.identificationParameters.setName(this.destinationFile.getName().substring(0, this.destinationFile.getName().lastIndexOf(".")));
        }
        if ((annotationSettings = this.identificationParameters.getAnnotationParameters()) == null) {
            annotationSettings = new AnnotationParameters(searchParameters);
            this.identificationParameters.setAnnotationParameters(annotationSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id)) {
            String arg104 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL.id);
            Double value6 = Double.valueOf(arg104);
            annotationSettings.setIntensityLimit(value6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_LEVEL_TYPE.id)) {
            String arg105 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_LEVEL_TYPE.id);
            AnnotationParameters.IntensityThresholdType value7 = AnnotationParameters.IntensityThresholdType.valueOf(arg105);
            annotationSettings.setIntensityThresholdType(value7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id)) {
            String arg106 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_MZ_TOLERANCE.id);
            Double value8 = Double.valueOf(arg106);
            annotationSettings.setFragmentIonAccuracy(value8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id)) {
            boolean value6;
            String arg107 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id);
            Integer intValue4 = Integer.valueOf(arg107);
            switch (intValue4) {
                case 1: {
                    boolean value9 = true;
                    break;
                }
                case 0: {
                    value6 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.ANNOTATION_HIGH_RESOLUTION.id + ": " + arg107 + ". 0 or 1 expected.");
                }
            }
            SpectrumAnnotator.TiesResolution tiesResolution = value6 ? SpectrumAnnotator.TiesResolution.mostAccurateMz : SpectrumAnnotator.TiesResolution.mostIntense;
            annotationSettings.setTiesResolution(tiesResolution);
        }
        if ((sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingParameters()) == null) {
            sequenceMatchingPreferences = new SequenceMatchingParameters();
            this.identificationParameters.setSequenceMatchingParameters(sequenceMatchingPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id)) {
            String arg108 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_TYPE.id);
            Integer intValue5 = Integer.valueOf(arg108);
            SequenceMatchingParameters.MatchingType value32 = SequenceMatchingParameters.MatchingType.getMatchingType(intValue5);
            sequenceMatchingPreferences.setSequenceMatchingType(value32);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id)) {
            String arg109 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_X.id);
            Double value10 = Double.valueOf(arg109);
            sequenceMatchingPreferences.setLimitX(value10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_ENZYMATIC_TAGS.id)) {
            String arg110 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_ENZYMATIC_TAGS.id);
            Integer option62 = Integer.valueOf(arg110);
            sequenceMatchingPreferences.setEnzymaticTagsOnly(option62 == 1);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MAX_PTMS_PER_TAG.id)) {
            String arg111 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MAX_PTMS_PER_TAG.id);
            Integer intValue6 = Integer.valueOf(arg111);
            sequenceMatchingPreferences.setMaxPtmsPerTagPeptide(intValue6);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_AMINO_ACID_SCORE.id)) {
            String arg112 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_AMINO_ACID_SCORE.id);
            Integer intValue7 = Integer.valueOf(arg112);
            sequenceMatchingPreferences.setMinAminoAcidScore(intValue7);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_TAG_LENGTH.id)) {
            String arg113 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SEQUENCE_MATCHING_MIN_TAG_LENGTH.id);
            Integer intValue8 = Integer.valueOf(arg113);
            sequenceMatchingPreferences.setMinTagLength(intValue8);
        }
        PeptideAssumptionFilter peptideAssumptionFilter = this.identificationParameters.getPeptideAssumptionFilter();
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id)) {
            String arg114 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MIN.id);
            value3 = Integer.valueOf(arg114);
            peptideAssumptionFilter.setMinPepLength((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id)) {
            String arg115 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PEPTIDE_LENGTH_MAX.id);
            value3 = Integer.valueOf(arg115);
            peptideAssumptionFilter.setMaxPepLength((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MIN.id)) {
            String arg116 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MIN.id);
            value3 = Integer.valueOf(arg116);
            peptideAssumptionFilter.setMinMissedCleavages((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_MC_MAX.id)) {
            String arg117 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_MC_MAX.id);
            value3 = Integer.valueOf(arg117);
            peptideAssumptionFilter.setMaxMissedCleavages((Integer)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id)) {
            String arg118 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ.id);
            value3 = Double.valueOf(arg118);
            peptideAssumptionFilter.setMaxMzDeviation((Double)value3);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id)) {
            String arg119 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id);
            Integer option63 = Integer.valueOf(arg119);
            switch (option63) {
                case 1: {
                    peptideAssumptionFilter.setIsPpm(true);
                    break;
                }
                case 0: {
                    peptideAssumptionFilter.setIsPpm(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.IMPORT_PRECURSOR_MZ_PPM.id + ": " + arg119 + ". 0 or 1 expected.");
                }
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id)) {
            boolean value7;
            String arg120 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id);
            Integer intValue9 = Integer.valueOf(arg120);
            switch (intValue9) {
                case 1: {
                    boolean value11 = true;
                    break;
                }
                case 0: {
                    value7 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.EXCLUDE_UNKNOWN_PTMs.id + ": " + arg120 + ". 0 or 1 expected.");
                }
            }
            peptideAssumptionFilter.setRemoveUnknownModifications(value7);
        }
        if ((ptmScoringPreferences = this.identificationParameters.getModificationLocalizationParameters()) == null) {
            ptmScoringPreferences = new ModificationLocalizationParameters();
            this.identificationParameters.setModificationLocalizationParameters(ptmScoringPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_SCORE.id)) {
            String arg22 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_SCORE.id);
            Integer intValue10 = Integer.valueOf(arg22);
            ModificationLocalizationScore ptmScore = ModificationLocalizationScore.getScore(intValue10);
            if (ptmScore == ModificationLocalizationScore.None) {
                ptmScoringPreferences.setProbabilisticScoreCalculation(false);
            } else {
                ptmScoringPreferences.setProbabilisticScoreCalculation(true);
                ptmScoringPreferences.setSelectedProbabilisticScore(ptmScore);
            }
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_THRESHOLD.id)) {
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_THRESHOLD.id);
            Double value12 = Double.valueOf(arg2);
            ptmScoringPreferences.setProbabilisticScoreThreshold(value12);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id)) {
            boolean value8;
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id);
            Integer intValue11 = Integer.valueOf(arg2);
            switch (intValue11) {
                case 1: {
                    boolean value13 = true;
                    break;
                }
                case 0: {
                    value8 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SCORE_NEUTRAL_LOSSES.id + ": " + arg2 + ". 0 or 1 expected.");
                }
            }
            ptmScoringPreferences.setProbabilisticScoreNeutralLosses(value8);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id)) {
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_SEQUENCE_MATCHING_TYPE.id);
            Integer intValue12 = Integer.valueOf(arg2);
            SequenceMatchingParameters.MatchingType value14 = SequenceMatchingParameters.MatchingType.getMatchingType(intValue12);
            SequenceMatchingParameters ptmSequenceMatchingPreferences = new SequenceMatchingParameters();
            ptmSequenceMatchingPreferences.setLimitX(sequenceMatchingPreferences.getLimitX());
            ptmSequenceMatchingPreferences.setSequenceMatchingType(value14);
            ptmScoringPreferences.setSequenceMatchingParameters(ptmSequenceMatchingPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PTM_ALIGNMENT.id)) {
            boolean value9;
            arg2 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PTM_ALIGNMENT.id);
            Integer intValue13 = Integer.valueOf(arg2);
            switch (intValue13) {
                case 1: {
                    boolean value15 = true;
                    break;
                }
                case 0: {
                    value9 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.PTM_ALIGNMENT.id + ": " + arg2 + ". 0 or 1 expected.");
                }
            }
            ptmScoringPreferences.setAlignNonConfidentModifications(value9);
        }
        ProteinInferenceParameters proteinInferencePreferences = this.identificationParameters.getProteinInferenceParameters();
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id)) {
            boolean value10;
            String arg121 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id);
            Integer intValue14 = Integer.valueOf(arg121);
            switch (intValue14) {
                case 1: {
                    boolean value16 = true;
                    break;
                }
                case 0: {
                    value10 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS.id + ": " + arg121 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroups(value10);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id)) {
            boolean value11;
            String arg122 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id);
            Integer intValue15 = Integer.valueOf(arg122);
            switch (intValue15) {
                case 1: {
                    boolean value17 = true;
                    break;
                }
                case 0: {
                    value11 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_VARIANT.id + ": " + arg122 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsVariants(value11);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id)) {
            boolean value12;
            String arg123 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id);
            Integer intValue16 = Integer.valueOf(arg123);
            switch (intValue16) {
                case 1: {
                    boolean value18 = true;
                    break;
                }
                case 0: {
                    value12 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_ENZYMATICITY.id + ": " + arg123 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsEnzymaticity(value12);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id)) {
            boolean value13;
            String arg124 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id);
            Integer intValue17 = Integer.valueOf(arg124);
            switch (intValue17) {
                case 1: {
                    boolean value19 = true;
                    break;
                }
                case 0: {
                    value13 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_EVIDENCE.id + ": " + arg124 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsEvidence(value13);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id)) {
            boolean value14;
            String arg125 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id);
            Integer intValue18 = Integer.valueOf(arg125);
            switch (intValue18) {
                case 1: {
                    boolean value20 = true;
                    break;
                }
                case 0: {
                    value14 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE.id + ": " + arg125 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setSimplifyGroupsConfidence(value14);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE_THRESHOLD.id)) {
            String arg126 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.SIMPLIFY_GOUPS_CONFIDENCE_THRESHOLD.id);
            double value21 = Double.parseDouble(arg126);
            proteinInferencePreferences.setConfidenceThreshold(value21);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id)) {
            boolean value15;
            String arg127 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id);
            Integer intValue19 = Integer.valueOf(arg127);
            switch (intValue19) {
                case 1: {
                    boolean value22 = true;
                    break;
                }
                case 0: {
                    value15 = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.PROTEIN_INFERENCE_MODIFICATIONS.id + ": " + arg127 + ". 0 or 1 expected.");
                }
            }
            proteinInferencePreferences.setModificationRefinement(value15);
        }
        if ((idMatchValidationPreferences = this.identificationParameters.getIdValidationParameters()) == null) {
            idMatchValidationPreferences = new IdMatchValidationParameters();
            this.identificationParameters.setIdValidationParameters(idMatchValidationPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PSM_FDR.id)) {
            String arg128 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PSM_FDR.id);
            Double value22 = Double.valueOf(arg128);
            idMatchValidationPreferences.setDefaultPsmFDR(value22);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PEPTIDE_FDR.id)) {
            String arg129 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PEPTIDE_FDR.id);
            value2 = Double.valueOf(arg129);
            idMatchValidationPreferences.setDefaultPeptideFDR(value2);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FDR.id)) {
            String arg130 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FDR.id);
            value2 = Double.valueOf(arg130);
            idMatchValidationPreferences.setDefaultProteinFDR(value2);
        }
        if ((fractionSettings = this.identificationParameters.getFractionParameters()) == null) {
            fractionSettings = new FractionParameters();
            this.identificationParameters.setFractionParameters(fractionSettings);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id)) {
            String arg131 = this.commandLine.getOptionValue(IdentificationParametersCLIParams.PROTEIN_FRACTION_MW_CONFIDENCE.id);
            Double value23 = Double.valueOf(arg131);
            fractionSettings.setProteinConfidenceMwPlots(value23);
        }
        if ((fastaPreferences = this.identificationParameters.getFastaParameters()) == null) {
            fastaPreferences = new FastaParameters();
            this.identificationParameters.setFastaParameters(fastaPreferences);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id);
            intValue = Integer.valueOf(arg);
            switch (intValue) {
                case 1: {
                    value = true;
                    break;
                }
                case 0: {
                    value = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.FASTA_TARGET_DECOY.id + ": " + arg + ". 0 or 1 expected.");
                }
            }
            fastaPreferences.setTargetDecoy(value);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_TAG.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_TAG.id);
            fastaPreferences.setDecoyFlag(arg);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id);
            intValue = Integer.valueOf(arg);
            switch (intValue) {
                case 1: {
                    value = true;
                    break;
                }
                case 0: {
                    value = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect value for parameter " + IdentificationParametersCLIParams.FASTA_DECOY_SUFFIX.id + ": " + arg + ". 0 or 1 expected.");
                }
            }
            fastaPreferences.setDecoySuffix(value);
        }
        if (this.commandLine.hasOption(IdentificationParametersCLIParams.FASTA_DECOY_FILE_TAG.id)) {
            arg = this.commandLine.getOptionValue(IdentificationParametersCLIParams.FASTA_DECOY_FILE_TAG.id);
            fastaPreferences.setTargetDecoyFileNameSuffix(arg);
        }
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParameters;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public Boolean isListMods() {
        return this.listMods;
    }

    public Boolean isListEnzymes() {
        return this.listEnzymes;
    }

    public static boolean isValidModifications(CommandLine aLine) throws IOException {
        Modification ptm;
        ArrayList<String> args;
        String arg;
        boolean error = false;
        if (aLine.hasOption(IdentificationParametersCLIParams.FIXED_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.FIXED_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = ModificationFactory.getInstance().getModification(ptmName);
                    if (ptm != null) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (IllegalArgumentException e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the fixed modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                error = true;
            }
        }
        if (aLine.hasOption(IdentificationParametersCLIParams.VARIABLE_MODS.id)) {
            arg = aLine.getOptionValue(IdentificationParametersCLIParams.VARIABLE_MODS.id);
            try {
                args = CommandLineUtils.splitInput(arg);
                for (String ptmName : args) {
                    ptm = ModificationFactory.getInstance().getModification(ptmName);
                    if (ptm != null) continue;
                    throw new IllegalArgumentException("PTM " + ptmName + " not found.");
                }
            }
            catch (IllegalArgumentException e) {
                if (!error) {
                    System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the variable modifications:" + System.getProperty("line.separator") + e.getLocalizedMessage() + System.getProperty("line.separator"));
                }
                error = true;
            }
        }
        return !error;
    }
}

