/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.peptide_mapper;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;

public class MappingWorker
implements Runnable {
    WaitingHandlerCLIImpl waitingHandlerCLIImpl = null;
    FastaMapper peptideMapper = null;
    SequenceMatchingParameters sequenceMatchingPreferences = null;
    BufferedReader br = null;
    PrintWriter writer = null;
    int NUM_READS = 1000;
    boolean flanking = false;
    boolean peptideMapping = false;
    public Exception exception = null;

    public MappingWorker(WaitingHandlerCLIImpl waitingHandlerCLIImpl, FastaMapper peptideMapper, IdentificationParameters identificationParameters, BufferedReader br, PrintWriter writer, boolean peptideMapping) {
        this.waitingHandlerCLIImpl = waitingHandlerCLIImpl;
        this.peptideMapper = peptideMapper;
        this.sequenceMatchingPreferences = identificationParameters.getSequenceMatchingParameters();
        this.br = br;
        this.writer = writer;
        this.flanking = identificationParameters.getSearchParameters().getFlanking();
        this.peptideMapping = peptideMapping;
    }

    public String flanking(PeptideProteinMapping peptideProteinMapping, FastaMapper peptideMapper) {
        String peptide = peptideProteinMapping.getPeptideSequence();
        String accession = peptideProteinMapping.getProteinAccession();
        int peptideLength = peptide.length();
        char prefixChar = ((FMIndex)peptideMapper).prefixCharacter(accession, peptideProteinMapping.fmIndexPosition);
        peptide = prefixChar != FMIndex.DELIMITER ? Character.toString(prefixChar) + "." + peptide : "-" + peptide;
        char suffixChar = ((FMIndex)peptideMapper).suffixCharacter(accession, peptideProteinMapping.fmIndexPosition, peptideLength + 1);
        peptide = suffixChar != FMIndex.DELIMITER ? peptide + "." + Character.toString(suffixChar) : peptide + "-";
        return peptide;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block27: {
            rows = new ArrayList<String>();
            outputData = new HashSet<String>();
            block10: while (true) {
                block26: {
                    rows.clear();
                    outputData.clear();
                    try {
                        row = "";
                        i = 0;
                        while (!this.waitingHandlerCLIImpl.isRunCanceled() && i++ < this.NUM_READS && (row = this.br.readLine()) != null) {
                            rows.add(row);
                        }
                        if (!this.waitingHandlerCLIImpl.isRunCanceled() && !rows.isEmpty()) break block26;
                        break block27;
                    }
                    catch (Exception e) {
                        this.waitingHandlerCLIImpl.setRunCanceled();
                        this.exception = new IOException("Error: cound not open input list.\n\n" + e);
                        return;
                    }
                }
                if (this.peptideMapping) {
                    for (String inputPeptide : rows) {
                        if (!this.waitingHandlerCLIImpl.isRunCanceled()) {
                            for (char c : inputPeptide.toCharArray()) {
                                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') continue;
                                this.waitingHandlerCLIImpl.setRunCanceled();
                                this.exception = new RuntimeException("Error: invalid character in line '" + inputPeptide + "' -> '" + c + "'.");
                                return;
                            }
                            try {
                                var5_10 = this.peptideMapper.getProteinMapping(inputPeptide.toUpperCase(), this.sequenceMatchingPreferences).iterator();
                                while (var5_10.hasNext()) {
                                    peptideProteinMapping = (PeptideProteinMapping)var5_10.next();
                                    peptide = peptideProteinMapping.getPeptideSequence();
                                    accession = peptideProteinMapping.getProteinAccession();
                                    startIndex = peptideProteinMapping.getIndex() + 1;
                                    if (this.flanking) {
                                        peptide = this.flanking(peptideProteinMapping, this.peptideMapper);
                                    }
                                    outputData.add(peptide + "," + accession + "," + startIndex);
                                }
                                this.waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                            }
                            catch (Exception e) {
                                this.exception = new RuntimeException("An error occurred during the mapping of '" + inputPeptide + "'\n\n" + e);
                                this.waitingHandlerCLIImpl.setRunCanceled();
                            }
                            continue;
                        }
                        break;
                    }
                } else {
                    for (String tagString : rows) {
                        if (!this.waitingHandlerCLIImpl.isRunCanceled()) {
                            tag = new Tag();
                            for (String part : tagString.split(",")) {
                                if (Pattern.matches("[a-zA-Z]+", part)) {
                                    tag.addAminoAcidSequence(new AminoAcidSequence(part));
                                    continue;
                                }
                                try {
                                    mass = Double.parseDouble(part);
                                    tag.addMassGap(mass);
                                }
                                catch (NumberFormatException e) {
                                    this.waitingHandlerCLIImpl.setRunCanceled();
                                    this.exception = new RuntimeException("Error: line contains no valid tag: '" + tagString + "'.\n\n" + e);
                                    return;
                                }
                            }
                            try {
                                for (PeptideProteinMapping peptideProteinMapping : this.peptideMapper.getProteinMapping(tag, this.sequenceMatchingPreferences)) {
                                    peptide = peptideProteinMapping.getPeptideSequence();
                                    accession = peptideProteinMapping.getProteinAccession();
                                    startIndex = peptideProteinMapping.getIndex() + 1;
                                    if (this.flanking) {
                                        peptide = this.flanking(peptideProteinMapping, this.peptideMapper);
                                    }
                                    outputData.add(peptide + "," + accession + "," + startIndex + "," + PeptideUtils.getVariableModificationsAsString(peptideProteinMapping.getVariableModifications()));
                                }
                                this.waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                            }
                            catch (Exception e) {
                                this.exception = new RuntimeException("An error occurred during the mapping of '" + tagString + "'\n\n" + e);
                                this.waitingHandlerCLIImpl.setRunCanceled();
                            }
                            continue;
                        }
                        break;
                    }
                }
                e = outputData.iterator();
                while (true) {
                    if (!e.hasNext()) continue block10;
                    output = (String)e.next();
                    if (!this.waitingHandlerCLIImpl.isRunCanceled()) ** break;
                    continue block10;
                    this.writer.println(output);
                }
                break;
            }
            catch (Exception e) {
                this.exception = new IOException("Error: could not write into file.\n\n" + e);
                this.waitingHandlerCLIImpl.setRunCanceled();
                return;
            }
        }
    }
}

