/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.software.autoupdater.DownloadLatestZipFromRepo;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.xml.stream.XMLStreamException;

public class PeptideShakerSetupDialog
extends JDialog {
    private UtilitiesUserParameters utilitiesUserParameters;
    private String lastSelectedFolder = "";
    private boolean dialogCanceled = true;
    private JFrame parentFrame = null;
    private JDialog parentDialog = null;
    private ProgressDialogX progressDialog;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton peptideShakerButton;
    private JLabel peptideShakerDownloadLinkLabel;
    private JPanel peptideShakerDownloadPanel;
    private JLabel peptideShakerInfoLabel;
    private JPanel peptideShakerInstallationPanel;
    private JLabel peptideShakerJarFileHelpLabel;
    private JTextField peptideShakernstallationJTextField;

    public PeptideShakerSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.parentFrame = parent;
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    public PeptideShakerSetupDialog(JDialog parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.parentDialog = parent;
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    private void setUpGUI() {
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (this.utilitiesUserParameters.getPeptideShakerPath() == null) {
            boolean downloaded = this.downloadPeptideShaker();
            if (downloaded) {
                this.dialogCanceled = false;
            } else {
                if (this.utilitiesUserParameters != null) {
                    this.peptideShakernstallationJTextField.setText(this.utilitiesUserParameters.getPeptideShakerPath());
                    this.lastSelectedFolder = this.utilitiesUserParameters.getPeptideShakerPath();
                }
                this.setVisible(true);
            }
        } else {
            if (this.utilitiesUserParameters != null) {
                this.peptideShakernstallationJTextField.setText(this.utilitiesUserParameters.getPeptideShakerPath());
                this.lastSelectedFolder = this.utilitiesUserParameters.getPeptideShakerPath();
            }
            this.setVisible(true);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.peptideShakerInstallationPanel = new JPanel();
        this.peptideShakernstallationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.peptideShakerJarFileHelpLabel = new JLabel();
        this.peptideShakerDownloadPanel = new JPanel();
        this.peptideShakerInfoLabel = new JLabel();
        this.peptideShakerDownloadLinkLabel = new JLabel();
        this.peptideShakerButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(0);
        this.setTitle("PeptideShaker Settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PeptideShakerSetupDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.peptideShakerInstallationPanel.setBorder(BorderFactory.createTitledBorder("PeptideShaker Installation"));
        this.peptideShakerInstallationPanel.setOpaque(false);
        this.peptideShakernstallationJTextField.setEditable(false);
        this.peptideShakernstallationJTextField.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.peptideShakerJarFileHelpLabel.setFont(this.peptideShakerJarFileHelpLabel.getFont().deriveFont(this.peptideShakerJarFileHelpLabel.getFont().getStyle() | 2));
        this.peptideShakerJarFileHelpLabel.setText("Please locate the folder containing the PeptideShaker jar file.");
        GroupLayout peptideShakerInstallationPanelLayout = new GroupLayout(this.peptideShakerInstallationPanel);
        this.peptideShakerInstallationPanel.setLayout(peptideShakerInstallationPanelLayout);
        peptideShakerInstallationPanelLayout.setHorizontalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerInstallationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.peptideShakerJarFileHelpLabel)).addComponent(this.peptideShakernstallationJTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        peptideShakerInstallationPanelLayout.setVerticalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideShakernstallationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerJarFileHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.peptideShakerDownloadPanel.setBorder(BorderFactory.createTitledBorder("Download PeptideShaker"));
        this.peptideShakerDownloadPanel.setOpaque(false);
        this.peptideShakerInfoLabel.setFont(this.peptideShakerInfoLabel.getFont().deriveFont(this.peptideShakerInfoLabel.getFont().getStyle() | 1));
        this.peptideShakerInfoLabel.setText("PeptideShaker - interpretation of proteomics identifications from multiple search engines");
        this.peptideShakerDownloadLinkLabel.setText("<html>Download here: <a href>https://compomics.github.io/projects/peptide-shaker.html</a></html>");
        this.peptideShakerDownloadLinkLabel.setToolTipText("Go to https://compomics.github.io/projects/peptide-shaker.html");
        this.peptideShakerDownloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseExited(evt);
            }
        });
        this.peptideShakerButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png")));
        this.peptideShakerButton.setToolTipText("Go to http://compomics.github.io/projects/peptide-shaker.html");
        this.peptideShakerButton.setBorderPainted(false);
        this.peptideShakerButton.setContentAreaFilled(false);
        this.peptideShakerButton.setFocusPainted(false);
        this.peptideShakerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseExited(evt);
            }
        });
        GroupLayout peptideShakerDownloadPanelLayout = new GroupLayout(this.peptideShakerDownloadPanel);
        this.peptideShakerDownloadPanel.setLayout(peptideShakerDownloadPanelLayout);
        peptideShakerDownloadPanelLayout.setHorizontalGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addComponent(this.peptideShakerInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, peptideShakerDownloadPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.peptideShakerDownloadLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.peptideShakerButton).addContainerGap()));
        peptideShakerDownloadPanelLayout.setVerticalGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.peptideShakerInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideShakerDownloadLinkLabel, -2, -1, -2)).addComponent(this.peptideShakerButton));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideShakerDownloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.peptideShakerInstallationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideShakerInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerDownloadPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".jar", "PeptideShaker jar file (.jar)", "Select PeptideShaker Jar File", this.lastSelectedFolder, null, true);
        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else if (!selectedFile.getName().contains("PeptideShaker")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a PeptideShaker jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.peptideShakernstallationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserParameters.setPeptideShakerPath(this.peptideShakernstallationJTextField.getText());
        try {
            UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
            this.dialogCanceled = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void peptideShakerDownloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerDownloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerDownloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openPeptideShakerWebPage();
    }

    private void peptideShakerButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerButtonMouseClicked(MouseEvent evt) {
        this.openPeptideShakerWebPage();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void openPeptideShakerWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/peptide-shaker.html");
        this.setCursor(new Cursor(0));
    }

    public boolean isDialogCanceled() {
        return this.dialogCanceled;
    }

    public boolean downloadPeptideShaker() {
        int option = JOptionPane.showConfirmDialog(this, "Cannot find PeptideShaker. Do you want to download it now? (Select 'No' if already downloaded.)", "Download PeptideShaker?", 0);
        if (option == 0) {
            File downloadFolder;
            String installPath = "user.home";
            if (this.utilitiesUserParameters.getPeptideShakerPath() != null && new File(this.utilitiesUserParameters.getPeptideShakerPath()).getParentFile() != null && new File(this.utilitiesUserParameters.getPeptideShakerPath()).getParentFile().getParentFile() != null) {
                installPath = new File(this.utilitiesUserParameters.getPeptideShakerPath()).getParentFile().getParent();
            }
            if ((downloadFolder = FileChooserUtil.getUserSelectedFolder(this, "Select PeptideShaker Folder", installPath, "PeptideShaker Folder", "Select", false)) != null) {
                this.progressDialog = this.parentFrame != null ? new ProgressDialogX((Frame)this.parentFrame, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true) : (this.parentDialog != null ? new ProgressDialogX(this.parentDialog, (JFrame)this.parentDialog.getParent(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true) : new ProgressDialogX((Frame)new JFrame(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
                this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                this.progressDialog.setTitle("Downloading PeptideShaker. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PeptideShakerSetupDialog.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                Thread thread = new Thread("DownloadThread"){

                    @Override
                    public void run() {
                        try {
                            URL jarRepository = new URL("http", "genesis.ugent.be", "/maven2/");
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(downloadFolder, "PeptideShaker", "eu.isas.peptideshaker", "PeptideShaker", "peptide-shaker.ico", null, jarRepository, false, true, new GUIFileDAO(), PeptideShakerSetupDialog.this.progressDialog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                    }
                };
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.progressDialog.isRunCanceled()) {
                    this.progressDialog.setRunFinished();
                    return false;
                }
                if (!this.progressDialog.isRunFinished()) {
                    this.progressDialog.setRunFinished();
                }
                return true;
            }
        }
        return false;
    }
}

