/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ProteoWizardSetupDialog
extends JDialog {
    private UtilitiesUserParameters utilitiesUserParameters;
    private String lastSelectedFolder = "";
    private boolean dialogCanceled = true;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel downloadLinkLabel;
    private JPanel downloadPanel;
    private JLabel folderHelpLabel;
    private JButton iconButton;
    private JLabel infoLabel;
    private JTextField installationJTextField;
    private JPanel installationPanel;
    private JLabel jLabel2;
    private JButton okButton;

    public ProteoWizardSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    public ProteoWizardSetupDialog(JDialog parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    private void setUpGUI() {
        int option;
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        if (this.utilitiesUserParameters.getProteoWizardPath() == null && (option = JOptionPane.showConfirmDialog(this, "ProteoWizard is required to convert raw files. Do you want to download it now? (Select 'No' if already downloaded.)", "Download ProteoWizard?", 0)) == 0) {
            this.openWebPage();
        }
        if (this.utilitiesUserParameters != null) {
            this.installationJTextField.setText(this.utilitiesUserParameters.getProteoWizardPath());
            this.lastSelectedFolder = this.utilitiesUserParameters.getProteoWizardPath();
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.installationPanel = new JPanel();
        this.installationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.folderHelpLabel = new JLabel();
        this.downloadPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.downloadLinkLabel = new JLabel();
        this.iconButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(0);
        this.setTitle("ProteoWizard Settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProteoWizardSetupDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.installationPanel.setBorder(BorderFactory.createTitledBorder("ProteoWizard Installation"));
        this.installationPanel.setOpaque(false);
        this.installationJTextField.setEditable(false);
        this.installationJTextField.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteoWizardSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.folderHelpLabel.setFont(this.folderHelpLabel.getFont().deriveFont(this.folderHelpLabel.getFont().getStyle() | 2));
        this.folderHelpLabel.setText("Please locate the ProteoWizard folder, for example: C:\\Program Files\\ProteoWizard\\ProteoWizard 3.0.7665.");
        GroupLayout installationPanelLayout = new GroupLayout(this.installationPanel);
        this.installationPanel.setLayout(installationPanelLayout);
        installationPanelLayout.setHorizontalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationJTextField, -1, 619, Short.MAX_VALUE).addGroup(installationPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.folderHelpLabel).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        installationPanelLayout.setVerticalGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installationPanelLayout.createSequentialGroup().addContainerGap().addGroup(installationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.downloadPanel.setBorder(BorderFactory.createTitledBorder("Download ProteoWizard"));
        this.downloadPanel.setOpaque(false);
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(this.infoLabel.getFont().getStyle() | 1));
        this.infoLabel.setText("ProteoWizard - open-source and cross-platform proteomics data analysis");
        this.downloadLinkLabel.setText("<html>Download here: <a href> http://proteowizard.sourceforge.net</a></html>");
        this.downloadLinkLabel.setToolTipText("Go to http://proteowizard.sourceforge.net");
        this.downloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProteoWizardSetupDialog.this.downloadLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteoWizardSetupDialog.this.downloadLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteoWizardSetupDialog.this.downloadLinkLabelMouseExited(evt);
            }
        });
        this.iconButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/pwiz_purple_logo.png")));
        this.iconButton.setToolTipText("Go to http://proteowizard.sourceforge.net");
        this.iconButton.setBorderPainted(false);
        this.iconButton.setContentAreaFilled(false);
        this.iconButton.setFocusPainted(false);
        this.iconButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProteoWizardSetupDialog.this.iconButtonMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteoWizardSetupDialog.this.iconButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteoWizardSetupDialog.this.iconButtonMouseExited(evt);
            }
        });
        GroupLayout downloadPanelLayout = new GroupLayout(this.downloadPanel);
        this.downloadPanel.setLayout(downloadPanelLayout);
        downloadPanelLayout.setHorizontalGroup(downloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(downloadPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel).addComponent(this.downloadLinkLabel, -2, -1, -2)).addGap(0, 168, Short.MAX_VALUE).addComponent(this.iconButton).addContainerGap()));
        downloadPanelLayout.setVerticalGroup(downloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downloadPanelLayout.createSequentialGroup().addComponent(this.iconButton).addGap(4, 4, 4)).addGroup(GroupLayout.Alignment.TRAILING, downloadPanelLayout.createSequentialGroup().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadLinkLabel, -2, -1, -2).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteoWizardSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteoWizardSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.installationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.installationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFolder(this, "ProteoWizard Installation Folder", this.lastSelectedFolder, "ProteoWizard installation folder", "OK", true);
        if (selectedFile != null) {
            if (!new File(selectedFile, "msconvert.exe").exists() && !new File(selectedFile, "msconvert").exists()) {
                JOptionPane.showMessageDialog(this, "The selected folder is not a valid ProteoWizard folder!", "Wrong Folder Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.installationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserParameters.setProteoWizardPath(this.installationJTextField.getText());
        try {
            UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
            this.dialogCanceled = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void downloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void downloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void downloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openWebPage();
    }

    private void iconButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void iconButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void iconButtonMouseClicked(MouseEvent evt) {
        this.openWebPage();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void openWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://proteowizard.sourceforge.net");
        this.setCursor(new Cursor(0));
    }

    public boolean isDialogCanceled() {
        return this.dialogCanceled;
    }
}

