/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JTable;

public class Util {
    public static final String[] FORBIDDEN_CHARACTERS = new String[]{"!", ":", ";", "\\?", "/", "\\\\", "\\*", "<", ">", "\"", "'", "\\|"};
    public static final String ENCODING = "UTF-8";
    public static final String DEFAULT_COLUMN_SEPARATOR = "\t";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final double MASS_PER_AA = 100.0;

    public static String removeSubString(String string, String subString) {
        String result;
        String[] split = string.split(subString);
        if (split.length > 1) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (String splitPart : split) {
                stringBuilder.append(splitPart);
            }
            result = stringBuilder.toString();
        } else {
            result = string;
        }
        return result;
    }

    public static boolean sendGAUpdate(String ua, String action, String label) {
        boolean returnVal = true;
        String collect_url = "https://www.google-analytics.com/collect";
        String post = "v=1&tid=" + ua + "&cid=35119a79-1a05-49d7-b876-bb88420f825b&uid=asuueffeqqss&t=event&ec=usage&ea=" + action + "&el=" + label;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(collect_url).openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(1000);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(post);
            connection.getResponseCode();
        }
        catch (IOException ex) {
            returnVal = false;
        }
        return returnVal;
    }

    public static String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = Util.class.getClassLoader().getResourceAsStream("compomics-utilities.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("compomics-utilities.version");
    }

    public static String removeCharacters(String string, char forbiddenCharacter) {
        StringBuilder sb = new StringBuilder(string.length());
        char[] stringChars = string.toCharArray();
        for (int i = 0; i < stringChars.length; ++i) {
            char charAtI = stringChars[i];
            if (charAtI == forbiddenCharacter) continue;
            sb.append(charAtI);
        }
        return sb.toString();
    }

    public static String removeCharacters(String string, String[] forbiddenCharacters) {
        String result = string;
        for (String fc : forbiddenCharacters) {
            String[] split = result.split(fc);
            if (split.length <= 1) continue;
            result = Arrays.stream(split).collect(Collectors.joining());
        }
        return result;
    }

    public static String removeForbiddenCharacters(String string) {
        return Util.removeCharacters(string, FORBIDDEN_CHARACTERS);
    }

    public static boolean containsForbiddenCharacter(String string) {
        for (String forbiddenCharacter : FORBIDDEN_CHARACTERS) {
            if (!string.contains(forbiddenCharacter)) continue;
            return true;
        }
        return false;
    }

    public static String replaceAll(String string, char a, char b) {
        char[] stringArray = string.toCharArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != a) continue;
            stringArray[i] = b;
        }
        return new String(stringArray);
    }

    public static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public static double floorDouble(double d, int places) {
        return new BigDecimal(String.valueOf(d)).setScale(places, RoundingMode.FLOOR).doubleValue();
    }

    public static double getPpmError(double theoreticalMzValue, double massError) {
        double ppmValue = massError / theoreticalMzValue * 1000000.0;
        return ppmValue;
    }

    public static String color2Hex(int colorRGB) {
        return Integer.toHexString(colorRGB & 0xFFFFFF);
    }

    public static String color2Hex(Color color) {
        return Util.color2Hex(color.getRGB());
    }

    public static Color getColor(int colorRGB) {
        return new Color(colorRGB >> 16 & 0xFF, colorRGB >> 8 & 0xFF, colorRGB & 0xFF);
    }

    public static String tableToText(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml) {
        StringBuilder tableAsString = new StringBuilder();
        for (int i = 0; i < table.getColumnCount() && !progressDialog.isRunCanceled(); ++i) {
            tableAsString.append(table.getColumnName(i)).append(separator);
        }
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        String lineBreak = System.getProperty("line.separator");
        tableAsString.append(lineBreak);
        for (int i = 0; i < table.getRowCount() && !progressDialog.isRunCanceled(); ++i) {
            progressDialog.increasePrimaryProgressCounter();
            for (int j = 0; j < table.getColumnCount() && !progressDialog.isRunCanceled(); ++j) {
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.contains("<html>") && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    tableAsString.append(tempValue).append(separator);
                    continue;
                }
                tableAsString.append(separator);
            }
            tableAsString.append(lineBreak);
        }
        return tableAsString.toString();
    }

    public static void tableToFile(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml, BufferedWriter writer) throws IOException {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            writer.write(table.getColumnName(i) + separator);
        }
        if (progressDialog != null) {
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        }
        String lineBreak = System.getProperty("line.separator");
        writer.write(lineBreak);
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (progressDialog != null) {
                if (progressDialog.isRunCanceled()) {
                    return;
                }
                progressDialog.increasePrimaryProgressCounter();
            }
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (progressDialog != null && progressDialog.isRunCanceled()) {
                    return;
                }
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.contains("<html>") && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    writer.write(tempValue + separator);
                    continue;
                }
                writer.write(separator);
            }
            writer.write(lineBreak);
        }
    }

    public static boolean sameLists(ArrayList<?> list1, ArrayList<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        HashMap list1Occurrence = list1.stream().collect(Collectors.groupingBy(a -> a, HashMap::new, Collectors.counting()));
        HashMap list2Occurrence = list2.stream().collect(Collectors.groupingBy(a -> a, HashMap::new, Collectors.counting()));
        return list1Occurrence.entrySet().stream().allMatch(entry -> list2Occurrence.containsKey(entry.getKey()) && ((Long)list2Occurrence.get(entry.getKey())).equals(entry.getValue()));
    }

    public static int getOccurrence(String input, char character) {
        return (int)input.chars().filter(aa -> aa == character).count();
    }

    public static ArrayList<Integer> getIndexes(String bigString, String smallString) {
        Pattern pattern = Pattern.compile(smallString);
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(bigString);
        matcher.matches();
        int index = 0;
        while (matcher.find(index)) {
            index = matcher.start();
            result.add(++index);
        }
        return result;
    }

    public static double readDoubleAsString(String doubleAsString) throws NumberFormatException {
        BigDecimal temp;
        try {
            temp = new BigDecimal(doubleAsString);
        }
        catch (NumberFormatException e) {
            doubleAsString = doubleAsString.replaceAll("\\.", "");
            doubleAsString = doubleAsString.replaceAll(",", "\\.");
            try {
                temp = new BigDecimal(doubleAsString);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(doubleAsString + " cannot be read as a floating value!");
            }
        }
        return temp.doubleValue();
    }

    public static int convertBooleanToInteger(Boolean booleanToConvert) {
        return booleanToConvert != false ? 1 : 0;
    }

    public static String keyValueToString(String key, String value) {
        StringBuilder sb = new StringBuilder(key.length() + value.length() + 2);
        sb.append(key).append("(").append(value).append(")");
        return sb.toString();
    }
}

