/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db.object;

import com.compomics.util.db.object.DbMutex;
import com.compomics.util.db.object.ObjectsDB;
import com.compomics.util.waiting.WaitingHandler;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectsCache {
    private double memoryShare = 0.75;
    private final ConcurrentHashMap<Long, ObjectsCacheElement> loadedObjects = new ConcurrentHashMap();
    private HashMap<Class, HashSet<Long>> classMap = new HashMap();
    private boolean readOnly = false;
    private ObjectsDB objectsDB = null;
    private final int keepObjectsThreshold = 10000;

    public ObjectsCache(ObjectsDB objectsDB) {
        this.objectsDB = objectsDB;
    }

    public int getCacheSize() {
        DbMutex.loadObjectMutex.acquire();
        int size = this.loadedObjects.size();
        DbMutex.loadObjectMutex.release();
        return size;
    }

    public double getMemoryShare() {
        return this.memoryShare;
    }

    public void setMemoryShare(double memoryShare) {
        this.memoryShare = memoryShare;
        try {
            this.updateCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getObject(long objectKey) {
        Object object = null;
        DbMutex.loadObjectMutex.acquire();
        if (this.loadedObjects.containsKey(objectKey)) {
            object = this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).object;
        }
        DbMutex.loadObjectMutex.release();
        return object;
    }

    public void removeObject(long objectKey) {
        if (!this.readOnly) {
            DbMutex.loadObjectMutex.acquire();
            boolean contains = this.loadedObjects.containsKey(objectKey);
            DbMutex.loadObjectMutex.release();
            if (contains) {
                Object object = this.getObject(objectKey);
                DbMutex.loadObjectMutex.acquire();
                this.classMap.get(object.getClass()).remove(objectKey);
                this.loadedObjects.remove(objectKey);
                DbMutex.loadObjectMutex.release();
            }
        }
    }

    public void addObject(long objectKey, Object object) {
        this.addObject(objectKey, object, false, false);
    }

    public void addObject(long objectKey, Object object, boolean inDB, boolean edited) {
        if (!this.readOnly) {
            DbMutex.loadObjectMutex.acquire();
            if (!this.loadedObjects.containsKey(objectKey)) {
                this.loadedObjects.put(objectKey, new ObjectsCacheElement(object, inDB, edited));
            } else {
                this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).object = object;
                this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).inDB = inDB;
                this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).edited = edited;
            }
            if (!this.classMap.containsKey(object.getClass())) {
                this.classMap.put(object.getClass(), new HashSet());
            }
            this.classMap.get(object.getClass()).add(objectKey);
            DbMutex.loadObjectMutex.release();
            this.updateCache();
        }
    }

    public void addObjects(HashMap<Long, Object> objects) {
        this.addObjects(objects, false, false);
    }

    public void addObjects(HashMap<Long, Object> objects, boolean inDB, boolean edited) {
        if (!this.readOnly) {
            DbMutex.loadObjectMutex.acquire();
            for (Map.Entry<Long, Object> kv : objects.entrySet()) {
                long objectKey = kv.getKey();
                Object object = kv.getValue();
                if (!this.loadedObjects.containsKey(objectKey)) {
                    this.loadedObjects.put(objectKey, new ObjectsCacheElement(object, inDB, edited));
                } else {
                    this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).object = object;
                    this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).inDB = inDB;
                    this.loadedObjects.get((Object)Long.valueOf((long)objectKey)).edited = edited;
                }
                if (!this.classMap.containsKey(object.getClass())) {
                    this.classMap.put(object.getClass(), new HashSet());
                }
                this.classMap.get(object.getClass()).add(objectKey);
            }
            DbMutex.loadObjectMutex.release();
            this.updateCache();
        }
    }

    private boolean memoryCheck() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() < (long)(this.memoryShare * (double)Runtime.getRuntime().maxMemory());
    }

    public void saveObjects(int numLastEntries) {
        this.saveObjects(numLastEntries, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObjects(int numLastEntries, WaitingHandler waitingHandler, boolean clearEntries) {
        if (!this.readOnly) {
            Connection connection = this.objectsDB.getDB();
            try {
                PreparedStatement psInsert = connection.prepareStatement("INSERT INTO data (id, class, data) VALUES (?, ?, ?);");
                PreparedStatement psUpdate = connection.prepareStatement("UPDATE data SET data = ? WHERE id = ?;");
                DbMutex.loadObjectMutex.acquire();
                HashSet<Long> keysInBackend = this.objectsDB.getKeysInBackend();
                HashSet<Long> removeKeys = new HashSet<Long>();
                Kryo kryo = this.objectsDB.kryo;
                int i = 0;
                for (Map.Entry<Long, ObjectsCacheElement> entry : this.loadedObjects.entrySet()) {
                    if (numLastEntries <= i++) break;
                    if (waitingHandler != null) {
                        waitingHandler.increaseSecondaryProgressCounter();
                        if (waitingHandler.isRunCanceled()) break;
                    }
                    long key = entry.getKey();
                    ObjectsCacheElement obj = this.loadedObjects.get(key);
                    obj.edited = false;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Output output = new Output((OutputStream)baos);
                    kryo.writeObject(output, obj.object);
                    output.close();
                    byte[] barray = baos.toByteArray();
                    baos.close();
                    if (obj.inDB) {
                        psUpdate.setBytes(1, barray);
                        psUpdate.setLong(2, key);
                        psUpdate.addBatch();
                    } else {
                        psInsert.setLong(1, key);
                        psInsert.setString(2, obj.object.getClass().getName());
                        psInsert.setBytes(3, barray);
                        psInsert.addBatch();
                        keysInBackend.add(key);
                    }
                    obj.inDB = true;
                    if (!clearEntries) continue;
                    removeKeys.add(key);
                    this.classMap.get(obj.object.getClass()).remove(key);
                }
                psInsert.executeBatch();
                psUpdate.executeBatch();
                if (removeKeys.size() > 0) {
                    ((ConcurrentHashMap.KeySetView)this.loadedObjects.keySet()).removeAll(removeKeys);
                }
                connection.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DbMutex.loadObjectMutex.release();
            }
        }
    }

    private void updateCache() {
        int cacheSize = this.getCacheSize();
        while (cacheSize > 10000 && !this.memoryCheck()) {
            int toRemove = cacheSize >> 2;
            this.saveObjects(toRemove, null, true);
            cacheSize = this.getCacheSize();
        }
    }

    public boolean inCache(long longKey) {
        DbMutex.loadObjectMutex.acquire();
        boolean contains = this.loadedObjects.containsKey(longKey);
        DbMutex.loadObjectMutex.release();
        return contains;
    }

    public void saveCache(WaitingHandler waitingHandler, boolean emptyCache) {
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.loadedObjects.size() + 1);
        }
        int cacheSize = this.getCacheSize();
        this.saveObjects(cacheSize, waitingHandler, emptyCache);
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
    }

    public boolean isEmpty() {
        DbMutex.loadObjectMutex.acquire();
        boolean isEmpty = this.loadedObjects.isEmpty();
        DbMutex.loadObjectMutex.release();
        return isEmpty;
    }

    public void clearCache() {
        DbMutex.loadObjectMutex.acquire();
        this.loadedObjects.clear();
        DbMutex.loadObjectMutex.release();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public HashSet<Long> getClassInCache(Class className) {
        return this.classMap.get(className);
    }

    public class ObjectsCacheElement {
        public Object object;
        public boolean inDB;
        public boolean edited;

        public ObjectsCacheElement(Object object) {
            this(object, false, true);
        }

        public ObjectsCacheElement(Object object, boolean inDB, boolean edited) {
            this.object = object;
            this.inDB = inDB;
            this.edited = edited;
        }
    }
}

