/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db.object;

import com.compomics.util.db.object.DbMutex;
import com.compomics.util.db.object.ObjectsCache;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ObjectsDB {
    private String dbName;
    private String path;
    private ObjectsCache objectsCache;
    private static boolean debugInteractions = false;
    private Connection connection = null;
    public Kryo kryo;
    private static boolean connectionActive = false;
    private int currentAdded = 0;
    private HashSet<Long> keysInBackend = new HashSet();

    public ObjectsDB() {
    }

    public ObjectsDB(String folder, String dbName) {
        this(folder, dbName, false);
    }

    public ObjectsDB(String path, String dbName, boolean overwrite) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Creating database");
        }
        this.kryo = new Kryo();
        this.kryo.setRegistrationRequired(false);
        this.path = path;
        this.dbName = dbName;
        File dbFolder = this.getDbFolder();
        if (!dbFolder.exists() && !dbFolder.mkdirs()) {
            throw new IllegalArgumentException("Cannot create database folder!");
        }
        File dbFile = this.getDbFile();
        if (dbFile.exists() && overwrite) {
            dbFile.delete();
        }
        this.establishConnection();
        this.objectsCache = new ObjectsCache(this);
    }

    public void commit() {
        try {
            DbMutex.dbMutex.acquire();
            this.connection.commit();
        }
        catch (Exception exception) {
        }
        finally {
            DbMutex.dbMutex.release();
        }
    }

    public int getCurrentAdded() {
        return this.currentAdded;
    }

    public File getDbFile() {
        return new File(this.path, this.dbName);
    }

    public File getDbFolder() {
        return new File(this.path);
    }

    public Connection getDB() {
        return this.connection;
    }

    public String getName() {
        return this.dbName;
    }

    public ObjectsCache getObjectsCache() {
        return this.objectsCache;
    }

    public void setObjectCache(ObjectsCache objectCache) {
        this.objectsCache = objectCache;
    }

    public void insertObject(long objectKey, Object object) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Inserting single object " + object.getClass().getName() + ", key: " + objectKey);
        }
        if (object == null) {
            throw new IllegalArgumentException("error: null insertion: " + objectKey);
        }
        ((ExperimentObject)object).setId(objectKey);
        this.objectsCache.addObject(objectKey, object, false, true);
    }

    public HashSet<Long> getClassObjectIDs(Class className) {
        return this.getClassObjectIDs(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Long> getClassObjectIDs(Class className, String filters) {
        HashSet<Long> cacheIDs = this.objectsCache.getClassInCache(className);
        HashSet<Long> classObjectIds = cacheIDs != null ? new HashSet<Long>(cacheIDs) : new HashSet();
        String sqlQuery = "SELECT id FROM data WHERE class = ?";
        if (filters != null) {
            sqlQuery = sqlQuery + " AND " + filters;
        }
        sqlQuery = sqlQuery + ";";
        try {
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement(sqlQuery);
            pstmt.setString(1, className.getName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                classObjectIds.add(rs.getLong("id"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
        return classObjectIds;
    }

    public void insertObjects(HashMap<Long, Object> objects, WaitingHandler waitingHandler, boolean displayProgress) {
        for (Map.Entry<Long, Object> entry : objects.entrySet()) {
            long objectKey = entry.getKey();
            Object object = entry.getValue();
            if (object == null) {
                throw new IllegalArgumentException("error: null insertion: " + objectKey);
            }
            if (debugInteractions) {
                System.out.println(System.currentTimeMillis() + " Inserting single object, table: " + object.getClass().getName() + ", key: " + objectKey);
            }
            ((ExperimentObject)object).setId(objectKey);
        }
        this.currentAdded += objects.size();
        this.objectsCache.addObjects(objects, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadFromDB(long objectKey) {
        Object object = null;
        try {
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement("SELECT class, data FROM data WHERE id = ?;");
            pstmt.setLong(1, objectKey);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ByteArrayInputStream bis = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)rs.getBinaryStream("data")));
                Input input = new Input((InputStream)bis);
                Class<?> c = Class.forName(rs.getString("class"));
                object = this.kryo.readObject(input, c);
                input.close();
                bis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
        return object;
    }

    public void loadObjects(Collection<Long> keys, WaitingHandler waitingHandler, boolean displayProgress) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " loading " + keys.size() + " objects");
        }
        HashMap<Long, Object> objectsNotInCache = new HashMap<Long, Object>();
        for (long objectKey : keys) {
            Object obj;
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            if (this.objectsCache.inCache(objectKey) || (obj = this.loadFromDB(objectKey)) == null) continue;
            objectsNotInCache.put(objectKey, obj);
        }
        this.objectsCache.addObjects(objectsNotInCache, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObjects(Class className, WaitingHandler waitingHandler, boolean displayProgress) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " loading all " + className.getName() + " objects");
        }
        HashMap<Long, Object> objectsNotInCache = new HashMap<Long, Object>();
        try {
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement("SELECT * FROM data WHERE class = ?;");
            pstmt.setString(1, className.getName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    return;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)rs.getBinaryStream("data")));
                Input input = new Input((InputStream)bis);
                Object object = this.kryo.readObject(input, Class.forName(rs.getString("class")));
                input.close();
                bis.close();
                long objectKey = rs.getLong("id");
                objectsNotInCache.put(objectKey, object);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
        this.objectsCache.addObjects(objectsNotInCache, true, false);
    }

    public Object retrieveObject(long objectKey) {
        Object obj;
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " | retrieving one object with key: " + objectKey);
        }
        if ((obj = this.objectsCache.getObject(objectKey)) == null && (obj = this.loadFromDB(objectKey)) != null) {
            this.objectsCache.addObject(objectKey, obj, true, false);
        }
        return obj;
    }

    public int getNumber(Class className) {
        return this.getClassObjectIDs(className).size();
    }

    public void dumpToDB() {
        DbMutex.dbMutex.acquire();
        this.objectsCache.saveCache(null, false);
        DbMutex.dbMutex.release();
    }

    public ArrayList<Object> retrieveObjects(Collection<Long> keys, WaitingHandler waitingHandler, boolean displayProgress) {
        ArrayList<Object> retrievingObjects = new ArrayList<Object>(keys.size());
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " retrieving " + keys.size() + " objects");
        }
        HashMap<Long, Object> objectsNotInCache = new HashMap<Long, Object>();
        for (long objectKey : keys) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return retrievingObjects;
            }
            Object obj = this.objectsCache.getObject(objectKey);
            if (obj == null && (obj = this.loadFromDB(objectKey)) != null) {
                objectsNotInCache.put(objectKey, obj);
            }
            retrievingObjects.add(obj);
        }
        this.objectsCache.addObjects(objectsNotInCache, true, false);
        return retrievingObjects;
    }

    public void updateObject(long objectKey, Object object) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " | retrieving one object with key: " + objectKey);
        }
        this.objectsCache.addObject(objectKey, object, this.inBackend(objectKey), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> retrieveObjects(Class className, WaitingHandler waitingHandler, boolean displayProgress) {
        ArrayList<Object> retrievingObjects = new ArrayList<Object>();
        HashMap<Long, Object> objectsNotInCache = new HashMap<Long, Object>();
        HashSet<Long> objectInCache = this.objectsCache.getClassInCache(className);
        objectInCache.forEach(key -> retrievingObjects.add(this.objectsCache.getObject((long)key)));
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " retrieving all " + className + " objects");
        }
        try {
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement("SELECT * FROM data WHERE class = ?;");
            pstmt.setString(1, className.getName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    ArrayList<Object> arrayList = retrievingObjects;
                    return arrayList;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)rs.getBinaryStream("data")));
                Input input = new Input((InputStream)bis);
                Object object = this.kryo.readObject(input, Class.forName(rs.getString("class")));
                input.close();
                bis.close();
                long objectKey = rs.getLong("id");
                if (!objectInCache.contains(objectKey)) {
                    objectsNotInCache.put(objectKey, object);
                }
                retrievingObjects.add(object);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
        this.objectsCache.addObjects(objectsNotInCache, true, false);
        return retrievingObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjects(Collection<Long> keys, WaitingHandler waitingHandler, boolean displayProgress) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " removing " + keys.size() + " objects");
        }
        try {
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM data WHERE id = ?;");
            for (long key : keys) {
                if (waitingHandler.isRunCanceled()) {
                    break;
                }
                this.objectsCache.removeObject(key);
                pstmt.setLong(1, key);
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(long key) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " removing object: " + key);
        }
        try {
            this.objectsCache.removeObject(key);
            DbMutex.dbMutex.acquire();
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM data WHERE id = ?;");
            pstmt.setLong(1, key);
            pstmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
    }

    public boolean inCache(long objectKey) {
        return this.objectsCache.inCache(objectKey);
    }

    public boolean inDB(long objectKey) {
        if (debugInteractions) {
            System.out.println(System.currentTimeMillis() + " Checking db content,  key: " + objectKey);
        }
        if (this.objectsCache.inCache(objectKey)) {
            return true;
        }
        return this.inBackend(objectKey);
    }

    public boolean inBackend(long objectKey) {
        return this.keysInBackend.contains(objectKey);
    }

    public HashSet<Long> getKeysInBackend() {
        return this.keysInBackend;
    }

    public static boolean isConnectionActive() {
        return connectionActive;
    }

    public void lock(WaitingHandler waitingHandler) {
        DbMutex.dbMutex.acquire();
        if (debugInteractions) {
            System.out.println("locking database");
        }
        connectionActive = false;
        this.objectsCache.saveCache(waitingHandler, true);
        DbMutex.dbMutex.release();
    }

    public void unlock() {
        DbMutex.dbMutex.acquire();
        if (debugInteractions) {
            System.out.println("unlocking database");
        }
        connectionActive = true;
        DbMutex.dbMutex.release();
    }

    public void close(boolean saveCache) {
        try {
            DbMutex.dbMutex.acquire();
            if (debugInteractions) {
                System.out.println("closing database");
            }
            if (saveCache) {
                this.objectsCache.saveCache(null, true);
            }
            this.objectsCache.clearCache();
            connectionActive = false;
            this.connection.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DbMutex.dbMutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishConnection() {
        block11: {
            File dbFile = this.getDbFile();
            if (debugInteractions) {
                System.out.println(System.currentTimeMillis() + " Establishing database: " + dbFile.getAbsolutePath());
            }
            try {
                DbMutex.dbMutex.acquire();
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
                this.connection.setAutoCommit(false);
                boolean insertTables = true;
                PreparedStatement pst = this.connection.prepareStatement("SELECT * FROM sqlite_master WHERE type = 'table'");
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    if (!rs.getString("name").equals("data")) continue;
                    insertTables = false;
                    break;
                }
                this.connection.commit();
                if (insertTables) {
                    String sql = "CREATE TABLE `data` (`id` INTEGER, `class` TEXT, `data` BLOB, PRIMARY KEY(id));";
                    Statement stmt = this.connection.createStatement();
                    stmt.execute(sql);
                    sql = "CREATE INDEX `data_id_index` ON `data` (`id` ASC);";
                    stmt.execute(sql);
                    sql = "CREATE INDEX `data_class_index` ON `data` (`class` ASC);";
                    stmt.execute(sql);
                    this.connection.commit();
                    break block11;
                }
                try {
                    PreparedStatement pstmt = this.connection.prepareStatement("SELECT id FROM data");
                    ResultSet rsId = pstmt.executeQuery();
                    if (rsId.next()) {
                        this.keysInBackend.add(rsId.getLong("id"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                DbMutex.dbMutex.release();
            }
        }
        connectionActive = true;
    }

    public String getPath() {
        return this.path;
    }

    public static void setDebugInteractions(boolean debug) {
        debugInteractions = debug;
    }
}

