/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids.impl;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.atoms.AtomImpl;

public class GlutamicAcid
extends AminoAcid {
    static final long serialVersionUID = 6850534412637609745L;

    public GlutamicAcid() {
        this.singleLetterCode = "E";
        this.threeLetterCode = "Glu";
        this.name = "Glutamic Acid";
        this.monoisotopicAtomChain = new AtomChain();
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.H, (Integer)0), 7);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
        this.monoisotopicAtomChain.append(new AtomImpl(Atom.O, (Integer)0), 3);
        this.subAminoAcidsWithoutCombination = new char[]{'E'};
        this.subAminoAcidsWithCombination = this.subAminoAcidsWithoutCombination;
        this.aminoAcidCombinations = new char[]{'Z', 'X'};
        this.standardGeneticCode = new String[]{"GAA", "GAG"};
    }

    @Override
    public boolean iscombination() {
        return false;
    }

    @Override
    public double getHydrophobicity() {
        return -1.5;
    }

    @Override
    public double getHelicity() {
        return 0.85;
    }

    @Override
    public double getBasicity() {
        return 215.6;
    }

    @Override
    public double getPI() {
        return 3.15;
    }

    @Override
    public double getPK1() {
        return 2.1;
    }

    @Override
    public double getPK2() {
        return 9.47;
    }

    @Override
    public double getPKa() {
        return 4.25;
    }

    @Override
    public int getVanDerWaalsVolume() {
        return 109;
    }
}

