/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ensembl.EnsemblVersion;
import com.compomics.util.experiment.biology.genes.ensembl.GeneMapping;
import com.compomics.util.experiment.biology.genes.go.GoMapping;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblGenomesSpecies;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ProteinGeneDetailsProvider {
    public static final String SEPARATOR = "\t";
    private static String GENE_MAPPING_FOLDER = System.getProperty("user.home") + "/.compomics/gene_mappings/";
    private static final String TOOL_GENE_MAPPING_SUBFOLDER = "resources/conf/gene_mappings/";
    private static final String ENSEMBL_VERSIONS = "ensembl_versions";
    private static final String GO_DOMAINS = "go_domains";
    public static final String GENE_MAPPING_FILE_SUFFIX = "_gene_mappings";
    public static final String GO_MAPPING_FILE_SUFFIX = "_go_mappings";
    private HashMap<String, String> ensemblVersionsMap;
    private final String PADDING = "    ";

    public void initialize(String jarFilePath) throws IOException {
        File ensemblVersionsFile = ProteinGeneDetailsProvider.getEnsemblVersionsFile();
        if (ensemblVersionsFile.exists()) {
            this.loadEnsemblSpeciesVersions(ensemblVersionsFile);
        } else {
            this.ensemblVersionsMap = new HashMap();
        }
        this.createDefaultGeneMappingFilesGeneric(jarFilePath, new File(jarFilePath, "resources/conf/gene_mappings/ensembl_versions"), new File(jarFilePath, "resources/conf/gene_mappings/go_domains"), true);
    }

    public GeneMaps getGeneMaps(GeneParameters genePreferences, FastaSummary fastaSummary, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, WaitingHandler waitingHandler) {
        Collection<String> accessions = sequenceProvider.getAccessions();
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        HashMap<String, GeneMapping> geneMappings = new HashMap<String, GeneMapping>(accessions.size());
        HashMap<String, GoMapping> goMappings = new HashMap<String, GoMapping>(accessions.size());
        for (String uniprotTaxonomy : fastaSummary.speciesOccurrence.keySet()) {
            if (uniprotTaxonomy.equals("Unknown")) continue;
            try {
                Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, true);
                if (taxon == null) continue;
                String speciesName = speciesFactory.getName(taxon);
                String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
                if (ensemblDatasetName != null) {
                    File geneMappingFile = ProteinGeneDetailsProvider.getGeneMappingFile(ensemblDatasetName);
                    File goMappingFile = ProteinGeneDetailsProvider.getGoMappingFile(ensemblDatasetName);
                    if (genePreferences.getAutoUpdate().booleanValue()) {
                        boolean success = true;
                        try {
                            if (!geneMappingFile.exists() || !goMappingFile.exists() || this.newVersionExists(taxon)) {
                                success = this.downloadMappings(waitingHandler, taxon);
                            }
                            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                                return null;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            success = false;
                        }
                        if (!success) {
                            waitingHandler.appendReport("    Update of gene information for species " + speciesName + " failed.", true, true);
                        }
                    }
                    if (geneMappingFile.exists()) {
                        GeneMapping geneMapping = new GeneMapping();
                        try {
                            geneMapping.importFromFile(geneMappingFile, waitingHandler);
                            geneMappings.put(speciesName, geneMapping);
                        }
                        catch (Exception e) {
                            waitingHandler.appendReport("    Import of gene mappings for " + speciesName + " failed.", true, true);
                        }
                    } else {
                        waitingHandler.appendReport("    Gene mapping for " + speciesName + " not available.", true, true);
                    }
                    if (goMappingFile.exists()) {
                        GoMapping goMapping = new GoMapping();
                        try {
                            goMapping.loadMappingsFromFile(goMappingFile, waitingHandler);
                            goMappings.put(speciesName, goMapping);
                        }
                        catch (Exception e) {
                            waitingHandler.appendReport("    Import of the GO mapping for " + speciesName + " failed.", true, true);
                        }
                        continue;
                    }
                    waitingHandler.appendReport("    GO mapping for " + speciesName + " not available.", true, true);
                    continue;
                }
                waitingHandler.appendReport("    " + speciesName + " not available in Ensembl.", true, true);
            }
            catch (Exception e) {
                waitingHandler.appendReport("    No taxonomy found for " + uniprotTaxonomy + ".", true, true);
            }
        }
        GeneMaps geneMaps = new GeneMaps();
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap(1);
        }
        HashMap<String, String> ensemblVersionsUsed = new HashMap<String, String>(this.ensemblVersionsMap);
        HashMap<String, String> geneNameToEnsemblIdMap = new HashMap<String, String>(accessions.size());
        HashMap<String, String> geneNameToChromosomeMap = new HashMap<String, String>(accessions.size());
        HashMap<String, HashSet<String>> proteinToGoMap = new HashMap<String, HashSet<String>>(accessions.size());
        HashMap<String, HashSet<String>> goToProteinMap = new HashMap<String, HashSet<String>>(accessions.size());
        HashMap<String, String> goNamesMap = new HashMap<String, String>(accessions.size());
        for (String accession : accessions) {
            String uniprotTaxonomy = proteinDetailsProvider.getTaxonomy(accession);
            if (uniprotTaxonomy == null || uniprotTaxonomy.equals("")) continue;
            try {
                HashSet<String> newTerms;
                GoMapping goMapping;
                GeneMapping geneMapping;
                Integer taxon = speciesFactory.getUniprotTaxonomy().getId(uniprotTaxonomy, false);
                if (taxon == null) continue;
                String speciesName = speciesFactory.getName(taxon);
                String geneName = proteinDetailsProvider.getGeneName(accession);
                if (geneName != null && (geneMapping = (GeneMapping)geneMappings.get(speciesName)) != null) {
                    String ensemblId;
                    String chromosome = geneMapping.getChromosome(geneName);
                    if (chromosome != null) {
                        geneNameToChromosomeMap.put(geneName, chromosome);
                    }
                    if ((ensemblId = geneMapping.getEnsemblAccession(geneName)) != null) {
                        geneNameToEnsemblIdMap.put(geneName, ensemblId);
                    }
                }
                if ((goMapping = (GoMapping)goMappings.get(speciesName)) == null) continue;
                HashSet<String> goTerms = proteinToGoMap.get(accession);
                if (goTerms == null) {
                    goTerms = new HashSet(1);
                    proteinToGoMap.put(accession, goTerms);
                }
                if ((newTerms = goMapping.getGoAccessions(accession)) == null) continue;
                goTerms.addAll(newTerms);
                for (String goTerm : newTerms) {
                    HashSet<String> proteins;
                    String goName = goMapping.getTermName(goTerm);
                    if (goName != null) {
                        goNamesMap.put(goTerm, goName);
                    }
                    if ((proteins = goToProteinMap.get(goTerm)) == null) {
                        proteins = new HashSet(1);
                        goToProteinMap.put(goTerm, proteins);
                    }
                    proteins.add(accession);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        geneMaps.setEnsemblVersionsMap(ensemblVersionsUsed);
        geneMaps.setGeneNameToEnsemblIdMap(geneNameToEnsemblIdMap);
        geneMaps.setGeneNameToChromosomeMap(geneNameToChromosomeMap);
        geneMaps.setProteinToGoMap(proteinToGoMap);
        geneMaps.setGoAccessionToProteinMap(goToProteinMap);
        geneMaps.setGoNamesMap(goNamesMap);
        return geneMaps;
    }

    public boolean downloadGeneSequences(File destinationFile, String ensemblType, String ensemblSchemaName, String ensemblDbName, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"FASTA\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" />\n<Attribute name = \"coding\" /></Dataset>\n</Query></Query>";
        String waitingText = "Downloading gene sequences. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, destinationFile, ensemblType, waitingHandler);
    }

    public boolean downloadGoMappings(String ensemblType, String ensemblSchemaName, String ensemblDbName, boolean swissProtMapping, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String accessionMapping = swissProtMapping ? "\"uniprotswissprot\"" : "\"uniprotsptrembl\"";
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = " + accessionMapping + " />";
        requestXml = requestXml + "<Attribute name = \"goslim_goa_accession\" /><Attribute name = \"goslim_goa_description\" />";
        requestXml = requestXml + "</Dataset></Query>";
        File tempFile = ProteinGeneDetailsProvider.getGoMappingFile(ensemblDbName);
        String waitingText = "Downloading GO Mappings. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, tempFile, ensemblType, waitingHandler);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, destinationFile, ensemblType, null);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, null, destinationFile, ensemblType, waitingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryEnsembl(String requestXml, String waitingText, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        boolean success;
        block27: {
            if (waitingHandler != null && waitingHandler instanceof ProgressDialogX && waitingText == null) {
                waitingText = "Downloading from Ensembl. Please wait...";
            }
            success = true;
            int lastThousand = 0;
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                String lineBreak = System.getProperty("line.separator");
                try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) break block27;
                    if (waitingHandler != null) {
                        waitingHandler.setWaitingText(waitingText);
                    } else {
                        System.out.println(waitingText);
                    }
                    int counter = 0;
                    boolean fileCreated = destinationFile.createNewFile();
                    if (fileCreated || destinationFile.exists()) {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                             FileWriter w = new FileWriter(destinationFile);
                             BufferedWriter bw = new BufferedWriter(w);){
                            String rowLine = br.readLine();
                            if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                if (rowLine.lastIndexOf("Attribute goslim_goa_accession NOT FOUND") != -1) {
                                    success = false;
                                    break block27;
                                }
                                if (rowLine.lastIndexOf("Attribute uniprotswissprot_accession NOT FOUND") != -1) {
                                    success = false;
                                    break block27;
                                }
                                throw new IllegalArgumentException("Query error: " + rowLine);
                            }
                            while (rowLine != null && success) {
                                int thousand;
                                if (waitingHandler != null) {
                                    if (waitingHandler.isRunCanceled()) {
                                        break block27;
                                    }
                                    if (waitingHandler instanceof ProgressDialogX) {
                                        waitingHandler.setWaitingText(waitingText + " (" + counter++ + " rows downloaded)");
                                    }
                                } else if ((thousand = ++counter / 10000) > lastThousand) {
                                    System.out.println(waitingText + " (" + counter + " rows downloaded)");
                                    lastThousand = thousand;
                                }
                                bw.write(rowLine + lineBreak);
                                rowLine = br.readLine();
                            }
                            break block27;
                        }
                    }
                    if (waitingHandler != null) {
                        waitingHandler.setRunCanceled();
                    }
                    throw new IllegalArgumentException("The mapping file could not be created.");
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadGeneMappings(String ensemblType, String ensemblSchemaName, String ensemblDatasetName, String ensemblVersion, WaitingHandler waitingHandler) throws MalformedURLException, IOException, IllegalArgumentException {
        block17: {
            String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDatasetName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" /><Attribute name = \"external_gene_name\" /><Attribute name = \"chromosome_name\" /></Dataset></Query>";
            if (!waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                String lineBreak = System.getProperty("line.separator");
                try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler.isRunCanceled()) break block17;
                    waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait...");
                    int counter = 0;
                    File tempFile = ProteinGeneDetailsProvider.getGeneMappingFile(ensemblDatasetName);
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                         FileWriter w = new FileWriter(tempFile);
                         BufferedWriter bw = new BufferedWriter(w);){
                        String rowLine = br.readLine();
                        if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                            throw new IllegalArgumentException("Query error on line: " + rowLine);
                        }
                        while (rowLine != null && !waitingHandler.isRunCanceled()) {
                            if (waitingHandler instanceof ProgressDialogX) {
                                waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait... (" + counter++ + " rows downloaded)");
                            }
                            bw.write(rowLine + lineBreak);
                            rowLine = br.readLine();
                        }
                    }
                    if (!waitingHandler.isRunCanceled()) {
                        this.updateEnsemblVersion(ensemblDatasetName, "Ensembl " + ensemblVersion);
                    }
                }
            }
        }
    }

    public static File getGeneMappingFolder() {
        return new File(GENE_MAPPING_FOLDER);
    }

    public static void setGeneMappingFolder(String geneMappingFolder) {
        GENE_MAPPING_FOLDER = geneMappingFolder;
    }

    public void createDefaultGeneMappingFilesGeneric(String jarFilePath, File sourceEnsemblVersionsFile, File sourceGoDomainsFile, boolean updateEqualVersion) {
        boolean fileCreated;
        boolean folderCreated;
        if (!ProteinGeneDetailsProvider.getGeneMappingFolder().exists() && !(folderCreated = ProteinGeneDetailsProvider.getGeneMappingFolder().mkdirs())) {
            throw new IllegalArgumentException("Could not create the gene mapping folder.");
        }
        File targetEnsemblVersionsFile = ProteinGeneDetailsProvider.getEnsemblVersionsFile();
        File targetGoDomainsFile = ProteinGeneDetailsProvider.getGoDomainsFile();
        HashMap<Object, Object> localEnsemblVersionsMap = new HashMap();
        HashMap<Object, Boolean> localUpdateSpeciesEnsembl = new HashMap<Object, Boolean>();
        try {
            if (!targetEnsemblVersionsFile.exists()) {
                fileCreated = targetEnsemblVersionsFile.createNewFile();
                if (!fileCreated) {
                    throw new IllegalArgumentException("Could not create the Ensembl versions file.");
                }
                IoUtil.copyFile(sourceEnsemblVersionsFile, targetEnsemblVersionsFile);
                localEnsemblVersionsMap = this.getEnsemblSpeciesVersions(targetEnsemblVersionsFile);
                for (Map.Entry<Object, Object> entry : localEnsemblVersionsMap.entrySet()) {
                    Integer speciesEnsemblVersionNew = this.getEnsemblVersionFromFile(sourceEnsemblVersionsFile, (String)entry.getKey());
                    this.updateEnsemblVersion((String)entry.getKey(), "Ensembl " + speciesEnsemblVersionNew);
                    localUpdateSpeciesEnsembl.put(entry.getKey(), true);
                }
            } else {
                localEnsemblVersionsMap = this.getEnsemblSpeciesVersions(targetEnsemblVersionsFile);
                for (Map.Entry<Object, Object> entry : localEnsemblVersionsMap.entrySet()) {
                    Integer speciesEnsemblVersionNew = this.getEnsemblVersionFromFile(sourceEnsemblVersionsFile, (String)entry.getKey());
                    if (speciesEnsemblVersionNew != null) {
                        Integer speciesEnsemblVersionOld = this.getEnsemblVersionFromFile(targetEnsemblVersionsFile, (String)entry.getKey());
                        if (speciesEnsemblVersionOld == null || speciesEnsemblVersionOld.equals(speciesEnsemblVersionNew) && updateEqualVersion || speciesEnsemblVersionOld < speciesEnsemblVersionNew) {
                            localUpdateSpeciesEnsembl.put(entry.getKey(), true);
                            this.updateEnsemblVersion((String)entry.getKey(), "Ensembl " + speciesEnsemblVersionNew);
                            continue;
                        }
                        localUpdateSpeciesEnsembl.put(entry.getKey(), false);
                        continue;
                    }
                    localUpdateSpeciesEnsembl.put(entry.getKey(), false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create or update the Ensembl versions file.");
        }
        try {
            if (!targetGoDomainsFile.exists() && !(fileCreated = targetGoDomainsFile.createNewFile())) {
                throw new IllegalArgumentException("Could not create the GO domains file.");
            }
            IoUtil.copyFile(sourceGoDomainsFile, targetGoDomainsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create the GO domains file.");
        }
        for (Map.Entry entry : localUpdateSpeciesEnsembl.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            File sourceSpeciesGoMappingsFile = new File(jarFilePath, TOOL_GENE_MAPPING_SUBFOLDER + (String)entry.getKey() + GO_MAPPING_FILE_SUFFIX);
            File sourceSpeciesGeneMappingFile = new File(jarFilePath, TOOL_GENE_MAPPING_SUBFOLDER + (String)entry.getKey() + GENE_MAPPING_FILE_SUFFIX);
            File targetSpeciesGoMappingsFile = new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), sourceSpeciesGoMappingsFile.getName());
            File targetSpeciesGeneMappingFile = new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), sourceSpeciesGeneMappingFile.getName());
            try {
                boolean fileCreated2;
                if (!targetSpeciesGoMappingsFile.exists() && !(fileCreated2 = targetSpeciesGoMappingsFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species GO mapping file.");
                }
                IoUtil.copyFile(sourceSpeciesGoMappingsFile, targetSpeciesGoMappingsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species GO mapping file.");
            }
            try {
                boolean fileCreated2;
                if (!targetSpeciesGeneMappingFile.exists() && !(fileCreated2 = targetSpeciesGeneMappingFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species gene mapping file.");
                }
                IoUtil.copyFile(sourceSpeciesGeneMappingFile, targetSpeciesGeneMappingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species gene mapping file.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnsemblVersion(String ensemblDatasetName, String ensemblVersion) throws IOException {
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap();
        }
        this.ensemblVersionsMap.put(ensemblDatasetName, ensemblVersion);
        try (FileWriter w = new FileWriter(ProteinGeneDetailsProvider.getEnsemblVersionsFile());
             BufferedWriter bw = new BufferedWriter(w);){
            for (String key : this.ensemblVersionsMap.keySet()) {
                bw.write(key + SEPARATOR + this.ensemblVersionsMap.get(key));
                bw.newLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEnsemblVersionFromFile(File ensemblVersionsFile, String species) throws IOException {
        Integer version = null;
        try (FileReader r = new FileReader(ensemblVersionsFile);
             BufferedReader br = new BufferedReader(r);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] splittedLine = line.split(SEPARATOR);
                String speciesAtLine = splittedLine[0];
                if (!speciesAtLine.equals(species)) continue;
                String[] ensemblVersionSplit = splittedLine[1].split(" ");
                version = Integer.valueOf(ensemblVersionSplit[1]);
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getEnsemblSpeciesVersions(File ensemblVersionsFile) throws FileNotFoundException, IOException {
        HashMap<String, String> localEnsemblVersionsMap = new HashMap<String, String>();
        try (FileReader r = new FileReader(ensemblVersionsFile);
             BufferedReader br = new BufferedReader(r);){
            String line = br.readLine();
            while (line != null) {
                String[] elements = line.split("\\t");
                localEnsemblVersionsMap.put(elements[0], elements[1]);
                line = br.readLine();
            }
        }
        return localEnsemblVersionsMap;
    }

    public void loadEnsemblSpeciesVersions(File ensemblVersionsFile) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(ensemblVersionsFile));){
            this.ensemblVersionsMap = new HashMap();
            String line = br.readLine();
            while (line != null) {
                String[] elements = line.split("\\t");
                this.ensemblVersionsMap.put(elements[0], elements[1]);
                line = br.readLine();
            }
        }
    }

    private URL getEnsemblUrl(String ensemblType) throws MalformedURLException {
        if (ensemblType.equalsIgnoreCase("fungi")) {
            return new URL("https://fungi.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("plants")) {
            return new URL("https://plants.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("protists")) {
            return new URL("https://protists.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("metazoa")) {
            return new URL("https://metazoa.ensembl.org/biomart/martservice/result");
        }
        return new URL("https://www.ensembl.org/biomart/martservice/result");
    }

    public boolean downloadMappings(WaitingHandler waitingHandler, Integer taxon) throws IOException {
        boolean canceled;
        String schemaName;
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        String latinName = speciesFactory.getLatinName(taxon);
        if (latinName == null) {
            latinName = taxon.toString();
        }
        if (waitingHandler.isReport()) {
            waitingHandler.appendReport("    Downloading GO and gene mappings for species " + latinName + ".", true, true);
        }
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = speciesFactory.getEnsemblGenomesSpecies().getDivision(taxon);
        String ensemblType = "ensembl";
        if (ensemblGenomeDivision != null) {
            ensemblType = ensemblGenomeDivision.ensemblType;
        }
        if ((schemaName = EnsemblVersion.getEnsemblSchemaName(ensemblGenomeDivision)) == null) {
            return false;
        }
        String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
        if (ensemblDatasetName == null) {
            return false;
        }
        if (!waitingHandler.isRunCanceled()) {
            boolean goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, true, waitingHandler);
            if (!goMappingsDownloaded) {
                goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, false, waitingHandler);
            }
            if (!goMappingsDownloaded) {
                waitingHandler.appendReport("    Gene ontology mappings not available. Downloading gene mappings only.", true, true);
            } else if (waitingHandler.isReport()) {
                waitingHandler.appendReport("    GO mappings downloaded.", true, true);
            }
        }
        if (!waitingHandler.isRunCanceled()) {
            this.downloadGeneMappings(ensemblType, schemaName, ensemblDatasetName, EnsemblVersion.getCurrentEnsemblVersion(ensemblGenomeDivision).toString(), waitingHandler);
            if (!waitingHandler.isRunCanceled() && waitingHandler.isReport()) {
                waitingHandler.appendReport("    Gene mappings downloaded.", true, true);
            }
        }
        return !(canceled = waitingHandler.isRunCanceled());
    }

    public static File getGeneMappingFile(String ensemblDatasetName) {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ensemblDatasetName + GENE_MAPPING_FILE_SUFFIX);
    }

    public static File getGoMappingFile(String ensemblDatasetName) {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ensemblDatasetName + GO_MAPPING_FILE_SUFFIX);
    }

    public static File getEnsemblVersionsFile() {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ENSEMBL_VERSIONS);
    }

    public static File getGoDomainsFile() {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), GO_DOMAINS);
    }

    public String getEnsemblVersion(Integer taxon) {
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        String ensemblDatasetName = speciesFactory.getEnsemblDataset(taxon);
        if (this.ensemblVersionsMap == null) {
            return null;
        }
        return this.ensemblVersionsMap.get(ensemblDatasetName);
    }

    public boolean newVersionExists(Integer taxon) {
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = SpeciesFactory.getInstance().getEnsemblGenomesSpecies().getDivision(taxon);
        Integer latestEnsemblVersion = EnsemblVersion.getCurrentEnsemblVersion(ensemblGenomeDivision);
        String currentEnsemblVersionAsString = this.getEnsemblVersion(taxon);
        if (currentEnsemblVersionAsString != null) {
            Integer currentEnsemblVersion;
            currentEnsemblVersionAsString = currentEnsemblVersionAsString.substring(currentEnsemblVersionAsString.indexOf(" ") + 1);
            try {
                currentEnsemblVersion = Integer.valueOf(currentEnsemblVersionAsString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                currentEnsemblVersion = latestEnsemblVersion;
            }
            return currentEnsemblVersion < latestEnsemblVersion;
        }
        return true;
    }
}

