/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.NeutralLossCombination;
import com.compomics.util.experiment.biology.ions.impl.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.biology.ions.impl.RelatedIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.ions.impl.TagFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.amino_acid_tags.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;

public class IonFactory {
    private static IonFactory instance = null;
    private static HashSet<String> defaultNeutralLosses = null;
    private final HashMap<Long, NeutralLossCombination[]> neutralLossesCombinationsCache = new HashMap(4);
    private static final double nh3 = Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass();
    private static final double co = Atom.C.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    private static final double nMinusO = Atom.N.getMonoisotopicMass() - Atom.O.getMonoisotopicMass();
    private static final double co2 = Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass();
    private static final double h2 = 2.0 * Atom.H.getMonoisotopicMass();
    private static final double h2o = 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    private static final double ho = Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();

    private IonFactory() {
    }

    public static IonFactory getInstance() {
        if (instance == null) {
            instance = new IonFactory();
        }
        return instance;
    }

    public static HashSet<String> getDefaultNeutralLosses() {
        if (defaultNeutralLosses == null) {
            IonFactory.setDefaultNeutralLosses();
        }
        return defaultNeutralLosses;
    }

    private static synchronized void setDefaultNeutralLosses() {
        defaultNeutralLosses = new HashSet(2);
        defaultNeutralLosses.add(NeutralLoss.H2O.name);
        defaultNeutralLosses.add(NeutralLoss.NH3.name);
    }

    public static HashSet<String> getNeutralLosses(ModificationParameters modificationParameters) {
        HashSet<String> neutralLosses = new HashSet<String>(IonFactory.getDefaultNeutralLosses());
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        neutralLosses.addAll(modificationParameters.getAllModifications().stream().flatMap(modName -> modificationFactory.getModification((String)modName).getNeutralLosses().stream()).map(neutralLoss -> neutralLoss.name).collect(Collectors.toSet()));
        return neutralLosses;
    }

    public static HashSet<Integer> getReporterIons(ModificationParameters modificationParameters) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        return modificationParameters.getAllModifications().stream().flatMap(modName -> modificationFactory.getModification((String)modName).getReporterIons().stream()).map(ReporterIon::getSubType).collect(Collectors.toCollection(HashSet::new));
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        return this.getFragmentIons(peptide, null, modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters);
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Peptide peptide, SpecificAnnotationParameters specificAnnotationSettings, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        Modification modification;
        HashMap<Ion.IonType, HashSet<Integer>> selectedIonTypes = null;
        if (specificAnnotationSettings != null) {
            selectedIonTypes = specificAnnotationSettings.getIonTypes();
        }
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        String sequence = peptide.getSequence();
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        HashSet<String> possibleNeutralLosses = null;
        if (specificAnnotationSettings == null || !specificAnnotationSettings.getNeutralLossesMap().isEmpty()) {
            possibleNeutralLosses = new HashSet<String>(IonFactory.getDefaultNeutralLosses());
        }
        HashSet<String> allModifications = new HashSet<String>(1);
        String[] variableModNames = null;
        try {
            variableModNames = peptide.getIndexedVariableModifications();
        }
        catch (IllegalArgumentException e) {
            return result;
        }
        Modification[] variableModifications = new Modification[variableModNames.length];
        String[] fixedModNames = peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationsSequenceMatchingParameters);
        Modification[] fixedModifications = new Modification[fixedModNames.length];
        for (int i = 0; i < variableModNames.length; ++i) {
            String modName = variableModNames[i];
            if (modName != null) {
                allModifications.add(modName);
                variableModifications[i] = modification = modificationFactory.getModification(modName);
            }
            if ((modName = fixedModNames[i]) == null) continue;
            allModifications.add(modName);
            fixedModifications[i] = modification = modificationFactory.getModification(modName);
        }
        for (String modName : allModifications) {
            modification = modificationFactory.getModification(modName);
            if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.REPORTER_ION)) {
                for (ReporterIon reporterIon : modification.getReporterIons()) {
                    int subType;
                    ArrayList<Ion> ions;
                    HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.REPORTER_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap(modification.getReporterIons().size());
                        result.put(Ion.IonType.REPORTER_ION.index, ionsMap);
                    }
                    if ((ions = ionsMap.get(subType = reporterIon.getSubType())) != null) continue;
                    ions = new ArrayList(1);
                    ionsMap.put(subType, ions);
                    ions.add(reporterIon);
                }
            }
            if (specificAnnotationSettings != null && specificAnnotationSettings.getNeutralLossesMap().isEmpty()) continue;
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                possibleNeutralLosses.add(neutralLoss.name);
            }
        }
        NeutralLossCombination[] neutralLossesCombinations = null;
        if (specificAnnotationSettings == null || !specificAnnotationSettings.getNeutralLossesMap().isEmpty()) {
            neutralLossesCombinations = this.getNeutralLossesCombinations(possibleNeutralLosses);
        }
        double forwardMass = 0.0;
        Modification modification2 = fixedModifications[0];
        if (modification2 != null) {
            forwardMass += modification2.getMass();
        }
        if ((modification2 = variableModifications[0]) != null) {
            forwardMass += modification2.getMass();
        }
        double rewindMass = Atom.O.getMonoisotopicMass();
        modification2 = fixedModifications[sequence.length() + 1];
        if (modification2 != null) {
            rewindMass += modification2.getMass();
        }
        if ((modification2 = variableModifications[sequence.length() + 1]) != null) {
            rewindMass += modification2.getMass();
        }
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            HashMap<Integer, ArrayList<Ion>> ionsMap;
            Object ions;
            HashMap<Integer, ArrayList<Ion>> ionsMap2;
            char aaName = sequence.charAt(aa);
            if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.IMMONIUM_ION)) {
                ImmoniumIon immoniumIon;
                int subType;
                ArrayList<Ion> ions2;
                ionsMap2 = result.get(Ion.IonType.IMMONIUM_ION.index);
                if (ionsMap2 == null) {
                    ionsMap2 = new HashMap(sequence.length());
                    result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap2);
                }
                if ((ions2 = ionsMap2.get(subType = (immoniumIon = ImmoniumIon.getImmoniumIon(aaName)).getSubType())) == null) {
                    ions2 = new ArrayList(1);
                    ions2.add(immoniumIon);
                    ionsMap2.put(subType, ions2);
                }
            }
            if (selectedIonTypes == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.RELATED_ION)) {
                ArrayList<RelatedIon> relatedIons;
                ionsMap2 = result.get(Ion.IonType.RELATED_ION.index);
                if (ionsMap2 == null) {
                    ionsMap2 = new HashMap(sequence.length());
                    result.put(Ion.IonType.RELATED_ION.index, ionsMap2);
                }
                if ((relatedIons = RelatedIon.getRelatedIons(AminoAcid.getAminoAcid(aaName))) != null) {
                    for (RelatedIon tempRelated : relatedIons) {
                        int subType = tempRelated.getSubType();
                        ions = ionsMap2.get(subType);
                        if (ions == null) {
                            ions = new ArrayList(1);
                        }
                        ((ArrayList)ions).add((Ion)tempRelated);
                        ionsMap2.put(subType, (ArrayList<Ion>)ions);
                    }
                }
            }
            int faa = aa + 1;
            AminoAcid currentAA = AminoAcid.getAminoAcid(aaName);
            forwardMass += currentAA.getMonoisotopicMass();
            modification2 = fixedModifications[faa];
            if (modification2 != null) {
                forwardMass += modification2.getMass();
            }
            if ((modification2 = variableModifications[faa]) != null) {
                forwardMass += modification2.getMass();
            }
            if ((ionsMap = result.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index)) == null) {
                ionsMap = new HashMap(6);
                result.put(Ion.IonType.PEPTIDE_FRAGMENT_ION.index, ionsMap);
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(0)) {
                int subType = 0;
                ArrayList<Ion> ions3 = ionsMap.get(subType);
                if (ions3 == null) {
                    ions3 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions3);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions3.add(new PeptideFragmentIon(subType, faa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions3.add(new PeptideFragmentIon(subType, faa, forwardMass - co, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(1)) {
                int subType = 1;
                ArrayList<Ion> ions4 = ionsMap.get(subType);
                if (ions4 == null) {
                    ions4 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions4);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions4.add(new PeptideFragmentIon(subType, faa, forwardMass - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions4.add(new PeptideFragmentIon(subType, faa, forwardMass, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(2)) {
                int subType = 2;
                ArrayList<Ion> ions5 = ionsMap.get(subType);
                if (ions5 == null) {
                    ions5 = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, ions5);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions5.add(new PeptideFragmentIon(subType, faa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ions5.add(new PeptideFragmentIon(subType, faa, forwardMass + nh3, null));
                }
            }
            int raa = sequence.length() - aa - 1;
            currentAA = AminoAcid.getAminoAcid(sequence.charAt(raa));
            rewindMass += currentAA.getMonoisotopicMass();
            modification2 = fixedModifications[raa + 1];
            if (modification2 != null) {
                rewindMass += modification2.getMass();
            }
            if ((modification2 = variableModifications[raa + 1]) != null) {
                rewindMass += modification2.getMass();
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(3)) {
                int subType = 3;
                ions = ionsMap.get(subType);
                if (ions == null) {
                    ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, (ArrayList<Ion>)ions);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + co - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + co, null));
                }
            }
            if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) && specificAnnotationSettings.getFragmentIonTypes().contains(4)) {
                int subType = 4;
                ions = ionsMap.get(subType);
                if (ions == null) {
                    ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                    ionsMap.put(subType, (ArrayList<Ion>)ions);
                }
                if (neutralLossesCombinations != null) {
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + h2 - losses.getMass(), losses.getNeutralLossCombination()));
                    }
                } else {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass + h2, null));
                }
            }
            if (specificAnnotationSettings != null && (!selectedIonTypes.keySet().contains((Object)Ion.IonType.PEPTIDE_FRAGMENT_ION) || !specificAnnotationSettings.getFragmentIonTypes().contains(5))) continue;
            int subType = 5;
            ions = ionsMap.get(subType);
            if (ions == null) {
                ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                ionsMap.put(subType, (ArrayList<Ion>)ions);
            }
            if (neutralLossesCombinations != null) {
                for (NeutralLossCombination losses : neutralLossesCombinations) {
                    ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass - Atom.N.getMonoisotopicMass() - losses.getMass(), losses.getNeutralLossCombination()));
                }
                continue;
            }
            ((ArrayList)ions).add(new PeptideFragmentIon(subType, faa, rewindMass - Atom.N.getMonoisotopicMass(), null));
        }
        AminoAcid currentAA = AminoAcid.getAminoAcid(sequence.charAt(sequence.length() - 1));
        forwardMass += currentAA.getMonoisotopicMass();
        modification2 = fixedModifications[sequence.length()];
        if (modification2 != null) {
            forwardMass += modification2.getMass();
        }
        if ((modification2 = variableModifications[sequence.length()]) != null) {
            forwardMass += modification2.getMass();
        }
        if ((modification2 = fixedModifications[sequence.length() + 1]) != null) {
            forwardMass += modification2.getMass();
        }
        if ((modification2 = variableModifications[sequence.length() + 1]) != null) {
            forwardMass += modification2.getMass();
        }
        if (specificAnnotationSettings == null || selectedIonTypes.keySet().contains((Object)Ion.IonType.PRECURSOR_ION)) {
            int subType;
            ArrayList<Ion> ions;
            HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.PRECURSOR_ION.index);
            if (ionsMap == null) {
                ionsMap = new HashMap(1);
                result.put(Ion.IonType.PRECURSOR_ION.index, ionsMap);
            }
            if ((ions = ionsMap.get(subType = 0)) == null) {
                ions = neutralLossesCombinations != null ? new ArrayList(neutralLossesCombinations.length) : new ArrayList(1);
                ionsMap.put(subType, ions);
            }
            if (neutralLossesCombinations != null) {
                for (NeutralLossCombination losses : neutralLossesCombinations) {
                    ions.add(new PrecursorIon(forwardMass + h2o - losses.getMass(), losses.getNeutralLossCombination()));
                }
            } else {
                ions.add(new PrecursorIon(forwardMass + ho, null));
            }
        }
        return result;
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Tag tag, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        int subType;
        ArrayList<PrecursorIon> ions;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        HashSet<String> possibleNeutralLosses = new HashSet<String>(IonFactory.getDefaultNeutralLosses());
        NeutralLossCombination[] neutralLossesCombinations = this.getNeutralLossesCombinations(possibleNeutralLosses);
        HashSet<String> allModifications = new HashSet<String>(2);
        int ionNumberOffset = 1;
        ArrayList<Double> massOffsets = new ArrayList<Double>();
        massOffsets.add(0.0);
        ArrayList<TagComponent> tagContent = tag.getContent();
        for (int tagIndex = 0; tagIndex < tagContent.size(); ++tagIndex) {
            Object newModifications;
            TagComponent tagComponent = tagContent.get(tagIndex);
            if (tagComponent instanceof AminoAcidSequence) {
                Object aminoAcid;
                Modification modification;
                String modName;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                String[] variableModNames = aminoAcidSequence.getIndexedVariableModifications();
                String[] fixedModNames = aminoAcidSequence.getFixedModifications(tagIndex == 0, tagIndex == tagContent.size() - 1, modificationParameters, modificationsSequenceMatchingParameters);
                newModifications = new HashSet(0);
                Modification[] variableModifications = new Modification[variableModNames.length];
                Modification[] fixedModifications = new Modification[fixedModNames.length];
                for (int i = 0; i < variableModifications.length; ++i) {
                    modName = variableModNames[i];
                    if (modName != null) {
                        if (!allModifications.contains(modName)) {
                            ((HashSet)newModifications).add(modName);
                            allModifications.add(modName);
                        }
                        variableModifications[i] = modification = modificationFactory.getModification(modName);
                    }
                    if ((modName = fixedModNames[i]) == null) continue;
                    if (!allModifications.contains(modName)) {
                        ((HashSet)newModifications).add(modName);
                        allModifications.add(modName);
                    }
                    fixedModifications[i] = modification = modificationFactory.getModification(modName);
                }
                Iterator i = ((HashSet)newModifications).iterator();
                while (i.hasNext()) {
                    modName = (String)i.next();
                    modification = ModificationFactory.getInstance().getModification(modName);
                    for (ReporterIon ptmReporterIon : modification.getReporterIons()) {
                        int subType2;
                        ArrayList<Ion> ions2;
                        HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.REPORTER_ION.index);
                        if (ionsMap == null) {
                            ionsMap = new HashMap(1);
                            result.put(Ion.IonType.REPORTER_ION.index, ionsMap);
                        }
                        if ((ions2 = ionsMap.get(subType2 = ptmReporterIon.getSubType())) != null) continue;
                        ions2 = new ArrayList(1);
                        ionsMap.put(subType2, ions2);
                        ions2.add(ptmReporterIon);
                    }
                    for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                        possibleNeutralLosses.add(neutralLoss.name);
                    }
                }
                for (int i2 = 0; i2 < aminoAcidSequence.length(); ++i2) {
                    ArrayList<RelatedIon> relatedIons;
                    ImmoniumIon immoniumIon;
                    int subType3;
                    ArrayList<Ion> ions3;
                    aminoAcid = aminoAcidSequence.getAminoAcidAt(i2);
                    HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap(1);
                        result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                    }
                    if ((ions3 = ionsMap.get(subType3 = (immoniumIon = ImmoniumIon.getImmoniumIon(((AminoAcid)aminoAcid).getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions3 = new ArrayList(1);
                        ions3.add(immoniumIon);
                        ionsMap.put(subType3, ions3);
                    }
                    if ((ionsMap = result.get(Ion.IonType.RELATED_ION.index)) == null) {
                        ionsMap = new HashMap(1);
                        result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                    }
                    if ((relatedIons = RelatedIon.getRelatedIons((AminoAcid)aminoAcid)) != null) {
                        for (RelatedIon tempRelated : relatedIons) {
                            subType3 = tempRelated.getSubType();
                            ions3 = ionsMap.get(subType3);
                            if (ions3 == null) {
                                ions3 = new ArrayList(1);
                            }
                            ions3.add(tempRelated);
                            ionsMap.put(subType3, ions3);
                        }
                    }
                    double mass = ((AminoAcid)aminoAcid).getMonoisotopicMass();
                    Modification modification2 = variableModifications[i2];
                    if (modification2 != null) {
                        mass += modification2.getMass();
                    }
                    if ((modification2 = fixedModifications[i2]) != null) {
                        mass += modification2.getMass();
                    }
                    sequenceMass += mass;
                    ionsMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                    }
                    Iterator iterator = massOffsets.iterator();
                    while (iterator.hasNext()) {
                        double massOffset = (Double)iterator.next();
                        int aa = ionNumberOffset + i2;
                        int subaa = i2 + 1;
                        double forwardMass = massOffset + sequenceMass;
                        subType3 = 0;
                        ions3 = ionsMap.get(subType3);
                        if (ions3 == null) {
                            ions3 = new ArrayList();
                            ionsMap.put(subType3, ions3);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions3.add(new TagFragmentIon(subType3, aa, subaa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                        subType3 = 1;
                        ions3 = ionsMap.get(subType3);
                        if (ions3 == null) {
                            ions3 = new ArrayList();
                            ionsMap.put(subType3, ions3);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions3.add(new TagFragmentIon(subType3, aa, subaa, forwardMass - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                        subType3 = 2;
                        ions3 = ionsMap.get(subType3);
                        if (ions3 == null) {
                            ions3 = new ArrayList();
                            ionsMap.put(subType3, ions3);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions3.add(new TagFragmentIon(subType3, aa, subaa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcid = massOffsets.iterator();
                while (aminoAcid.hasNext()) {
                    double offsetMass = (Double)aminoAcid.next();
                    double newMass = offsetMass + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap ionsMap = (HashMap)result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (ionsMap == null) {
                    ionsMap = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                }
                newModifications = massOffsets.iterator();
                while (newModifications.hasNext()) {
                    double massOffset = (Double)newModifications.next();
                    double forwardMass = massOffset + gapMass;
                    int subType4 = 0;
                    ArrayList<TagFragmentIon> ions4 = (ArrayList<TagFragmentIon>)ionsMap.get(subType4);
                    if (ions4 == null) {
                        ions4 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType4, ions4);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions4.add(new TagFragmentIon(subType4, aa, subaa, forwardMass - co - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                    }
                    subType4 = 1;
                    ions4 = (ArrayList<TagFragmentIon>)ionsMap.get(subType4);
                    if (ions4 == null) {
                        ions4 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType4, ions4);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions4.add(new TagFragmentIon(subType4, aa, subaa, forwardMass - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                    }
                    subType4 = 2;
                    ions4 = (ArrayList<TagFragmentIon>)ionsMap.get(subType4);
                    if (ions4 == null) {
                        ions4 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType4, ions4);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions4.add(new TagFragmentIon(subType4, aa, subaa, forwardMass + nh3 - losses.getMass(), losses.getNeutralLossCombination(), massOffset));
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator massOffset = massOffsets.iterator();
                while (massOffset.hasNext()) {
                    double offsetMass = (Double)massOffset.next();
                    newOffsetMasses.add(offsetMass + gapMass);
                }
                massOffsets = newOffsetMasses;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        ArrayList<TagComponent> reversedTag = new ArrayList<TagComponent>(tag.getContent());
        Collections.reverse(reversedTag);
        ionNumberOffset = 0;
        massOffsets.clear();
        massOffsets.add(0.0);
        allModifications.clear();
        possibleNeutralLosses.clear();
        for (int tagIndex = 0; tagIndex < tagContent.size(); ++tagIndex) {
            Object newModifications;
            TagComponent tagComponent = tagContent.get(tagIndex);
            if (tagComponent instanceof AminoAcidSequence) {
                String modName;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                String[] variableModNames = aminoAcidSequence.getIndexedVariableModifications();
                String[] fixedModNames = aminoAcidSequence.getFixedModifications(tagIndex == 0, tagIndex == tagContent.size() - 1, modificationParameters, modificationsSequenceMatchingParameters);
                newModifications = new HashSet(0);
                Modification[] variableModifications = new Modification[variableModNames.length];
                Modification[] fixedModifications = new Modification[fixedModNames.length];
                for (int i = 0; i < variableModifications.length; ++i) {
                    Modification modification;
                    modName = variableModNames[i];
                    if (modName != null) {
                        if (!allModifications.contains(modName)) {
                            ((HashSet)newModifications).add(modName);
                            allModifications.add(modName);
                        }
                        variableModifications[i] = modification = modificationFactory.getModification(modName);
                    }
                    if ((modName = fixedModNames[i]) == null) continue;
                    if (!allModifications.contains(modName)) {
                        ((HashSet)newModifications).add(modName);
                        allModifications.add(modName);
                    }
                    fixedModifications[i] = modification = modificationFactory.getModification(modName);
                }
                Iterator i = ((HashSet)newModifications).iterator();
                while (i.hasNext()) {
                    modName = (String)i.next();
                    Modification modification = ModificationFactory.getInstance().getModification(modName);
                    for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                        possibleNeutralLosses.add(neutralLoss.name);
                    }
                }
                for (int i3 = aminoAcidSequence.length() - 1; i3 >= 0; --i3) {
                    ArrayList<RelatedIon> relatedIons;
                    ImmoniumIon immoniumIon;
                    int subType5;
                    ArrayList<Ion> ions5;
                    AminoAcid aminoAcid = aminoAcidSequence.getAminoAcidAt(i3);
                    HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                    }
                    if ((ions5 = ionsMap.get(subType5 = (immoniumIon = ImmoniumIon.getImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions5 = new ArrayList();
                        ions5.add(immoniumIon);
                        ionsMap.put(subType5, ions5);
                    }
                    if ((ionsMap = result.get(Ion.IonType.RELATED_ION.index)) == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.RELATED_ION.index, ionsMap);
                    }
                    if ((relatedIons = RelatedIon.getRelatedIons(aminoAcid)) != null) {
                        for (RelatedIon tempRelated : relatedIons) {
                            subType5 = tempRelated.getSubType();
                            ions5 = ionsMap.get(subType5);
                            if (ions5 == null) {
                                ions5 = new ArrayList(1);
                            }
                            ions5.add(tempRelated);
                            ionsMap.put(subType5, ions5);
                        }
                    }
                    double mass = aminoAcid.getMonoisotopicMass();
                    Modification modification = variableModifications[i3];
                    if (modification != null) {
                        mass += modification.getMass();
                    }
                    if ((modification = fixedModifications[i3]) != null) {
                        mass += modification.getMass();
                    }
                    sequenceMass += mass;
                    ionsMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap == null) {
                        ionsMap = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                    }
                    Iterator iterator = massOffsets.iterator();
                    while (iterator.hasNext()) {
                        double massOffset = (Double)iterator.next();
                        int aa = ionNumberOffset + aminoAcidSequence.length() - i3;
                        int subaa = aminoAcidSequence.length() - i3;
                        double rewindMass = massOffset + sequenceMass;
                        double gap = 0.0;
                        if (massOffset != Atom.O.getMonoisotopicMass()) {
                            gap = massOffset;
                        }
                        if ((ions5 = ionsMap.get(subType5 = 3)) == null) {
                            ions5 = new ArrayList();
                            ionsMap.put(subType5, ions5);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions5.add(new TagFragmentIon(subType5, aa, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap));
                        }
                        subType5 = 4;
                        ions5 = ionsMap.get(subType5);
                        if (ions5 == null) {
                            ions5 = new ArrayList();
                            ionsMap.put(subType5, ions5);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions5.add(new TagFragmentIon(subType5, aa, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap));
                        }
                        subType5 = 5;
                        ions5 = ionsMap.get(subType5);
                        if (ions5 == null) {
                            ions5 = new ArrayList();
                            ionsMap.put(subType5, ions5);
                        }
                        for (NeutralLossCombination losses : neutralLossesCombinations) {
                            ions5.add(new TagFragmentIon(subType5, aa, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    double offsetMass = (Double)iterator.next();
                    double newMass = offsetMass + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap ionsMap = (HashMap)result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (ionsMap == null) {
                    ionsMap = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                }
                newModifications = massOffsets.iterator();
                while (newModifications.hasNext()) {
                    double massOffset = (Double)newModifications.next();
                    double gap = gapMass;
                    if (massOffset != Atom.O.getMonoisotopicMass()) {
                        gap += massOffset;
                    }
                    double rewindMass = massOffset + gapMass;
                    int subType6 = 3;
                    ArrayList<TagFragmentIon> ions6 = (ArrayList<TagFragmentIon>)ionsMap.get(subType6);
                    if (ions6 == null) {
                        ions6 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType6, ions6);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions6.add(new TagFragmentIon(subType6, aa, subaa, rewindMass + co2 - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                    subType6 = 4;
                    ions6 = (ArrayList<TagFragmentIon>)ionsMap.get(subType6);
                    if (ions6 == null) {
                        ions6 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType6, ions6);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions6.add(new TagFragmentIon(subType6, aa, subaa, rewindMass + h2o - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                    subType6 = 5;
                    ions6 = (ArrayList<TagFragmentIon>)ionsMap.get(subType6);
                    if (ions6 == null) {
                        ions6 = new ArrayList<TagFragmentIon>();
                        ionsMap.put(subType6, ions6);
                    }
                    for (NeutralLossCombination losses : neutralLossesCombinations) {
                        ions6.add(new TagFragmentIon(subType6, aa, subaa, rewindMass - nMinusO - losses.getMass(), losses.getNeutralLossCombination(), gap));
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    double offsetMass = (Double)iterator.next();
                    newOffsetMasses.add(offsetMass + gapMass);
                }
                massOffsets = newOffsetMasses;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        HashMap ionsMap = (HashMap)result.get(Ion.IonType.PRECURSOR_ION.index);
        if (ionsMap == null) {
            ionsMap = new HashMap(1);
            result.put(Ion.IonType.PRECURSOR_ION.index, ionsMap);
        }
        if ((ions = (ArrayList<PrecursorIon>)ionsMap.get(subType = 0)) == null) {
            ions = new ArrayList<PrecursorIon>(neutralLossesCombinations.length);
            ionsMap.put(subType, ions);
        }
        for (NeutralLossCombination losses : neutralLossesCombinations) {
            ions.add(new PrecursorIon(tag.getMass() - losses.getMass(), losses.getNeutralLossCombination()));
        }
        return result;
    }

    public NeutralLossCombination[] getNeutralLossesCombinations(HashSet<String> possibleNeutralLosses) {
        long lossesKey = this.getNeutralLossesKey(possibleNeutralLosses);
        NeutralLossCombination[] neutralLossesCombinations = this.neutralLossesCombinationsCache.get(lossesKey);
        if (neutralLossesCombinations == null) {
            ArrayList<NeutralLoss[]> neutralLossesCombinationsLists = this.estimateNeutralLossesCombinations(possibleNeutralLosses);
            neutralLossesCombinations = new NeutralLossCombination[neutralLossesCombinationsLists.size()];
            for (int i = 0; i < neutralLossesCombinationsLists.size(); ++i) {
                NeutralLossCombination combinationObject;
                NeutralLoss[] combination = neutralLossesCombinationsLists.get(i);
                neutralLossesCombinations[i] = combinationObject = new NeutralLossCombination(combination);
            }
            this.neutralLossesCombinationsCache.put(lossesKey, neutralLossesCombinations);
        }
        return neutralLossesCombinations;
    }

    private ArrayList<NeutralLoss[]> estimateNeutralLossesCombinations(HashSet<String> possibleNeutralLosses) {
        String[] lossesNames = (String[])possibleNeutralLosses.stream().sorted().toArray(String[]::new);
        ArrayList<NeutralLoss[]> neutralLossesCombinations = new ArrayList<NeutralLoss[]>();
        NeutralLoss[] tempList = new NeutralLoss[]{};
        neutralLossesCombinations.add(tempList);
        for (int i = 0; i < lossesNames.length; ++i) {
            String name1 = lossesNames[i];
            NeutralLoss neutralLoss1 = NeutralLoss.getNeutralLoss(name1);
            tempList = new NeutralLoss[]{neutralLoss1};
            neutralLossesCombinations.add(tempList);
            for (int j = i + 1; j < lossesNames.length; ++j) {
                String name2 = lossesNames[j];
                tempList = new NeutralLoss[]{neutralLoss1, NeutralLoss.getNeutralLoss(name2)};
                neutralLossesCombinations.add(tempList);
            }
        }
        return neutralLossesCombinations;
    }

    private long getNeutralLossesKey(HashSet<String> possibleNeutralLosses) {
        return ExperimentObject.asLong(possibleNeutralLosses.stream().collect(Collectors.joining()));
    }

    public static double getLossesMass(NeutralLoss[] neutralLosses) {
        return Arrays.stream(neutralLosses).mapToDouble(NeutralLoss::getMass).sum();
    }
}

