/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.modifications;

public enum ModificationCategory {
    Common,
    Common_Biological,
    Common_Artifact,
    Metal,
    Glyco,
    Less_Common,
    Labeling,
    Nucleotide_Substitution_One,
    Nucleotide_Substitution_TwoPlus,
    Other;


    public String toString() {
        switch (this) {
            case Common: {
                return "Common Fixed and Variable";
            }
            case Common_Biological: {
                return "Common Biological";
            }
            case Common_Artifact: {
                return "Common Artifact";
            }
            case Metal: {
                return "Metal";
            }
            case Glyco: {
                return "Glycosylation";
            }
            case Less_Common: {
                return "Less Common";
            }
            case Labeling: {
                return "Labeling";
            }
            case Nucleotide_Substitution_One: {
                return "Substitution (1 Nucleotide)";
            }
            case Nucleotide_Substitution_TwoPlus: {
                return "Substitution (2+ Nucleotides)";
            }
            case Other: {
                return "Other";
            }
        }
        throw new UnsupportedOperationException("Modification category " + this.name() + " not implemented.");
    }

    public static String getCategoriesAsString() {
        StringBuilder modCategoriesAsString = new StringBuilder();
        for (ModificationCategory modCategory : ModificationCategory.values()) {
            if (modCategoriesAsString.length() > 0) {
                modCategoriesAsString.append(", ");
            }
            modCategoriesAsString.append((Object)modCategory);
        }
        modCategoriesAsString.append(".");
        return modCategoriesAsString.toString();
    }
}

