/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.proteins;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Peptide
extends ExperimentObject {
    private String sequence;
    private long key = NO_KEY;
    private boolean keySet = false;
    private long matchingKey;
    private double mass = -1.0;
    private TreeMap<String, int[]> proteinMapping = null;
    private ModificationMatch[] variableModifications = null;
    private static final ModificationMatch[] NO_MOD = new ModificationMatch[0];
    private HashMap<String, HashMap<Integer, PeptideVariantMatches>> variantMatches = null;
    public static final String MODIFICATION_LOCALIZATION_SEPARATOR = "-ATAA-";
    public static final String MODIFICATION_SEPARATOR = "_";

    public Peptide() {
    }

    public Peptide(String aSequence, ModificationMatch[] variableModifications, HashMap<String, HashMap<Integer, PeptideVariantMatches>> variantMatches, boolean sanityCheck, double mass) {
        this.sequence = aSequence;
        this.variableModifications = variableModifications != null && variableModifications.length > 0 ? variableModifications : null;
        this.variantMatches = variantMatches;
        this.mass = mass;
        if (sanityCheck) {
            this.sanityCheck();
        }
    }

    public Peptide(String aSequence, ModificationMatch[] variableModifications, boolean sanityCheck, double mass) {
        this(aSequence, variableModifications, null, sanityCheck, mass);
    }

    public Peptide(String aSequence, ModificationMatch[] variableModifications, boolean sanityCheck) {
        this(aSequence, variableModifications, sanityCheck, -1.0);
    }

    public Peptide(String aSequence) {
        this(aSequence, null, false);
    }

    public Peptide(String aSequence, ModificationMatch[] variableModifications) {
        this(aSequence, variableModifications, false);
    }

    public Peptide(String aSequence, ModificationMatch[] variableModifications, HashMap<String, HashMap<Integer, PeptideVariantMatches>> variantMatches, boolean sanityCheck) {
        this(aSequence, variableModifications, variantMatches, sanityCheck, -1.0);
    }

    private void sanityCheck() {
        String[] conflictingPtms;
        this.sequence = this.sequence.replaceAll("[#*$%&]", "");
        if (this.variableModifications != null && (conflictingPtms = (String[])Arrays.stream(this.variableModifications).map(modificationMatch -> modificationMatch.getModification()).filter(modificationName -> modificationName.contains(MODIFICATION_SEPARATOR) || modificationName.contains(MODIFICATION_LOCALIZATION_SEPARATOR)).toArray(String[]::new)).length > 0) {
            String conflictingPtmsString = Arrays.stream(conflictingPtms).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Modification names containing '_' or '-ATAA-' are not supported. Conflicting name(s): " + conflictingPtmsString);
        }
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public TreeMap<String, int[]> getProteinMapping() {
        return this.proteinMapping;
    }

    public void setProteinMapping(TreeMap<String, int[]> proteinMapping) {
        this.proteinMapping = proteinMapping;
    }

    public void setVariantMatches(HashMap<String, HashMap<Integer, PeptideVariantMatches>> variantMatches) {
        this.variantMatches = variantMatches;
    }

    public HashMap<String, HashMap<Integer, PeptideVariantMatches>> getVariantMatches() {
        return this.variantMatches;
    }

    public double getMass() {
        if (this.mass < 0.0) {
            throw new IllegalArgumentException("Mass not estimated.");
        }
        return this.mass;
    }

    public double getMass(ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        if (this.mass < 0.0) {
            this.estimateTheoreticMass(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        }
        return this.mass;
    }

    public ModificationMatch[] getVariableModifications() {
        return this.variableModifications == null ? NO_MOD : this.variableModifications;
    }

    public String[] getIndexedVariableModifications() {
        String[] result = new String[this.sequence.length() + 2];
        if (this.variableModifications != null) {
            for (ModificationMatch modificationMatch : this.variableModifications) {
                int site = modificationMatch.getSite();
                if (result[site] != null) {
                    throw new IllegalArgumentException("Two modifications found (" + result[site] + " and " + modificationMatch.getModification() + ") at site " + site + " of peptide " + this.sequence + ".");
                }
                result[site] = modificationMatch.getModification();
            }
        }
        return result;
    }

    public String[] getFixedModifications(ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        String[] result = new String[this.sequence.length() + 2];
        for (String modName : modificationParameters.getFixedModifications()) {
            int[] sites;
            Modification modification = modificationFactory.getModification(modName);
            for (int site : sites = ModificationUtils.getPossibleModificationSites(this, modification, sequenceProvider, modificationsSequenceMatchingParameters)) {
                if (result[site] != null) {
                    throw new IllegalArgumentException("Attempting to put two fixed modifications (" + result[site] + " and " + modification.getName() + " on amino acid " + site + " of peptide " + this.getSequence() + ".");
                }
                result[site] = modification.getName();
            }
        }
        return result;
    }

    public void setVariableModifications(ModificationMatch[] variableModifications) {
        this.variableModifications = variableModifications;
        this.setMass(-1.0);
        this.setKey(NO_KEY);
    }

    public void clearVariableModifications() {
        this.variableModifications = null;
        this.setMass(-1.0);
        this.setKey(NO_KEY);
    }

    public void addVariableModification(ModificationMatch modificationMatch) {
        this.variableModifications = this.variableModifications == null ? new ModificationMatch[1] : Arrays.copyOf(this.variableModifications, this.variableModifications.length + 1);
        this.variableModifications[this.variableModifications.length - 1] = modificationMatch;
        this.setMass(-1.0);
        this.setKey(NO_KEY);
    }

    public void clearVariantMatches() {
        if (this.variantMatches != null) {
            this.variantMatches.clear();
        }
    }

    public int getPeptideEnd(String proteinAccession, int peptideStart) {
        PeptideVariantMatches peptideVariantMatches;
        HashMap<Integer, PeptideVariantMatches> proteinVariants;
        int peptideEnd = peptideStart + this.sequence.length() - 1;
        if (this.variantMatches != null && (proteinVariants = this.variantMatches.get(proteinAccession)) != null && (peptideVariantMatches = proteinVariants.get(peptideStart)) != null) {
            peptideEnd += peptideVariantMatches.getLengthDiff();
        }
        return peptideEnd;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public int getNMissedCleavages(Enzyme enzyme) {
        return enzyme.getNmissedCleavages(this.sequence);
    }

    public int getNMissedCleavages(DigestionParameters digestionPreferences) {
        return digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme ? digestionPreferences.getEnzymes().stream().mapToInt(enzyme -> this.getNMissedCleavages((Enzyme)enzyme)).min().orElse(0) : 0;
    }

    public long getMatchingKey() {
        return this.matchingKey;
    }

    public void setMatchingKey(long matchingKey) {
        this.matchingKey = matchingKey;
    }

    public long getMatchingKey(SequenceMatchingParameters sequenceMatchingPreferences) {
        if (!this.keySet) {
            String matchingSequence = AminoAcid.getMatchingSequence(this.sequence, sequenceMatchingPreferences);
            this.setMatchingKey(Peptide.getKey(matchingSequence, this.variableModifications));
            this.keySet = true;
        }
        return this.matchingKey;
    }

    public long getKey() {
        return this.key;
    }

    public static long getKey(String sequence, ModificationMatch[] variableModifications) {
        if (variableModifications == null || variableModifications.length == 0) {
            return ExperimentObject.asLong(sequence);
        }
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        String modificationsKey = Arrays.stream(variableModifications).map(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred() ? Arrays.stream(new String[]{modificationFactory.getModification(modificationMatch.getModification()).getAmbiguityKey(), MODIFICATION_LOCALIZATION_SEPARATOR, Integer.toString(modificationMatch.getSite())}).collect(Collectors.joining()) : modificationFactory.getModification(modificationMatch.getModification()).getAmbiguityKey()).sorted().collect(Collectors.joining(MODIFICATION_SEPARATOR));
        String keyAsString = String.join((CharSequence)MODIFICATION_SEPARATOR, sequence, modificationsKey);
        return ExperimentObject.asLong(keyAsString);
    }

    public int getNVariableModifications(double modificationMass) {
        return this.variableModifications == null ? 0 : (int)Arrays.stream(this.variableModifications).map(modificationMatch -> ModificationFactory.getInstance().getModification(modificationMatch.getModification())).filter(modification -> modification.getMass() == modificationMass).count();
    }

    public int getNVariableModifications() {
        return this.variableModifications == null ? 0 : this.variableModifications.length;
    }

    public ArrayList<Integer> getPotentialModificationSitesNoCombination(Modification modification, String proteinSequence, int peptideStart) {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>(1);
        switch (modification.getModificationType()) {
            case modaa: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                if (aminoAcidPattern.length() == 1) {
                    for (int i = 0; i < this.sequence.length(); ++i) {
                        char aa = this.sequence.charAt(i);
                        if (!targetedAA.contains(Character.valueOf(aa))) continue;
                        possibleSites.add(i + 1);
                    }
                } else {
                    for (int i = 0; i < this.sequence.length(); ++i) {
                        Character aa = Character.valueOf(this.sequence.charAt(i));
                        if (!targetedAA.contains(aa) || !aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, peptideStart + i)) continue;
                        possibleSites.add(i + 1);
                    }
                }
                return possibleSites;
            }
            case modc_protein: {
                int peptideEnd = this.getPeptideEnd(proteinSequence, peptideStart);
                if (peptideEnd == proteinSequence.length() - 1) {
                    possibleSites.add(peptideEnd + 1);
                }
                return possibleSites;
            }
            case modc_peptide: {
                possibleSites.add(this.sequence.length());
                return possibleSites;
            }
            case modn_protein: {
                if (peptideStart == 0) {
                    possibleSites.add(1);
                }
                return possibleSites;
            }
            case modn_peptide: {
                possibleSites.add(1);
                return possibleSites;
            }
            case modcaa_protein: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                int peptideEnd = this.getPeptideEnd(proteinSequence, peptideStart);
                if (peptideEnd == proteinSequence.length() - 1) {
                    Character aa = Character.valueOf(this.sequence.charAt(this.sequence.length() - 1));
                    if (aminoAcidPattern.length() == 1) {
                        if (targetedAA.contains(aa)) {
                            possibleSites.add(this.sequence.length());
                        }
                    } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, peptideEnd)) {
                        possibleSites.add(this.sequence.length());
                    }
                }
                return possibleSites;
            }
            case modcaa_peptide: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                Character aa = Character.valueOf(this.sequence.charAt(this.sequence.length() - 1));
                if (aminoAcidPattern.length() == 1) {
                    if (targetedAA.contains(aa)) {
                        possibleSites.add(this.sequence.length());
                    }
                } else {
                    int peptideEnd = this.getPeptideEnd(proteinSequence, peptideStart);
                    if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, peptideEnd)) {
                        possibleSites.add(this.sequence.length());
                    }
                }
                return possibleSites;
            }
            case modnaa_protein: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                if (peptideStart == 0) {
                    Character aa = Character.valueOf(this.sequence.charAt(0));
                    if (aminoAcidPattern.length() == 1) {
                        if (targetedAA.contains(aa)) {
                            possibleSites.add(1);
                        }
                    } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, 0)) {
                        possibleSites.add(1);
                    }
                }
                return possibleSites;
            }
            case modnaa_peptide: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                Character aa = Character.valueOf(this.sequence.charAt(0));
                if (aminoAcidPattern.length() == 1) {
                    if (targetedAA.contains(aa)) {
                        possibleSites.add(1);
                    }
                } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, 0)) {
                    possibleSites.add(1);
                }
                return possibleSites;
            }
        }
        throw new UnsupportedOperationException("Modification site not implemented for modification of type " + (Object)((Object)modification.getModificationType()) + ".");
    }

    public boolean isSameSequenceAndModificationStatus(Peptide anotherPeptide, SequenceMatchingParameters sequenceMatchingPreferences) {
        return this.isSameSequence(anotherPeptide, sequenceMatchingPreferences) && this.isSameModificationStatus(anotherPeptide);
    }

    public boolean isSameSequence(Peptide anotherPeptide, SequenceMatchingParameters sequenceMatchingPreferences) {
        String otherSequence = anotherPeptide.getSequence();
        if (this.sequence.length() != otherSequence.length()) {
            return false;
        }
        String matchingSequence = AminoAcid.getMatchingSequence(this.sequence, sequenceMatchingPreferences);
        String otherMatchingSequence = AminoAcid.getMatchingSequence(otherSequence, sequenceMatchingPreferences);
        return matchingSequence.equals(otherMatchingSequence);
    }

    public boolean isSameModificationStatus(Peptide anotherPeptide) {
        if (this.getNVariableModifications() != anotherPeptide.getNVariableModifications()) {
            return false;
        }
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        ModificationMatch[] modificationMatches1 = this.getVariableModifications();
        Map<Double, Long> masses1 = Arrays.stream(modificationMatches1).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.counting()));
        ModificationMatch[] modificationMatches2 = anotherPeptide.getVariableModifications();
        Map<Double, Long> masses2 = Arrays.stream(modificationMatches2).collect(Collectors.groupingBy(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass(), Collectors.counting()));
        if (masses1.size() != masses2.size()) {
            return false;
        }
        return !masses1.entrySet().stream().anyMatch(entry -> masses2.get(entry.getKey()) == null || !((Long)entry.getValue()).equals(masses2.get(entry.getKey())));
    }

    public boolean sameModificationsAs(Peptide anotherPeptide, ArrayList<String> modifications) {
        int position;
        ArrayList<Integer> sites;
        double tempMass;
        String modName;
        if (this.getNVariableModifications() != anotherPeptide.getNVariableModifications()) {
            return false;
        }
        HashMap modificationToPositionsMap1 = new HashMap();
        HashMap modificationToPositionsMap2 = new HashMap();
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        for (ModificationMatch modificationMatch : this.getVariableModifications()) {
            modName = modificationMatch.getModification();
            if (!modifications.contains(modName)) continue;
            tempMass = modificationFactory.getModification(modName).getMass();
            sites = (ArrayList<Integer>)modificationToPositionsMap1.get(tempMass);
            if (sites == null) {
                sites = new ArrayList<Integer>();
                modificationToPositionsMap1.put(tempMass, sites);
            }
            position = modificationMatch.getSite();
            sites.add(position);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getVariableModifications()) {
            modName = modificationMatch.getModification();
            if (!modifications.contains(modName)) continue;
            tempMass = modificationFactory.getModification(modName).getMass();
            sites = (ArrayList<Integer>)modificationToPositionsMap2.get(tempMass);
            if (sites == null) {
                sites = new ArrayList<Integer>();
                modificationToPositionsMap2.put(tempMass, sites);
            }
            position = modificationMatch.getSite();
            sites.add(position);
        }
        Iterator iterator = modificationToPositionsMap1.keySet().iterator();
        while (iterator.hasNext()) {
            double tempMass2 = (Double)iterator.next();
            ArrayList sites1 = (ArrayList)modificationToPositionsMap1.get(tempMass2);
            ArrayList sites2 = (ArrayList)modificationToPositionsMap2.get(tempMass2);
            if (sites2 == null || sites1.size() != sites2.size()) {
                return false;
            }
            Collections.sort(sites1);
            Collections.sort(sites2);
            for (int i = 0; i < sites1.size(); ++i) {
                if (((Integer)sites1.get(i)).intValue() == ((Integer)sites2.get(i)).intValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameModificationsAs(Peptide anotherPeptide) {
        String modName;
        if (this.getNVariableModifications() != anotherPeptide.getNVariableModifications()) {
            return false;
        }
        ArrayList<String> modifications = new ArrayList<String>();
        for (ModificationMatch modificationMatch : this.getVariableModifications()) {
            modName = modificationMatch.getModification();
            if (modifications.contains(modName)) continue;
            modifications.add(modName);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getVariableModifications()) {
            modName = modificationMatch.getModification();
            if (modifications.contains(modName)) continue;
            modifications.add(modName);
        }
        return this.sameModificationsAs(anotherPeptide, modifications);
    }

    public String getTaggedModifiedSequence(ModificationParameters modificationProfile, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationsSequenceMatchingParameters, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, HashSet<String> displayedModifications) {
        String[] confidentModificationSites = new String[this.sequence.length() + 2];
        String[] representativeModificationSites = new String[this.sequence.length() + 2];
        String[] secondaryModificationSites = new String[this.sequence.length() + 2];
        String[] fixedModificationSites = new String[this.sequence.length() + 2];
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        if (this.variableModifications != null) {
            for (ModificationMatch modMatch : this.variableModifications) {
                String modName = modMatch.getModification();
                if (displayedModifications != null && !displayedModifications.contains(modName)) continue;
                int modSite = modMatch.getSite();
                if (modMatch.getConfident()) {
                    confidentModificationSites[modSite] = modName;
                    continue;
                }
                representativeModificationSites[modSite] = modName;
            }
        }
        for (String modName : modificationProfile.getFixedModifications()) {
            int[] sites;
            if (displayedModifications != null && !displayedModifications.contains(modName)) continue;
            Modification modification = modificationFactory.getModification(modName);
            for (int site : sites = ModificationUtils.getPossibleModificationSites(this, modification, sequenceProvider, modificationsSequenceMatchingParameters)) {
                fixedModificationSites[site] = modName;
            }
        }
        return PeptideUtils.getTaggedModifiedSequence(this, modificationProfile, this.getFixedModifications(modificationProfile, sequenceProvider, modificationsSequenceMatchingParameters), this.getIndexedVariableModifications(), confidentModificationSites, representativeModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, includeHtmlStartEndTags, useShortName);
    }

    public void estimateTheoreticMass(ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        double tempMass = StandardMasses.h2o.mass + this.sequence.chars().mapToDouble(aa -> AminoAcid.getAminoAcid((char)aa).getMonoisotopicMass()).sum();
        if (this.variableModifications != null) {
            ModificationFactory modificationFactory = ModificationFactory.getInstance();
            tempMass += Arrays.stream(this.variableModifications).mapToDouble(modificationMatch -> modificationFactory.getModification(modificationMatch.getModification()).getMass()).sum();
        }
        String[] fixedModifications = this.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        this.setMass(tempMass += Arrays.stream(fixedModifications).filter(modName -> modName != null).mapToDouble(modName -> modificationFactory.getModification((String)modName).getMass()).sum());
    }

    public Peptide getNoModPeptide(HashSet<String> forbiddenModifications) {
        ModificationMatch[] filteredVariableModifications = this.variableModifications == null ? null : (ModificationMatch[])Arrays.stream(this.variableModifications).filter(modificationMatch -> !forbiddenModifications.contains(modificationMatch.getModification())).toArray(ModificationMatch[]::new);
        Peptide noModPeptide = new Peptide(this.getSequence(), filteredVariableModifications);
        noModPeptide.setProteinMapping(this.getProteinMapping());
        return noModPeptide;
    }
}

