/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filtering;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public enum FilterItemComparator {
    equal("=", "Equals"),
    higher(">", "Higher"),
    lower("<", "Lower"),
    higherOrEqual(">=", "Higher or Equal"),
    lowerOrEqual("<=", "Lower or Equal"),
    contains("contains", "Contains"),
    excludes("excludes", "Does not contain"),
    matches("matches", "Matches the given regular expression");

    public final String name;
    public final String description;
    public static final String[] trueFalse;

    private FilterItemComparator(String symbol, String description) {
        this.name = symbol;
        this.description = description;
    }

    public boolean passes(String threshold, double value) {
        switch (this) {
            case equal: {
                return Double.parseDouble(threshold) == value;
            }
            case higher: {
                return value > Double.parseDouble(threshold);
            }
            case lower: {
                return value < Double.parseDouble(threshold);
            }
            case higherOrEqual: {
                return value >= Double.parseDouble(threshold);
            }
            case lowerOrEqual: {
                return value <= Double.parseDouble(threshold);
            }
            case contains: {
                return Double.toString(value).contains(threshold);
            }
            case excludes: {
                return !Double.toString(value).contains(threshold);
            }
            case matches: {
                return Double.toString(value).matches(threshold);
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, String value) {
        switch (this) {
            case equal: {
                return threshold.equals(value);
            }
            case higher: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble > thresholdDouble;
            }
            case lower: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble < thresholdDouble;
            }
            case higherOrEqual: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble >= thresholdDouble;
            }
            case lowerOrEqual: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble <= thresholdDouble;
            }
            case contains: {
                return value.contains(threshold);
            }
            case excludes: {
                return !value.contains(threshold);
            }
            case matches: {
                return value.matches(threshold);
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, Collection<String> values) {
        return this.passes(threshold, values.stream());
    }

    public boolean passes(String threshold, String[] values) {
        return this.passes(threshold, Arrays.stream(values));
    }

    public boolean passes(String threshold, Stream<String> values) {
        switch (this) {
            case equal: 
            case higher: 
            case lower: 
            case higherOrEqual: 
            case lowerOrEqual: 
            case contains: 
            case matches: {
                values.anyMatch(value -> this.passes(threshold, (String)value));
            }
            case excludes: {
                values.allMatch(value -> this.passes(threshold, (String)value));
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public String toString() {
        return this.name;
    }

    private FilterItemComparator() {
        this.name = "";
        this.description = "";
    }

    static {
        trueFalse = new String[]{"Yes", "No"};
    }
}

