/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.features;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesCache;
import com.compomics.util.experiment.identification.filtering.ProteinFilter;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.spectrumcounting.SpectrumCountingMethod;
import com.compomics.util.experiment.units.MetricsPrefix;
import com.compomics.util.experiment.units.StandardUnit;
import com.compomics.util.experiment.units.UnitOfMeasurement;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.threading.ObjectMutex;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class IdentificationFeaturesGenerator {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private IdentificationFeaturesCache identificationFeaturesCache = new IdentificationFeaturesCache();
    private final Metrics metrics;
    private final Identification identification;
    private final IdentificationParameters identificationParameters;
    private SpectrumCountingParameters spectrumCountingPreferences;
    private final ConcurrentHashMap<String, NonSymmetricalNormalDistribution> massErrorDistribution = new ConcurrentHashMap(1);
    private final ObjectMutex massErrorDistributionMutex = new ObjectMutex();

    public IdentificationFeaturesGenerator() {
        this.sequenceProvider = null;
        this.spectrumProvider = null;
        this.metrics = null;
        this.identification = null;
        this.identificationParameters = null;
    }

    public IdentificationFeaturesGenerator(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, Metrics metrics, SpectrumCountingParameters spectrumCountingPreferences) {
        this.metrics = metrics;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.identificationParameters = identificationParameters;
        this.identification = identification;
        this.spectrumCountingPreferences = spectrumCountingPreferences;
    }

    public void setMassErrorDistribution(String spectrumFile, double[] precursorMzDeviations) {
        NonSymmetricalNormalDistribution distribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistributionFromSortedArray(precursorMzDeviations);
        this.massErrorDistribution.put(spectrumFile, distribution);
    }

    public NonSymmetricalNormalDistribution getMassErrorDistribution(String spectrumFile) {
        if (this.massErrorDistribution == null || this.massErrorDistribution.get(spectrumFile) == null) {
            this.massErrorDistributionMutex.acquire(spectrumFile);
            this.estimateMassErrorDistribution(spectrumFile);
            this.massErrorDistributionMutex.release(spectrumFile);
        }
        return this.massErrorDistribution.get(spectrumFile);
    }

    private void estimateMassErrorDistribution(String spectrumFile) {
        HashSet<Long> spectrumMatchesKeys = this.identification.getSpectrumIdentification().get(spectrumFile);
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        double[] precursorMzDeviations = spectrumMatchesKeys.stream().map(key -> this.identification.getSpectrumMatch((long)key)).filter(spectrumMatch -> spectrumMatch.getBestPeptideAssumption() != null && ((PSParameter)spectrumMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated() && !PeptideUtils.isDecoy(spectrumMatch.getBestPeptideAssumption().getPeptide(), this.sequenceProvider)).mapToDouble(spectrumMatch -> spectrumMatch.getBestPeptideAssumption().getDeltaMz(this.spectrumProvider.getPrecursorMz(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle()), searchParameters.isPrecursorAccuracyTypePpm(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())).sorted().toArray();
        if (precursorMzDeviations.length == 0) {
            this.massErrorDistribution.put(spectrumFile, new NonSymmetricalNormalDistribution(0.0, 0.0, 0.0));
        } else {
            this.setMassErrorDistribution(spectrumFile, precursorMzDeviations);
        }
    }

    public double[] getCoverableAA(long proteinMatchKey) {
        double[] result = (double[])this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.coverable_AA_p, proteinMatchKey);
        if (result == null) {
            result = this.estimateCoverableAA(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.coverable_AA_p, proteinMatchKey, result);
        }
        return result;
    }

    public int[] getAACoverage(long proteinMatchKey) {
        int[] result = (int[])this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.AA_coverage, proteinMatchKey);
        if (result == null) {
            result = this.estimateAACoverage(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.AA_coverage, proteinMatchKey, result);
        }
        return result;
    }

    public void updateCoverableAA(long proteinMatchKey) {
        double[] result = this.estimateCoverableAA(proteinMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.coverable_AA_p, proteinMatchKey, result);
    }

    public TreeSet<String> getFoundModifications() {
        return this.metrics.getFoundModifications();
    }

    private HashMap<Integer, Double> estimateSequenceCoverage(long proteinMatchKey) {
        int[] aaCoverage = this.getAACoverage(proteinMatchKey);
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        for (int validationLevel : MatchValidationLevel.getValidationLevelIndexes()) {
            result.put(validationLevel, 0.0);
        }
        for (int validationLevel : aaCoverage) {
            result.put(validationLevel, (Double)result.get(validationLevel) + 1.0);
        }
        ProteinMatch proteinMatch = (ProteinMatch)this.identification.retrieveObject(proteinMatchKey);
        String sequence = this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
        for (int validationLevel : MatchValidationLevel.getValidationLevelIndexes()) {
            result.put(validationLevel, result.get(validationLevel) / (double)sequence.length());
        }
        return result;
    }

    private double estimateValidatedSequenceCoverage(long proteinMatchKey) {
        int[] aaCoverage = this.getAACoverage(proteinMatchKey);
        double nAAValidated = Arrays.stream(aaCoverage).filter(validationLevel -> validationLevel == MatchValidationLevel.doubtful.getIndex() || validationLevel == MatchValidationLevel.confident.getIndex()).count();
        ProteinMatch proteinMatch = (ProteinMatch)this.identification.retrieveObject(proteinMatchKey);
        String sequence = this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
        return nAAValidated / (double)sequence.length();
    }

    public int[] estimateAACoverage(long proteinMatchKey, boolean enzymatic) {
        return this.estimateAACoverage(proteinMatchKey, false, enzymatic);
    }

    private int[] estimateAACoverage(long proteinMatchKey, boolean allPeptides, boolean enzymatic) {
        PeptideMatch peptideMatch;
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        String accession = proteinMatch.getLeadingAccession();
        String sequence = this.sequenceProvider.getSequence(accession);
        HashMap coverage = new HashMap();
        PeptideMatchesIterator peptideMatchesIterator = this.identification.getPeptideMatchesIterator(proteinMatch.getPeptideMatchesKeys(), null);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            DigestionParameters digestionParameters;
            Peptide peptide = peptideMatch.getPeptide();
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
            boolean enzymaticPeptide = false;
            if (!allPeptides && (digestionParameters = this.identificationParameters.getSearchParameters().getDigestionParameters()).getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                enzymaticPeptide = PeptideUtils.isEnzymatic(peptide, accession, sequence, digestionParameters.getEnzymes());
            }
            if (!allPeptides && (!enzymatic || !enzymaticPeptide) && (enzymatic || enzymaticPeptide)) continue;
            int validationLevel = psParameter.getMatchValidationLevel().getIndex();
            HashSet<Integer> validationLevelCoverage = (HashSet<Integer>)coverage.get(validationLevel);
            if (validationLevelCoverage == null) {
                validationLevelCoverage = new HashSet<Integer>(peptide.getSequence().length());
                coverage.put(validationLevel, validationLevelCoverage);
            }
            for (int peptideStart : peptide.getProteinMapping().get(accession)) {
                int peptideEnd = peptide.getPeptideEnd(accession, peptideStart);
                for (int j = peptideStart; j <= peptideEnd; ++j) {
                    validationLevelCoverage.add(j);
                }
            }
        }
        TreeMap validationLevels = new TreeMap(coverage);
        int[] result = new int[sequence.length()];
        for (int i = 0; i < sequence.length(); ++i) {
            result[i] = MatchValidationLevel.none.getIndex();
        }
        for (Map.Entry entry : validationLevels.entrySet()) {
            Iterator iterator = ((HashSet)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                result[index] = (Integer)entry.getKey();
            }
        }
        return result;
    }

    private int[] estimateAACoverage(long proteinMatchKey) {
        return this.estimateAACoverage(proteinMatchKey, true, true);
    }

    private double[] estimateCoverableAA(long proteinMatchKey) {
        ProteinMatch proteinMatch = (ProteinMatch)this.identification.retrieveObject(proteinMatchKey);
        String accession = proteinMatch.getLeadingAccession();
        String sequence = this.sequenceProvider.getSequence(accession);
        double[] result = new double[sequence.length()];
        NonSymmetricalNormalDistribution peptideLengthDistribution = this.metrics.getPeptideLengthDistribution();
        DigestionParameters digestionPreferences = this.identificationParameters.getSearchParameters().getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = 1.0;
            }
            return result;
        }
        int lastCleavage = -1;
        char previousChar = sequence.charAt(0);
        for (int i = 0; i < sequence.length() - 1; ++i) {
            double p = 1.0;
            char nextChar = sequence.charAt(i + 1);
            boolean cleavage = false;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                if (!enzyme.isCleavageSite(previousChar, nextChar)) continue;
                cleavage = true;
                break;
            }
            if (cleavage) {
                int length = i - lastCleavage;
                if (peptideLengthDistribution == null) {
                    int pepMax = this.identificationParameters.getPeptideAssumptionFilter().getMaxPepLength();
                    if (length > pepMax) {
                        p = 0.0;
                    }
                } else {
                    p = peptideLengthDistribution.getProbabilityAt(length);
                }
                for (int j = lastCleavage + 1; j <= i; ++j) {
                    result[j] = p;
                }
                lastCleavage = i;
            }
            previousChar = nextChar;
        }
        double p = 1.0;
        int length = sequence.length() - 1 - lastCleavage;
        if (peptideLengthDistribution == null) {
            int pepMax = this.identificationParameters.getPeptideAssumptionFilter().getMaxPepLength();
            if (length > pepMax) {
                p = 0.0;
            }
        } else {
            p = peptideLengthDistribution.getProbabilityAt(length);
        }
        for (int j = lastCleavage + 1; j < sequence.length(); ++j) {
            result[j] = p;
        }
        return result;
    }

    public double getValidatedSequenceCoverage(long proteinMatchKey) {
        Double result = (Double)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.sequence_coverage, proteinMatchKey);
        if (result == null) {
            result = this.estimateValidatedSequenceCoverage(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.sequence_coverage, proteinMatchKey, result);
        }
        return result;
    }

    public boolean validatedSequenceCoverageInCache(long proteinMatchKey) {
        return this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.sequence_validation_coverage, proteinMatchKey) != null;
    }

    public HashMap<Integer, Double> getSequenceCoverage(long proteinMatchKey) {
        HashMap<Integer, Double> result = (HashMap<Integer, Double>)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.sequence_validation_coverage, proteinMatchKey);
        if (result == null) {
            result = this.estimateSequenceCoverage(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.sequence_validation_coverage, proteinMatchKey, result);
        }
        return result;
    }

    public boolean sequenceCoverageInCache(long proteinMatchKey) {
        return this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.sequence_validation_coverage, proteinMatchKey) != null;
    }

    public long[] getNonEnzymatic(long proteinMatchKey, DigestionParameters digestionPreferences) {
        long[] result = (long[])this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.tryptic_protein, proteinMatchKey);
        if (result == null) {
            result = this.estimateNonEnzymatic(proteinMatchKey, digestionPreferences);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.tryptic_protein, proteinMatchKey, result);
        }
        return result;
    }

    private long[] estimateNonEnzymatic(long proteinMatchKey, DigestionParameters digestionPreferences) {
        ProteinMatch proteinMatch = (ProteinMatch)this.identification.retrieveObject(proteinMatchKey);
        long[] peptideKeys = proteinMatch.getPeptideMatchesKeys();
        return digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme ? Arrays.stream(peptideKeys).filter(key -> ((PSParameter)this.identification.getPeptideMatch(key).getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated() && !PeptideUtils.isEnzymatic(this.identification.getPeptideMatch(key).getPeptide(), this.sequenceProvider, digestionPreferences.getEnzymes())).toArray() : new long[]{};
    }

    public void updateSequenceCoverage(long proteinMatchKey) {
        HashMap<Integer, Double> result = this.estimateSequenceCoverage(proteinMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.sequence_validation_coverage, proteinMatchKey, result);
    }

    public double getNormalizedSpectrumCounting(long proteinMatchKey) {
        return this.getNormalizedSpectrumCounting(proteinMatchKey, this.metrics, this.spectrumCountingPreferences.getUnit(), this.spectrumCountingPreferences.getReferenceMass(), this.spectrumCountingPreferences.getSelectedMethod());
    }

    public double getNormalizedSpectrumCounting(long proteinMatchKey, SpectrumCountingParameters spectrumCountingPreferences, Metrics metrics) {
        return this.getNormalizedSpectrumCounting(proteinMatchKey, metrics, spectrumCountingPreferences.getUnit(), spectrumCountingPreferences.getReferenceMass(), spectrumCountingPreferences.getSelectedMethod());
    }

    public double getNormalizedSpectrumCounting(long proteinMatchKey, UnitOfMeasurement unit, SpectrumCountingMethod method) {
        return this.getNormalizedSpectrumCounting(proteinMatchKey, this.metrics, unit, this.spectrumCountingPreferences.getReferenceMass(), method);
    }

    public double getNormalizedSpectrumCounting(long proteinMatchKey, Metrics metrics, UnitOfMeasurement unit, Double referenceMass, SpectrumCountingMethod method) {
        double spectrumCounting = this.getSpectrumCounting(proteinMatchKey, method);
        if (this.spectrumCountingPreferences.getNormalize().booleanValue()) {
            String unitFullName = unit.getFullName();
            StandardUnit standardUnit = StandardUnit.getStandardUnit(unitFullName);
            if (standardUnit == null) {
                throw new UnsupportedOperationException("Unit " + unitFullName + " not supported.");
            }
            switch (standardUnit) {
                case mol: {
                    if (referenceMass == null) {
                        throw new IllegalArgumentException("Reference mass missing for abundance normalization.");
                    }
                    MetricsPrefix metricsPrefix = unit.getMetricsPrefix();
                    int unitCorrection = 9 + metricsPrefix.POWER;
                    Double result = spectrumCounting * Math.pow(10.0, -unitCorrection);
                    result = result * referenceMass;
                    Double totalCounting = metrics.getTotalSpectrumCountingMass();
                    result = result / totalCounting;
                    return result;
                }
                case percentage: {
                    Double totalCounting = metrics.getTotalSpectrumCounting();
                    Double result = 100.0 * spectrumCounting / totalCounting;
                    return result;
                }
                case ppm: {
                    Double totalCounting = metrics.getTotalSpectrumCounting();
                    Double result = 1000000.0 * spectrumCounting / totalCounting;
                    return result;
                }
            }
            throw new UnsupportedOperationException("Unit " + unitFullName + " not supported.");
        }
        return spectrumCounting;
    }

    public double getSpectrumCounting(long proteinMatchKey) {
        return this.getSpectrumCounting(proteinMatchKey, this.spectrumCountingPreferences.getSelectedMethod());
    }

    public Double getSpectrumCounting(long proteinMatchKey, SpectrumCountingMethod method) {
        if (method == this.spectrumCountingPreferences.getSelectedMethod()) {
            Double result = (Double)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.spectrum_counting, proteinMatchKey);
            if (result == null) {
                result = this.estimateSpectrumCounting(proteinMatchKey);
                this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.spectrum_counting, proteinMatchKey, result);
            }
            return result;
        }
        SpectrumCountingParameters tempPreferences = new SpectrumCountingParameters();
        tempPreferences.setSelectedMethod(method);
        return IdentificationFeaturesGenerator.estimateSpectrumCounting(this.identification, this.sequenceProvider, proteinMatchKey, tempPreferences, this.identificationParameters.getPeptideAssumptionFilter().getMaxPepLength(), this.identificationParameters);
    }

    public boolean spectrumCountingInCache(long proteinMatchKey) {
        Double result = (Double)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.spectrum_counting, proteinMatchKey);
        return result != null;
    }

    private double estimateSpectrumCounting(long proteinMatchKey) {
        return IdentificationFeaturesGenerator.estimateSpectrumCounting(this.identification, this.sequenceProvider, proteinMatchKey, this.spectrumCountingPreferences, this.identificationParameters.getPeptideAssumptionFilter().getMaxPepLength(), this.identificationParameters);
    }

    public static double estimateSpectrumCounting(Identification identification, SequenceProvider sequenceProvider, long proteinMatchKey, SpectrumCountingParameters spectrumCountingPreferences, int maxPepLength, IdentificationParameters identificationParameters) {
        ProteinMatch proteinMatch = (ProteinMatch)identification.retrieveObject(proteinMatchKey);
        DigestionParameters digestionPreferences = identificationParameters.getSearchParameters().getDigestionParameters();
        if (spectrumCountingPreferences.getSelectedMethod() == SpectrumCountingMethod.NSAF) {
            PeptideMatch peptideMatch2;
            double result = 0.0;
            PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(proteinMatch.getPeptideMatchesKeys(), null);
            while ((peptideMatch2 = peptideMatchesIterator.next()) != null) {
                PSParameter psParameter = (PSParameter)peptideMatch2.getUrParam(PSParameter.dummy);
                if (psParameter.getMatchValidationLevel().getIndex() < spectrumCountingPreferences.getMatchValidationLevel()) continue;
                Peptide peptide = peptideMatch2.getPeptide();
                int peptideOccurrence = identification.getProteinMatches(peptideMatch2.getKey()).stream().map(groupKey -> identification.getProteinMatch((long)groupKey)).filter(sharedGroup -> ((PSParameter)sharedGroup.getUrParam(PSParameter.dummy)).getMatchValidationLevel().getIndex() >= spectrumCountingPreferences.getMatchValidationLevel()).filter(sharedGroup -> peptide.getProteinMapping().containsKey(sharedGroup.getLeadingAccession())).mapToInt(sharedGroup -> peptide.getProteinMapping().get(sharedGroup.getLeadingAccession()).length).sum();
                double spectrumCount = Arrays.stream(peptideMatch2.getSpectrumMatchesKeys()).mapToObj(key -> identification.getSpectrumMatch(key)).filter(spectrumMatch -> ((PSParameter)spectrumMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().getIndex() >= spectrumCountingPreferences.getMatchValidationLevel()).count();
                double ratio = spectrumCount / (double)peptideOccurrence;
                result += ratio;
            }
            String proteinSequence = sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
            result = digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme ? (result /= (double)ProteinUtils.getObservableLength(proteinSequence, digestionPreferences.getEnzymes(), maxPepLength)) : (result /= (double)proteinSequence.length());
            if (Double.valueOf(result).isInfinite() || Double.valueOf(result).isNaN()) {
                result = 0.0;
            }
            return result;
        }
        double result = Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(key -> identification.getPeptideMatch(key)).filter(peptideMatch -> ((PSParameter)peptideMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().getIndex() >= spectrumCountingPreferences.getMatchValidationLevel()).count();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            String proteinSequence = sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
            result = Math.pow(10.0, result / (double)(ProteinUtils.getNCleavageSites(proteinSequence, digestionPreferences.getEnzymes()) + 1)) - 1.0;
        } else {
            result = Math.pow(10.0, result) - 1.0;
        }
        if (Double.valueOf(result).isInfinite() || Double.valueOf(result).isNaN()) {
            result = 0.0;
        }
        return result;
    }

    public double getObservableCoverage(long proteinMatchKey) {
        Double result = (Double)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.expected_coverage, proteinMatchKey);
        if (result == null) {
            result = this.estimateObservableCoverage(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.expected_coverage, proteinMatchKey, result);
        }
        return result;
    }

    public boolean observableCoverageInCache(long proteinMatchKey) {
        return this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.expected_coverage, proteinMatchKey) != null;
    }

    public void updateObservableCoverage(long proteinMatchKey) {
        double result = this.estimateObservableCoverage(proteinMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.expected_coverage, proteinMatchKey, result);
    }

    private double estimateObservableCoverage(long proteinMatchKey) {
        DigestionParameters digestionPreferences = this.identificationParameters.getSearchParameters().getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) {
            return 1.0;
        }
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        String leadingAccession = proteinMatch.getLeadingAccession();
        String sequence = this.sequenceProvider.getSequence(leadingAccession);
        double lengthMax = this.identificationParameters.getPeptideAssumptionFilter().getMaxPepLength();
        if (this.metrics.getPeptideLengthDistribution() != null) {
            lengthMax = Math.min(lengthMax, this.metrics.getPeptideLengthDistribution().getValueAtCumulativeProbability(0.99));
        }
        int observableLength = ProteinUtils.getObservableLength(sequence, digestionPreferences.getEnzymes(), lengthMax);
        return (double)observableLength / (double)sequence.length();
    }

    public int getNValidatedProteins() {
        if (this.metrics.getnValidatedProteins() == -1) {
            this.estimateNValidatedProteins();
        }
        return this.metrics.getnValidatedProteins();
    }

    private void estimateNValidatedProteins() {
        this.metrics.setnValidatedProteins((int)this.identification.getProteinIdentification().stream().map(key -> this.identification.getProteinMatch((long)key)).filter(proteinMatch -> !proteinMatch.isDecoy() && ((PSParameter)proteinMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated()).count());
    }

    public int getNConfidentProteins() {
        if (this.metrics.getnConfidentProteins() == -1) {
            this.estimateNConfidentProteins();
        }
        return this.metrics.getnConfidentProteins();
    }

    private void estimateNConfidentProteins() {
        this.metrics.setnConfidentProteins((int)this.identification.getProteinIdentification().stream().map(key -> this.identification.getProteinMatch((long)key)).filter(proteinMatch -> !proteinMatch.isDecoy() && ((PSParameter)proteinMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel() == MatchValidationLevel.confident).count());
    }

    private int estimateNValidatedPeptides(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(key -> this.identification.getPeptideMatch(key)).filter(peptideMatch -> ((PSParameter)peptideMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated()).count();
    }

    private int estimateNConfidentPeptides(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(key -> this.identification.getPeptideMatch(key)).filter(peptideMatch -> ((PSParameter)peptideMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel() == MatchValidationLevel.confident).count();
    }

    public int getNUniquePeptides(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.unique_peptides, proteinMatchKey);
        if (result == null) {
            result = this.estimateNUniquePeptides(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.unique_peptides, proteinMatchKey, result);
        }
        return result;
    }

    private int estimateNUniquePeptides(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(peptideKey -> this.identification.getPeptideMatch(peptideKey)).filter(peptideMatch -> this.identification.getProteinMatches(peptideMatch.getKey()).size() == 1).count();
    }

    public int getNUniqueValidatedPeptides(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.unique_validated_peptides, proteinMatchKey);
        if (result == null) {
            result = this.estimateNUniqueValidatedPeptides(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.unique_validated_peptides, proteinMatchKey, result);
        }
        return result;
    }

    private int estimateNUniqueValidatedPeptides(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(peptideKey -> this.identification.getPeptideMatch(peptideKey)).filter(peptideMatch -> ((PSParameter)peptideMatch.getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated() && this.identification.getProteinMatches(peptideMatch.getKey()).size() == 1).count();
    }

    public boolean hasEnzymaticPeptides(long proteinMatchKey) {
        Boolean result = (Boolean)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.containsEnzymaticPeptides, proteinMatchKey);
        if (result == null) {
            result = this.checkEnzymaticPeptides(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.containsEnzymaticPeptides, proteinMatchKey, result);
        }
        return result;
    }

    private boolean checkEnzymaticPeptides(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        DigestionParameters digestionPreferences = this.identificationParameters.getSearchParameters().getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            return Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(key -> this.identification.getPeptideMatch(key)).anyMatch(peptideMatch -> PeptideUtils.isEnzymatic(peptideMatch.getPeptide(), this.sequenceProvider, digestionPreferences.getEnzymes()));
        }
        return true;
    }

    public int getNEnzymaticTermini(Peptide peptide, String accession) {
        if (!peptide.getProteinMapping().containsKey(accession)) {
            return 0;
        }
        DigestionParameters digestionPreferences = this.identificationParameters.getSearchParameters().getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            String proteinSequence = this.sequenceProvider.getSequence(accession);
            int peptideLength = peptide.getSequence().length();
            return digestionPreferences.getEnzymes().stream().mapToInt(enzyme -> this.getNEnzymaticTermini(peptide.getProteinMapping().get(accession), peptideLength, proteinSequence, (Enzyme)enzyme)).max().orElse(0);
        }
        return 2;
    }

    private int getNEnzymaticTermini(int[] peptideStarts, int peptideLength, String proteinSequence, Enzyme enzyme) {
        return Arrays.stream(peptideStarts).map(peptideStart -> PeptideUtils.getNEnzymaticTermini(peptideStart, peptideStart + peptideLength - 1, proteinSequence, enzyme)).max().orElse(0);
    }

    public int getNValidatedPeptides(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_peptides, proteinMatchKey);
        if (result == null) {
            result = this.estimateNValidatedPeptides(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_validated_peptides, proteinMatchKey, result);
        }
        return result;
    }

    public int getNConfidentPeptides(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_confident_peptides, proteinMatchKey);
        if (result == null) {
            result = this.estimateNConfidentPeptides(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_peptides, proteinMatchKey, result);
        }
        return result;
    }

    public void updateNConfidentPeptides(long proteinMatchKey) {
        Integer result = this.estimateNConfidentPeptides(proteinMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_peptides, proteinMatchKey, result);
    }

    public void updateNConfidentSpectra(long proteinMatchKey) {
        Integer result = this.estimateNConfidentSpectra(proteinMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, proteinMatchKey, result);
    }

    public boolean nValidatedPeptidesInCache(long proteinMatchKey) {
        Object object = this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_peptides, proteinMatchKey);
        return object != null;
    }

    public Integer getNSpectra(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_spectra, proteinMatchKey);
        if (result == null) {
            result = this.estimateNSpectra(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_spectra, proteinMatchKey, result);
        }
        return result;
    }

    public boolean nSpectraInCache(long proteinMatchKey) {
        Object object = this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_spectra, proteinMatchKey);
        return object != null;
    }

    private int estimateNSpectra(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToInt(key -> this.identification.getPeptideMatch(key).getSpectrumCount()).sum();
    }

    public int getMaxNSpectra() {
        return this.identificationFeaturesCache.getMaxSpectrumCount();
    }

    public int getNValidatedSpectra(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, proteinMatchKey);
        if (result == null) {
            result = this.estimateNValidatedSpectra(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, proteinMatchKey, result);
        }
        return result;
    }

    public int getNConfidentSpectra(long proteinMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, proteinMatchKey);
        if (result == null) {
            result = this.estimateNConfidentSpectra(proteinMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, proteinMatchKey, result);
        }
        return result;
    }

    public boolean nValidatedSpectraInCache(long proteinMatchKey) {
        Object object = this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, proteinMatchKey);
        return object != null;
    }

    private int estimateNValidatedSpectra(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).flatMap(key -> Arrays.stream(this.identification.getPeptideMatch(key).getSpectrumMatchesKeys())).filter(key -> ((PSParameter)this.identification.getSpectrumMatch(key).getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated()).count();
    }

    private int estimateNConfidentSpectra(long proteinMatchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
        return (int)Arrays.stream(proteinMatch.getPeptideMatchesKeys()).flatMap(key -> Arrays.stream(this.identification.getPeptideMatch(key).getSpectrumMatchesKeys())).filter(key -> ((PSParameter)this.identification.getSpectrumMatch(key).getUrParam(PSParameter.dummy)).getMatchValidationLevel() == MatchValidationLevel.confident).count();
    }

    public int getNValidatedSpectraForPeptide(long peptideMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, peptideMatchKey);
        if (result == null) {
            result = this.estimateNValidatedSpectraForPeptide(peptideMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, peptideMatchKey, result);
        }
        return result;
    }

    public int getNConfidentSpectraForPeptide(long peptideMatchKey) {
        Integer result = (Integer)this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, peptideMatchKey);
        if (result == null) {
            result = this.estimateNConfidentSpectraForPeptide(peptideMatchKey);
            this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, peptideMatchKey, result);
        }
        return result;
    }

    public void updateNConfidentSpectraForPeptide(long peptideMatchKey) {
        Integer result = this.estimateNConfidentSpectraForPeptide(peptideMatchKey);
        this.identificationFeaturesCache.addObject(IdentificationFeaturesCache.ObjectType.number_of_confident_spectra, peptideMatchKey, result);
    }

    public boolean nValidatedSpectraForPeptideInCache(long peptideMatchKey) {
        Object object = this.identificationFeaturesCache.getObject(IdentificationFeaturesCache.ObjectType.number_of_validated_spectra, peptideMatchKey);
        return object != null;
    }

    private int estimateNConfidentSpectraForPeptide(long peptideMatchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideMatchKey);
        return (int)Arrays.stream(peptideMatch.getSpectrumMatchesKeys()).filter(key -> ((PSParameter)this.identification.getSpectrumMatch(key).getUrParam(PSParameter.dummy)).getMatchValidationLevel() == MatchValidationLevel.confident).count();
    }

    private int estimateNValidatedSpectraForPeptide(long peptideMatchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideMatchKey);
        return (int)Arrays.stream(peptideMatch.getSpectrumMatchesKeys()).filter(key -> ((PSParameter)this.identification.getSpectrumMatch(key).getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated()).count();
    }

    public void clearSpectrumCounting() {
        this.identificationFeaturesCache.removeObjects(IdentificationFeaturesCache.ObjectType.spectrum_counting);
    }

    public String getConfidentModificationSites(IdentificationMatch identificationMatch, String sequence) {
        PSModificationScores modificationsScores = (PSModificationScores)identificationMatch.getUrParam(PSModificationScores.dummy);
        return modificationsScores == null ? "" : modificationsScores.getConfidentlyLocalizedModifications().stream().map(modName -> String.join((CharSequence)"", modName, modificationsScores.getConfidentSitesForModification((String)modName).stream().sorted().map(modSite -> PeptideUtils.getModifiedAaIndex(modSite, sequence.length())).map(site -> String.join((CharSequence)"", sequence.substring((int)site, site + 1), site.toString())).collect(Collectors.joining(", ", " (", ")")))).collect(Collectors.joining(";"));
    }

    public String getConfidentModificationSitesNumber(IdentificationMatch identificationMatch) {
        PSModificationScores modificationScores = (PSModificationScores)identificationMatch.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : modificationScores.getConfidentlyLocalizedModifications().stream().map(modName -> String.join((CharSequence)"", modName, " (", Integer.toString(modificationScores.getConfidentSitesForModification((String)modName).size()), ")")).collect(Collectors.joining(";"));
    }

    public String getAmbiguousModificationSites(IdentificationMatch identificationMatch, String sequence) {
        PSModificationScores modificationScores = (PSModificationScores)identificationMatch.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : modificationScores.getAmbiguouslyLocalizedModifications().stream().map(modName -> String.join((CharSequence)"", modName, " (", this.getSitesSummary(modificationScores.getAmbiguousModificationsSites((String)modName), sequence), ")")).collect(Collectors.joining(";"));
    }

    private String getSitesSummary(HashMap<Integer, HashSet<Integer>> sites, String sequence) {
        return new TreeMap<Integer, HashSet<Integer>>(sites).entrySet().stream().map(entry -> String.join((CharSequence)"", sequence.substring(ModificationUtils.getSite((Integer)entry.getKey(), sequence.length()) - 1, ModificationUtils.getSite((Integer)entry.getKey(), sequence.length())), Integer.toString(ModificationUtils.getSite((Integer)entry.getKey(), sequence.length())), ((HashSet)entry.getValue()).stream().map(index -> Integer.toString(ModificationUtils.getSite(index, sequence.length()))).collect(Collectors.joining(" ", "-{", "}")))).collect(Collectors.joining(","));
    }

    public String getAmbiguousModificationSiteNumber(IdentificationMatch identificationMatch) {
        PSModificationScores modificationScores = (PSModificationScores)identificationMatch.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : modificationScores.getAmbiguouslyLocalizedModifications().stream().map(modName -> String.join((CharSequence)"", modName, " (", Integer.toString(modificationScores.getAmbiguousModificationsSites((String)modName).size()), ")")).collect(Collectors.joining(";"));
    }

    public String getConfidentModificationSites(IdentificationMatch match, String sequence, ArrayList<String> targetedModifications) {
        PSModificationScores modificationScores = (PSModificationScores)match.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : targetedModifications.stream().flatMap(modName -> modificationScores.getConfidentSitesForModification((String)modName).stream()).distinct().sorted().map(modSite -> PeptideUtils.getModifiedAaIndex(modSite, sequence.length())).map(site -> String.join((CharSequence)"", sequence.substring((int)site, site + 1), site.toString())).collect(Collectors.joining(","));
    }

    public String getConfidentModificationSitesNumber(IdentificationMatch match, ArrayList<String> targetedModifications) {
        PSModificationScores modificationScores = (PSModificationScores)match.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : Long.toString(targetedModifications.stream().flatMap(modName -> modificationScores.getConfidentSitesForModification((String)modName).stream()).distinct().count());
    }

    public String getAmbiguousModificationSites(IdentificationMatch match, String sequence, ArrayList<String> targetedModifications) {
        PSModificationScores modificationScores = (PSModificationScores)match.getUrParam(PSModificationScores.dummy);
        if (modificationScores == null) {
            return "";
        }
        TreeMap<Integer, ArrayList<String>> reportPerSite = new TreeMap<Integer, ArrayList<String>>();
        for (String modName : targetedModifications) {
            TreeMap<Integer, HashSet<Integer>> sites = new TreeMap<Integer, HashSet<Integer>>(modificationScores.getAmbiguousModificationsSites(modName));
            for (Map.Entry<Integer, HashSet<Integer>> entry : sites.entrySet()) {
                int representativeSite = entry.getKey();
                HashSet<Integer> ambiguousSites = entry.getValue();
                StringBuilder prefix = new StringBuilder();
                prefix.append(sequence.charAt(representativeSite - 1)).append(representativeSite).append("-{");
                String reportAtSite = ambiguousSites.stream().sorted().map(site -> String.join((CharSequence)"", sequence.substring(site - 1, (int)site), site.toString())).collect(Collectors.joining(" ", prefix, "}"));
                ArrayList<String> reportsAtSite = (ArrayList<String>)reportPerSite.get(representativeSite);
                if (reportsAtSite == null) {
                    reportsAtSite = new ArrayList<String>(1);
                    reportPerSite.put(representativeSite, reportsAtSite);
                }
                reportsAtSite.add(reportAtSite);
            }
        }
        return reportPerSite.values().stream().flatMap(Collection::stream).collect(Collectors.joining(";"));
    }

    public String getAmbiguousModificationSiteNumber(IdentificationMatch match, ArrayList<String> targetedModifications) {
        PSModificationScores modificationScores = (PSModificationScores)match.getUrParam(PSModificationScores.dummy);
        return modificationScores == null ? "" : Long.toString(targetedModifications.stream().flatMap(modName -> modificationScores.getAmbiguousModificationsSites((String)modName).keySet().stream()).distinct().count());
    }

    public String getModifiedSequence(IdentificationMatch identificationMatch, String sequence) {
        PSModificationScores modificationScores = (PSModificationScores)identificationMatch.getUrParam(PSModificationScores.dummy);
        if (modificationScores == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(sequence.length());
        for (int aa = 0; aa < sequence.length(); ++aa) {
            result.append(sequence.charAt(aa));
            int aaNumber = aa + 1;
            HashSet<String> modificationsAtSite = modificationScores.getConfidentModificationsAt(aaNumber);
            if (modificationsAtSite.isEmpty()) continue;
            result.append(modificationsAtSite.stream().sorted().map(modName -> this.modificationFactory.getModification((String)modName).getShortName()).collect(Collectors.joining(",", "<", ">")));
        }
        return result.toString();
    }

    public long[] getValidatedProteins(FilterParameters filterPreferences) {
        return this.getValidatedProteins(null, filterPreferences);
    }

    public long[] getValidatedProteins(WaitingHandler waitingHandler, FilterParameters filterPreferences) {
        long[] result = this.identificationFeaturesCache.getValidatedProteinList();
        if (result == null) {
            this.getProcessedProteinKeys(waitingHandler, filterPreferences);
        }
        return this.identificationFeaturesCache.getValidatedProteinList();
    }

    public long[] getProcessedProteinKeys(WaitingHandler waitingHandler, FilterParameters filterPreferences) {
        if (this.identificationFeaturesCache.getProteinList() == null) {
            Object proteinPsParameter;
            ProteinMatch proteinMatch;
            if (waitingHandler != null) {
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setWaitingText("Loading Protein Information. Please Wait...");
                waitingHandler.setMaxSecondaryProgressCounter(this.identification.getProteinIdentification().size());
            }
            boolean needMaxValues = this.metrics.getMaxNPeptides() == null || this.metrics.getMaxNPeptides() <= 0 || this.metrics.getMaxNPsms() == null || this.metrics.getMaxNPsms() <= 0 || this.metrics.getMaxSpectrumCounting() == null || this.metrics.getMaxSpectrumCounting() <= 0.0 || this.metrics.getMaxMW() == null || this.metrics.getMaxMW() <= 0.0;
            HashMap orderMap = new HashMap();
            ArrayList<Double> scores = new ArrayList<Double>();
            int maxPeptides = 0;
            int maxSpectra = 0;
            double maxSpectrumCounting = 0.0;
            double maxMW = 0.0;
            int nValidatedProteins = 0;
            int nConfidentProteins = 0;
            ProteinMatchesIterator proteinMatchesIterator = this.identification.getProteinMatchesIterator(waitingHandler);
            while ((proteinMatch = proteinMatchesIterator.next()) != null) {
                long proteinKey = proteinMatch.getKey();
                if (!proteinMatch.isDecoy() && !((PSParameter)(proteinPsParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy))).getHidden()) {
                    double score = ((PSParameter)proteinPsParameter).getScore();
                    int nPeptides = -proteinMatch.getPeptideMatchesKeys().length;
                    int nSpectra = -this.getNSpectra(proteinKey).intValue();
                    if (needMaxValues) {
                        String proteinSequence;
                        double mw;
                        double tempSpectrumCounting;
                        if (-nPeptides > maxPeptides) {
                            maxPeptides = -nPeptides;
                        }
                        if (-nSpectra > maxSpectra) {
                            maxSpectra = -nSpectra;
                        }
                        if ((tempSpectrumCounting = this.getNormalizedSpectrumCounting(proteinKey)) > maxSpectrumCounting) {
                            maxSpectrumCounting = tempSpectrumCounting;
                        }
                        if ((mw = ProteinUtils.computeMolecularWeight(proteinSequence = this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession()))) > maxMW) {
                            maxMW = mw;
                        }
                        if (((PSParameter)proteinPsParameter).getMatchValidationLevel().isValidated()) {
                            ++nValidatedProteins;
                            if (((PSParameter)proteinPsParameter).getMatchValidationLevel() == MatchValidationLevel.confident) {
                                ++nConfidentProteins;
                            }
                        }
                    }
                    if (!orderMap.containsKey(score)) {
                        orderMap.put(score, new HashMap(1));
                        scores.add(score);
                    }
                    if (!((HashMap)orderMap.get(score)).containsKey(nPeptides)) {
                        ((HashMap)orderMap.get(score)).put(nPeptides, new HashMap(1));
                    }
                    if (!((HashMap)((HashMap)orderMap.get(score)).get(nPeptides)).containsKey(nSpectra)) {
                        ((HashMap)((HashMap)orderMap.get(score)).get(nPeptides)).put(nSpectra, new ArrayList(1));
                    }
                    ((ArrayList)((HashMap)((HashMap)orderMap.get(score)).get(nPeptides)).get(nSpectra)).add(proteinKey);
                }
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                return null;
            }
            if (needMaxValues) {
                this.metrics.setMaxNPeptides(maxPeptides);
                this.metrics.setMaxNPsms(maxSpectra);
                this.metrics.setMaxSpectrumCounting(maxSpectrumCounting);
                this.metrics.setMaxMW(maxMW);
                this.metrics.setnValidatedProteins(nValidatedProteins);
                this.metrics.setnConfidentProteins(nConfidentProteins);
            }
            ArrayList proteinList = new ArrayList();
            ArrayList scoreList = new ArrayList(orderMap.keySet());
            Collections.sort(scoreList);
            if (waitingHandler != null) {
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setWaitingText("Updating Protein Table. Please Wait...");
                waitingHandler.setMaxSecondaryProgressCounter(this.identification.getProteinIdentification().size());
            }
            proteinPsParameter = scoreList.iterator();
            while (proteinPsParameter.hasNext()) {
                double currentScore = (Double)proteinPsParameter.next();
                ArrayList nPeptideList = new ArrayList(((HashMap)orderMap.get(currentScore)).keySet());
                Collections.sort(nPeptideList);
                Iterator iterator = nPeptideList.iterator();
                while (iterator.hasNext()) {
                    int currentNPeptides = (Integer)iterator.next();
                    ArrayList nPsmList = new ArrayList(((HashMap)((HashMap)orderMap.get(currentScore)).get(currentNPeptides)).keySet());
                    Collections.sort(nPsmList);
                    Iterator iterator2 = nPsmList.iterator();
                    while (iterator2.hasNext()) {
                        int currentNPsms = (Integer)iterator2.next();
                        ArrayList tempList = (ArrayList)((HashMap)((HashMap)orderMap.get(currentScore)).get(currentNPeptides)).get(currentNPsms);
                        Collections.sort(tempList);
                        proteinList.addAll(tempList);
                        if (waitingHandler == null) continue;
                        waitingHandler.setMaxSecondaryProgressCounter(tempList.size());
                        if (!waitingHandler.isRunCanceled()) continue;
                        return null;
                    }
                }
            }
            long[] proteinArray = proteinList.stream().mapToLong(Long::longValue).toArray();
            this.identificationFeaturesCache.setProteinList(proteinArray);
            if (waitingHandler != null) {
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
                if (waitingHandler.isRunCanceled()) {
                    return null;
                }
            }
        }
        if (this.hidingNeeded(filterPreferences) || this.identificationFeaturesCache.getProteinListAfterHiding() == null) {
            ArrayList<Long> proteinListAfterHiding = new ArrayList<Long>();
            ArrayList<Long> validatedProteinList = new ArrayList<Long>();
            int nValidatedProteins = 0;
            int nConfidentProteins = 0;
            for (long proteinKey : this.identificationFeaturesCache.getProteinList()) {
                PSParameter psParameter;
                ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinKey);
                if (!proteinMatch.isDecoy() && !(psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy)).getHidden()) {
                    proteinListAfterHiding.add(proteinKey);
                    if (psParameter.getMatchValidationLevel().isValidated()) {
                        ++nValidatedProteins;
                        validatedProteinList.add(proteinKey);
                        if (psParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                            ++nConfidentProteins;
                        }
                    }
                }
                if (waitingHandler == null) continue;
                waitingHandler.setPrimaryProgressCounterIndeterminate(true);
                if (!waitingHandler.isRunCanceled()) continue;
                return null;
            }
            long[] proteinArrayAfterHiding = proteinListAfterHiding.stream().mapToLong(Long::longValue).toArray();
            this.identificationFeaturesCache.setProteinListAfterHiding(proteinArrayAfterHiding);
            long[] validatedProteinArray = validatedProteinList.stream().mapToLong(Long::longValue).toArray();
            this.identificationFeaturesCache.setValidatedProteinList(validatedProteinArray);
            this.metrics.setnValidatedProteins(nValidatedProteins);
            this.metrics.setnConfidentProteins(nConfidentProteins);
        }
        return this.identificationFeaturesCache.getProteinListAfterHiding();
    }

    public long[] getProteinKeys(WaitingHandler waitingHandler, FilterParameters filterPreferences) {
        if (this.identificationFeaturesCache.getProteinList() == null) {
            this.getProcessedProteinKeys(waitingHandler, filterPreferences);
        }
        return this.identificationFeaturesCache.getProteinList();
    }

    public long[] getSortedPeptideKeys(long proteinKey) {
        if (proteinKey != this.identificationFeaturesCache.getCurrentProteinKey() || this.identificationFeaturesCache.getPeptideList() == null) {
            ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinKey);
            TreeMap peptideMap = Arrays.stream(proteinMatch.getPeptideMatchesKeys()).filter(peptideKey -> !((PSParameter)this.identification.getPeptideMatch(peptideKey).getUrParam(PSParameter.dummy)).getHidden()).boxed().collect(Collectors.groupingBy(peptideKey -> ((PSParameter)this.identification.getPeptideMatch((long)peptideKey).getUrParam(PSParameter.dummy)).getScore(), TreeMap::new, Collectors.groupingBy(peptideKey -> this.identification.getPeptideMatch((long)peptideKey).getSpectrumCount(), TreeMap::new, Collectors.toCollection(TreeSet::new))));
            int maxSpectrumCount = peptideMap.values().stream().mapToInt(map -> (Integer)map.lastKey()).max().orElse(0);
            this.identificationFeaturesCache.setMaxSpectrumCount(maxSpectrumCount);
            long[] sortedKeys = peptideMap.values().stream().flatMap(map -> map.descendingMap().values().stream()).flatMap(subKeys -> subKeys.stream()).mapToLong(a -> a).toArray();
            this.identificationFeaturesCache.setPeptideList(sortedKeys);
            this.identificationFeaturesCache.setCurrentProteinKey(proteinKey);
        }
        return this.identificationFeaturesCache.getPeptideList();
    }

    public long[] getSortedPsmKeys(long peptideKey, boolean sortOnRt, boolean forceUpdate) {
        if (peptideKey != this.identificationFeaturesCache.getCurrentPeptideKey() || this.identificationFeaturesCache.getPsmList() == null || forceUpdate) {
            Object psParameter;
            SpectrumMatch spectrumMatch;
            PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
            HashMap orderingMap = new HashMap(1);
            double precursorRT = Double.NaN;
            boolean hasRT = sortOnRt;
            int nValidatedPsms = 0;
            long[] spectrumKeys = peptideMatch.getSpectrumMatchesKeys();
            SpectrumMatchesIterator psmIterator = this.identification.getSpectrumMatchesIterator(spectrumKeys, null);
            while ((spectrumMatch = psmIterator.next()) != null) {
                int charge;
                long matchKey = spectrumMatch.getKey();
                psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                if (((PSParameter)psParameter).getHidden()) continue;
                if (((PSParameter)psParameter).getMatchValidationLevel().isValidated()) {
                    ++nValidatedPsms;
                }
                if (!orderingMap.containsKey(charge = spectrumMatch.getBestPeptideAssumption().getIdentificationCharge())) {
                    orderingMap.put(charge, new HashMap(spectrumKeys.length));
                }
                if (hasRT) {
                    try {
                        precursorRT = this.spectrumProvider.getPrecursorRt(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
                        if (Double.isNaN(precursorRT)) {
                            hasRT = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        hasRT = false;
                    }
                }
                if (!hasRT) {
                    precursorRT = ((PSParameter)psParameter).getScore();
                }
                if (!((HashMap)orderingMap.get(charge)).containsKey(precursorRT)) {
                    ((HashMap)orderingMap.get(charge)).put(precursorRT, new ArrayList(1));
                }
                ((ArrayList)((HashMap)orderingMap.get(charge)).get(precursorRT)).add(matchKey);
            }
            this.identificationFeaturesCache.setnValidatedPsms(nValidatedPsms);
            ArrayList charges = new ArrayList(orderingMap.keySet());
            Collections.sort(charges);
            ArrayList psmList = new ArrayList();
            psParameter = charges.iterator();
            while (psParameter.hasNext()) {
                int currentCharge = (Integer)psParameter.next();
                ArrayList rts = new ArrayList(((HashMap)orderingMap.get(currentCharge)).keySet());
                Collections.sort(rts);
                Iterator iterator = rts.iterator();
                while (iterator.hasNext()) {
                    double currentRT = (Double)iterator.next();
                    ArrayList tempResult = (ArrayList)((HashMap)orderingMap.get(currentCharge)).get(currentRT);
                    Collections.sort(tempResult);
                    psmList.addAll(tempResult);
                }
            }
            long[] psmArray = psmList.stream().mapToLong(Long::longValue).toArray();
            this.identificationFeaturesCache.setPsmList(psmArray);
            this.identificationFeaturesCache.setCurrentPeptideKey(peptideKey);
        }
        return this.identificationFeaturesCache.getPsmList();
    }

    public int getNValidatedPsms() {
        return this.identificationFeaturesCache.getnValidatedPsms();
    }

    private boolean hidingNeeded(FilterParameters filterPreferences) {
        if (filterPreferences == null) {
            return false;
        }
        if (this.identificationFeaturesCache.isFiltered()) {
            return true;
        }
        for (ProteinFilter proteinFilter : filterPreferences.getProteinHideFilters().values()) {
            if (!proteinFilter.isActive()) continue;
            this.identificationFeaturesCache.setFiltered(true);
            return true;
        }
        return false;
    }

    public void setProteinKeys(long[] proteinList) {
        this.identificationFeaturesCache.setProteinList(proteinList);
    }

    public IdentificationFeaturesCache getIdentificationFeaturesCache() {
        return this.identificationFeaturesCache;
    }

    public void setIdentificationFeaturesCache(IdentificationFeaturesCache identificationFeaturesCache) {
        this.identificationFeaturesCache = identificationFeaturesCache;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setSpectrumCountingPreferences(SpectrumCountingParameters spectrumCountingPreferences) {
        this.spectrumCountingPreferences = spectrumCountingPreferences;
    }

    public int getNValidatedProteinGroups(long peptideKey) {
        return this.getNValidatedProteinGroups(peptideKey, null);
    }

    public int getNValidatedProteinGroups(long peptideKey, WaitingHandler waitingHandler) {
        TreeSet<Long> keys = this.identification.getProteinMatches(peptideKey);
        return (int)keys.stream().filter(key -> ((PSParameter)this.identification.getProteinMatch((long)key).getUrParam(PSParameter.dummy)).getMatchValidationLevel().isValidated()).count();
    }
}

