/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.Arrays;
import java.util.TreeMap;

public class PeptideAssumptionFilter
extends ExperimentObject {
    private int minPepLength;
    private int maxPepLength;
    private double maxMassDeviation;
    private boolean isPpm;
    private boolean unknownModification;
    private Integer minMissedCleavages;
    private Integer maxMissedCleavages;
    private Integer minIsotopes;
    private Integer maxIsotopes;

    public PeptideAssumptionFilter() {
        this.minPepLength = 8;
        this.maxPepLength = 30;
        this.maxMassDeviation = -1.0;
        this.isPpm = true;
        this.unknownModification = true;
        this.minMissedCleavages = null;
        this.maxMissedCleavages = null;
        this.minIsotopes = null;
        this.maxIsotopes = null;
    }

    public PeptideAssumptionFilter(int minPepLength, int maxPepLength, double maxMzDeviation, boolean isPpm, boolean unknownModification, Integer minMissedCleavages, Integer maxMissedCleavages, Integer minIsotopes, Integer maxIsotopes) {
        this.minPepLength = minPepLength;
        this.maxPepLength = maxPepLength;
        this.maxMassDeviation = maxMzDeviation;
        this.isPpm = isPpm;
        this.unknownModification = unknownModification;
        this.minMissedCleavages = minMissedCleavages;
        this.maxMissedCleavages = maxMissedCleavages;
        this.minIsotopes = minIsotopes;
        this.maxIsotopes = maxIsotopes;
    }

    public void setFilterFromSearchParameters(SearchParameters searchParameters) {
        this.isPpm = searchParameters.isPrecursorAccuracyTypePpm();
        this.maxMassDeviation = searchParameters.getPrecursorAccuracy();
        this.minIsotopes = searchParameters.getMinIsotopicCorrection();
        this.maxIsotopes = searchParameters.getMaxIsotopicCorrection();
        this.unknownModification = true;
    }

    public boolean validatePeptide(Peptide peptide, SequenceMatchingParameters sequenceMatchingPreferences, DigestionParameters digestionPreferences) {
        String peptideSequence = peptide.getSequence();
        int sequenceLength = peptideSequence.length();
        if (this.maxPepLength > 0 && sequenceLength > this.maxPepLength || this.minPepLength > 0 && sequenceLength < this.minPepLength) {
            return false;
        }
        double xShare = (double)Util.getOccurrence(peptideSequence, 'X') / (double)sequenceLength;
        if (xShare > sequenceMatchingPreferences.getLimitX()) {
            return false;
        }
        if (this.minMissedCleavages != null || this.maxMissedCleavages != null) {
            int peptideMinMissedCleavages = peptide.getNMissedCleavages(digestionPreferences);
            if (this.minMissedCleavages != null && peptideMinMissedCleavages < this.minMissedCleavages) {
                return false;
            }
            if (this.maxMissedCleavages != null && peptideMinMissedCleavages > this.maxMissedCleavages) {
                return false;
            }
        }
        return true;
    }

    public boolean validateProteins(Peptide peptide, SequenceMatchingParameters sequenceMatchingPreferences, SequenceProvider sequenceProvider) {
        TreeMap<String, int[]> proteinMapping = peptide.getProteinMapping();
        if (proteinMapping != null && proteinMapping.size() > 1) {
            boolean target = false;
            boolean decoy = false;
            for (String accession : proteinMapping.navigableKeySet()) {
                if (ProteinUtils.isDecoy(accession, sequenceProvider)) {
                    decoy = true;
                    continue;
                }
                target = true;
            }
            if (target && decoy) {
                return false;
            }
        }
        return true;
    }

    public boolean validateModifications(Peptide peptide, SequenceMatchingParameters sequenceMatchingPreferences, SequenceMatchingParameters modificationSequenceMatchingPreferences, ModificationParameters modificationProfile) {
        ModificationMatch[] modificationMatches;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        return !this.unknownModification || !Arrays.stream(modificationMatches = peptide.getVariableModifications()).map(ModificationMatch::getModification).anyMatch(modName -> !modificationFactory.containsModification((String)modName));
    }

    public boolean validatePrecursor(PeptideAssumption assumption, String spectrumFile, String spectrumTitle, SpectrumProvider spectrumProvider, SearchParameters searchParameters) {
        double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
        int isotopeNumber = assumption.getIsotopeNumber(precursorMz, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
        if (this.minIsotopes != null && isotopeNumber < this.minIsotopes) {
            return false;
        }
        if (this.maxIsotopes != null && isotopeNumber > this.maxIsotopes) {
            return false;
        }
        double mzDeviation = assumption.getDeltaMz(precursorMz, this.isPpm, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
        return this.maxMassDeviation <= 0.0 || Math.abs(mzDeviation) <= this.maxMassDeviation;
    }

    public boolean removeUnknownModifications() {
        return this.unknownModification;
    }

    public void setRemoveUnknownModifications(boolean unknownModification) {
        this.unknownModification = unknownModification;
    }

    public boolean isIsPpm() {
        return this.isPpm;
    }

    public void setIsPpm(boolean isPpm) {
        this.isPpm = isPpm;
    }

    public double getMaxMzDeviation() {
        return this.maxMassDeviation;
    }

    public void setMaxMzDeviation(double maxMzDeviation) {
        this.maxMassDeviation = maxMzDeviation;
    }

    public int getMaxPepLength() {
        return this.maxPepLength;
    }

    public void setMaxPepLength(int maxPepLength) {
        this.maxPepLength = maxPepLength;
    }

    public int getMinPepLength() {
        return this.minPepLength;
    }

    public void setMinPepLength(int minPepLength) {
        this.minPepLength = minPepLength;
    }

    public Integer getMinIsotopes() {
        return this.minIsotopes;
    }

    public void setMinIsotopes(Integer minIsotopes) {
        this.minIsotopes = minIsotopes;
    }

    public Integer getMaxIsotopes() {
        return this.maxIsotopes;
    }

    public void setMaxIsotopes(Integer maxIsotopes) {
        this.maxIsotopes = maxIsotopes;
    }

    public boolean isSameAs(PeptideAssumptionFilter anotherFilter) {
        if (this.minMissedCleavages != null && anotherFilter.getMinMissedCleavages() != null && !this.minMissedCleavages.equals(anotherFilter.getMinMissedCleavages())) {
            return false;
        }
        if (this.minMissedCleavages != null && anotherFilter.getMinMissedCleavages() == null) {
            return false;
        }
        if (this.minMissedCleavages == null && anotherFilter.getMinMissedCleavages() != null) {
            return false;
        }
        if (this.maxMissedCleavages != null && anotherFilter.getMaxMissedCleavages() != null && this.maxMissedCleavages.equals(anotherFilter.getMaxMissedCleavages())) {
            return false;
        }
        if (this.maxMissedCleavages != null && anotherFilter.getMaxMissedCleavages() == null) {
            return false;
        }
        if (this.maxMissedCleavages == null && anotherFilter.getMaxMissedCleavages() != null) {
            return false;
        }
        if (this.minIsotopes != null && anotherFilter.getMinIsotopes() != null && !this.minIsotopes.equals(anotherFilter.getMinIsotopes())) {
            return false;
        }
        if (this.minIsotopes != null && anotherFilter.getMinIsotopes() == null) {
            return false;
        }
        if (this.minIsotopes == null && anotherFilter.getMinIsotopes() != null) {
            return false;
        }
        if (this.maxIsotopes != null && anotherFilter.getMaxIsotopes() != null && !this.maxIsotopes.equals(anotherFilter.getMaxIsotopes())) {
            return false;
        }
        if (this.maxIsotopes != null && anotherFilter.getMaxIsotopes() == null) {
            return false;
        }
        if (this.maxIsotopes == null && anotherFilter.getMaxIsotopes() != null) {
            return false;
        }
        return this.isPpm == anotherFilter.isPpm && this.unknownModification == anotherFilter.removeUnknownModifications() && this.minPepLength == anotherFilter.getMinPepLength() && this.maxPepLength == anotherFilter.getMaxPepLength() && this.maxMassDeviation == anotherFilter.getMaxMzDeviation();
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Peptide Length: ").append(this.minPepLength).append("-").append(this.maxPepLength).append(".").append(newLine);
        if (this.maxMassDeviation >= 0.0) {
            output.append("Precursor m/z Deviation: ").append(this.maxMassDeviation);
            if (this.isPpm) {
                output.append(" ppm.").append(newLine);
            } else {
                output.append(" Da.").append(newLine);
            }
        }
        output.append("Remove Unknown Modifications: ").append(this.unknownModification).append(".").append(newLine);
        if (this.minMissedCleavages != null || this.maxMissedCleavages != null) {
            output.append("Missed Cleavages: ");
            if (this.minMissedCleavages != null) {
                output.append(this.minMissedCleavages);
            } else {
                output.append("0");
            }
            output.append("-");
            if (this.maxMissedCleavages != null) {
                output.append(this.maxMissedCleavages);
            } else {
                output.append("n");
            }
            output.append(".").append(newLine);
        }
        if (this.minIsotopes != null || this.maxIsotopes != null) {
            output.append("Isotopes: ");
            if (this.minIsotopes != null) {
                output.append(this.minIsotopes);
            } else {
                output.append("n");
            }
            output.append("-");
            if (this.maxIsotopes != null) {
                output.append(this.maxIsotopes);
            } else {
                output.append("n");
            }
            output.append(".").append(newLine);
        }
        return output.toString();
    }

    public Integer getMinMissedCleavages() {
        return this.minMissedCleavages;
    }

    public void setMinMissedCleavages(Integer minMissedCleavages) {
        this.minMissedCleavages = minMissedCleavages;
    }

    public Integer getMaxMissedCleavages() {
        return this.maxMissedCleavages;
    }

    public void setMaxMissedCleavages(Integer maxMissedCleavages) {
        this.maxMissedCleavages = maxMissedCleavages;
    }
}

