/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.experiment.identification.filtering.items.PeptideFilterItem;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import java.util.HashSet;
import java.util.stream.Collectors;

public class PeptideFilter
extends MatchFilter {
    static final long serialVersionUID = 959658989341486818L;

    public PeptideFilter() {
        this.filterType = MatchFilter.FilterType.PEPTIDE;
    }

    public PeptideFilter(String name) {
        this.name = name;
        this.filterType = MatchFilter.FilterType.PEPTIDE;
    }

    public PeptideFilter(String name, String description) {
        this.name = name;
        this.description = description;
        this.filterType = MatchFilter.FilterType.PEPTIDE;
    }

    public PeptideFilter(String name, String description, String condition, String reportPassed, String reportFailed) {
        this.name = name;
        this.description = description;
        this.condition = condition;
        this.reportPassed = reportPassed;
        this.reportFailed = reportFailed;
        this.filterType = MatchFilter.FilterType.PEPTIDE;
    }

    @Override
    protected MatchFilter getNew() {
        return new PeptideFilter();
    }

    @Override
    public boolean isValidated(String itemName, FilterItemComparator filterItemComparator, Object value, long matchKey, Identification identification, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider) {
        PeptideFilterItem filterItem = PeptideFilterItem.getItem(itemName);
        if (filterItem == null) {
            throw new IllegalArgumentException("Filter item " + itemName + "not recognized as peptide filter item.");
        }
        String input = value.toString();
        switch (filterItem) {
            case proteinAccession: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                return filterItemComparator.passes(input, peptideMatch.getPeptide().getProteinMapping().keySet());
            }
            case proteinDescription: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                return filterItemComparator.passes(input, peptideMatch.getPeptide().getProteinMapping().keySet().stream().map(accession -> proteinDetailsProvider.getDescription((String)accession)).collect(Collectors.toList()));
            }
            case sequence: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                return filterItemComparator.passes(input, peptideMatch.getPeptide().getSequence());
            }
            case modification: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                PSModificationScores modificationScores = (PSModificationScores)peptideMatch.getUrParam(PSModificationScores.dummy);
                HashSet<String> modifications = modificationScores == null ? new HashSet(0) : modificationScores.getScoredModifications();
                return filterItemComparator.passes(input, modifications);
            }
            case nPSMs: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                int nPsms = peptideMatch.getSpectrumCount();
                return filterItemComparator.passes(input, nPsms);
            }
            case nValidatedPSMs: {
                int nPsms = identificationFeaturesGenerator.getNValidatedSpectraForPeptide(matchKey);
                return filterItemComparator.passes(input, nPsms);
            }
            case nConfidentPSMs: {
                int nPsms = identificationFeaturesGenerator.getNConfidentSpectraForPeptide(matchKey);
                return filterItemComparator.passes(input, nPsms);
            }
            case confidence: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                double confidence = psParameter.getConfidence();
                return filterItemComparator.passes(input, confidence);
            }
            case proteinInference: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                int pi = psParameter.getProteinInferenceGroupClass();
                return filterItemComparator.passes(input, pi);
            }
            case validationStatus: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                int validation = psParameter.getMatchValidationLevel().getIndex();
                return filterItemComparator.passes(input, validation);
            }
            case stared: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                String starred = psParameter.getStarred() ? FilterItemComparator.trueFalse[0] : FilterItemComparator.trueFalse[1];
                return filterItemComparator.passes(input, starred);
            }
        }
        throw new IllegalArgumentException("Protein filter not implemented for item " + filterItem.name + ".");
    }

    @Override
    public FilterItem[] getPossibleFilterItems() {
        return PeptideFilterItem.values();
    }

    @Override
    public FilterItem getFilterItem(String itemName) {
        return PeptideFilterItem.getItem(itemName);
    }
}

