/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering.items;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.util.ArrayList;
import java.util.Arrays;

public enum AssumptionFilterItem implements FilterItem
{
    minimalLength("Minimal length", "Minimal sequence length."),
    maximalLength("Maximal length", "Maximal sequence length."),
    precrusorMz("Precursor m/z", "Spectrum precursor m/z."),
    precrusorRT("Precursor RT", "Spectrum precursor retention time."),
    precrusorCharge("Precursor charge", "Spectrum precursor charge according to the identification."),
    precrusorMzErrorDa("Precursor m/z error (Da)", "Spectrum precursor m/z error in Dalton."),
    precrusorMzErrorPpm("Precursor m/z error (ppm)", "Spectrum precursor m/z error in ppm."),
    precrusorMzErrorStat("Precursor m/z error (%p)", "Probability in percent of getting the spectrum precursor m/z error in the spectrum file."),
    ptm("PTM", "Post-translational modification carried by the match."),
    sequenceCoverage("Sequence coverage", "Coverage of the sequence by fragment ions in percent."),
    algorithmScore("Algorithm score", "Score given by the identification algorithm."),
    confidence("Confidence", "Confidence in protein identification."),
    validationStatus("Validation", "Validation status."),
    stared("Stared", "Marked with a yellow star.");

    public final String name;
    public final String description;

    private AssumptionFilterItem(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static AssumptionFilterItem getItem(String itemName) {
        for (AssumptionFilterItem filterItem : AssumptionFilterItem.values()) {
            if (!filterItem.name.equals(itemName)) continue;
            return filterItem;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FilterItem[] getPossibleValues() {
        AssumptionFilterItem[] values = AssumptionFilterItem.values();
        FilterItem[] result = new FilterItem[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    @Override
    public boolean isNumber() {
        switch (this) {
            case minimalLength: 
            case maximalLength: 
            case precrusorMz: 
            case precrusorRT: 
            case precrusorCharge: 
            case precrusorMzErrorDa: 
            case precrusorMzErrorPpm: 
            case precrusorMzErrorStat: 
            case sequenceCoverage: 
            case algorithmScore: 
            case confidence: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<String> getPossibilities() {
        switch (this) {
            case validationStatus: {
                return new ArrayList<String>(Arrays.asList(MatchValidationLevel.getValidationLevelsNames()));
            }
            case stared: {
                ArrayList<String> starred = new ArrayList<String>(2);
                starred.add("Starred");
                starred.add("Not Starred");
                return starred;
            }
        }
        return null;
    }

    @Override
    public boolean needsModifications() {
        switch (this) {
            case ptm: {
                return true;
            }
        }
        return false;
    }

    private AssumptionFilterItem() {
        this.name = "";
        this.description = "";
    }
}

