/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering.items;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.util.ArrayList;
import java.util.Arrays;

public enum PeptideFilterItem implements FilterItem
{
    proteinAccession("Protein Accession", "Accession of the protein this peptide maps to according to the sequence database."),
    proteinDescription("Protein Description", "Description of the protein according to the sequence database."),
    sequence("Peptide Sequence", "Amino acid pattern which should be contained in the peptide sequence."),
    modification("modification", "Modification carried by the peptide."),
    nPSMs("#PSMs", "Number of PSMs."),
    nValidatedPSMs("#Validated PSMs", "Number of Validated PSMs."),
    nConfidentPSMs("#Confident PSMs", "Number of Confident PSMs."),
    confidence("Confidence", "Confidence in protein identification."),
    proteinInference("PI", "Protein inference status of the peptide."),
    validationStatus("Validation", "Validation status."),
    stared("Stared", "Marked with a yellow star.");

    public final String name;
    public final String description;

    private PeptideFilterItem(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static PeptideFilterItem getItem(String itemName) {
        for (PeptideFilterItem filterItem : PeptideFilterItem.values()) {
            if (!filterItem.name.equals(itemName)) continue;
            return filterItem;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FilterItem[] getPossibleValues() {
        PeptideFilterItem[] values = PeptideFilterItem.values();
        FilterItem[] result = new FilterItem[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    @Override
    public boolean isNumber() {
        switch (this) {
            case nPSMs: 
            case nValidatedPSMs: 
            case nConfidentPSMs: 
            case confidence: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<String> getPossibilities() {
        switch (this) {
            case proteinInference: {
                ArrayList<String> pi = new ArrayList<String>(4);
                pi.add(PSParameter.getProteinInferenceClassAsString(0));
                pi.add(PSParameter.getProteinInferenceClassAsString(1));
                pi.add(PSParameter.getProteinInferenceClassAsString(2));
                pi.add(PSParameter.getProteinInferenceClassAsString(3));
                return pi;
            }
            case validationStatus: {
                return new ArrayList<String>(Arrays.asList(MatchValidationLevel.getValidationLevelsNames()));
            }
            case stared: {
                ArrayList<String> starred = new ArrayList<String>(2);
                starred.add("Starred");
                starred.add("Not Starred");
                return starred;
            }
        }
        return null;
    }

    @Override
    public boolean needsModifications() {
        switch (this) {
            case modification: {
                return true;
            }
        }
        return false;
    }

    private PeptideFilterItem() {
        this.name = "";
        this.description = "";
    }
}

