/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering.items;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.identification.filtering.items.AssumptionFilterItem;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.util.ArrayList;
import java.util.Arrays;

public enum PsmFilterItem implements FilterItem
{
    confidence("Confidence", "Confidence in protein identification."),
    validationStatus("Validation", "Validation status."),
    stared("Stared", "Marked with a yellow star.");

    public final String name;
    public final String description;

    private PsmFilterItem(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static PsmFilterItem getItem(String itemName) {
        for (PsmFilterItem filterItem : PsmFilterItem.values()) {
            if (!filterItem.name.equals(itemName)) continue;
            return filterItem;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FilterItem[] getPossibleValues() {
        int i;
        PsmFilterItem[] values = PsmFilterItem.values();
        AssumptionFilterItem[] assumptionValues = AssumptionFilterItem.values();
        int totalLength = values.length + assumptionValues.length;
        FilterItem[] result = new FilterItem[totalLength];
        for (i = 0; i < values.length; ++i) {
            result[i] = values[i];
        }
        for (AssumptionFilterItem assumptionValue : assumptionValues) {
            result[i] = assumptionValue;
            ++i;
        }
        return result;
    }

    @Override
    public boolean isNumber() {
        switch (this) {
            case confidence: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<String> getPossibilities() {
        switch (this) {
            case validationStatus: {
                return new ArrayList<String>(Arrays.asList(MatchValidationLevel.getValidationLevelsNames()));
            }
            case stared: {
                ArrayList<String> starred = new ArrayList<String>(2);
                starred.add("Starred");
                starred.add("Not Starred");
                return starred;
            }
        }
        return null;
    }

    @Override
    public boolean needsModifications() {
        switch (this) {
            default: 
        }
        return false;
    }

    private PsmFilterItem() {
        this.name = "";
        this.description = "";
    }
}

