/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_inference;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.modification.ModificationSiteMapping;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class PeptideInference {
    public void peptideInference(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ModificationProvider modificationProvider, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        waitingHandler.setWaitingText("Peptide Inference. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference = new HashMap<Double, HashMap<String, HashSet<Long>>>();
        HashMap<Double, HashSet<Long>> notConfidentPeptideInference = new HashMap<Double, HashSet<Long>>();
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            if (spectrumMatch.getBestPeptideAssumption() == null) continue;
            this.fillConfidentMaps(spectrumMatch, confidentPeptideInference, notConfidentPeptideInference, modificationParameters, modificationProvider, waitingHandler);
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        HashSet<Long> progress = new HashSet<Long>();
        for (Map.Entry entry : notConfidentPeptideInference.entrySet()) {
            double modMass = (Double)entry.getKey();
            Iterator iterator = ((HashSet)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long spectrumKey = (Long)iterator.next();
                this.peptideInference(modMass, spectrumKey, confidentPeptideInference, identification, searchParameters, modificationSequenceMatchingParameters, sequenceProvider, modificationProvider);
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                if (progress.contains(spectrumKey)) continue;
                progress.add(spectrumKey);
                waitingHandler.increaseSecondaryProgressCounter();
            }
        }
    }

    private void peptideInference(double modMass, long spectrumKey, HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters modificationSequenceMatchingParameters, SequenceProvider sequenceProvider, ModificationProvider modificationProvider) {
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        String sequence = peptide.getSequence();
        int nMod = this.getNMod(peptide, modMass, modificationProvider);
        HashSet<Integer> oldLocalization = this.getModificationSites(peptide, modMass, modificationProvider);
        HashSet<Integer> newLocalizationCandidates = new HashSet<Integer>(nMod - oldLocalization.size());
        HashMap<String, HashSet<Long>> modConfidentPeptides = confidentPeptideInference.get(modMass);
        if (modConfidentPeptides != null) {
            this.findConfidentPeptideAndMerge(oldLocalization, newLocalizationCandidates, sequence, modMass, nMod, modConfidentPeptides, identification, modificationProvider);
            if (oldLocalization.size() + newLocalizationCandidates.size() < nMod) {
                this.findRelatedPeptides(oldLocalization, newLocalizationCandidates, peptide, modMass, confidentPeptideInference, identification, searchParameters, modificationSequenceMatchingParameters, sequenceProvider, modificationProvider);
            }
            if (!newLocalizationCandidates.isEmpty()) {
                this.mapInferredSites(spectrumMatch, peptide, newLocalizationCandidates, modMass, nMod, searchParameters, modificationSequenceMatchingParameters, sequenceProvider, modificationProvider);
            }
        }
    }

    private HashSet<Integer> getModificationSites(Peptide peptide, double modMass, ModificationProvider modificationProvider) {
        return Arrays.stream(peptide.getVariableModifications()).filter(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() == modMass).map(ModificationMatch::getSite).collect(Collectors.toCollection(HashSet::new));
    }

    private int getNMod(Peptide peptide, double modMass, ModificationProvider modificationProvider) {
        return (int)Arrays.stream(peptide.getVariableModifications()).map(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification())).filter(modification -> modification.getMass() == modMass).count();
    }

    private void findConfidentPeptideAndMerge(HashSet<Integer> oldLocalization, HashSet<Integer> newLocalizationCandidates, String sequence, double modMass, int nMod, HashMap<String, HashSet<Long>> modConfidentPeptides, Identification identification, ModificationProvider modificationProvider) {
        HashSet<Long> keys = modConfidentPeptides.get(sequence);
        if (keys != null) {
            Peptide tempPeptide;
            SpectrumMatch secondaryMatch;
            for (long tempKey : keys) {
                secondaryMatch = identification.getSpectrumMatch(tempKey);
                tempPeptide = secondaryMatch.getBestPeptideAssumption().getPeptide();
                long tempNMod = Arrays.stream(tempPeptide.getVariableModifications()).map(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification())).filter(modification -> modification.getMass() == modMass).count();
                if (tempNMod != (long)nMod) continue;
                ArrayList tempLocalizations = Arrays.stream(tempPeptide.getVariableModifications()).filter(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() == modMass).map(ModificationMatch::getSite).collect(Collectors.toCollection(ArrayList::new));
                Iterator iterator = tempLocalizations.iterator();
                while (iterator.hasNext()) {
                    int localization = (Integer)iterator.next();
                    if (oldLocalization.contains(localization) || newLocalizationCandidates.contains(localization)) continue;
                    newLocalizationCandidates.add(localization);
                }
            }
            if (oldLocalization.size() + newLocalizationCandidates.size() < nMod) {
                for (long tempKey : keys) {
                    secondaryMatch = (SpectrumMatch)identification.retrieveObject(tempKey);
                    tempPeptide = secondaryMatch.getBestPeptideAssumption().getPeptide();
                    ArrayList tempLocalizations = Arrays.stream(tempPeptide.getVariableModifications()).filter(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() == modMass).map(ModificationMatch::getSite).collect(Collectors.toCollection(ArrayList::new));
                    Iterator iterator = tempLocalizations.iterator();
                    while (iterator.hasNext()) {
                        int localization = (Integer)iterator.next();
                        if (oldLocalization.contains(localization) || newLocalizationCandidates.contains(localization)) continue;
                        newLocalizationCandidates.add(localization);
                    }
                }
            }
        }
    }

    private void findRelatedPeptides(HashSet<Integer> oldLocalization, HashSet<Integer> newLocalizationCandidates, Peptide peptide, double modMass, HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters modificationSequenceMatchingParameters, SequenceProvider sequenceProvider, ModificationProvider modificationProvider) {
        String sequence = peptide.getSequence();
        HashMap<String, HashSet<Long>> confidentAtMass = confidentPeptideInference.get(modMass);
        for (String otherSequence : confidentAtMass.keySet()) {
            int[] possibleSites;
            Modification modification;
            Modification modification2;
            boolean siteOccupied;
            int shiftedLocalization;
            int localization;
            Iterator iterator;
            int tempIndex;
            String tempSequence;
            int ref;
            ArrayList tempLocalizations;
            Peptide tempPeptide;
            SpectrumMatch secondaryMatch;
            if (!sequence.equals(otherSequence) && sequence.contains(otherSequence)) {
                for (long tempKey : confidentAtMass.get(otherSequence)) {
                    secondaryMatch = (SpectrumMatch)identification.retrieveObject(tempKey);
                    tempPeptide = secondaryMatch.getBestPeptideAssumption().getPeptide();
                    tempLocalizations = Arrays.stream(tempPeptide.getVariableModifications()).filter(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() == modMass).map(ModificationMatch::getSite).collect(Collectors.toCollection(ArrayList::new));
                    ref = 0;
                    tempSequence = sequence;
                    while ((tempIndex = tempSequence.indexOf(otherSequence)) >= 0) {
                        ref += tempIndex;
                        iterator = tempLocalizations.iterator();
                        while (iterator.hasNext()) {
                            localization = (Integer)iterator.next();
                            shiftedLocalization = ref + localization;
                            if (oldLocalization.contains(shiftedLocalization) || newLocalizationCandidates.contains(shiftedLocalization)) continue;
                            siteOccupied = false;
                            for (ModificationMatch modificationMatch2 : peptide.getVariableModifications()) {
                                modification2 = modificationProvider.getModification(modificationMatch2.getModification());
                                if (modification2.getMass() == modMass || modificationMatch2.getSite() != shiftedLocalization) continue;
                                siteOccupied = true;
                            }
                            boolean candidatePtm = false;
                            if (!siteOccupied) {
                                for (String modName : searchParameters.getModificationParameters().getAllNotFixedModifications()) {
                                    modification = modificationProvider.getModification(modName);
                                    if (modification.getMass() != modMass || !Arrays.stream(possibleSites = ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, modificationSequenceMatchingParameters)).anyMatch(site -> site == shiftedLocalization)) continue;
                                    candidatePtm = true;
                                    break;
                                }
                            }
                            if (!candidatePtm || siteOccupied) continue;
                            newLocalizationCandidates.add(shiftedLocalization);
                        }
                        tempSequence = tempSequence.substring(tempIndex + 1);
                        ++ref;
                    }
                }
                continue;
            }
            if (sequence.equals(otherSequence) || !otherSequence.contains(sequence)) continue;
            for (long tempKey : confidentAtMass.get(otherSequence)) {
                secondaryMatch = identification.getSpectrumMatch(tempKey);
                tempPeptide = secondaryMatch.getBestPeptideAssumption().getPeptide();
                tempLocalizations = Arrays.stream(tempPeptide.getVariableModifications()).filter(modificationMatch -> modificationMatch.getConfident() || modificationMatch.getInferred()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() == modMass).map(ModificationMatch::getSite).collect(Collectors.toCollection(ArrayList::new));
                ref = 0;
                tempSequence = otherSequence;
                while ((tempIndex = tempSequence.indexOf(sequence)) >= 0) {
                    ref += tempIndex;
                    iterator = tempLocalizations.iterator();
                    while (iterator.hasNext()) {
                        localization = (Integer)iterator.next();
                        shiftedLocalization = localization - ref;
                        if (shiftedLocalization <= 0 || shiftedLocalization > sequence.length() || oldLocalization.contains(shiftedLocalization) || newLocalizationCandidates.contains(shiftedLocalization)) continue;
                        siteOccupied = false;
                        for (ModificationMatch modificationMatch2 : peptide.getVariableModifications()) {
                            modification2 = modificationProvider.getModification(modificationMatch2.getModification());
                            if (modification2.getMass() == modMass || modificationMatch2.getSite() != shiftedLocalization) continue;
                            siteOccupied = true;
                        }
                        boolean candidateModification = false;
                        if (!siteOccupied) {
                            for (String modName : searchParameters.getModificationParameters().getAllNotFixedModifications()) {
                                modification = modificationProvider.getModification(modName);
                                if (modification.getMass() != modMass || !Arrays.stream(possibleSites = ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, modificationSequenceMatchingParameters)).anyMatch(site -> site == shiftedLocalization)) continue;
                                candidateModification = true;
                                break;
                            }
                        }
                        if (!candidateModification || siteOccupied) continue;
                        newLocalizationCandidates.add(shiftedLocalization);
                    }
                    tempSequence = tempSequence.substring(tempIndex + 1);
                    ++ref;
                }
            }
        }
    }

    private void mapInferredSites(SpectrumMatch spectrumMatch, Peptide peptide, HashSet<Integer> newLocalizationCandidates, double modMass, int nMod, SearchParameters searchParameters, SequenceMatchingParameters modificationSequenceMatchingParameters, SequenceProvider sequenceProvider, ModificationProvider modificationProvider) {
        HashMap<Integer, ModificationMatch> nonConfidentMatches = new HashMap<Integer, ModificationMatch>();
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            Modification modification = modificationProvider.getModification(modName);
            if (modificationMatch.getConfident() || modification.getMass() != modMass) continue;
            nonConfidentMatches.put(modificationMatch.getSite(), modificationMatch);
        }
        HashMap<Integer, Integer> mapping = ModificationSiteMapping.align(nonConfidentMatches.keySet(), newLocalizationCandidates);
        for (Integer oldLocalization : mapping.keySet()) {
            ModificationMatch modificationMatch;
            modificationMatch = (ModificationMatch)nonConfidentMatches.get(oldLocalization);
            Integer newLocalization = mapping.get(oldLocalization);
            if (modificationMatch == null) {
                throw new IllegalArgumentException("No modification match found at site " + oldLocalization + " in spectrum " + spectrumMatch.getKey() + ".");
            }
            if (newLocalization == null) continue;
            if (!newLocalization.equals(oldLocalization)) {
                String candidateName = null;
                for (String modName : searchParameters.getModificationParameters().getAllNotFixedModifications()) {
                    int[] possibleSites;
                    Modification modification = modificationProvider.getModification(modName);
                    if (modification.getMass() != modMass || !Arrays.stream(possibleSites = ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, modificationSequenceMatchingParameters)).anyMatch(site -> site == newLocalization)) continue;
                    candidateName = modification.getName();
                    break;
                }
                if (candidateName == null) {
                    throw new IllegalArgumentException("No PTM found for site " + newLocalization + " on  peptide " + peptide.getSequence() + " in spectrum " + spectrumMatch.getKey() + ".");
                }
                String previousName = modificationMatch.getModification();
                modificationMatch.setSite(newLocalization);
                modificationMatch.setModification(candidateName);
                PSModificationScores psmScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy);
                psmScores.changeRepresentativeSite(candidateName, previousName, oldLocalization, newLocalization, nMod, modificationProvider);
            }
            modificationMatch.setInferred(true);
        }
    }

    private void fillConfidentMaps(SpectrumMatch spectrumMatch, HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference, HashMap<Double, HashSet<Long>> notConfidentPeptideInference, ModificationParameters modificationParameters, ModificationProvider modificationProvider, WaitingHandler waitingHandler) {
        boolean variableAA = false;
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        block0: for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            Modification modification = modificationProvider.getModification(modName);
            if (modification.getModificationType() == ModificationType.modaa) {
                variableAA = true;
                break;
            }
            double modMass = modification.getMass();
            for (String otherModName : modificationParameters.getAllNotFixedModifications()) {
                Object otherModification;
                if (otherModName.equals(modName) || ((Modification)(otherModification = modificationProvider.getModification(otherModName))).getMass() != modMass || modification.getModificationType() == ((Modification)otherModification).getModificationType()) continue;
                variableAA = true;
                continue block0;
            }
        }
        if (variableAA) {
            boolean confident = true;
            for (ModificationMatch modMatch : peptide.getVariableModifications()) {
                String sequence;
                HashSet<Long> spectra;
                boolean maybeNotTerminal;
                String modName = modMatch.getModification();
                Modification modification = modificationProvider.getModification(modName);
                double modMass = modification.getMass();
                boolean bl = maybeNotTerminal = modification.getModificationType() == ModificationType.modaa;
                if (!maybeNotTerminal) {
                    for (String otherModName : modificationParameters.getAllNotFixedModifications()) {
                        Modification otherModification;
                        if (otherModName.equals(modName) || (otherModification = modificationProvider.getModification(otherModName)).getMass() != modMass || modification.getModificationType() == otherModification.getModificationType()) continue;
                        maybeNotTerminal = true;
                        break;
                    }
                }
                if (!maybeNotTerminal) continue;
                if (!modMatch.getConfident()) {
                    HashSet<Long> spectra2 = notConfidentPeptideInference.get(modMass);
                    if (spectra2 == null) {
                        spectra2 = new HashSet(2);
                        notConfidentPeptideInference.put(modMass, spectra2);
                    }
                    spectra2.add(spectrumMatch.getKey());
                    confident = false;
                    continue;
                }
                HashMap<String, HashSet<Long>> modMap = confidentPeptideInference.get(modMass);
                if (modMap == null) {
                    modMap = new HashMap(2);
                    confidentPeptideInference.put(modMass, modMap);
                }
                if ((spectra = modMap.get(sequence = spectrumMatch.getBestPeptideAssumption().getPeptide().getSequence())) == null) {
                    spectra = new HashSet(2);
                    modMap.put(sequence, spectra);
                }
                spectra.add(spectrumMatch.getKey());
            }
            if (confident) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
        } else {
            waitingHandler.increaseSecondaryProgressCounter();
        }
    }
}

