/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_shaker;

import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.utils.EmptyCollections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PSModificationScores
extends ExperimentObject
implements UrParameter {
    public static final PSModificationScores dummy = new PSModificationScores();
    private final HashMap<String, ModificationScoring> modificationMap = new HashMap(0);
    private HashMap<Integer, HashSet<String>> mainModificationSites = null;
    private HashMap<String, HashSet<Integer>> confidentModificationsByModName = null;
    private HashMap<Integer, HashMap<Integer, HashSet<String>>> ambiguousModificationsByRepresentativeSite = null;
    private HashMap<String, HashMap<Integer, HashSet<Integer>>> ambiguousModificationsByModName = null;

    public void addModificationScoring(String modName, ModificationScoring modificationScoring) {
        this.modificationMap.put(modName, modificationScoring);
    }

    public ModificationScoring getModificationScoring(String modName) {
        return this.modificationMap.get(modName);
    }

    public boolean containsModification(String modName) {
        return this.modificationMap.containsKey(modName);
    }

    public Set<String> getScoredModifications() {
        return this.modificationMap.keySet();
    }

    public void addConfidentModificationSite(String modName, int modificationSite) {
        HashSet<Integer> modificationSites;
        HashSet<String> modifications;
        if (this.mainModificationSites == null) {
            this.mainModificationSites = new HashMap(1);
        }
        if ((modifications = this.mainModificationSites.get(modificationSite)) == null) {
            modifications = new HashSet(1);
            this.mainModificationSites.put(modificationSite, modifications);
        }
        modifications.add(modName);
        if (this.confidentModificationsByModName == null) {
            this.confidentModificationsByModName = new HashMap(1);
        }
        if ((modificationSites = this.confidentModificationsByModName.get(modName)) == null) {
            modificationSites = new HashSet(1);
            this.confidentModificationsByModName.put(modName, modificationSites);
        }
        modificationSites.add(modificationSite);
    }

    public void addAmbiguousModificationSites(int representativeSite, HashMap<Integer, HashSet<String>> possibleModifications) {
        HashMap<Integer, HashSet<String>> modificationGroupsAtSite;
        if (this.ambiguousModificationsByRepresentativeSite == null) {
            this.ambiguousModificationsByRepresentativeSite = new HashMap(possibleModifications.size());
            this.ambiguousModificationsByModName = new HashMap(possibleModifications.size());
        }
        if ((modificationGroupsAtSite = this.ambiguousModificationsByRepresentativeSite.get(representativeSite)) == null) {
            modificationGroupsAtSite = new HashMap(1);
            this.ambiguousModificationsByRepresentativeSite.put(representativeSite, modificationGroupsAtSite);
        }
        for (int site : possibleModifications.keySet()) {
            for (String modName : possibleModifications.get(site)) {
                HashSet<String> modifications = modificationGroupsAtSite.get(site);
                if (modifications == null) {
                    modifications = new HashSet(1);
                    modificationGroupsAtSite.put(site, modifications);
                }
                if (modifications.contains(modName)) continue;
                modifications.add(modName);
            }
        }
        HashSet<String> modifications = possibleModifications.get(representativeSite);
        for (String modification : modifications) {
            HashSet<Integer> secondarySites;
            HashMap<Integer, HashSet<Integer>> modSites = this.ambiguousModificationsByModName.get(modification);
            if (modSites == null) {
                modSites = new HashMap(1);
                this.ambiguousModificationsByModName.put(modification, modSites);
            }
            if ((secondarySites = modSites.get(representativeSite)) == null) {
                secondarySites = new HashSet(1);
                modSites.put(representativeSite, secondarySites);
            }
            for (int site : possibleModifications.keySet()) {
                secondarySites.add(site);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changeRepresentativeSite(String modName, String originalModName, int originalRepresentativeSite, int newRepresentativeSite, int nMod, ModificationProvider modificationProvider) {
        void var13_17;
        String tempModName;
        HashSet<Integer> secondarySites;
        double modMass = modificationProvider.getModification(modName).getMass();
        HashMap<Integer, HashSet<String>> ambiguousSites = this.ambiguousModificationsByRepresentativeSite.get(originalRepresentativeSite);
        if (ambiguousSites != null) {
            int site;
            HashMap newSites = new HashMap(1);
            HashSet<Integer> sitesToRemove = new HashSet<Integer>(0);
            for (Map.Entry<Integer, HashSet<String>> entry : ambiguousSites.entrySet()) {
                site = entry.getKey();
                HashSet<String> hashSet = entry.getValue();
                for (String tempModName2 : hashSet) {
                    double tempModMass = modificationProvider.getModification(tempModName2).getMass();
                    if (modMass != tempModMass) continue;
                    HashSet<String> newModifications = new HashSet<String>(1);
                    newModifications.add(tempModName2);
                    newSites.put(site, newModifications);
                    hashSet.remove(tempModName2);
                    if (!hashSet.isEmpty()) continue;
                    sitesToRemove.add(site);
                }
            }
            Iterator<Map.Entry<Integer, HashSet<String>>> iterator = sitesToRemove.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)((Object)iterator.next());
                ambiguousSites.remove(n);
            }
            if (ambiguousSites.isEmpty()) {
                this.ambiguousModificationsByRepresentativeSite.remove(originalRepresentativeSite);
            }
            if ((ambiguousSites = this.ambiguousModificationsByRepresentativeSite.get(newRepresentativeSite)) == null) {
                this.ambiguousModificationsByRepresentativeSite.put(newRepresentativeSite, newSites);
            } else {
                for (Map.Entry<Integer, HashSet<String>> entry : newSites.entrySet()) {
                    void var15_25;
                    site = entry.getKey();
                    HashSet<String> hashSet = entry.getValue();
                    if (hashSet == null) {
                        HashSet hashSet2 = new HashSet(1);
                        ambiguousSites.put(site, hashSet2);
                    }
                    var15_25.add(modName);
                }
            }
        }
        HashSet<Integer> originalSecondarySites = null;
        HashMap<Integer, HashSet<Integer>> modificationSiteMap = this.ambiguousModificationsByModName.get(originalModName);
        if (modificationSiteMap != null) {
            originalSecondarySites = modificationSiteMap.get(originalRepresentativeSite);
            modificationSiteMap.remove(originalRepresentativeSite);
            if (modificationSiteMap.isEmpty()) {
                this.ambiguousModificationsByModName.remove(originalModName);
            }
        }
        if ((modificationSiteMap = this.ambiguousModificationsByModName.get(modName)) == null) {
            modificationSiteMap = new HashMap(1);
            this.ambiguousModificationsByModName.put(modName, modificationSiteMap);
        }
        if ((secondarySites = modificationSiteMap.get(newRepresentativeSite)) == null) {
            secondarySites = new HashSet(1);
            modificationSiteMap.put(newRepresentativeSite, secondarySites);
        }
        if (originalSecondarySites != null) {
            secondarySites.addAll(originalSecondarySites);
        }
        boolean bl = false;
        if (this.confidentModificationsByModName != null) {
            for (Map.Entry<String, HashSet<Integer>> entry : this.confidentModificationsByModName.entrySet()) {
                tempModName = entry.getKey();
                double tempModMass = modificationProvider.getModification(tempModName).getMass();
                if (modMass != tempModMass) continue;
                var13_16 += entry.getValue().size();
            }
        }
        for (Map.Entry<String, HashMap<Integer, HashSet<Integer>>> entry : this.ambiguousModificationsByModName.entrySet()) {
            tempModName = entry.getKey();
            double tempModMass = modificationProvider.getModification(tempModName).getMass();
            if (modMass != tempModMass) continue;
            var13_17 += entry.getValue().size();
        }
        if (var13_17 != nMod) {
            throw new IllegalArgumentException("Incorrect number of representative sites for modification of mass " + modMass + ". Expected: " + nMod + ", found: " + (int)var13_17 + ".");
        }
    }

    public boolean isConfidentModificationSite(int site, String modificationName) {
        return this.mainModificationSites != null && this.mainModificationSites.containsKey(site) && this.mainModificationSites.get(site).contains(modificationName);
    }

    public HashSet<String> getConfidentModificationsAt(int site) {
        return this.mainModificationSites == null || !this.mainModificationSites.containsKey(site) ? EmptyCollections.emptyStringSet : this.mainModificationSites.get(site);
    }

    public HashSet<String> getModificationsAtRepresentativeSite(int site) {
        HashMap<Integer, HashSet<String>> modificationsAtSite = this.getAmbiguousModificationsAtRepresentativeSite(site);
        HashSet<String> modifications = modificationsAtSite.get(site);
        return modifications == null ? EmptyCollections.emptyStringSet : modificationsAtSite.get(site);
    }

    public HashSet<Integer> getConfidentSitesForModification(String modName) {
        return this.confidentModificationsByModName == null || !this.confidentModificationsByModName.containsKey(modName) ? EmptyCollections.emptyIntSet : this.confidentModificationsByModName.get(modName);
    }

    public HashMap<Integer, HashSet<String>> getAmbiguousModificationsAtRepresentativeSite(int representativeSite) {
        return this.ambiguousModificationsByRepresentativeSite == null || !this.ambiguousModificationsByRepresentativeSite.containsKey(representativeSite) ? new HashMap<Integer, HashSet<String>>(0) : this.ambiguousModificationsByRepresentativeSite.get(representativeSite);
    }

    public HashMap<Integer, HashSet<Integer>> getAmbiguousModificationsSites(String modName) {
        return this.ambiguousModificationsByModName == null ? new HashMap(0) : this.ambiguousModificationsByModName.get(modName);
    }

    public TreeSet<Integer> getConfidentSites() {
        return this.mainModificationSites == null ? new TreeSet<Integer>() : new TreeSet<Integer>(this.mainModificationSites.keySet());
    }

    public TreeSet<Integer> getRepresentativeSites() {
        return this.ambiguousModificationsByRepresentativeSite == null ? EmptyCollections.emptyIntTreeSet : new TreeSet<Integer>(this.ambiguousModificationsByRepresentativeSite.keySet());
    }

    public TreeSet<String> getConfidentlyLocalizedModifications() {
        return this.confidentModificationsByModName == null ? EmptyCollections.emptyStringTreeSet : new TreeSet<String>(this.confidentModificationsByModName.keySet());
    }

    public TreeSet<String> getAmbiguouslyLocalizedModifications() {
        return this.ambiguousModificationsByModName == null ? EmptyCollections.emptyStringTreeSet : new TreeSet<String>(this.ambiguousModificationsByModName.keySet());
    }

    @Override
    public long getParameterKey() {
        return this.getId();
    }
}

