/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_shaker;

import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.util.FastMath;

public class PSParameter
extends ExperimentObject
implements UrParameter {
    static final long serialVersionUID = 2846587135366515967L;
    private double algorithmDeltaPEP;
    private double deltaPEP;
    private double score;
    private double probability;
    private MatchValidationLevel matchValidationLevel;
    private boolean manualValidation = false;
    private boolean hidden = false;
    private boolean starred = false;
    private int proteinInferenceGroupClass = 0;
    public static final int NOT_GROUP = 0;
    public static final int RELATED = 1;
    public static final int RELATED_AND_UNRELATED = 2;
    public static final int UNRELATED = 3;
    private HashMap<String, Double> fractionPEP = null;
    private HashMap<String, Double> fractionScore = null;
    private HashMap<String, Integer> validatedPeptidesPerFraction = null;
    private HashMap<String, Integer> validatedSpectraPerFraction = null;
    private HashMap<String, ArrayList<Double>> precursorIntensityPerFraction = null;
    private HashMap<String, Double> precursorIntensityAveragePerFraction = null;
    private HashMap<String, Double> precursorIntensitySummedPerFraction = null;
    private HashMap<String, Boolean> qcFilters = null;
    private HashMap<Integer, Double> intermediateScores;
    public static final PSParameter dummy = new PSParameter();

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public void setGroupClass(int groupClass) {
        this.proteinInferenceGroupClass = groupClass;
    }

    public double getScore() {
        return this.score;
    }

    public double getTransformedScore() {
        return PSParameter.transformScore(this.getScore());
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getConfidence() {
        double confidence = 100.0 * (1.0 - this.probability);
        return confidence < 0.0 ? 0.0 : confidence;
    }

    public Double getAlgorithmDeltaPEP() {
        return this.algorithmDeltaPEP;
    }

    public void setAlgorithmDeltaPEP(double deltaPEP) {
        this.algorithmDeltaPEP = deltaPEP;
    }

    public double getDeltaPEP() {
        return this.deltaPEP;
    }

    public void setDeltaPEP(double deltaPEP) {
        this.deltaPEP = deltaPEP;
    }

    public void setQcFilters(HashMap<String, Boolean> qcFilters) {
        this.qcFilters = qcFilters;
    }

    public MatchValidationLevel getMatchValidationLevel() {
        return this.matchValidationLevel;
    }

    public void setMatchValidationLevel(MatchValidationLevel matchValidationLevel) {
        this.matchValidationLevel = matchValidationLevel;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setStarred(boolean starred) {
        this.starred = starred;
    }

    public boolean getStarred() {
        return this.starred;
    }

    public int getProteinInferenceGroupClass() {
        return this.proteinInferenceGroupClass;
    }

    public String getProteinInferenceClassAsString() {
        return PSParameter.getProteinInferenceClassAsString(this.proteinInferenceGroupClass);
    }

    public static String getProteinInferenceClassAsString(int matchClass) {
        switch (matchClass) {
            case 0: {
                return "Single Protein";
            }
            case 1: {
                return "Related Proteins";
            }
            case 2: {
                return "Related and Unrelated Proteins";
            }
            case 3: {
                return "Unrelated Proteins";
            }
        }
        return "";
    }

    public void setProteinInferenceClass(int groupClass) {
        this.proteinInferenceGroupClass = groupClass;
    }

    public HashMap<String, Integer> getValidatedPeptidesPerFraction() {
        return this.validatedPeptidesPerFraction;
    }

    public HashMap<String, Integer> getValidatedSpectraPerFraction() {
        return this.validatedSpectraPerFraction;
    }

    public void setFractionScore(String fraction, double confidence) {
        if (this.fractionScore == null) {
            this.fractionScore = new HashMap(2);
        }
        this.fractionScore.put(fraction, confidence);
    }

    public void setFractionScore(HashMap<String, Double> fractionScore) {
        this.fractionScore = fractionScore;
    }

    public Double getFractionScore(String fraction) {
        if (this.fractionScore == null) {
            return null;
        }
        return this.fractionScore.get(fraction);
    }

    public Set<String> getFractions() {
        return this.fractionScore == null ? null : this.fractionScore.keySet();
    }

    public HashMap<String, Double> getFractionScore() {
        return this.fractionScore;
    }

    public void setFractionPEP(String fraction, Double confidence) {
        if (this.fractionPEP == null) {
            this.fractionPEP = new HashMap(2);
        }
        this.fractionPEP.put(fraction, confidence);
    }

    public void setFractionPEP(HashMap<String, Double> fractionPEP) {
        this.fractionPEP = fractionPEP;
    }

    public Double getFractionPEP(String fraction) {
        return this.fractionPEP == null ? null : this.fractionPEP.get(fraction);
    }

    public HashMap<String, Double> getFractionPEP() {
        return this.fractionPEP;
    }

    public Double getFractionConfidence(String fraction) {
        return this.fractionPEP == null || this.fractionPEP.get(fraction) == null ? null : Double.valueOf(100.0 * (1.0 - this.fractionPEP.get(fraction)));
    }

    public int getFractionValidatedPeptides(String fraction) {
        return this.validatedPeptidesPerFraction == null || this.validatedPeptidesPerFraction.get(fraction) == null ? 0 : this.validatedPeptidesPerFraction.get(fraction);
    }

    public void setValidatedPeptidesPerFraction(HashMap<String, Integer> validatedPeptidesPerFraction) {
        this.validatedPeptidesPerFraction = validatedPeptidesPerFraction;
    }

    public Integer getFractionValidatedSpectra(String fraction) {
        return this.validatedSpectraPerFraction == null || this.validatedSpectraPerFraction.get(fraction) == null ? Integer.valueOf(0) : this.validatedSpectraPerFraction.get(fraction);
    }

    public void setValidatedSpectraPepFraction(HashMap<String, Integer> validatedSpectraPerFraction) {
        this.validatedSpectraPerFraction = validatedSpectraPerFraction;
    }

    public ArrayList<Double> getPrecursorIntensityPerFraction(String fraction) {
        return this.precursorIntensityPerFraction == null ? new ArrayList(0) : this.precursorIntensityPerFraction.get(fraction);
    }

    public HashMap<String, ArrayList<Double>> getPrecursorIntensityPerFraction() {
        return this.precursorIntensityPerFraction;
    }

    public void setPrecursorIntensityAveragePerFraction(HashMap<String, Double> precursorIntensityAveragePerFraction) {
        this.precursorIntensityAveragePerFraction = precursorIntensityAveragePerFraction;
    }

    public void setPrecursorIntensitySummedPerFraction(HashMap<String, Double> precursorIntensitySummedPerFraction) {
        this.precursorIntensitySummedPerFraction = precursorIntensitySummedPerFraction;
    }

    public void setPrecursorIntensityPerFraction(HashMap<String, ArrayList<Double>> precursorIntensityPerFraction) {
        this.precursorIntensityPerFraction = precursorIntensityPerFraction;
        for (Map.Entry<String, ArrayList<Double>> entry : precursorIntensityPerFraction.entrySet()) {
            String fraction = entry.getKey();
            double sum = entry.getValue().stream().mapToDouble(Double::doubleValue).sum();
            if (this.precursorIntensitySummedPerFraction == null) {
                this.precursorIntensitySummedPerFraction = new HashMap(2);
            }
            if (this.precursorIntensityAveragePerFraction == null) {
                this.precursorIntensityAveragePerFraction = new HashMap(2);
            }
            if (sum > 0.0) {
                this.precursorIntensitySummedPerFraction.put(fraction, sum);
                this.precursorIntensityAveragePerFraction.put(fraction, sum / (double)precursorIntensityPerFraction.get(fraction).size());
                continue;
            }
            this.precursorIntensitySummedPerFraction.put(fraction, null);
            this.precursorIntensityAveragePerFraction.put(fraction, null);
        }
    }

    public Double getPrecursorIntensityAveragePerFraction(String fraction) {
        return this.precursorIntensityAveragePerFraction == null ? null : this.precursorIntensityAveragePerFraction.get(fraction);
    }

    public HashMap<String, Double> getPrecursorIntensityAveragePerFraction() {
        return this.precursorIntensityAveragePerFraction;
    }

    public Double getPrecursorIntensitySummedPerFraction(String fraction) {
        return this.precursorIntensitySummedPerFraction == null ? null : this.precursorIntensitySummedPerFraction.get(fraction);
    }

    public HashMap<String, Double> getPrecursorIntensitySummedPerFraction() {
        return this.precursorIntensitySummedPerFraction;
    }

    public boolean getManualValidation() {
        return this.manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this.manualValidation = manualValidation;
    }

    public void setQcResult(String criterion, boolean validated) {
        if (this.qcFilters == null) {
            this.qcFilters = new HashMap(1);
        }
        this.qcFilters.put(criterion, validated);
    }

    public Boolean isQcPassed(String criterion) {
        return this.qcFilters == null ? null : this.qcFilters.get(criterion);
    }

    public Set<String> getQcCriteria() {
        return this.qcFilters == null ? new HashSet(0) : this.qcFilters.keySet();
    }

    public HashMap<String, Boolean> getQcFilters() {
        return this.qcFilters;
    }

    public void resetQcResults() {
        if (this.qcFilters == null) {
            this.qcFilters = new HashMap(1);
        } else {
            this.qcFilters.clear();
        }
    }

    public boolean hasQcFilters() {
        return this.qcFilters != null && !this.qcFilters.isEmpty();
    }

    public void setIntermediateScore(Integer scoreId, Double score) {
        if (this.intermediateScores == null) {
            this.createIntermediateScoreMap();
        }
        this.intermediateScores.put(scoreId, score);
    }

    public void setIntermediateScores(HashMap<Integer, Double> intermediateScores) {
        this.intermediateScores = intermediateScores;
    }

    public synchronized void createIntermediateScoreMap() {
        if (this.intermediateScores == null) {
            this.intermediateScores = new HashMap(1);
        }
    }

    public Double getIntermediateScore(int scoreId) {
        return this.intermediateScores == null ? null : this.intermediateScores.get(scoreId);
    }

    public HashMap<Integer, Double> getIntermediateScores() {
        return this.intermediateScores;
    }

    public static double transformScore(double rawScore) {
        double score;
        if (rawScore <= 0.0) {
            score = 100.0;
        } else {
            score = -10.0 * FastMath.log10((double)rawScore);
            if (score > 100.0) {
                score = 100.0;
            }
        }
        return score;
    }

    @Override
    public long getParameterKey() {
        return 2846587135366515967L;
    }
}

