/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.fm_index;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Protein;
import com.compomics.util.experiment.biology.variants.AaSubstitutionMatrix;
import com.compomics.util.experiment.biology.variants.Variant;
import com.compomics.util.experiment.biology.variants.amino_acids.Deletion;
import com.compomics.util.experiment.biology.variants.amino_acids.Insertion;
import com.compomics.util.experiment.biology.variants.amino_acids.Substitution;
import com.compomics.util.experiment.identification.amino_acid_tags.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.fm_index.AccessionMetaData;
import com.compomics.util.experiment.identification.protein_inference.fm_index.CacheElement;
import com.compomics.util.experiment.identification.protein_inference.fm_index.MassIndexMap;
import com.compomics.util.experiment.identification.protein_inference.fm_index.MatrixContent;
import com.compomics.util.experiment.identification.protein_inference.fm_index.Rank;
import com.compomics.util.experiment.identification.protein_inference.fm_index.SNPElement;
import com.compomics.util.experiment.identification.protein_inference.fm_index.TagElement;
import com.compomics.util.experiment.identification.protein_inference.fm_index.WaveletTree;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.ProteinIterator;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.biology.protein.iterators.FastaIterator;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jsuffixarrays.DivSufSort;

public class FMIndex
extends ExperimentObject
implements FastaMapper,
SequenceProvider,
ProteinDetailsProvider {
    private static final String FM_INDEX_VERSION_NUMBER = "v1.0.1";
    private static final int HEADERS_CACHE_SIZE = 100000;
    public int maxPTMsPerPeptide = 3;
    public boolean onlyTrypticPeptides = false;
    public static char DELIMITER = (char)47;
    public static char SENTINEL = (char)36;
    static Object cacheMutex = new Object();
    private int indexParts = 0;
    private final int indexChunkSize = 0x6400000;
    private ArrayList<int[]> suffixArraysPrimary = new ArrayList();
    public ArrayList<WaveletTree> occurrenceTablesPrimary = new ArrayList();
    public ArrayList<WaveletTree> occurrenceTablesReversed = new ArrayList();
    public ArrayList<int[]> lessTablesPrimary = new ArrayList();
    public ArrayList<int[]> lessTablesReversed = new ArrayList();
    public ArrayList<Integer> indexStringLengths = new ArrayList();
    private final int samplingShift = 3;
    private final int samplingMask = 7;
    private final int sampling = 8;
    private ArrayList<int[]> boundaries = new ArrayList();
    private ArrayList<String[]> accessions = new ArrayList();
    private HashSet<String> decoyAccessions = new HashSet();
    private HashMap<String, AccessionMetaData> accessionMetaData = new HashMap();
    private ConcurrentHashMap<String, Header> headerCache = new ConcurrentHashMap();
    private double[] aaMasses = null;
    private int[] aaMassIndexes = null;
    private int numMasses = 0;
    private String[] modifictationLabels = null;
    private HashMap<String, Integer> modificationLabelsToId = new HashMap();
    private boolean[] modificationFlags = null;
    private boolean withVariableModifications = false;
    private final int[] BSubstitutions = new int[]{68, 78};
    private final int[] JSubstitutions = new int[]{73, 76};
    private final int[] ZSubstitutions = new int[]{69, 81};
    private ArrayList<String> fmodc = null;
    private ArrayList<Double> fmodcMass = null;
    private ArrayList<String>[] fmodcaa = null;
    private ArrayList<Double>[] fmodcaaMass = null;
    private ArrayList<String> fmodn = null;
    private ArrayList<Double> fmodnMass = null;
    private ArrayList<String>[] fmodnaa = null;
    private ArrayList<Double>[] fmodnaaMass = null;
    private ArrayList<String> fmodcp = null;
    private ArrayList<Double> fmodcpMass = null;
    private ArrayList<String>[] fmodcpaa = null;
    private ArrayList<Double>[] fmodcpaaMass = null;
    private ArrayList<String> fmodnp = null;
    private ArrayList<Double> fmodnpMass = null;
    private ArrayList<String>[] fmodnpaa = null;
    private ArrayList<Double>[] fmodnpaaMass = null;
    private ArrayList<String> vmodc = null;
    private ArrayList<Double> vmodcMass = null;
    private ArrayList<String>[] vmodcaa = null;
    private ArrayList<Double>[] vmodcaaMass = null;
    private ArrayList<String> vmodn = null;
    private ArrayList<Double> vmodnMass = null;
    private ArrayList<String>[] vmodnaa = null;
    private ArrayList<Double>[] vmodnaaMass = null;
    private ArrayList<String> vmodcp = null;
    private ArrayList<Double> vmodcpMass = null;
    private ArrayList<String>[] vmodcpaa = null;
    private ArrayList<Double>[] vmodcpaaMass = null;
    private ArrayList<String> vmodnp = null;
    private ArrayList<Double> vmodnpMass = null;
    private ArrayList<String>[] vmodnpaa = null;
    private ArrayList<Double>[] vmodnpaaMass = null;
    private boolean hasCTermDirectionModification = false;
    private boolean hasNTermDirectionModification = false;
    private boolean hasModificationatTerminus = false;
    private boolean hasFixedModification_CatTerminus = false;
    private boolean hasFixedModification_NatTerminus = false;
    private double negativeModificationMass = 0.0;
    private final ArrayList<Rank> variantBitsPrimary = new ArrayList();
    private final ArrayList<Rank> variantBitsReversed = new ArrayList();
    private final ArrayList<HashSet<int[]>[]> variantsPrimary = new ArrayList();
    private final ArrayList<HashSet<int[]>[]> variantsReversed = new ArrayList();
    HashMap<String, ArrayList<SNPElement>> SNPs = new HashMap();
    PeptideVariantsParameters.VariantType variantMatchingType = PeptideVariantsParameters.VariantType.NO_VARIANT;
    int maxNumberVariants = 0;
    int maxNumberInsertions = 0;
    int maxNumberDeletions = 0;
    int maxNumberSubstitutions = 0;
    boolean[][] substitutionMatrix = null;
    double lookupMultiplier = 1000.0;
    SearchParameters.MassAccuracyType massAccuracyType = SearchParameters.MassAccuracyType.DA;
    double massTolerance = 0.02;
    private static final double LOOKUP_MAX_MASS = 800.0;
    long[] lookupMasses = null;
    int maxXPerTag = 4;
    long[][] Xlookup = null;
    ArrayList<Long[]> modificationPatterns = new ArrayList(2);
    HashMap<String, int[]> modificationPatternNames = new HashMap(2);
    int longestModificationpattern = 0;
    int[][][] allPermutations = new int[][][]{new int[][]{{-1}}, new int[][]{{0}}, new int[][]{{0, 1}, {1, 0}}, new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}}, new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 2, 1, 3}, {0, 2, 3, 1}, {0, 3, 1, 2}, {0, 3, 2, 1}, {1, 0, 2, 3}, {1, 0, 3, 2}, {1, 2, 0, 3}, {1, 2, 3, 0}, {1, 3, 0, 2}, {1, 3, 2, 0}, {2, 0, 1, 3}, {2, 0, 3, 1}, {2, 1, 0, 3}, {2, 1, 3, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {3, 1, 0, 2}, {3, 1, 2, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}}};
    ArrayList<MassIndexMap> massIndexMaps = null;
    private HashMap<String, CacheElement>[] cache = null;

    public FMIndex() {
    }

    private static int binarySearch(int[] array, int key) {
        int low = 0;
        int mid = 0;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (array[mid] <= key) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (mid > 0 && key < array[mid]) {
            --mid;
        }
        return mid;
    }

    public double computeMassValue(double currentMass, double refMass) {
        double mass_diff = Math.abs(currentMass - refMass);
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
            return mass_diff;
        }
        return mass_diff / refMass * 1000000.0;
    }

    public double computeMassTolerance(double currentTollerance, double refMass) {
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA) {
            return currentTollerance;
        }
        return currentTollerance / 1000000.0 * refMass;
    }

    public void addModificationPattern(Modification modification) {
        AminoAcidPattern aap = modification.getPattern();
        HashMap<Integer, ArrayList<Character>> aaTargered = aap.getAaTargeted();
        Set<Integer> keySet = aaTargered.keySet();
        int startPos = Collections.min(keySet);
        int endPos = Collections.max(keySet);
        int patternLength = endPos - startPos + 1;
        if (patternLength > 62) {
            throw new UnsupportedOperationException("Pattern contains more than 64 sites, not supported");
        }
        long preMask = (1 << patternLength) - 1;
        for (int key2 : keySet) {
            preMask &= 1L << key2 - startPos ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Long[] masks = new Long[128];
        for (int i = 0; i < 128; ++i) {
            masks[i] = preMask;
        }
        keySet.stream().forEach(key -> ((ArrayList)aaTargered.get(key)).stream().forEach(c -> {
            char c2 = c.charValue();
            Long.valueOf(masks[c2] | 1L << key - startPos);
        }));
        this.modificationPatternNames.put(modification.getName(), new int[]{this.modificationPatterns.size(), startPos, patternLength});
        this.modificationPatterns.add(masks);
        this.longestModificationpattern = Math.max(this.longestModificationpattern, patternLength);
    }

    public boolean checkModificationPattern(PeptideProteinMapping peptideProteinMapping) {
        if (this.modificationPatterns.isEmpty()) {
            return true;
        }
        String searchText = peptideProteinMapping.getPeptideSequence();
        for (ModificationMatch modificationMatch : peptideProteinMapping.getVariableModifications()) {
            if (!this.modificationPatternNames.containsKey(modificationMatch.getModification())) continue;
            int[] ptmPatternData = this.modificationPatternNames.get(modificationMatch.getModification());
            Long[] masks = this.modificationPatterns.get(ptmPatternData[0]);
            int textPos = modificationMatch.getSite() - 1;
            if (textPos + ptmPatternData[1] < 0) {
                return false;
            }
            if (textPos + ptmPatternData[1] + ptmPatternData[2] > searchText.length()) {
                return false;
            }
            long pattern = 1L;
            int i = textPos + ptmPatternData[1];
            for (int j = 0; j < ptmPatternData[2] && pattern != 0L; ++j) {
                pattern = (pattern & masks[searchText.charAt(i)]) << 1;
                ++i;
            }
            return (1L << ptmPatternData[2] & pattern) > 0L;
        }
        return true;
    }

    public int[] computeMappingRanges(double mass) {
        int[] ranges = new int[]{0, -1};
        int low = 0;
        int mid = 0;
        int high = this.massIndexMaps.size() - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (this.massIndexMaps.get((int)mid).mass <= mass - this.computeMassTolerance(this.massTolerance, this.massIndexMaps.get((int)mid).mass)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        ranges[0] = Math.max(mid, 0);
        while (ranges[0] < this.massIndexMaps.size() - 1 && this.massIndexMaps.get((int)ranges[0]).mass < mass - this.computeMassTolerance(this.massTolerance, this.massIndexMaps.get((int)ranges[0]).mass)) {
            ranges[0] = ranges[0] + 1;
        }
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.DA && Math.abs(this.massIndexMaps.get((int)ranges[0]).mass - mass) > this.massTolerance) {
            return ranges;
        }
        if (this.massAccuracyType == SearchParameters.MassAccuracyType.PPM && this.computeMassValue(mass, this.massIndexMaps.get((int)ranges[0]).mass) > this.massTolerance) {
            return ranges;
        }
        low = ranges[0];
        high = this.massIndexMaps.size() - 1;
        while (low <= high) {
            mid = low + high >> 1;
            if (this.massIndexMaps.get((int)mid).mass < mass + this.computeMassTolerance(this.massTolerance, this.massIndexMaps.get((int)mid).mass)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        ranges[1] = Math.min(mid, this.massIndexMaps.size());
        while (0 < ranges[1] && this.massIndexMaps.get((int)ranges[1]).mass > mass + this.computeMassTolerance(this.massTolerance, this.massIndexMaps.get((int)ranges[1]).mass)) {
            ranges[1] = ranges[1] - 1;
        }
        return ranges;
    }

    public long getAllocatedBytes() {
        long bytes = 0L;
        for (int indexPart = 0; indexPart < this.indexParts; ++indexPart) {
            bytes += (long)(this.occurrenceTablesPrimary.get(indexPart).getAllocatedBytes() + this.occurrenceTablesReversed.get(indexPart).getAllocatedBytes() + this.suffixArraysPrimary.get(indexPart).length * 4);
            String[] accessionsPart = this.accessions.get(indexPart);
            for (int j = 0; j < accessionsPart.length; ++j) {
                bytes += (long)(accessionsPart[j].length() * 2);
            }
            for (String accKey : this.accessionMetaData.keySet()) {
                bytes += (long)(accKey.length() * 2);
                bytes += (long)(this.accessionMetaData.get(accKey).getHeaderAsString().length() * 2);
            }
            bytes += (long)(this.suffixArraysPrimary.get(indexPart).length * 4);
        }
        return bytes;
    }

    public FMIndex(File fastaFile, FastaParameters fastaParameters, WaitingHandler waitingHandler, boolean displayProgress, PeptideVariantsParameters peptideVariantsPreferences, SearchParameters searchParameters) throws IOException, OutOfMemoryError, RuntimeException, IllegalArgumentException {
        if (searchParameters != null) {
            this.massTolerance = searchParameters.getFragmentIonAccuracy();
            this.massAccuracyType = searchParameters.getFragmentAccuracyType();
            this.init(fastaFile, fastaParameters, waitingHandler, displayProgress, searchParameters, peptideVariantsPreferences, null);
        } else {
            this.init(fastaFile, fastaParameters, waitingHandler, displayProgress, null, peptideVariantsPreferences, null);
        }
    }

    public FMIndex(File fastaFile, FastaParameters fastaParameters, WaitingHandler waitingHandler, boolean displayProgress, IdentificationParameters identificationParameters) throws IOException, OutOfMemoryError, RuntimeException, IllegalArgumentException {
        this.init(fastaFile, fastaParameters, waitingHandler, displayProgress, identificationParameters.getSearchParameters(), identificationParameters.getPeptideVariantsParameters(), identificationParameters.getSequenceMatchingParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void init(File fastaFile, FastaParameters fastaParameters, WaitingHandler waitingHandler, boolean displayProgress, SearchParameters searchParameters, PeptideVariantsParameters peptideVariantsPreferences, SequenceMatchingParameters sequenceMatchingParameters) throws IOException, OutOfMemoryError, RuntimeException, IllegalArgumentException {
        int i;
        ModificationParameters modificationSettings;
        this.maxNumberVariants = peptideVariantsPreferences.getnVariants();
        this.variantMatchingType = peptideVariantsPreferences.getVariantType();
        this.maxNumberInsertions = peptideVariantsPreferences.getnAaInsertions();
        this.maxNumberDeletions = peptideVariantsPreferences.getnAaDeletions();
        this.maxNumberSubstitutions = peptideVariantsPreferences.getnAaSubstitutions();
        this.SNPs = peptideVariantsPreferences.getFixedVariants();
        if (sequenceMatchingParameters != null) {
            this.maxPTMsPerPeptide = sequenceMatchingParameters.getMaxPtmsPerTagPeptide();
            this.onlyTrypticPeptides = sequenceMatchingParameters.isEnzymaticTagsOnly();
        }
        TreeSet<Character> aaGroups = new TreeSet<Character>();
        aaGroups.add(Character.valueOf('B'));
        aaGroups.add(Character.valueOf('J'));
        aaGroups.add(Character.valueOf('X'));
        aaGroups.add(Character.valueOf('Z'));
        this.substitutionMatrix = new boolean[128][128];
        for (int i3 = 0; i3 < 128; ++i3) {
            for (int j = 0; j < 128; ++j) {
                this.substitutionMatrix[i3][j] = false;
            }
        }
        AaSubstitutionMatrix aaSubstitutionMatrix = peptideVariantsPreferences.getAaSubstitutionMatrix();
        for (int aa = 65; aa <= 90; ++aa) {
            HashSet<Character> substitutions;
            if (!aaSubstitutionMatrix.getOriginalAminoAcids().contains(Character.valueOf((char)aa)) || (substitutions = aaSubstitutionMatrix.getSubstitutionAminoAcids(Character.valueOf((char)aa))).isEmpty()) continue;
            for (char subAA : substitutions) {
                this.substitutionMatrix[aa][subAA] = true;
            }
        }
        ModificationParameters modificationParameters = modificationSettings = searchParameters != null ? searchParameters.getModificationParameters() : null;
        if (modificationSettings != null) {
            ArrayList<Character> targets;
            Modification ptm;
            int[] modificationCounts = new int[128];
            for (int i4 = 0; i4 < modificationCounts.length; ++i4) {
                modificationCounts[i4] = 0;
            }
            ModificationFactory ptmFactory = ModificationFactory.getInstance();
            ArrayList<String> variableModifications = ptmFactory.getExpectedVariableModifications(searchParameters);
            ArrayList<String> fixedModifications = modificationSettings.getFixedModifications();
            int hasVariableModification = 0;
            for (String modification : variableModifications) {
                Modification ptm2 = ptmFactory.getModification(modification);
                if (ptm2.getCategory() == ModificationCategory.Nucleotide_Substitution_One || ptm2.getCategory() == ModificationCategory.Nucleotide_Substitution_TwoPlus) continue;
                switch (ptm2.getModificationType()) {
                    case modaa: {
                        if (ptm2.getPattern().length() > 1) {
                            this.addModificationPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            char c2 = c.charValue();
                            modificationCounts[c2] = modificationCounts[c2] + 1;
                            hasVariableModification = Math.max(hasVariableModification, modificationCounts[c.charValue()]);
                        }
                        this.withVariableModifications = true;
                        break;
                    }
                    case modc_protein: {
                        if (this.vmodc == null) {
                            this.vmodc = new ArrayList();
                            this.vmodcMass = new ArrayList();
                            this.hasCTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                        }
                        this.vmodc.add(modification);
                        this.vmodcMass.add(ptm2.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modcaa_protein: {
                        if (this.vmodcaa == null) {
                            this.vmodcaa = new ArrayList[128];
                            for (int i5 = 0; i5 < 128; ++i5) {
                                this.vmodcaa[i5] = new ArrayList();
                            }
                            this.vmodcaaMass = new ArrayList[128];
                            for (int i2 = 0; i2 < 128; ++i2) {
                                this.vmodcaaMass[i2] = new ArrayList();
                            }
                            this.hasCTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addModificationPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodcaa[c.charValue()].add(modification);
                            this.vmodcaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modc_peptide: {
                        if (this.vmodcp == null) {
                            this.vmodcp = new ArrayList();
                            this.vmodcpMass = new ArrayList();
                            this.hasCTermDirectionModification = true;
                        }
                        this.vmodcp.add(modification);
                        this.vmodcpMass.add(ptm2.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modcaa_peptide: {
                        if (this.vmodcpaa == null) {
                            this.vmodcpaa = new ArrayList[128];
                            for (int i6 = 0; i6 < 128; ++i6) {
                                this.vmodcpaa[i6] = new ArrayList();
                            }
                            this.vmodcpaaMass = new ArrayList[128];
                            for (int i3 = 0; i3 < 128; ++i3) {
                                this.vmodcpaaMass[i3] = new ArrayList();
                            }
                            this.hasCTermDirectionModification = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addModificationPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodcpaa[c.charValue()].add(modification);
                            this.vmodcpaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modn_protein: {
                        if (this.vmodn == null) {
                            this.vmodn = new ArrayList();
                            this.vmodnMass = new ArrayList();
                            this.hasNTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                        }
                        this.vmodn.add(modification);
                        this.vmodnMass.add(ptm2.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modnaa_protein: {
                        if (this.vmodnaa == null) {
                            this.vmodnaa = new ArrayList[128];
                            for (int i7 = 0; i7 < 128; ++i7) {
                                this.vmodnaa[i7] = new ArrayList();
                            }
                            this.vmodnaaMass = new ArrayList[128];
                            for (int i4 = 0; i4 < 128; ++i4) {
                                this.vmodnaaMass[i4] = new ArrayList();
                            }
                            this.hasNTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addModificationPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodnaa[c.charValue()].add(modification);
                            this.vmodnaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modn_peptide: {
                        if (this.vmodnp == null) {
                            this.vmodnp = new ArrayList();
                            this.vmodnpMass = new ArrayList();
                            this.hasNTermDirectionModification = true;
                        }
                        this.vmodnp.add(modification);
                        this.vmodnpMass.add(ptm2.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                        break;
                    }
                    case modnaa_peptide: {
                        if (this.vmodnpaa == null) {
                            this.vmodnpaa = new ArrayList[128];
                            for (int i8 = 0; i8 < 128; ++i8) {
                                this.vmodnpaa[i8] = new ArrayList();
                            }
                            this.vmodnpaaMass = new ArrayList[128];
                            for (int i5 = 0; i5 < 128; ++i5) {
                                this.vmodnpaaMass[i5] = new ArrayList();
                            }
                            this.hasNTermDirectionModification = true;
                        }
                        if (ptm2.getPattern().length() > 1) {
                            this.addModificationPattern(ptm2);
                        }
                        ArrayList<Character> targets2 = ptm2.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets2) {
                            this.vmodnpaa[c.charValue()].add(modification);
                            this.vmodnpaaMass[c.charValue()].add(ptm2.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm2.getMass());
                    }
                }
            }
            this.aaMasses = new double[128 * (1 + hasVariableModification)];
            this.modifictationLabels = new String[128 * (1 + hasVariableModification)];
            this.modificationFlags = new boolean[128 * (1 + hasVariableModification)];
            for (int i9 = 0; i9 < this.aaMasses.length; ++i9) {
                this.aaMasses[i9] = -1.0;
                this.modifictationLabels[i9] = null;
                this.modificationFlags[i9] = false;
            }
            char[] aminoAcids = AminoAcid.getAminoAcids();
            for (int i10 = 0; i10 < aminoAcids.length; ++i10) {
                if (aaGroups.contains(Character.valueOf(aminoAcids[i10]))) continue;
                this.aaMasses[aminoAcids[i10]] = AminoAcid.getAminoAcid(aminoAcids[i10]).getMonoisotopicMass();
            }
            block48: for (String modification : fixedModifications) {
                ptm = ptmFactory.getModification(modification);
                if (ptm.getCategory() == ModificationCategory.Nucleotide_Substitution_One || ptm.getCategory() == ModificationCategory.Nucleotide_Substitution_TwoPlus) continue;
                switch (ptm.getModificationType()) {
                    case modaa: {
                        if (ptm.getPattern().length() > 1) {
                            this.addModificationPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            char c3 = c.charValue();
                            this.aaMasses[c3] = this.aaMasses[c3] + ptm.getMass();
                            if (!this.modificationLabelsToId.containsKey(ptm.getName())) {
                                this.modificationLabelsToId.put(ptm.getName(), Integer.valueOf(c.charValue()));
                            } else {
                                this.modificationLabelsToId.replace(ptm.getName(), Integer.valueOf(c.charValue()));
                            }
                            this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        }
                        continue block48;
                    }
                    case modc_protein: {
                        if (this.fmodc == null) {
                            this.fmodc = new ArrayList();
                            this.fmodcMass = new ArrayList();
                            this.hasCTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                            this.hasFixedModification_CatTerminus = true;
                        }
                        this.fmodc.add(modification);
                        this.fmodcMass.add(ptm.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modcaa_protein: {
                        if (this.fmodcaa == null) {
                            void var21_66;
                            void var21_64;
                            this.fmodcaa = new ArrayList[128];
                            boolean bl = false;
                            while (var21_64 < 128) {
                                this.fmodcaa[var21_64] = new ArrayList();
                                ++var21_64;
                            }
                            this.fmodcaaMass = new ArrayList[128];
                            boolean bl2 = false;
                            while (var21_66 < 128) {
                                this.fmodcaaMass[var21_66] = new ArrayList();
                                ++var21_66;
                            }
                            this.hasCTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                            this.hasFixedModification_CatTerminus = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addModificationPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodcaa[c.charValue()].add(modification);
                            this.fmodcaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modc_peptide: {
                        if (this.fmodcp == null) {
                            this.fmodcp = new ArrayList();
                            this.fmodcpMass = new ArrayList();
                            this.hasCTermDirectionModification = true;
                        }
                        this.fmodcp.add(modification);
                        this.fmodcpMass.add(ptm.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modcaa_peptide: {
                        if (this.fmodcpaa == null) {
                            void var21_71;
                            void var21_69;
                            this.fmodcpaa = new ArrayList[128];
                            boolean bl = false;
                            while (var21_69 < 128) {
                                this.fmodcpaa[var21_69] = new ArrayList();
                                ++var21_69;
                            }
                            this.fmodcpaaMass = new ArrayList[128];
                            boolean bl3 = false;
                            while (var21_71 < 128) {
                                this.fmodcpaaMass[var21_71] = new ArrayList();
                                ++var21_71;
                            }
                            this.hasCTermDirectionModification = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addModificationPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodcpaa[c.charValue()].add(modification);
                            this.fmodcpaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modn_protein: {
                        if (this.fmodn == null) {
                            this.fmodn = new ArrayList();
                            this.fmodnMass = new ArrayList();
                            this.hasNTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                            this.hasFixedModification_NatTerminus = true;
                        }
                        this.fmodn.add(modification);
                        this.fmodnMass.add(ptm.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modnaa_protein: {
                        if (this.fmodnaa == null) {
                            void var21_76;
                            void var21_74;
                            this.fmodnaa = new ArrayList[128];
                            boolean bl = false;
                            while (var21_74 < 128) {
                                this.fmodnaa[var21_74] = new ArrayList();
                                ++var21_74;
                            }
                            this.fmodnaaMass = new ArrayList[128];
                            boolean bl4 = false;
                            while (var21_76 < 128) {
                                this.fmodnaaMass[var21_76] = new ArrayList();
                                ++var21_76;
                            }
                            this.hasNTermDirectionModification = true;
                            this.hasModificationatTerminus = true;
                            this.hasFixedModification_NatTerminus = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addModificationPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodnaa[c.charValue()].add(modification);
                            this.fmodnaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modn_peptide: {
                        if (this.fmodnp == null) {
                            this.fmodnp = new ArrayList();
                            this.fmodnpMass = new ArrayList();
                            this.hasNTermDirectionModification = true;
                        }
                        this.fmodnp.add(modification);
                        this.fmodnpMass.add(ptm.getMass());
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                        break;
                    }
                    case modnaa_peptide: {
                        if (this.fmodnpaa == null) {
                            void var21_81;
                            void var21_79;
                            this.fmodnpaa = new ArrayList[128];
                            boolean bl = false;
                            while (var21_79 < 128) {
                                this.fmodnpaa[var21_79] = new ArrayList();
                                ++var21_79;
                            }
                            this.fmodnpaaMass = new ArrayList[128];
                            boolean bl5 = false;
                            while (var21_81 < 128) {
                                this.fmodnpaaMass[var21_81] = new ArrayList();
                                ++var21_81;
                            }
                            this.hasNTermDirectionModification = true;
                        }
                        if (ptm.getPattern().length() > 1) {
                            this.addModificationPattern(ptm);
                        }
                        targets = ptm.getPattern().getAminoAcidsAtTarget();
                        for (Character c : targets) {
                            this.fmodnpaa[c.charValue()].add(modification);
                            this.fmodnpaaMass[c.charValue()].add(ptm.getMass());
                        }
                        this.negativeModificationMass = Math.min(this.negativeModificationMass, ptm.getMass());
                    }
                }
            }
            for (int i15 = 0; i15 < modificationCounts.length; ++i15) {
                modificationCounts[i15] = 0;
            }
            for (String modification : variableModifications) {
                ptm = ptmFactory.getModification(modification);
                if (ptm.getModificationType() != ModificationType.modaa) continue;
                targets = ptm.getPattern().getAminoAcidsAtTarget();
                for (Character c : targets) {
                    int modPos = 128 * (1 + modificationCounts[c.charValue()]) + c.charValue();
                    this.aaMasses[modPos] = this.aaMasses[c.charValue()] + ptm.getMass();
                    if (!this.modificationLabelsToId.containsKey(ptm.getName())) {
                        this.modificationLabelsToId.put(ptm.getName(), modPos);
                    } else {
                        this.modificationLabelsToId.replace(ptm.getName(), modPos);
                    }
                    this.modifictationLabels[128 * (1 + modificationCounts[c.charValue()]) + c.charValue()] = modification;
                    this.modificationFlags[128 * (1 + modificationCounts[c.charValue()]) + c.charValue()] = true;
                    char c4 = c.charValue();
                    modificationCounts[c4] = modificationCounts[c4] + 1;
                }
            }
        } else {
            this.aaMasses = new double[128];
            for (int i16 = 0; i16 < this.aaMasses.length; ++i16) {
                this.aaMasses[i16] = -1.0;
            }
            char[] aminoAcids = AminoAcid.getAminoAcids();
            for (int i17 = 0; i17 < aminoAcids.length; ++i17) {
                if (aaGroups.contains(Character.valueOf(aminoAcids[i17]))) continue;
                this.aaMasses[aminoAcids[i17]] = AminoAcid.getAminoAcid(aminoAcids[i17]).getMonoisotopicMass();
            }
        }
        ArrayList<Integer> aaMassVector = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.aaMasses.length; ++i2) {
            if (!(this.aaMasses[i2] > 0.0)) continue;
            aaMassVector.add(i2);
        }
        this.aaMassIndexes = new int[aaMassVector.size()];
        for (int i6 = 0; i6 < aaMassVector.size(); ++i6) {
            this.aaMassIndexes[i6] = (Integer)aaMassVector.get(i6);
        }
        this.numMasses = aaMassVector.size() + 1;
        char[] sortedAas = new char[AminoAcid.getAminoAcids().length + 2];
        System.arraycopy(AminoAcid.getAminoAcids(), 0, sortedAas, 0, AminoAcid.getAminoAcids().length);
        sortedAas[AminoAcid.getAminoAcids().length] = SENTINEL;
        sortedAas[AminoAcid.getAminoAcids().length + 1] = DELIMITER;
        Arrays.sort(sortedAas);
        long[] alphabet = new long[]{0L, 0L};
        for (int i18 = 0; i18 < sortedAas.length; ++i18) {
            int n = sortedAas[i18] >> 6;
            alphabet[n] = alphabet[n] | 1L << (sortedAas[i18] & 0x3F);
        }
        String fastaExtension = IoUtil.getExtension(fastaFile);
        File FMFile = new File(fastaFile.getAbsolutePath().replace(fastaExtension, ".fmi"));
        boolean loadFasta = true;
        if (FMFile.exists()) {
            DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(FMFile.getAbsolutePath()), 0x100000));
            try (ObjectInputStream ois = null;){
                ois = new ObjectInputStream(is);
                String loadedVersionNumber = ois.readUTF();
                if (FM_INDEX_VERSION_NUMBER.equals(loadedVersionNumber)) {
                    this.indexParts = ois.readInt();
                    this.indexStringLengths = (ArrayList)ois.readObject();
                    this.suffixArraysPrimary = (ArrayList)ois.readObject();
                    this.occurrenceTablesPrimary = (ArrayList)ois.readObject();
                    this.occurrenceTablesReversed = (ArrayList)ois.readObject();
                    this.lessTablesPrimary = (ArrayList)ois.readObject();
                    this.lessTablesReversed = (ArrayList)ois.readObject();
                    this.boundaries = (ArrayList)ois.readObject();
                    this.accessions = (ArrayList)ois.readObject();
                    this.decoyAccessions = (HashSet)ois.readObject();
                    this.accessionMetaData = (HashMap)ois.readObject();
                    loadFasta = false;
                }
            }
        }
        if (loadFasta) {
            boolean bl;
            Protein protein;
            ArrayList<Integer> tmpLengths = new ArrayList<Integer>();
            ArrayList<Integer> tmpProteins = new ArrayList<Integer>();
            long ticker = 0x6400000L;
            boolean bl6 = true;
            int numProteins = 0;
            FastaIterator pi = new FastaIterator(fastaFile);
            while ((protein = pi.getNextProtein()) != null) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                    return;
                }
                int proteinLen = protein.getLength();
                ++numProteins;
                if ((long)(bl += proteinLen) <= ticker) continue;
                tmpLengths.add(bl ? 1 : 0);
                tmpProteins.add(numProteins);
                bl = true;
                numProteins = 0;
            }
            tmpLengths.add(bl ? 1 : 0);
            tmpProteins.add(numProteins);
            int maxProgressBar = 11 * tmpLengths.size();
            if (waitingHandler != null && displayProgress && !waitingHandler.isRunCanceled()) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(maxProgressBar);
                waitingHandler.setSecondaryProgressCounter(0);
            }
            pi = new FastaIterator(fastaFile);
            for (int i19 = 0; i19 < tmpLengths.size(); ++i19) {
                this.addDataToIndex(pi, (Integer)tmpLengths.get(i19), (Integer)tmpProteins.get(i19), alphabet, fastaParameters, waitingHandler, displayProgress);
            }
        }
        int lookupLength = (int)(802.0 * this.lookupMultiplier);
        this.lookupMasses = new long[(lookupLength >>> 6) + 3];
        for (i = 0; i < this.lookupMasses.length; ++i) {
            this.lookupMasses[i] = 0L;
        }
        this.Xlookup = new long[this.maxXPerTag + 1][];
        for (i = 1; i <= this.maxXPerTag; ++i) {
            this.Xlookup[i] = new long[(lookupLength >>> 6) + 3];
            for (int j = 0; j < this.Xlookup[i].length; ++j) {
                this.Xlookup[i][j] = 0L;
            }
        }
        this.massIndexMaps = new ArrayList(1000000);
        this.recursiveMassFilling(0.0, 0, 0, null);
        Collections.sort(this.massIndexMaps, new Comparator<MassIndexMap>(){

            @Override
            public int compare(MassIndexMap m1, MassIndexMap m2) {
                return (int)((m1.mass - m2.mass) * 1000000.0);
            }
        });
        this.cache = new HashMap[this.indexParts];
        for (int indexPart = 0; indexPart < this.indexParts; ++indexPart) {
            this.cache[indexPart] = new HashMap();
        }
        if (this.variantMatchingType == PeptideVariantsParameters.VariantType.FIXED) {
            for (int prt = 0; prt < this.indexParts; ++prt) {
                int[] aminoInfo;
                int[] aminoInfo2;
                int[] lessTablePrimary = this.lessTablesPrimary.get(prt);
                WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(prt);
                int n = occurrenceTablePrimary.getLength();
                long[] variantPrimBits = new long[(n >>> 6) + 1];
                long[] variantRevBits = new long[(n >>> 6) + 1];
                HashSet[] variantsPrimTmp = new HashSet[n];
                HashSet[] variantsPrim = null;
                HashSet[] variantsRevTmp = new HashSet[n];
                HashSet[] variantsRev = null;
                int numVariants = 0;
                int[] SA = new int[n];
                SA[0] = n - 1;
                int idx = 0;
                int sa = SA[0];
                while ((idx = lessTablePrimary[(aminoInfo2 = occurrenceTablePrimary.getCharacterInfo(idx))[0]] + aminoInfo2[1]) != 0) {
                    SA[idx] = --sa;
                }
                lessTablePrimary = null;
                occurrenceTablePrimary = null;
                int[] inversedSampledSuffixArray = new int[n];
                for (int i20 = 0; i20 < n; ++i20) {
                    inversedSampledSuffixArray[SA[i20]] = i20;
                }
                SA = null;
                for (String accession : this.accessions.get(prt)) {
                    if (!this.SNPs.containsKey(accession)) continue;
                    for (SNPElement SNP : this.SNPs.get(accession)) {
                        int offset = SNP.sourceAA == '*' ? 1 : 0;
                        int posSNP = inversedSampledSuffixArray[this.accessionMetaData.get((Object)accession).trueBeginning + SNP.position + offset];
                        int n2 = posSNP >>> 6;
                        variantPrimBits[n2] = variantPrimBits[n2] | 1L << (posSNP & 0x3F);
                        if (variantsPrimTmp[posSNP] == null) {
                            variantsPrimTmp[posSNP] = new HashSet();
                        }
                        variantsPrimTmp[posSNP].add(new int[]{SNP.sourceAA, SNP.targetAA, posSNP});
                        ++numVariants;
                    }
                }
                inversedSampledSuffixArray = null;
                variantsPrim = new HashSet[numVariants];
                int j = 0;
                for (int i21 = 0; i21 < n; ++i21) {
                    if (variantsPrimTmp[i21] == null) continue;
                    variantsPrim[j++] = variantsPrimTmp[i21];
                }
                this.variantBitsPrimary.add(new Rank(variantPrimBits, n));
                this.variantsPrimary.add(variantsPrim);
                int[] lessTableReversed = this.lessTablesReversed.get(prt);
                WaveletTree occurrenceTableReversed = this.occurrenceTablesReversed.get(prt);
                idx = 0;
                SA = new int[n];
                SA[0] = n - 1;
                sa = SA[0];
                while ((idx = lessTableReversed[(aminoInfo = occurrenceTableReversed.getCharacterInfo(idx))[0]] + aminoInfo[1]) != 0) {
                    SA[idx] = --sa;
                }
                lessTableReversed = null;
                occurrenceTableReversed = null;
                inversedSampledSuffixArray = new int[n];
                for (int i22 = 0; i22 < n; ++i22) {
                    inversedSampledSuffixArray[SA[i22]] = i22;
                }
                for (String accession : this.accessions.get(prt)) {
                    if (!this.SNPs.containsKey(accession)) continue;
                    for (SNPElement SNP : this.SNPs.get(accession)) {
                        int posSNP = inversedSampledSuffixArray[n - 2 - (this.accessionMetaData.get((Object)accession).trueBeginning + SNP.position)];
                        int n3 = posSNP >>> 6;
                        variantRevBits[n3] = variantRevBits[n3] | 1L << (posSNP & 0x3F);
                        if (variantsRevTmp[posSNP] == null) {
                            variantsRevTmp[posSNP] = new HashSet();
                        }
                        variantsRevTmp[posSNP].add(new int[]{SNP.sourceAA, SNP.targetAA, posSNP});
                    }
                }
                variantsRev = new HashSet[numVariants];
                int j2 = 0;
                for (int i23 = 0; i23 < n; ++i23) {
                    if (variantsRevTmp[i23] == null) continue;
                    variantsRev[j2++] = variantsRevTmp[i23];
                }
                this.variantBitsReversed.add(new Rank(variantRevBits, n));
                this.variantsReversed.add(variantsRev);
            }
        }
        if (loadFasta) {
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(FMFile.getAbsolutePath())));
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeUTF(FM_INDEX_VERSION_NUMBER);
            oos.writeInt(this.indexParts);
            oos.writeObject(this.indexStringLengths);
            oos.writeObject(this.suffixArraysPrimary);
            oos.writeObject(this.occurrenceTablesPrimary);
            oos.writeObject(this.occurrenceTablesReversed);
            oos.writeObject(this.lessTablesPrimary);
            oos.writeObject(this.lessTablesReversed);
            oos.writeObject(this.boundaries);
            oos.writeObject(this.accessions);
            oos.writeObject(this.decoyAccessions);
            oos.writeObject(this.accessionMetaData);
            oos.close();
        }
    }

    void addDataToIndex(ProteinIterator pi, int indexStringLength, int numProteins, long[] alphabet, FastaParameters fastaParameters, WaitingHandler waitingHandler, boolean displayProgress) throws IOException, OutOfMemoryError, RuntimeException, IllegalArgumentException {
        int i;
        ++this.indexParts;
        this.indexStringLengths.add(indexStringLength += numProteins + 1);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        byte[] T = new byte[indexStringLength];
        T[0] = (byte)DELIMITER;
        T[indexStringLength - 2] = (byte)DELIMITER;
        T[indexStringLength - 1] = (byte)SENTINEL;
        int[] bndaries = new int[numProteins + 1];
        this.boundaries.add(bndaries);
        String[] accssions = new String[numProteins];
        int indexPart = this.accessions.size();
        this.accessions.add(accssions);
        this.boundaries.get((int)0)[0] = 1;
        int tmpN = 0;
        int tmpNumProtein = 0;
        HashMap<String, Integer> accessionEndings = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < numProteins; ++i2) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            Protein currentProtein = pi.getNextProtein();
            if (currentProtein == null) {
                throw new IllegalArgumentException("More sequences from database requested than contained.");
            }
            String accession = currentProtein.getAccession();
            Header headerObject = ((FastaIterator)pi).getLastHeader();
            String headerAsString = headerObject.getRawHeader();
            if (headerAsString.charAt(0) == '>') {
                headerAsString = headerAsString.substring(1).trim();
            }
            AccessionMetaData accMD = new AccessionMetaData(headerAsString);
            this.accessionMetaData.put(accession, accMD);
            if (accession == null || accession.equals("")) {
                accession = headerAsString;
            }
            if (fastaParameters != null && ProteinUtils.isDecoy(accession, fastaParameters)) {
                this.decoyAccessions.add(accession);
            }
            int proteinLen = currentProtein.getLength();
            T[tmpN++] = (byte)DELIMITER;
            accMD.trueBeginning = tmpN;
            accessionEndings.put(accession, tmpN + proteinLen);
            for (char c : currentProtein.getSequence().toCharArray()) {
                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') continue;
                throw new IllegalArgumentException("Protein sequence of protein '" + headerAsString + "' contains invalid character: '" + Character.toString(c) + "'.");
            }
            System.arraycopy(currentProtein.getSequence().toUpperCase().getBytes(), 0, T, tmpN, proteinLen);
            accssions[tmpNumProtein++] = accession;
            bndaries[tmpNumProtein] = (tmpN += proteinLen) + 1;
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        int[] T_int = new int[indexStringLength];
        for (int i3 = 0; i3 < indexStringLength; ++i3) {
            T_int[i3] = T[i3];
        }
        int[] suffixArrayPrimary = null;
        try {
            suffixArrayPrimary = new DivSufSort().buildSuffixArray(T_int, 0, indexStringLength);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred during index computation (suffix array):\n\n" + e);
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        T_int = null;
        int[] inversedSampledSuffixArray = new int[indexStringLength];
        for (int i4 = 0; i4 < indexStringLength; ++i4) {
            inversedSampledSuffixArray[suffixArrayPrimary[i4]] = i4;
        }
        for (String accession : accessionEndings.keySet()) {
            int truePos = (Integer)accessionEndings.get(accession);
            AccessionMetaData accessionMeta = this.accessionMetaData.get(accession);
            accessionMeta.index = inversedSampledSuffixArray[truePos];
            accessionMeta.indexPart = indexPart;
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        inversedSampledSuffixArray = null;
        byte[] bwt = new byte[indexStringLength];
        for (int i5 = 0; i5 < indexStringLength; ++i5) {
            bwt[i5] = suffixArrayPrimary[i5] != 0 ? T[suffixArrayPrimary[i5] - 1] : T[indexStringLength - 1];
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        int[] sampledSuffixArray = new int[(indexStringLength + 1 >> 3) + 1];
        int sampledIndex = 0;
        for (int i6 = 0; i6 < indexStringLength; i6 += 8) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            sampledSuffixArray[sampledIndex++] = suffixArrayPrimary[i6];
        }
        this.suffixArraysPrimary.add(sampledSuffixArray);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        WaveletTree occurrenceTablePrimary = new WaveletTree(bwt, alphabet, waitingHandler);
        int[] lessTablePrimary = occurrenceTablePrimary.createLessTable();
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        bwt = null;
        byte[] TReversed = new byte[indexStringLength];
        for (i = 0; i < indexStringLength - 1; ++i) {
            TReversed[indexStringLength - 2 - i] = T[i];
        }
        TReversed[indexStringLength - 1] = (byte)SENTINEL;
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        T_int = new int[indexStringLength];
        for (i = 0; i < indexStringLength; ++i) {
            T_int[i] = TReversed[i];
        }
        int[] suffixArrayReversed = new DivSufSort().buildSuffixArray(T_int, 0, indexStringLength);
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        bwt = new byte[indexStringLength];
        for (int i7 = 0; i7 < indexStringLength; ++i7) {
            bwt[i7] = suffixArrayReversed[i7] != 0 ? TReversed[suffixArrayReversed[i7] - 1] : TReversed[indexStringLength - 1];
        }
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        WaveletTree occurrenceTableReversed = new WaveletTree(bwt, alphabet, waitingHandler);
        int[] lessTableReversed = occurrenceTableReversed.createLessTable();
        if (displayProgress && waitingHandler != null && !waitingHandler.isRunCanceled()) {
            waitingHandler.increaseSecondaryProgressCounter();
        }
        this.occurrenceTablesPrimary.add(occurrenceTablePrimary);
        this.occurrenceTablesReversed.add(occurrenceTableReversed);
        this.lessTablesPrimary.add(lessTablePrimary);
        this.lessTablesReversed.add(lessTableReversed);
    }

    void recursiveMassFilling(double mass, int pos, int loop, int[] massIndexes) {
        if (mass >= 800.0) {
            return;
        }
        double transformedMass = this.computeMassTolerance(this.massTolerance, mass);
        if (mass > transformedMass) {
            int p;
            int startMass = (int)((mass - transformedMass) * this.lookupMultiplier);
            int endMass = (int)((mass + transformedMass) * this.lookupMultiplier + 1.0);
            int n = startMass >>> 6;
            this.lookupMasses[n] = this.lookupMasses[n] | -1L << (startMass & 0x3F);
            for (p = (startMass >>> 6) + 1; p < endMass >>> 6; ++p) {
                this.lookupMasses[p] = -1L;
            }
            int n2 = endMass >>> 6;
            this.lookupMasses[n2] = this.lookupMasses[n2] | -1L >>> 64 - (endMass & 0x3F);
            startMass = (int)((mass + 1.0 - transformedMass) * this.lookupMultiplier);
            endMass = (int)((mass + 1.0 + transformedMass) * this.lookupMultiplier + 1.0);
            if (loop <= this.maxXPerTag) {
                long[] lArray = this.Xlookup[loop];
                int n3 = startMass >>> 6;
                lArray[n3] = lArray[n3] | -1L << (startMass & 0x3F);
                for (p = (startMass >>> 6) + 1; p < endMass >>> 6; ++p) {
                    this.Xlookup[loop][p] = -1L;
                }
                long[] lArray2 = this.Xlookup[loop];
                int n4 = endMass >>> 6;
                lArray2[n4] = lArray2[n4] | -1L >>> 64 - (endMass & 0x3F);
                this.massIndexMaps.add(new MassIndexMap(mass, massIndexes));
            }
        }
        for (int i = pos; i < this.aaMassIndexes.length; ++i) {
            int[] massIndexesNew = new int[massIndexes != null ? massIndexes.length + 1 : 1];
            if (massIndexes != null) {
                for (int j = 0; j < massIndexes.length; ++j) {
                    massIndexesNew[j] = massIndexes[j];
                }
            }
            massIndexesNew[massIndexesNew.length - 1] = this.aaMassIndexes[i];
            this.recursiveMassFilling(mass + this.aaMasses[this.aaMassIndexes[i]], i, loop + 1, massIndexesNew);
        }
    }

    private ArrayList<String> createPeptideCombinations(String peptide, SequenceMatchingParameters seqMatchPref) {
        ArrayList<String> combinations;
        block11: {
            SequenceMatchingParameters.MatchingType sequenceMatchingType;
            block10: {
                combinations = new ArrayList<String>();
                sequenceMatchingType = seqMatchPref.getSequenceMatchingType();
                if (sequenceMatchingType != SequenceMatchingParameters.MatchingType.string) break block10;
                for (int i = 0; i < peptide.length(); ++i) {
                    combinations.add(peptide.substring(i, i + 1));
                }
                break block11;
            }
            if (sequenceMatchingType != SequenceMatchingParameters.MatchingType.aminoAcid && sequenceMatchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids) break block11;
            boolean indistinghuishable = sequenceMatchingType == SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids;
            for (int i = 0; i < peptide.length(); ++i) {
                int j;
                String chars = peptide.substring(i, i + 1);
                char[] aaCombinations = AminoAcid.getAminoAcid(peptide.charAt(i)).getCombinations();
                for (j = 0; j < aaCombinations.length; ++j) {
                    chars = chars + aaCombinations[j];
                }
                if (peptide.charAt(i) == 'B' || peptide.charAt(i) == 'J' || peptide.charAt(i) == 'Z') {
                    aaCombinations = AminoAcid.getAminoAcid(peptide.charAt(i)).getSubAminoAcids(false);
                    for (j = 0; j < aaCombinations.length; ++j) {
                        chars = chars + aaCombinations[j];
                    }
                }
                if (indistinghuishable && (peptide.charAt(i) == 'I' || peptide.charAt(i) == 'L')) {
                    switch (peptide.charAt(i)) {
                        case 'I': {
                            chars = chars + "L";
                            break;
                        }
                        case 'L': {
                            chars = chars + "I";
                        }
                    }
                }
                combinations.add(chars);
            }
        }
        return combinations;
    }

    private TagElement[] createPeptideCombinations(TagElement[] tagComponents, SequenceMatchingParameters seqMatchPref) {
        TagElement[] combinations;
        block18: {
            SequenceMatchingParameters.MatchingType sequenceMatchingType;
            block17: {
                int numElements = 0;
                for (int i = 0; i < tagComponents.length; ++i) {
                    if (tagComponents[i].isMass) {
                        ++numElements;
                        continue;
                    }
                    numElements += tagComponents[i].sequence.length();
                }
                combinations = new TagElement[numElements];
                int combinationPosition = 0;
                sequenceMatchingType = seqMatchPref.getSequenceMatchingType();
                if (sequenceMatchingType != SequenceMatchingParameters.MatchingType.string) break block17;
                for (TagElement tagElement : tagComponents) {
                    if (tagElement.isMass) {
                        combinations[combinationPosition++] = new TagElement(true, "", tagElement.mass, tagElement.xNumLimit);
                        continue;
                    }
                    for (int j = 0; j < tagElement.sequence.length(); ++j) {
                        combinations[combinationPosition++] = new TagElement(false, tagElement.sequence.substring(j, j + 1), tagElement.mass, tagElement.xNumLimit);
                    }
                }
                break block18;
            }
            if (sequenceMatchingType != SequenceMatchingParameters.MatchingType.aminoAcid && sequenceMatchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids) break block18;
            boolean indistinghuishable = sequenceMatchingType == SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids;
            for (TagElement tagElement : tagComponents) {
                if (!tagElement.isMass) {
                    String subSequence = tagElement.sequence;
                    for (int s = 0; s < subSequence.length(); ++s) {
                        int j;
                        char amino = subSequence.charAt(s);
                        int mod = tagElement.modifications != null ? tagElement.modifications[s] : -1;
                        String chars = String.valueOf(amino);
                        char[] aaCombinations = AminoAcid.getAminoAcid(amino).getCombinations();
                        for (j = 0; j < aaCombinations.length; ++j) {
                            chars = chars + aaCombinations[j];
                        }
                        if (amino == 'B' || amino == 'J' || amino == 'Z') {
                            aaCombinations = AminoAcid.getAminoAcid(amino).getSubAminoAcids(false);
                            for (j = 0; j < aaCombinations.length; ++j) {
                                chars = chars + aaCombinations[j];
                            }
                        }
                        if (indistinghuishable && (amino == 'I' || amino == 'L')) {
                            switch (amino) {
                                case 'I': {
                                    chars = chars + "L";
                                    break;
                                }
                                case 'L': {
                                    chars = chars + "I";
                                }
                            }
                        }
                        Integer[] mods = new Integer[chars.length()];
                        for (int i = 0; i < mods.length; ++i) {
                            mods[i] = mod;
                        }
                        combinations[combinationPosition++] = new TagElement(false, chars, tagElement.mass, tagElement.xNumLimit, mods);
                    }
                    continue;
                }
                combinations[combinationPosition++] = new TagElement(true, "", tagElement.mass, tagElement.xNumLimit);
            }
        }
        return combinations;
    }

    private int getTextPosition(int index, int indexPart) {
        int[] suffixArrayPrimary = this.suffixArraysPrimary.get(indexPart);
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int indexStringLength = this.indexStringLengths.get(indexPart);
        int numIterations = 0;
        while ((index & 7) != 0 && index != 0) {
            int[] aminoInfo = occurrenceTablePrimary.getCharacterInfo(index);
            index = lessTablePrimary[aminoInfo[0]] + aminoInfo[1];
            ++numIterations;
        }
        int pos = suffixArrayPrimary[index >> 3] + numIterations;
        return pos < indexStringLength ? pos : pos - indexStringLength;
    }

    @Override
    public ArrayList<PeptideProteinMapping> getProteinMapping(String peptide, SequenceMatchingParameters sequenceMatchingParameters) {
        ArrayList<PeptideProteinMapping> peptideProteinMapping = new ArrayList<PeptideProteinMapping>();
        switch (this.variantMatchingType) {
            case GENERIC: {
                for (int i = 0; i < this.indexParts; ++i) {
                    peptideProteinMapping.addAll(this.getProteinMappingWithVariantsGeneric(peptide, sequenceMatchingParameters, i));
                }
                break;
            }
            case SPECIFIC: {
                for (int i = 0; i < this.indexParts; ++i) {
                    peptideProteinMapping.addAll(this.getProteinMappingWithVariantsSpecific(peptide, sequenceMatchingParameters, i));
                }
                break;
            }
            case FIXED: {
                for (int i = 0; i < this.indexParts; ++i) {
                    peptideProteinMapping.addAll(this.getProteinMappingWithVariantsFixed(peptide, sequenceMatchingParameters, i));
                }
                break;
            }
            default: {
                for (int i = 0; i < this.indexParts; ++i) {
                    peptideProteinMapping.addAll(this.getProteinMappingWithoutVariants(peptide, sequenceMatchingParameters, i));
                }
            }
        }
        return peptideProteinMapping;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithoutVariants(String peptide, SequenceMatchingParameters seqMatchPref, int indexPart) {
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int maxX = (int)(seqMatchPref.getLimitX() * (double)lenPeptide);
        ArrayList[] backwardList = new ArrayList[lenPeptide + 1];
        int countX = 0;
        for (int i = 0; i <= lenPeptide; ++i) {
            backwardList[i] = new ArrayList(10);
            if (i >= lenPeptide || pep_rev.charAt(i) != 'X') continue;
            ++countX;
        }
        if (countX <= maxX) {
            backwardList[0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int j = 0; j < lenPeptide; ++j) {
                String combinationSequence = combinations.get(j);
                ArrayList cell = backwardList[j];
                for (MatrixContent content : cell) {
                    int leftIndexOld = content.left;
                    int rightIndexOld = content.right;
                    int numX = content.numX;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int newNumX;
                        int rightIndex;
                        int[] range;
                        char aminoAcid = combinationSequence.charAt(c);
                        int lessValue = lessTablePrimary[aminoAcid];
                        int leftIndex = lessValue + (range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid))[0];
                        if (leftIndex > (rightIndex = lessValue + range[1] - 1) || (newNumX = numX + (aminoAcid == 'X' ? 1 : 0)) > maxX) continue;
                        backwardList[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX));
                    }
                }
            }
            Iterator iterator = backwardList[lenPeptide].iterator();
            while (iterator.hasNext()) {
                MatrixContent content;
                MatrixContent currentContent = content = (MatrixContent)iterator.next();
                String currentPeptide = "";
                while (currentContent.previousContent != null) {
                    currentPeptide = currentPeptide + (char)currentContent.character;
                    currentContent = currentContent.previousContent;
                }
                int leftIndex = content.left;
                int rightIndex = content.right;
                int j = leftIndex;
                while (j <= rightIndex) {
                    int pos = this.getTextPosition(j, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, currentPeptide, pos - this.boundaries.get(indexPart)[index]);
                    peptideProteinMapping.fmIndexPosition = j++;
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariantsFixed(String peptide, SequenceMatchingParameters seqMatchPref, int indexPart) {
        int j;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        Rank variantPositionsPrimary = this.variantBitsPrimary.get(indexPart);
        HashSet<int[]>[] variantsListPrimary = this.variantsPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int xNumLimit = (int)(seqMatchPref.getLimitX() * (double)lenPeptide);
        ArrayList[][] backwardMatrix = new ArrayList[1][lenPeptide + 1];
        for (int k = 0; k < 1; ++k) {
            for (j = 0; j <= lenPeptide; ++j) {
                backwardMatrix[k][j] = new ArrayList(10);
            }
        }
        int countX = 0;
        for (j = 0; j <= lenPeptide; ++j) {
            if (j >= lenPeptide || pep_rev.charAt(j) != 'X') continue;
            ++countX;
        }
        if (countX <= xNumLimit) {
            backwardMatrix[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int k = 0; k < 1; ++k) {
                ArrayList[] backwardList = backwardMatrix[k];
                for (int j2 = 0; j2 < lenPeptide; ++j2) {
                    String combinationSequence = combinations.get(j2);
                    ArrayList cell = backwardList[j2];
                    for (int i = 0; i < cell.size(); ++i) {
                        MatrixContent content = (MatrixContent)cell.get(i);
                        int leftIndexOld = content.left;
                        int rightIndexOld = content.right;
                        int numX = content.numX;
                        int numVariants = content.numVariants;
                        int length = content.length;
                        for (int c = 0; c < combinationSequence.length(); ++c) {
                            char aminoAcidCheck = combinationSequence.charAt(c);
                            int newNumX = numX + (aminoAcidCheck == 'X' ? 1 : 0);
                            if (newNumX > xNumLimit) continue;
                            ArrayList<int[]> setCharacter = occurrenceTablePrimary.rangeQuery(leftIndexOld - 1, rightIndexOld);
                            this.addAmbiguous(setCharacter);
                            for (int[] borders : setCharacter) {
                                int numRightSNPs;
                                int aminoAcid = borders[0];
                                if (aminoAcid == DELIMITER) continue;
                                int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                                int lessValue = lessTablePrimary[aminoAcidSearch];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                if (aminoAcid == aminoAcidCheck) {
                                    if (leftIndex > rightIndex) continue;
                                    backwardList[j2 + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, -1, length + 1, numVariants, '-'));
                                    continue;
                                }
                                int numLeftSNPs = variantPositionsPrimary.getRankOne(leftIndex - 1);
                                if (numLeftSNPs >= (numRightSNPs = variantPositionsPrimary.getRankOne(rightIndex))) continue;
                                for (int SNPnum = numLeftSNPs + 1; SNPnum <= numRightSNPs; ++SNPnum) {
                                    int selectSNP = variantPositionsPrimary.getSelect(SNPnum);
                                    for (int[] variant : variantsListPrimary[SNPnum - 1]) {
                                        if (variant[0] != aminoAcid || variant[1] != aminoAcidCheck) continue;
                                        int leftIndexSNP = selectSNP;
                                        int rightIndexSNP = selectSNP;
                                        backwardList[j2 + 1].add(new MatrixContent(leftIndexSNP, rightIndexSNP, aminoAcidCheck, content, numX, -1, length + 1, numVariants + 1, (char)aminoAcid));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            for (ArrayList[] backwardList : backwardMatrix) {
                Iterator iterator = backwardList[lenPeptide].iterator();
                while (iterator.hasNext()) {
                    MatrixContent content;
                    MatrixContent currentContent = content = (MatrixContent)iterator.next();
                    String currentPeptide = "";
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        allVariants = allVariants + currentContent.variant;
                        currentContent = currentContent.previousContent;
                    }
                    int leftIndex = content.left;
                    int rightIndex = content.right;
                    String cleanPeptide = currentPeptide.replace("*", "");
                    for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                        int pos = this.getTextPosition(j3, indexPart);
                        int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                        String accession = this.accessions.get(indexPart)[index];
                        int startPosition = pos - this.boundaries.get(indexPart)[index];
                        boolean newPeptide = true;
                        for (PeptideProteinMapping ppm : allMatches) {
                            if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide)) continue;
                            newPeptide = false;
                            break;
                        }
                        if (!newPeptide) continue;
                        HashMap<Integer, Variant> variants = new HashMap<Integer, Variant>(0);
                        int lengthDifference = 0;
                        int length = 0;
                        for (int l = 0; l < allVariants.length(); ++l) {
                            Variant variant;
                            char edit = allVariants.charAt(l);
                            ++length;
                            if (edit == '-') continue;
                            if (edit == '*') {
                                variant = new Insertion(peptide.charAt(length - 1));
                                variants.put(length, variant);
                                --lengthDifference;
                                continue;
                            }
                            if ('A' <= edit && edit <= 'Z') {
                                variant = new Substitution(edit, peptide.charAt(length - 1));
                                variants.put(length, variant);
                                continue;
                            }
                            if ('a' > edit || edit > 'z') continue;
                            variant = new Deletion((char)(edit - 32));
                            variants.put(length, variant);
                            ++lengthDifference;
                            --length;
                        }
                        PeptideVariantMatches peptideVariantMatches = variants.isEmpty() ? null : new PeptideVariantMatches(variants, lengthDifference);
                        PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, null, peptideVariantMatches);
                        peptideProteinMapping.fmIndexPosition = j3;
                        allMatches.add(peptideProteinMapping);
                    }
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariantsGeneric(String peptide, SequenceMatchingParameters seqMatchPref, int indexPart) {
        int j;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int xNumLimit = (int)(seqMatchPref.getLimitX() * (double)lenPeptide);
        ArrayList[][] backwardMatrix = new ArrayList[this.maxNumberVariants + 1][lenPeptide + 1];
        for (int k = 0; k <= this.maxNumberVariants; ++k) {
            for (j = 0; j <= lenPeptide; ++j) {
                backwardMatrix[k][j] = new ArrayList(10);
            }
        }
        int countX = 0;
        for (j = 0; j <= lenPeptide; ++j) {
            if (j >= lenPeptide || pep_rev.charAt(j) != 'X') continue;
            ++countX;
        }
        if (countX <= xNumLimit) {
            backwardMatrix[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int k = 0; k <= this.maxNumberVariants; ++k) {
                ArrayList[] backwardList = backwardMatrix[k];
                for (int j2 = 0; j2 < lenPeptide; ++j2) {
                    String combinationSequence = combinations.get(j2);
                    ArrayList cell = backwardList[j2];
                    for (int i = 0; i < cell.size(); ++i) {
                        MatrixContent content = (MatrixContent)cell.get(i);
                        int leftIndexOld = content.left;
                        int rightIndexOld = content.right;
                        int numX = content.numX;
                        int numVariants = content.numVariants;
                        int length = content.length;
                        for (int c = 0; c < combinationSequence.length(); ++c) {
                            char aminoAcid = combinationSequence.charAt(c);
                            int lessValue = lessTablePrimary[aminoAcid];
                            int[] range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                            int leftIndex = lessValue + range[0];
                            int rightIndex = lessValue + range[1] - 1;
                            int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                            if (leftIndex <= rightIndex) {
                                if (newNumX > xNumLimit) continue;
                                backwardList[j2 + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, -1, length + 1, numVariants, '-'));
                            }
                            if (numVariants >= this.maxNumberVariants || c != 0) continue;
                            if (numVariants < this.maxNumberVariants) {
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, aminoAcid, content, newNumX, -1, length + 1, numVariants + 1, '*'));
                            }
                            ArrayList<int[]> setCharacter = occurrenceTablePrimary.rangeQuery(leftIndexOld - 1, rightIndexOld);
                            this.addAmbiguous(setCharacter);
                            for (int[] borders : setCharacter) {
                                int errorAminoAcid = borders[0];
                                int errorNewNumX = newNumX + (errorAminoAcid == 88 ? 1 : 0);
                                int errorAminoAcidSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                                int errorLessValue = lessTablePrimary[errorAminoAcidSearch];
                                int errorLeftIndex = errorLessValue + borders[1];
                                int errorRightIndex = errorLessValue + borders[2] - 1;
                                if (errorNewNumX > xNumLimit) continue;
                                backwardMatrix[k + 1][j2].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, -1, length, numVariants + 1, Character.toChars(errorAminoAcid + 32)[0]));
                                if (aminoAcid == errorAminoAcid) continue;
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, aminoAcid, content, errorNewNumX, -1, length + 1, numVariants + 1, (char)errorAminoAcid));
                            }
                        }
                    }
                }
            }
            for (ArrayList[] backwardList : backwardMatrix) {
                Iterator iterator = backwardList[lenPeptide].iterator();
                while (iterator.hasNext()) {
                    MatrixContent content;
                    MatrixContent currentContent = content = (MatrixContent)iterator.next();
                    String currentPeptide = "";
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        allVariants = allVariants + currentContent.variant;
                        currentContent = currentContent.previousContent;
                    }
                    int leftIndex = content.left;
                    int rightIndex = content.right;
                    String cleanPeptide = currentPeptide.replace("*", "");
                    for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                        int pos = this.getTextPosition(j3, indexPart);
                        int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                        String accession = this.accessions.get(indexPart)[index];
                        int startPosition = pos - this.boundaries.get(indexPart)[index];
                        boolean newPeptide = true;
                        for (PeptideProteinMapping ppm : allMatches) {
                            if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > this.maxNumberVariants) continue;
                            newPeptide = false;
                            break;
                        }
                        if (!newPeptide) continue;
                        HashMap<Integer, Variant> variants = new HashMap<Integer, Variant>(0);
                        int lengthDifference = 0;
                        int length = 0;
                        for (int l = 0; l < allVariants.length(); ++l) {
                            Variant variant;
                            char edit = allVariants.charAt(l);
                            ++length;
                            if (edit == '-') continue;
                            if (edit == '*') {
                                variant = new Insertion(peptide.charAt(length - 1));
                                variants.put(length, variant);
                                --lengthDifference;
                                continue;
                            }
                            if ('A' <= edit && edit <= 'Z') {
                                variant = new Substitution(edit, peptide.charAt(length - 1));
                                variants.put(length, variant);
                                continue;
                            }
                            if ('a' > edit || edit > 'z') continue;
                            variant = new Deletion((char)(edit - 32));
                            variants.put(length, variant);
                            ++lengthDifference;
                            --length;
                        }
                        PeptideVariantMatches peptideVariantMatches = variants.isEmpty() ? null : new PeptideVariantMatches(variants, lengthDifference);
                        PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, null, peptideVariantMatches);
                        peptideProteinMapping.fmIndexPosition = j3;
                        allMatches.add(peptideProteinMapping);
                    }
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariantsSpecific(String peptide, SequenceMatchingParameters seqMatchPref, int indexPart) {
        int j;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        String pep_rev = new StringBuilder(peptide).reverse().toString();
        int lenPeptide = peptide.length();
        ArrayList<String> combinations = this.createPeptideCombinations(pep_rev, seqMatchPref);
        int xNumLimit = (int)(seqMatchPref.getLimitX() * (double)lenPeptide);
        int numErrors = this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
        LinkedList[][] backwardMatrix = new LinkedList[numErrors + 1][lenPeptide + 1];
        for (int k = 0; k <= numErrors; ++k) {
            for (j = 0; j <= lenPeptide; ++j) {
                backwardMatrix[k][j] = new LinkedList();
            }
        }
        int countX = 0;
        for (j = 0; j <= lenPeptide; ++j) {
            if (j >= lenPeptide || pep_rev.charAt(j) != 'X') continue;
            ++countX;
        }
        if (countX <= xNumLimit) {
            MatrixContent content;
            backwardMatrix[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
            for (int k = 0; k <= numErrors; ++k) {
                LinkedList[] backwardList = backwardMatrix[k];
                for (int j2 = 0; j2 < lenPeptide; ++j2) {
                    String combinationSequence = combinations.get(j2);
                    LinkedList cell = backwardList[j2];
                    while (!cell.isEmpty()) {
                        content = (MatrixContent)cell.pop();
                        int leftIndexOld = content.left;
                        int rightIndexOld = content.right;
                        int numX = content.numX;
                        int length = content.length;
                        int numDeletions = content.numSpecificVariants[0];
                        int numInsertions = content.numSpecificVariants[1];
                        int numSubstitutions = content.numSpecificVariants[2];
                        for (int c = 0; c < combinationSequence.length(); ++c) {
                            char aminoAcid = combinationSequence.charAt(c);
                            int lessValue = lessTablePrimary[aminoAcid];
                            int[] range = occurrenceTablePrimary.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                            int leftIndex = lessValue + range[0];
                            int rightIndex = lessValue + range[1] - 1;
                            int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                            if (leftIndex <= rightIndex) {
                                if (newNumX > xNumLimit) continue;
                                backwardList[j2 + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions}, '-'));
                            }
                            if (c != 0) continue;
                            if (numInsertions < this.maxNumberInsertions) {
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*'));
                            }
                            ArrayList<int[]> setCharacter = occurrenceTablePrimary.rangeQuery(leftIndexOld - 1, rightIndexOld);
                            this.addAmbiguous(setCharacter);
                            for (int[] borders : setCharacter) {
                                int errorAminoAcid = borders[0];
                                int errorNewNumX = newNumX + (errorAminoAcid == 88 ? 1 : 0);
                                int errorAminoAcidSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                                int errorLessValue = lessTablePrimary[errorAminoAcidSearch];
                                int errorLeftIndex = errorLessValue + borders[1];
                                int errorRightIndex = errorLessValue + borders[2] - 1;
                                if (errorNewNumX > xNumLimit) continue;
                                if (numDeletions < this.maxNumberDeletions) {
                                    backwardMatrix[k + 1][j2].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(errorAminoAcid + 32)[0]));
                                }
                                if (aminoAcid == errorAminoAcid || numSubstitutions >= this.maxNumberSubstitutions || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                                backwardMatrix[k + 1][j2 + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)errorAminoAcid));
                            }
                        }
                    }
                }
            }
            for (LinkedList[] backwardList : backwardMatrix) {
                Iterator iterator = backwardList[lenPeptide].iterator();
                while (iterator.hasNext()) {
                    MatrixContent currentContent = content = (MatrixContent)iterator.next();
                    String currentPeptide = "";
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        currentPeptide = currentPeptide + (char)currentContent.character;
                        allVariants = allVariants + currentContent.variant;
                        currentContent = currentContent.previousContent;
                    }
                    int leftIndex = content.left;
                    int rightIndex = content.right;
                    String cleanPeptide = currentPeptide.replace("*", "");
                    for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                        int pos = this.getTextPosition(j3, indexPart);
                        int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                        String accession = this.accessions.get(indexPart)[index];
                        int startPosition = pos - this.boundaries.get(indexPart)[index];
                        boolean newPeptide = true;
                        for (PeptideProteinMapping ppm : allMatches) {
                            if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > numErrors) continue;
                            newPeptide = false;
                            break;
                        }
                        if (!newPeptide) continue;
                        HashMap<Integer, Variant> variants = new HashMap<Integer, Variant>(0);
                        int lengthDifference = 0;
                        int length = 0;
                        for (int l = 0; l < allVariants.length(); ++l) {
                            Variant variant;
                            char edit = allVariants.charAt(l);
                            ++length;
                            if (edit == '-') continue;
                            if (edit == '*') {
                                variant = new Insertion(peptide.charAt(length - 1));
                                variants.put(length, variant);
                                --lengthDifference;
                                continue;
                            }
                            if ('A' <= edit && edit <= 'Z') {
                                variant = new Substitution(edit, peptide.charAt(length - 1));
                                variants.put(length, variant);
                                continue;
                            }
                            if ('a' > edit || edit > 'z') continue;
                            variant = new Deletion((char)(edit - 32));
                            variants.put(length, variant);
                            ++lengthDifference;
                            --length;
                        }
                        PeptideVariantMatches peptideVariantMatches = variants.isEmpty() ? null : new PeptideVariantMatches(variants, lengthDifference);
                        PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, null, peptideVariantMatches);
                        peptideProteinMapping.fmIndexPosition = j3;
                        allMatches.add(peptideProteinMapping);
                    }
                }
            }
        }
        return allMatches;
    }

    private void addModifications(ArrayList<int[]> setCharacter) {
        int maxNum = setCharacter.size();
        for (int i = 0; i < maxNum; ++i) {
            for (int pos = 128 + setCharacter.get(i)[0]; pos < this.aaMasses.length && this.aaMasses[pos] != -1.0; pos += 128) {
                setCharacter.add(new int[]{setCharacter.get(i)[0], setCharacter.get(i)[1], setCharacter.get(i)[2], pos, setCharacter.get(i)[4]});
            }
        }
    }

    private void addAmbiguous(ArrayList<int[]> setCharacter) {
        int c;
        int i;
        long[] foundChars = new long[]{0L, 0L};
        int maxNum = setCharacter.size();
        int[] bValues = null;
        int[] jValues = null;
        int[] zValues = null;
        for (i = setCharacter.size() - 1; i >= 0; --i) {
            if (setCharacter.get(i)[0] == 66 || setCharacter.get(i)[0] == 74 || setCharacter.get(i)[0] == 90) {
                switch (setCharacter.get(i)[0]) {
                    case 66: {
                        bValues = setCharacter.get(i);
                        break;
                    }
                    case 74: {
                        jValues = setCharacter.get(i);
                        break;
                    }
                    case 90: {
                        zValues = setCharacter.get(i);
                    }
                }
                setCharacter.remove(i);
                continue;
            }
            c = setCharacter.get(i)[0];
            int n = c >>> 6;
            foundChars[n] = foundChars[n] | 1L << (c & 0x3F);
        }
        if (bValues != null) {
            for (i = 0; i < this.BSubstitutions.length; ++i) {
                c = this.BSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                setCharacter.add(new int[]{c, bValues[1], bValues[2], c, 66});
            }
        }
        if (jValues != null) {
            for (i = 0; i < this.JSubstitutions.length; ++i) {
                c = this.JSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                setCharacter.add(new int[]{c, jValues[1], jValues[2], c, 74});
            }
        }
        if (zValues != null) {
            for (i = 0; i < this.ZSubstitutions.length; ++i) {
                c = this.ZSubstitutions[i];
                if ((foundChars[c >>> 6] >>> (c & 0x3F) & 1L) != 0L) continue;
                setCharacter.add(new int[]{c, zValues[1], zValues[2], c, 90});
            }
        }
    }

    private boolean massNotValid(double currMass, double refMass) {
        double diffMass = Math.abs(currMass - refMass);
        int intMass = (int)(diffMass * this.lookupMultiplier);
        return diffMass > this.computeMassTolerance(this.massTolerance, refMass) && diffMass < 800.0 && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L;
    }

    private void mappingSequenceAndMasses(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence) {
        for (int j = 0; j < combinations.length; ++j) {
            LinkedList<MatrixContent> content = matrix[j];
            TagElement combination = combinations[j];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                int numX = cell.numX;
                if (combination.isMass) {
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications && cell.numPTMs < this.maxPTMsPerPeptide) {
                        this.addModifications(setCharacter);
                    }
                    for (int[] borders : setCharacter) {
                        int newNumX;
                        int aminoAcid = borders[0];
                        if (aminoAcid == DELIMITER || (newNumX = numX + (aminoAcid == 88 ? 1 : 0)) > combination.xNumLimit) continue;
                        double d = aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0;
                        double newMass = oldMass + d;
                        if (!(newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        double massDiff = Math.abs(combinationMass - newMass);
                        if (this.massNotValid(newMass, combinationMass)) continue;
                        boolean withinMass = this.withinMassTolerance(massDiff, newNumX);
                        int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], aminoAcidSearch, j));
                        if (!withinMass) continue;
                        matrix[j + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int modification = combination.modifications != null ? combination.modifications[i] : -1;
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int newNumX = numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (j < combinations.length - 1 && combinations[j].isMass != combinations[j + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, modification, aminoAcidSearch, j));
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsGeneric(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence) {
        int lenCombinations = combinations.length;
        for (int k = 0; k <= this.maxNumberVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int length = content.length;
                    int rightIndexOld = content.right;
                    int numVariants = content.numVariants;
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int aminoAcid = borders[0];
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                int withinMass = this.withinMassTolerance(massDiff, numX);
                                if (!this.massNotValid(newMass, combinationMass)) {
                                    int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass != 0 ? 1 : 0);
                                    row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], numVariants, '-', null));
                                }
                            }
                            if (numVariants >= this.maxNumberVariants) continue;
                            matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, numVariants + 1, Character.toChars(aminoAcid + 32)[0], null));
                            for (int index : this.aaMassIndexes) {
                                double aminoMass = oldMass + this.aaMasses[index];
                                int amino = index & 0x7F;
                                if (amino == aminoAcid || !this.substitutionMatrix[amino][aminoAcid] || !(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass) || this.massNotValid(aminoMass, combinationMass)) continue;
                                int offsetSub = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, numVariants + 1, (char)aminoAcid, null));
                            }
                        }
                        if (numVariants >= this.maxNumberVariants) continue;
                        for (Object index : (Object)this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            if (!(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass) || this.massNotValid(aminoMass, combinationMass)) continue;
                            int amino = index & 0x7F;
                            int offsetDel = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, (int)index, numVariants + 1, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            int modification = combination.modifications != null ? combination.modifications[c] : -1;
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, modification, length + 1, numVariants, '-'));
                        }
                        if (numVariants >= this.maxNumberVariants || c != 0) continue;
                        if (numVariants < this.maxNumberVariants) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, aminoAcid, content, newNumX, -1, length + 1, numVariants + 1, '*'));
                        }
                        ArrayList<int[]> setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacterSeq);
                        for (int[] borders : setCharacterSeq) {
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int aminoAcidErrorSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                            int errorLessValue = less[aminoAcidErrorSearch];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, -1, length, numVariants + 1, Character.toChars(errorAminoAcid + 32)[0]));
                            if (aminoAcid == errorAminoAcid || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, aminoAcid, content, errorNewNumX, -1, length + 1, numVariants + 1, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsGeneric(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        for (int k = 0; k <= this.maxNumberVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int length = content.length;
                    int rightIndexOld = content.right;
                    int numVariants = content.numVariants;
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int aminoAcid = borders[0];
                            if (j == lenCombinations - 1 && aminoAcid == DELIMITER && length > 1) {
                                int lessValue = less[aminoAcid];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                this.mapTagToProteinTermini(content, combinationMass, CTermDirection, row, j, leftIndex, rightIndex);
                                continue;
                            }
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                int withinMass = this.withinMassTolerance(massDiff, numX);
                                int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass != 0 ? 1 : 0);
                                row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], numVariants, '-', null));
                            }
                            if (numVariants >= this.maxNumberVariants) continue;
                            matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, numVariants + 1, Character.toChars(aminoAcid + 32)[0], null));
                            for (int index : this.aaMassIndexes) {
                                double aminoMass = oldMass + this.aaMasses[index];
                                int amino = index & 0x7F;
                                if (amino == aminoAcid || !this.substitutionMatrix[amino][aminoAcid] || !(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass)) continue;
                                int offsetSub = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, numVariants + 1, (char)aminoAcid, null));
                            }
                        }
                        if (numVariants >= this.maxNumberVariants) continue;
                        for (Object index : (Object)this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            if (!(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass)) continue;
                            int amino = index & 0x7F;
                            int offsetDel = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, (int)index, numVariants + 1, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            int modification = combination.modifications != null ? combination.modifications[c] : -1;
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, modification, length + 1, numVariants, '-'));
                        }
                        if (numVariants >= this.maxNumberVariants || c != 0) continue;
                        if (numVariants < this.maxNumberVariants) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, aminoAcid, content, newNumX, -1, length + 1, numVariants + 1, '*'));
                        }
                        ArrayList<int[]> setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacterSeq);
                        for (int[] borders : setCharacterSeq) {
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int aminoAcidErrorSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                            int errorLessValue = less[aminoAcidErrorSearch];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, -1, length, numVariants + 1, Character.toChars(errorAminoAcid + 32)[0]));
                            if (aminoAcid == errorAminoAcid || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, aminoAcid, content, errorNewNumX, -1, length + 1, numVariants + 1, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsFixed(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence, Rank variantPositions, HashSet<int[]>[] variants) {
        int lenCombinations = combinations.length;
        for (int k = 0; k < 1; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int length = content.length;
                    int rightIndexOld = content.right;
                    int numVariants = content.numVariants;
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int numRightSNPs;
                            int numLeftSNPs;
                            int numRightIns;
                            int numLeftIns;
                            int aminoAcid = borders[0];
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                boolean withinMass = this.withinMassTolerance(massDiff, numX);
                                if (!this.massNotValid(newMass, combinationMass)) {
                                    int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                                    row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], numVariants, '-', null));
                                }
                            }
                            if ((numLeftIns = variantPositions.getRankOne(leftIndexOld - 1)) < (numRightIns = variantPositions.getRankOne(rightIndexOld))) {
                                for (int SNPnum = numLeftIns; SNPnum < numRightIns; ++SNPnum) {
                                    for (int[] variant : variants[SNPnum]) {
                                        if (variant[0] != 42) continue;
                                        int leftIndexVar = variant[2];
                                        int rightIndexVar = variant[2];
                                        ArrayList<int[]> setCharacterSNP = new ArrayList<int[]>(this.numMasses);
                                        setCharacterSNP.add(new int[]{variant[1], 0, 0, variant[1], -1});
                                        this.addAmbiguous(setCharacterSNP);
                                        if (this.withVariableModifications) {
                                            this.addModifications(setCharacterSNP);
                                        }
                                        for (int[] bordersSNP : setCharacterSNP) {
                                            int aminoAcidIns = variant[1];
                                            double newMassIns = oldMass + this.aaMasses[bordersSNP[3]];
                                            if (!(newMassIns - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) || this.massNotValid(newMassIns, combinationMass)) continue;
                                            int offsetIns = this.computeMassValue(newMassIns, combinationMass) <= this.massTolerance ? 1 : 0;
                                            row[j + offsetIns].add(new MatrixContent(leftIndexVar, rightIndexVar, aminoAcidIns, content, newMassIns, length + 1, numX, bordersSNP[3], numVariants + 1, '*', null));
                                        }
                                    }
                                }
                            }
                            if ((numLeftSNPs = variantPositions.getRankOne(leftIndex - 1)) >= (numRightSNPs = variantPositions.getRankOne(rightIndex))) continue;
                            for (int SNPnum = numLeftSNPs; SNPnum < numRightSNPs; ++SNPnum) {
                                for (int[] variant : variants[SNPnum]) {
                                    if (variant[0] != aminoAcid) continue;
                                    int leftIndexVar = variant[2];
                                    int rightIndexVar = variant[2];
                                    if (variant[1] == 42) {
                                        if (!(oldMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) || this.massNotValid(oldMass, combinationMass)) continue;
                                        int offsetDel = this.computeMassValue(oldMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                        row[j + offsetDel].add(new MatrixContent(leftIndexVar, rightIndexVar, variant[1], content, oldMass, length, numX, -1, numVariants + 1, Character.toChars(aminoAcid + 32)[0], null));
                                        continue;
                                    }
                                    ArrayList<int[]> setCharacterSNP = new ArrayList<int[]>(this.numMasses);
                                    setCharacterSNP.add(new int[]{variant[1], 0, 0, variant[1], -1});
                                    this.addAmbiguous(setCharacterSNP);
                                    if (this.withVariableModifications) {
                                        this.addModifications(setCharacterSNP);
                                    }
                                    for (int[] bordersSNP : setCharacterSNP) {
                                        int aminoAcidSNP = variant[1];
                                        double newMassSNP = oldMass + this.aaMasses[bordersSNP[3]];
                                        if (!(newMassSNP - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) || this.massNotValid(newMassSNP, combinationMass)) continue;
                                        int offsetSNP = this.computeMassValue(newMassSNP, combinationMass) <= this.massTolerance ? 1 : 0;
                                        row[j + offsetSNP].add(new MatrixContent(leftIndexVar, rightIndexVar, aminoAcidSNP, content, newMassSNP, length + 1, numX, bordersSNP[3], numVariants + 1, (char)aminoAcid, null));
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int numRightIns;
                        char aminoAcidCheck = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcidCheck == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        for (int[] borders : setCharacter) {
                            int numRightSNPs;
                            int aminoAcid = borders[0];
                            if (aminoAcid == DELIMITER) continue;
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (aminoAcid == aminoAcidCheck) {
                                if (leftIndex > rightIndex) continue;
                                int modification = combination.modifications != null ? combination.modifications[c] : -1;
                                row[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, modification, length + 1, numVariants, '-'));
                                continue;
                            }
                            int numLeftSNPs = variantPositions.getRankOne(leftIndex - 1);
                            if (numLeftSNPs >= (numRightSNPs = variantPositions.getRankOne(rightIndex))) continue;
                            for (int SNPnum = numLeftSNPs; SNPnum < numRightSNPs; ++SNPnum) {
                                for (int[] variant : variants[SNPnum]) {
                                    int leftIndexSNP = variant[2];
                                    int rightIndexSNP = variant[2];
                                    if (variant[0] != aminoAcid) continue;
                                    if (variant[1] == 42) {
                                        row[j].add(new MatrixContent(leftIndexSNP, rightIndexSNP, 42, content, numX, -1, length, numVariants + 1, Character.toChars((char)aminoAcid + 32)[0]));
                                        continue;
                                    }
                                    if (variant[1] != aminoAcidCheck) continue;
                                    row[j + 1].add(new MatrixContent(leftIndexSNP, rightIndexSNP, variant[1], content, numX, -1, length + 1, numVariants + 1, (char)aminoAcid));
                                }
                            }
                        }
                        int numLeftIns = variantPositions.getRankOne(leftIndexOld - 1);
                        if (numLeftIns >= (numRightIns = variantPositions.getRankOne(rightIndexOld))) continue;
                        for (int numIns = numLeftIns; numIns < numRightIns; ++numIns) {
                            for (int[] variant : variants[numIns]) {
                                int leftIndexIns = variant[2];
                                int rightIndexIns = variant[2];
                                if (variant[0] != 42 || variant[1] != aminoAcidCheck) continue;
                                row[j + 1].add(new MatrixContent(leftIndexIns, rightIndexIns, variant[1], content, numX, -1, length + 1, numVariants + 1, '*'));
                            }
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsFixed(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence, Rank variantPositions, HashSet<int[]>[] variants, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        for (int k = 0; k < 1; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int length = content.length;
                    int rightIndexOld = content.right;
                    int numVariants = content.numVariants;
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int numRightSNPs;
                            int numLeftSNPs;
                            int numRightIns;
                            int numLeftIns;
                            int aminoAcid = borders[0];
                            if (j == lenCombinations - 1 && aminoAcid == DELIMITER && length > 1) {
                                int lessValue = less[aminoAcid];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                this.mapTagToProteinTermini(content, combinationMass, CTermDirection, row, j, leftIndex, rightIndex);
                                continue;
                            }
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                boolean withinMass = this.withinMassTolerance(massDiff, numX);
                                int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                                row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], numVariants, '-', null));
                            }
                            if ((numLeftIns = variantPositions.getRankOne(leftIndexOld - 1)) < (numRightIns = variantPositions.getRankOne(rightIndexOld))) {
                                for (int SNPnum = numLeftIns; SNPnum < numRightIns; ++SNPnum) {
                                    for (int[] variant : variants[SNPnum]) {
                                        if (variant[0] != 42) continue;
                                        int leftIndexVar = variant[2];
                                        int rightIndexVar = variant[2];
                                        ArrayList<int[]> setCharacterSNP = new ArrayList<int[]>(this.numMasses);
                                        setCharacterSNP.add(new int[]{variant[1], 0, 0, variant[1], -1});
                                        this.addAmbiguous(setCharacterSNP);
                                        if (this.withVariableModifications) {
                                            this.addModifications(setCharacterSNP);
                                        }
                                        for (int[] bordersSNP : setCharacterSNP) {
                                            int aminoAcidIns = variant[1];
                                            double newMassIns = oldMass + this.aaMasses[bordersSNP[3]];
                                            if (!(newMassIns - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass)) continue;
                                            int offsetIns = this.computeMassValue(newMassIns, combinationMass) <= this.massTolerance ? 1 : 0;
                                            row[j + offsetIns].add(new MatrixContent(leftIndexVar, rightIndexVar, aminoAcidIns, content, newMassIns, length + 1, numX, bordersSNP[3], numVariants + 1, '*', null));
                                        }
                                    }
                                }
                            }
                            if ((numLeftSNPs = variantPositions.getRankOne(leftIndex - 1)) >= (numRightSNPs = variantPositions.getRankOne(rightIndex))) continue;
                            for (int SNPnum = numLeftSNPs; SNPnum < numRightSNPs; ++SNPnum) {
                                for (int[] variant : variants[SNPnum]) {
                                    if (variant[0] != aminoAcid) continue;
                                    int leftIndexVar = variant[2];
                                    int rightIndexVar = variant[2];
                                    if (variant[1] == 42) {
                                        if (!(oldMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass)) continue;
                                        int offsetDel = this.computeMassValue(oldMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                        row[j + offsetDel].add(new MatrixContent(leftIndexVar, rightIndexVar, variant[1], content, oldMass, length, numX, -1, numVariants + 1, Character.toChars(aminoAcid + 32)[0], null));
                                        continue;
                                    }
                                    ArrayList<int[]> setCharacterSNP = new ArrayList<int[]>(this.numMasses);
                                    setCharacterSNP.add(new int[]{variant[1], 0, 0, variant[1], -1});
                                    this.addAmbiguous(setCharacterSNP);
                                    if (this.withVariableModifications) {
                                        this.addModifications(setCharacterSNP);
                                    }
                                    for (int[] bordersSNP : setCharacterSNP) {
                                        int aminoAcidSNP = variant[1];
                                        double newMassSNP = oldMass + this.aaMasses[bordersSNP[3]];
                                        if (!(newMassSNP - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass)) continue;
                                        int offsetSNP = this.computeMassValue(newMassSNP, combinationMass) <= this.massTolerance ? 1 : 0;
                                        row[j + offsetSNP].add(new MatrixContent(leftIndexVar, rightIndexVar, aminoAcidSNP, content, newMassSNP, length + 1, numX, bordersSNP[3], numVariants + 1, (char)aminoAcid, null));
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int numRightIns;
                        char aminoAcidCheck = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcidCheck == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        for (int[] borders : setCharacter) {
                            int numRightSNPs;
                            int aminoAcid = borders[0];
                            if (aminoAcid == DELIMITER) continue;
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (aminoAcid == aminoAcidCheck) {
                                if (leftIndex > rightIndex) continue;
                                int modification = combination.modifications != null ? combination.modifications[c] : -1;
                                row[j + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newNumX, modification, length + 1, numVariants, '-'));
                                continue;
                            }
                            int numLeftSNPs = variantPositions.getRankOne(leftIndex - 1);
                            if (numLeftSNPs >= (numRightSNPs = variantPositions.getRankOne(rightIndex))) continue;
                            for (int SNPnum = numLeftSNPs; SNPnum < numRightSNPs; ++SNPnum) {
                                for (int[] variant : variants[SNPnum]) {
                                    int leftIndexSNP = variant[2];
                                    int rightIndexSNP = variant[2];
                                    if (variant[0] != aminoAcid) continue;
                                    if (variant[1] == 42) {
                                        row[j].add(new MatrixContent(leftIndexSNP, rightIndexSNP, 42, content, numX, -1, length, numVariants + 1, Character.toChars((char)aminoAcid + 32)[0]));
                                        continue;
                                    }
                                    if (variant[1] != aminoAcidCheck) continue;
                                    row[j + 1].add(new MatrixContent(leftIndexSNP, rightIndexSNP, variant[1], content, numX, -1, length + 1, numVariants + 1, (char)aminoAcid));
                                }
                            }
                        }
                        int numLeftIns = variantPositions.getRankOne(leftIndexOld - 1);
                        if (numLeftIns >= (numRightIns = variantPositions.getRankOne(rightIndexOld))) continue;
                        for (int numIns = numLeftIns; numIns < numRightIns; ++numIns) {
                            for (int[] variant : variants[numIns]) {
                                int leftIndexIns = variant[2];
                                int rightIndexIns = variant[2];
                                if (variant[0] != 42 || variant[1] != aminoAcidCheck) continue;
                                row[j + 1].add(new MatrixContent(leftIndexIns, rightIndexIns, variant[1], content, numX, -1, length + 1, numVariants + 1, '*'));
                            }
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsSpecific(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence) {
        int lenCombinations = combinations.length;
        int maxNumberSpecificVariants = this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
        for (int k = 0; k <= maxNumberSpecificVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int rightIndexOld = content.right;
                    int length = content.length;
                    int numDeletions = content.numSpecificVariants[0];
                    int numInsertions = content.numSpecificVariants[1];
                    int numSubstitutions = content.numSpecificVariants[2];
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int aminoAcid = borders[0];
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                int withinMass = this.withinMassTolerance(massDiff, numX);
                                if (!this.massNotValid(newMass, combinationMass)) {
                                    int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass != 0 ? 1 : 0);
                                    row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], new int[]{numDeletions, numInsertions, numSubstitutions}, '-', null));
                                }
                            }
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(aminoAcid + 32)[0], null));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions) continue;
                            for (int index : this.aaMassIndexes) {
                                int amino = index & 0x7F;
                                if (!this.substitutionMatrix[amino][aminoAcid]) continue;
                                double aminoMass = oldMass + this.aaMasses[index];
                                if (amino == aminoAcid || !this.substitutionMatrix[amino][aminoAcid] || !(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass) || this.massNotValid(aminoMass, combinationMass)) continue;
                                int offsetSub = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)aminoAcid, null));
                            }
                        }
                        if (numInsertions >= this.maxNumberInsertions) continue;
                        for (Object index : (Object)this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            if (!(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass) || this.massNotValid(aminoMass, combinationMass)) continue;
                            int amino = index & 0x7F;
                            int offsetDel = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, (int)index, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions}, '-'));
                        }
                        if (c != 0) continue;
                        if (numInsertions < this.maxNumberInsertions) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*'));
                        }
                        if (numDeletions >= this.maxNumberDeletions && numSubstitutions >= this.maxNumberSubstitutions) continue;
                        ArrayList<int[]> setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacterSeq);
                        for (int[] borders : setCharacterSeq) {
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int errorAminoAcidSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                            int errorLessValue = less[errorAminoAcidSearch];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(errorAminoAcid + 32)[0]));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions || aminoAcid == errorAminoAcid || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    private void mappingSequenceAndMassesWithVariantsSpecific(TagElement[] combinations, LinkedList<MatrixContent>[][] matrix, int[] less, WaveletTree occurrence, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        int maxNumberSpecificVariants = this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
        for (int k = 0; k <= maxNumberSpecificVariants; ++k) {
            LinkedList<MatrixContent>[] row = matrix[k];
            for (int j = 0; j < lenCombinations; ++j) {
                TagElement combination = combinations[j];
                LinkedList<MatrixContent> cell = row[j];
                while (!cell.isEmpty()) {
                    MatrixContent content = cell.removeFirst();
                    int leftIndexOld = content.left;
                    int rightIndexOld = content.right;
                    int length = content.length;
                    int numDeletions = content.numSpecificVariants[0];
                    int numInsertions = content.numSpecificVariants[1];
                    int numSubstitutions = content.numSpecificVariants[2];
                    int numX = content.numX;
                    if (combination.isMass) {
                        double combinationMass = combination.mass;
                        double oldMass = content.mass;
                        ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacter);
                        if (this.withVariableModifications) {
                            this.addModifications(setCharacter);
                        }
                        for (int[] borders : setCharacter) {
                            int aminoAcid = borders[0];
                            if (j == lenCombinations - 1 && aminoAcid == DELIMITER && length > 1) {
                                int lessValue = less[aminoAcid];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                this.mapTagToProteinTermini(content, combinationMass, CTermDirection, row, j, leftIndex, rightIndex);
                                continue;
                            }
                            if (aminoAcid == DELIMITER) continue;
                            double newMass = oldMass + this.aaMasses[borders[3]];
                            int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                            int lessValue = less[aminoAcidSearch];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            if (newMass - this.computeMassTolerance(this.massTolerance, combinationMass) <= combinationMass) {
                                double massDiff = combinationMass - newMass;
                                int withinMass = this.withinMassTolerance(massDiff, numX);
                                int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass != 0 ? 1 : 0);
                                row[j + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, content, newMass, length + 1, numX, borders[3], new int[]{numDeletions, numInsertions, numSubstitutions}, '-', null));
                            }
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(leftIndex, rightIndex, 42, content, oldMass, length, numX, -1, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(aminoAcid + 32)[0], null));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions) continue;
                            for (int index : this.aaMassIndexes) {
                                int amino = index & 0x7F;
                                if (!this.substitutionMatrix[amino][aminoAcid]) continue;
                                double aminoMass = oldMass + this.aaMasses[index];
                                if (amino == aminoAcid || !this.substitutionMatrix[amino][aminoAcid] || !(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass)) continue;
                                int offsetSub = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                                matrix[k + 1][j + offsetSub].add(new MatrixContent(leftIndex, rightIndex, amino, content, aminoMass, length + 1, numX, index, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)aminoAcid, null));
                            }
                        }
                        if (numInsertions >= this.maxNumberInsertions) continue;
                        for (Object index : (Object)this.aaMassIndexes) {
                            double aminoMass = oldMass + this.aaMasses[index];
                            if (!(aminoMass - this.computeMassTolerance(this.massTolerance, combinationMass) < combinationMass)) continue;
                            int amino = index & 0x7F;
                            int offsetDel = this.computeMassValue(aminoMass, combinationMass) <= this.massTolerance ? 1 : 0;
                            matrix[k + 1][j + offsetDel].add(new MatrixContent(leftIndexOld, rightIndexOld, amino, content, aminoMass, length + 1, numX, (int)index, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*', null));
                        }
                        continue;
                    }
                    String combinationSequence = combination.sequence;
                    int xNumLimit = combination.xNumLimit;
                    for (int c = 0; c < combinationSequence.length(); ++c) {
                        int rightIndex;
                        char aminoAcid = combinationSequence.charAt(c);
                        int newNumX = numX + (aminoAcid == 'X' ? 1 : 0);
                        if (newNumX > xNumLimit) continue;
                        int lessValue = less[aminoAcid];
                        int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcid);
                        int leftIndex = lessValue + range[0];
                        if (leftIndex <= (rightIndex = lessValue + range[1] - 1)) {
                            row[j + 1].add(new MatrixContent(leftIndex, rightIndex, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions}, '-'));
                        }
                        if (c != 0) continue;
                        if (numInsertions < this.maxNumberInsertions) {
                            matrix[k + 1][j + 1].add(new MatrixContent(leftIndexOld, rightIndexOld, (int)aminoAcid, content, newNumX, length + 1, new int[]{numDeletions, numInsertions + 1, numSubstitutions}, '*'));
                        }
                        if (numDeletions >= this.maxNumberDeletions && numSubstitutions >= this.maxNumberSubstitutions) continue;
                        ArrayList<int[]> setCharacterSeq = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                        this.addAmbiguous(setCharacterSeq);
                        for (int[] borders : setCharacterSeq) {
                            int errorAminoAcid = borders[0];
                            int errorNewNumX = newNumX + (errorAminoAcid != 88 ? 0 : 1);
                            if (errorNewNumX > xNumLimit) continue;
                            int errorAminoAcidSearch = borders[4] == -1 ? errorAminoAcid : borders[4];
                            int errorLessValue = less[errorAminoAcidSearch];
                            int errorLeftIndex = errorLessValue + borders[1];
                            int errorRightIndex = errorLessValue + borders[2] - 1;
                            if (numDeletions < this.maxNumberDeletions) {
                                matrix[k + 1][j].add(new MatrixContent(errorLeftIndex, errorRightIndex, 42, content, errorNewNumX, length, new int[]{numDeletions + 1, numInsertions, numSubstitutions}, Character.toChars(errorAminoAcid + 32)[0]));
                            }
                            if (numSubstitutions >= this.maxNumberSubstitutions || aminoAcid == errorAminoAcid || !this.substitutionMatrix[errorAminoAcid][aminoAcid]) continue;
                            matrix[k + 1][j + 1].add(new MatrixContent(errorLeftIndex, errorRightIndex, (int)aminoAcid, content, errorNewNumX, length + 1, new int[]{numDeletions, numInsertions, numSubstitutions + 1}, (char)errorAminoAcid));
                        }
                    }
                }
            }
        }
    }

    public double pepMass(String peptide) {
        double mass = 0.0;
        for (int i = 0; i < peptide.length(); ++i) {
            mass += this.aaMasses[peptide.charAt(i)];
        }
        return mass;
    }

    public boolean withinMassTolerance(double mass, int numX) {
        if (mass + this.computeMassTolerance(this.massTolerance, mass) < this.negativeModificationMass) {
            return false;
        }
        int intMass = (int)((mass + 1.0) * this.lookupMultiplier);
        return 0 < numX && numX <= this.maxXPerTag && mass < 800.0 && (this.Xlookup[numX][intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 1L;
    }

    private void mappingSequenceAndMasses(TagElement[] combinations, LinkedList<MatrixContent>[] matrix, int[] less, WaveletTree occurrence, boolean CTermDirection) {
        int lenCombinations = combinations.length;
        for (int k = 0; k < lenCombinations; ++k) {
            TagElement combination = combinations[k];
            LinkedList<MatrixContent> content = matrix[k];
            while (!content.isEmpty()) {
                MatrixContent cell = content.removeFirst();
                int length = cell.length;
                int leftIndexOld = cell.left;
                int rightIndexOld = cell.right;
                if (combination.isMass) {
                    int aminoAcid;
                    double combinationMass = combination.mass;
                    double oldMass = cell.mass;
                    ArrayList<int[]> setCharacter = occurrence.rangeQuery(leftIndexOld - 1, rightIndexOld);
                    this.addAmbiguous(setCharacter);
                    if (this.withVariableModifications && cell.numPTMs < this.maxPTMsPerPeptide) {
                        this.addModifications(setCharacter);
                    }
                    if (k == lenCombinations - 1) {
                        for (int[] borders : setCharacter) {
                            aminoAcid = borders[0];
                            int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                            if (newNumX > combination.xNumLimit) continue;
                            if (aminoAcid != DELIMITER) {
                                boolean wmtV;
                                double massDiffDiffV;
                                int j;
                                boolean wmt;
                                double massDiffDiffAbs;
                                double massDiffDiff;
                                int i;
                                boolean hasFixedModification_atTerminus;
                                ArrayList<Double>[] vmodpaaMass;
                                ArrayList<String>[] vmodpaa;
                                ArrayList<Double> vmodpMass;
                                ArrayList<String> vmodp;
                                ArrayList<Double>[] fmodpaaMass;
                                ArrayList<String>[] fmodpaa;
                                ArrayList<Double> fmodpMass;
                                ArrayList<String> fmodp;
                                int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                                double newMass = oldMass + (aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0);
                                double massDiff = combinationMass - newMass;
                                int lastAcid = aminoAcid;
                                int lessValue = less[aminoAcidSearch];
                                int leftIndex = lessValue + borders[1];
                                int rightIndex = lessValue + borders[2] - 1;
                                MatrixContent newCell = new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k);
                                ModificationMatch modificationMatchEnd = null;
                                ModificationMatch modificationMatchEndEnd = null;
                                if (CTermDirection) {
                                    fmodp = this.fmodcp;
                                    fmodpMass = this.fmodcpMass;
                                    fmodpaa = this.fmodcpaa;
                                    fmodpaaMass = this.fmodcpaaMass;
                                    vmodp = this.vmodcp;
                                    vmodpMass = this.vmodcpMass;
                                    vmodpaa = this.vmodcpaa;
                                    vmodpaaMass = this.vmodcpaaMass;
                                    hasFixedModification_atTerminus = this.hasFixedModification_CatTerminus;
                                } else {
                                    fmodp = this.fmodnp;
                                    fmodpMass = this.fmodnpMass;
                                    fmodpaa = this.fmodnpaa;
                                    fmodpaaMass = this.fmodnpaaMass;
                                    vmodp = this.vmodnp;
                                    vmodpMass = this.vmodnpMass;
                                    vmodpaa = this.vmodnpaa;
                                    vmodpaaMass = this.vmodnpaaMass;
                                    hasFixedModification_atTerminus = this.hasFixedModification_NatTerminus;
                                }
                                boolean hasFixed = false;
                                boolean withinMass = false;
                                double xMassDiff = -1.0 - this.massTolerance;
                                if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                                    hasFixed = true;
                                    for (i = 0; i < fmodpaaMass[lastAcid].size(); ++i) {
                                        massDiffDiff = massDiff - fmodpaaMass[lastAcid].get(i);
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (newNumX == 0 && this.computeMassValue(fmodpaaMass[lastAcid].get(i) + newMass, combinationMass) < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            xMassDiff = massDiffDiffAbs;
                                        }
                                        if (xMassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(newNumX == 0 && this.computeMassValue(fmodpaaMass[lastAcid].get(i) + newMass + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                withinMass |= wmtV;
                                                xMassDiff = massDiffDiffV;
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), length + 1);
                                            }
                                        }
                                        if (!(xMassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(newNumX == 0 && this.computeMassValue(fmodpaaMass[lastAcid].get(i) + vmodpMass.get(j) + newMass, combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            xMassDiff = massDiffDiffV;
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), length + 1);
                                        }
                                    }
                                }
                                if (fmodp != null && xMassDiff < -this.massTolerance) {
                                    hasFixed = true;
                                    for (i = 0; i < fmodp.size(); ++i) {
                                        massDiffDiff = massDiff - fmodpMass.get(i);
                                        massDiffDiffAbs = Math.abs(massDiffDiff);
                                        wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                                        if (newNumX == 0 && this.computeMassValue(fmodpMass.get(i) + newMass, combinationMass) < this.massTolerance || wmt) {
                                            withinMass |= wmt;
                                            xMassDiff = massDiffDiffAbs;
                                        }
                                        if (xMassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                            for (j = 0; j < vmodpaaMass[lastAcid].size(); ++j) {
                                                massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j));
                                                wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                                if (!(newNumX == 0 && this.computeMassValue(fmodpMass.get(i) + newMass + vmodpaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                                withinMass |= wmtV;
                                                xMassDiff = massDiffDiffV;
                                                modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j), length + 1);
                                            }
                                        }
                                        if (!(xMassDiff < -this.massTolerance) || vmodp == null) continue;
                                        for (j = 0; j < vmodp.size(); ++j) {
                                            massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j));
                                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                                            if (!(newNumX == 0 && this.computeMassValue(fmodpMass.get(i) + newMass + vmodpMass.get(j), combinationMass) < this.massTolerance) && !wmtV) continue;
                                            withinMass |= wmtV;
                                            xMassDiff = massDiffDiffV;
                                            modificationMatchEndEnd = new ModificationMatch(vmodp.get(j), length + 1);
                                        }
                                    }
                                }
                                if (!hasFixedModification_atTerminus && !hasFixed && xMassDiff < -this.massTolerance) {
                                    boolean wmtV2;
                                    double massDiffV;
                                    double massDiffF = Math.abs(massDiff);
                                    boolean wmt2 = this.withinMassTolerance(massDiffF, newNumX);
                                    if (newNumX == 0 && this.computeMassValue(newMass, combinationMass) < this.massTolerance || wmt2) {
                                        withinMass |= wmt2;
                                        xMassDiff = massDiffF;
                                    }
                                    if (xMassDiff < -this.massTolerance && vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                                        for (int i2 = 0; i2 < vmodpaaMass[lastAcid].size(); ++i2) {
                                            massDiffV = Math.abs(massDiff - vmodpaaMass[lastAcid].get(i2));
                                            wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(newNumX == 0 && this.computeMassValue(vmodpaaMass[lastAcid].get(i2) + newMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            xMassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodpaa[lastAcid].get(i2), length + 1);
                                        }
                                    }
                                    if (xMassDiff < -this.massTolerance && vmodp != null) {
                                        for (int i3 = 0; i3 < vmodp.size(); ++i3) {
                                            massDiffV = Math.abs(massDiff - vmodpMass.get(i3));
                                            wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                                            if (!(newNumX == 0 && this.computeMassValue(vmodpMass.get(i3) + newMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                                            withinMass |= wmtV2;
                                            xMassDiff = massDiffV;
                                            modificationMatchEnd = new ModificationMatch(vmodp.get(i3), length + 1);
                                        }
                                    }
                                }
                                if (xMassDiff < -this.massTolerance) {
                                    if (!(newMass - this.computeMassTolerance(this.massTolerance, combinationMass) + this.negativeModificationMass <= combinationMass)) continue;
                                    content.add(newCell);
                                    continue;
                                }
                                if (modificationMatchEnd != null) {
                                    if (newNumX > 0 && !withinMass) continue;
                                    MatrixContent newEndCell = new MatrixContent(leftIndex, rightIndex, 0, newCell, 0.0, null, null, length + 1, 0, k, modificationMatchEnd, null, -1);
                                    ++newEndCell.numPTMs;
                                    if (modificationMatchEndEnd == null) {
                                        matrix[k + 1].add(newEndCell);
                                    } else {
                                        MatrixContent newEndEndCell = new MatrixContent(leftIndex, rightIndex, 0, newEndCell, 0.0, null, null, length + 1, 0, k, modificationMatchEndEnd, null, -1);
                                        ++newEndEndCell.numPTMs;
                                        matrix[k + 1].add(newEndEndCell);
                                    }
                                    if (withinMass) {
                                        matrix[k + 1].getLast().XMassDiff = xMassDiff;
                                    }
                                    matrix[k + 1].getLast().numX = 0;
                                    continue;
                                }
                                if (newNumX > 0 && !withinMass) continue;
                                matrix[k + 1].add(newCell);
                                matrix[k + 1].getLast().numX = 0;
                                if (!withinMass) continue;
                                matrix[k + 1].getLast().XMassDiff = xMassDiff;
                                continue;
                            }
                            if (length <= 1) continue;
                            int lessValue = less[aminoAcid];
                            int leftIndex = lessValue + borders[1];
                            int rightIndex = lessValue + borders[2] - 1;
                            this.mapTagToProteinTermini(cell, combinationMass, CTermDirection, matrix, k, leftIndex, rightIndex);
                        }
                        continue;
                    }
                    for (int[] borders : setCharacter) {
                        aminoAcid = borders[0];
                        if (aminoAcid == DELIMITER) continue;
                        double d = aminoAcid != 88 ? this.aaMasses[borders[3]] : 0.0;
                        double newMass = oldMass + d;
                        if (!(newMass - this.massTolerance <= combinationMass)) continue;
                        int aminoAcidSearch = borders[4] == -1 ? aminoAcid : borders[4];
                        int lessValue = less[aminoAcidSearch];
                        int leftIndex = lessValue + borders[1];
                        int rightIndex = lessValue + borders[2] - 1;
                        int newNumX = cell.numX + (aminoAcid == 88 ? 1 : 0);
                        if (newNumX > combination.xNumLimit) continue;
                        double massDiff = Math.abs(combinationMass - newMass);
                        int intMass = (int)(massDiff * this.lookupMultiplier);
                        if (massDiff > this.massTolerance && massDiff < 800.0 && (this.lookupMasses[intMass >>> 6] >>> (intMass & 0x3F) & 1L) == 0L) continue;
                        boolean withinMass = this.withinMassTolerance(massDiff, newNumX);
                        int offset = (this.computeMassValue(newMass, combinationMass) <= this.massTolerance ? 1 : 0) | (withinMass ? 1 : 0);
                        if (offset > 0) {
                            newNumX = 0;
                        }
                        matrix[k + offset].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, newMass, length + 1, newNumX, borders[3], borders[4], k));
                        if (!withinMass) continue;
                        matrix[k + offset].getLast().XMassDiff = massDiff;
                    }
                    continue;
                }
                String combinationSequence = combination.sequence;
                int xNumLimit = combination.xNumLimit;
                char aminoAcid = combinationSequence.charAt(0);
                for (int i = 0; i < combinationSequence.length(); ++i) {
                    char aminoAcidSearch = combinationSequence.charAt(i);
                    int lessValue = less[aminoAcidSearch];
                    int[] range = occurrence.singleRangeQuery(leftIndexOld - 1, rightIndexOld, aminoAcidSearch);
                    int leftIndex = lessValue + range[0];
                    int rightIndex = lessValue + range[1] - 1;
                    int modification = combination.modifications != null ? combination.modifications[i] : -1;
                    int newNumX = cell.numX + (aminoAcidSearch == 'X' ? 1 : 0);
                    if (leftIndex > rightIndex || newNumX > xNumLimit) continue;
                    if (k < combinations.length - 1 && combinations[k].isMass != combinations[k + 1].isMass) {
                        newNumX = 0;
                    }
                    matrix[k + 1].add(new MatrixContent(leftIndex, rightIndex, aminoAcid, cell, 0.0, length + 1, newNumX, modification, aminoAcidSearch, k));
                }
            }
        }
    }

    public void mapTagToProteinTermini(MatrixContent cell, double combinationMass, boolean CTermDirection, LinkedList<MatrixContent>[] matrix, int k, int leftIndex, int rightIndex) {
        boolean wmtV;
        double massDiffDiffV;
        boolean hasFixedPep;
        boolean wmtV2;
        int j;
        boolean wmt;
        double massDiffDiffAbs;
        double mDD;
        double massDiffDiff;
        int i;
        ArrayList<Double>[] vmodpaaMass;
        ArrayList<String>[] vmodpaa;
        ArrayList<Double> vmodpMass;
        ArrayList<String> vmodp;
        ArrayList<Double>[] fmodpaaMass;
        ArrayList<String>[] fmodpaa;
        ArrayList<Double> fmodpMass;
        ArrayList<String> fmodp;
        ArrayList<Double>[] vmodaaMass;
        ArrayList<String>[] vmodaa;
        ArrayList<Double> vmodMass;
        ArrayList<String> vmod;
        ArrayList<Double>[] fmodaaMass;
        ArrayList<String>[] fmodaa;
        ArrayList<Double> fmodMass;
        ArrayList<String> fmod;
        int lastAcid = cell.character;
        int newNumX = cell.numX;
        double oldMass = cell.mass;
        int length = cell.length;
        double massDiff = combinationMass - oldMass;
        ModificationMatch modificationMatchEnd = null;
        ModificationMatch modificationMatchEndEnd = null;
        boolean withinMass = false;
        double xMassDiff = -1.0;
        if (CTermDirection) {
            fmod = this.fmodc;
            fmodMass = this.fmodcMass;
            fmodaa = this.fmodcaa;
            fmodaaMass = this.fmodcaaMass;
            vmod = this.vmodc;
            vmodMass = this.vmodcMass;
            vmodaa = this.vmodcaa;
            vmodaaMass = this.vmodcaaMass;
            fmodp = this.fmodcp;
            fmodpMass = this.fmodcpMass;
            fmodpaa = this.fmodcpaa;
            fmodpaaMass = this.fmodcpaaMass;
            vmodp = this.vmodcp;
            vmodpMass = this.vmodcpMass;
            vmodpaa = this.vmodcpaa;
            vmodpaaMass = this.vmodcpaaMass;
        } else {
            fmod = this.fmodn;
            fmodMass = this.fmodnMass;
            fmodaa = this.fmodnaa;
            fmodaaMass = this.fmodnaaMass;
            vmod = this.vmodn;
            vmodMass = this.vmodnMass;
            vmodaa = this.vmodnaa;
            vmodaaMass = this.vmodnaaMass;
            fmodp = this.fmodnp;
            fmodpMass = this.fmodnpMass;
            fmodpaa = this.fmodnpaa;
            fmodpaaMass = this.fmodnpaaMass;
            vmodp = this.vmodnp;
            vmodpMass = this.vmodnpMass;
            vmodpaa = this.vmodnpaa;
            vmodpaaMass = this.vmodnpaaMass;
        }
        boolean matchThroughFixedMod = false;
        if (fmodaa != null && lastAcid > 0 && fmodaaMass[lastAcid].size() > 0) {
            for (i = 0; i < fmodaaMass[lastAcid].size(); ++i) {
                double massDiffDiffV2;
                massDiffDiff = massDiff - fmodaaMass[lastAcid].get(i);
                mDD = oldMass + fmodaaMass[lastAcid].get(i);
                massDiffDiffAbs = Math.abs(massDiffDiff);
                wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                if (newNumX == 0 && this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                    withinMass |= wmt;
                    xMassDiff = massDiffDiffAbs;
                    matchThroughFixedMod = true;
                }
                if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                    for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                        massDiffDiffV2 = Math.abs(massDiffDiff - vmodaaMass[lastAcid].get(j));
                        wmtV2 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodaaMass[lastAcid].get(j), combinationMass) < this.massTolerance) && !wmtV2) continue;
                        withinMass |= wmtV2;
                        xMassDiff = massDiffDiffV2;
                        modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), length);
                    }
                }
                if (vmod != null && modificationMatchEnd == null) {
                    for (j = 0; j < vmod.size(); ++j) {
                        massDiffDiffV2 = Math.abs(massDiffDiff - vmodMass.get(j));
                        wmtV2 = this.withinMassTolerance(massDiffDiffV2, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodMass.get(j), combinationMass) < this.massTolerance) && !wmtV2) continue;
                        withinMass |= wmtV2;
                        xMassDiff = massDiffDiffV2;
                        modificationMatchEndEnd = new ModificationMatch(vmod.get(j), length);
                    }
                }
                hasFixedPep = false;
                if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                    for (int j2 = 0; j2 < fmodpaaMass[lastAcid].size(); ++j2) {
                        massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j2));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j2), combinationMass) < this.massTolerance) && !wmtV) continue;
                        hasFixedPep = true;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        matchThroughFixedMod = true;
                    }
                }
                if (fmodp != null) {
                    for (int j3 = 0; j3 < fmodp.size(); ++j3) {
                        massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j3));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpMass.get(j3), combinationMass) < this.massTolerance) && !wmtV) continue;
                        hasFixedPep = true;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        matchThroughFixedMod = true;
                    }
                }
                if (hasFixedPep) continue;
                if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                    for (int j4 = 0; j4 < vmodpaaMass[lastAcid].size(); ++j4) {
                        massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j4));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j4), combinationMass) < this.massTolerance) && !wmtV) continue;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j4), length);
                    }
                }
                if (vmodp == null) continue;
                for (int j5 = 0; j5 < vmodp.size(); ++j5) {
                    massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j5));
                    wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                    if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpMass.get(j5), combinationMass) < this.massTolerance) && !wmtV) continue;
                    withinMass |= wmtV;
                    xMassDiff = massDiffDiffV;
                    modificationMatchEndEnd = new ModificationMatch(vmodp.get(j5), length);
                }
            }
        }
        if (fmod != null && modificationMatchEnd == null) {
            for (i = 0; i < fmod.size(); ++i) {
                massDiffDiff = massDiff - fmodMass.get(i);
                mDD = oldMass + fmodMass.get(i);
                massDiffDiffAbs = Math.abs(massDiffDiff);
                wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                if (newNumX == 0 && this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                    withinMass |= wmt;
                    xMassDiff = massDiffDiffAbs;
                    matchThroughFixedMod = true;
                }
                if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                    for (j = 0; j < vmodaaMass[lastAcid].size(); ++j) {
                        double massDiffV = Math.abs(massDiff - vmodaaMass[lastAcid].get(j));
                        wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(vmodaaMass[lastAcid].get(j) + oldMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                        withinMass |= wmtV2;
                        xMassDiff = massDiffV;
                        modificationMatchEndEnd = new ModificationMatch(vmodaa[lastAcid].get(j), length);
                    }
                }
                if (vmod != null && modificationMatchEnd == null) {
                    for (j = 0; j < vmod.size(); ++j) {
                        double massDiffV = Math.abs(massDiff - vmodMass.get(j));
                        wmtV2 = this.withinMassTolerance(massDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(vmodMass.get(j) + oldMass, combinationMass) < this.massTolerance) && !wmtV2) continue;
                        withinMass |= wmtV2;
                        xMassDiff = massDiffV;
                        modificationMatchEndEnd = new ModificationMatch(vmod.get(j), length);
                    }
                }
                hasFixedPep = false;
                if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                    for (int j6 = 0; j6 < fmodpaaMass[lastAcid].size(); ++j6) {
                        massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j6));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j6), combinationMass) < this.massTolerance) && !wmtV) continue;
                        hasFixedPep = true;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        matchThroughFixedMod = true;
                    }
                }
                if (fmodp != null) {
                    for (int j7 = 0; j7 < fmodp.size(); ++j7) {
                        massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j7));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpMass.get(j7), combinationMass) < this.massTolerance) && !wmtV) continue;
                        hasFixedPep = true;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        matchThroughFixedMod = true;
                    }
                }
                if (hasFixedPep) continue;
                if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                    for (int j8 = 0; j8 < vmodpaaMass[lastAcid].size(); ++j8) {
                        massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j8));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j8), combinationMass) < this.massTolerance) && !wmtV) continue;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j8), length);
                    }
                }
                if (vmodp == null) continue;
                for (int j9 = 0; j9 < vmodp.size(); ++j9) {
                    massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j9));
                    wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                    if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpMass.get(j9), combinationMass) < this.massTolerance) && !wmtV) continue;
                    withinMass |= wmtV;
                    xMassDiff = massDiffDiffV;
                    modificationMatchEndEnd = new ModificationMatch(vmodp.get(j9), length);
                }
            }
        }
        if (modificationMatchEnd == null) {
            if (vmodaa != null && lastAcid > 0 && vmodaaMass[lastAcid].size() > 0) {
                for (i = 0; i < vmodaaMass[lastAcid].size(); ++i) {
                    int j10;
                    massDiffDiff = massDiff - vmodaaMass[lastAcid].get(i);
                    mDD = oldMass + vmodaaMass[lastAcid].get(i);
                    massDiffDiffAbs = Math.abs(massDiffDiff);
                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                    if (newNumX == 0 && this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                        withinMass |= wmt;
                        xMassDiff = massDiffDiffAbs;
                        modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), length);
                    }
                    hasFixedPep = false;
                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                        for (j10 = 0; j10 < fmodpaaMass[lastAcid].size(); ++j10) {
                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j10));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j10), combinationMass) < this.massTolerance) && !wmtV) continue;
                            hasFixedPep = true;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), length);
                        }
                    }
                    if (fmodp != null) {
                        for (j10 = 0; j10 < fmodp.size(); ++j10) {
                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j10));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpMass.get(j10), combinationMass) < this.massTolerance) && !wmtV) continue;
                            hasFixedPep = true;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), length);
                        }
                    }
                    if (hasFixedPep) continue;
                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                        for (j10 = 0; j10 < vmodpaaMass[lastAcid].size(); ++j10) {
                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j10));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j10), combinationMass) < this.massTolerance) && !wmtV) continue;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), length);
                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j10), length);
                        }
                    }
                    if (vmodp == null) continue;
                    for (j10 = 0; j10 < vmodp.size(); ++j10) {
                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j10));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpMass.get(j10), combinationMass) < this.massTolerance) && !wmtV) continue;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        modificationMatchEnd = new ModificationMatch(vmodaa[lastAcid].get(i), length);
                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j10), length);
                    }
                }
            }
            if (vmod != null && modificationMatchEnd == null) {
                for (i = 0; i < vmod.size(); ++i) {
                    int j11;
                    massDiffDiff = massDiff - vmodMass.get(i);
                    mDD = oldMass + vmodMass.get(i);
                    massDiffDiffAbs = Math.abs(massDiffDiff);
                    wmt = this.withinMassTolerance(massDiffDiffAbs, newNumX);
                    if (newNumX == 0 && this.computeMassValue(mDD, combinationMass) < this.massTolerance || wmt) {
                        withinMass |= wmt;
                        xMassDiff = massDiffDiffAbs;
                        modificationMatchEnd = new ModificationMatch(vmod.get(i), length);
                    }
                    hasFixedPep = false;
                    if (fmodpaa != null && lastAcid > 0 && fmodpaaMass[lastAcid].size() > 0) {
                        for (j11 = 0; j11 < fmodpaaMass[lastAcid].size(); ++j11) {
                            massDiffDiffV = Math.abs(massDiffDiff - fmodpaaMass[lastAcid].get(j11));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpaaMass[lastAcid].get(j11), combinationMass) < this.massTolerance) && !wmtV) continue;
                            hasFixedPep = true;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmod.get(i), length);
                        }
                    }
                    if (fmodp != null) {
                        for (j11 = 0; j11 < fmodp.size(); ++j11) {
                            massDiffDiffV = Math.abs(massDiffDiff - fmodpMass.get(j11));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + fmodpMass.get(j11), combinationMass) < this.massTolerance) && !wmtV) continue;
                            hasFixedPep = true;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmod.get(i), length);
                        }
                    }
                    if (hasFixedPep) continue;
                    if (vmodpaa != null && lastAcid > 0 && vmodpaaMass[lastAcid].size() > 0) {
                        for (j11 = 0; j11 < vmodpaaMass[lastAcid].size(); ++j11) {
                            massDiffDiffV = Math.abs(massDiffDiff - vmodpaaMass[lastAcid].get(j11));
                            wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                            if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpaaMass[lastAcid].get(j11), combinationMass) < this.massTolerance) && !wmtV) continue;
                            withinMass |= wmtV;
                            xMassDiff = massDiffDiffV;
                            modificationMatchEnd = new ModificationMatch(vmod.get(i), length);
                            modificationMatchEndEnd = new ModificationMatch(vmodpaa[lastAcid].get(j11), length);
                        }
                    }
                    if (vmodp == null) continue;
                    for (j11 = 0; j11 < vmodp.size(); ++j11) {
                        massDiffDiffV = Math.abs(massDiffDiff - vmodpMass.get(j11));
                        wmtV = this.withinMassTolerance(massDiffDiffV, newNumX);
                        if (!(newNumX == 0 && this.computeMassValue(mDD + vmodpMass.get(j11), combinationMass) < this.massTolerance) && !wmtV) continue;
                        withinMass |= wmtV;
                        xMassDiff = massDiffDiffV;
                        modificationMatchEnd = new ModificationMatch(vmod.get(i), length);
                        modificationMatchEndEnd = new ModificationMatch(vmodp.get(j11), length);
                    }
                }
            }
        }
        if (modificationMatchEnd != null) {
            MatrixContent newEndCell = new MatrixContent(leftIndex, rightIndex, (int)DELIMITER, cell, 0.0, null, null, length, 0, k, modificationMatchEnd, null, -1);
            ++newEndCell.numPTMs;
            if (modificationMatchEndEnd == null) {
                matrix[k + 1].add(newEndCell);
            } else {
                MatrixContent newEndEndCell = new MatrixContent(leftIndex, rightIndex, (int)DELIMITER, newEndCell, 0.0, null, null, length, 0, k, modificationMatchEndEnd, null, -1);
                ++newEndEndCell.numPTMs;
                matrix[k + 1].add(newEndEndCell);
            }
            if (withinMass) {
                matrix[k + 1].getLast().XMassDiff = xMassDiff;
            }
            matrix[k + 1].getLast().numX = 0;
        } else if (matchThroughFixedMod && cell != null) {
            matrix[k + 1].add(cell);
            if (withinMass) {
                matrix[k + 1].getLast().XMassDiff = xMassDiff;
            }
            matrix[k + 1].getLast().numX = 0;
        }
    }

    @Override
    public ArrayList<PeptideProteinMapping> getProteinMapping(Tag tag, SequenceMatchingParameters sequenceMatchingPreferences) {
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>(1);
        if (this.variantMatchingType != PeptideVariantsParameters.VariantType.NO_VARIANT) {
            for (int i = 0; i < this.indexParts; ++i) {
                if (!this.onlyTrypticPeptides) {
                    allMatches.addAll(this.getProteinMappingWithVariants(tag, sequenceMatchingPreferences, i));
                    continue;
                }
                Tag Ktag = new Tag(tag);
                int l = Ktag.getContent().size();
                if (Ktag.getContent().get(l - 1) instanceof MassGap) {
                    ((MassGap)Ktag.getContent().get(l - 1)).setMass(((MassGap)Ktag.getContent().get(l - 1)).getMass() - this.aaMasses[75]);
                    Ktag.getContent().add(new AminoAcidSequence("K"));
                }
                allMatches.addAll(this.getProteinMappingWithVariants(Ktag, sequenceMatchingPreferences, i));
                Tag Rtag = new Tag(tag);
                if (Rtag.getContent().get(l - 1) instanceof MassGap) {
                    ((MassGap)Rtag.getContent().get(l - 1)).setMass(((MassGap)Rtag.getContent().get(l - 1)).getMass() - this.aaMasses[82]);
                    Rtag.getContent().add(new AminoAcidSequence("R"));
                }
                allMatches.addAll(this.getProteinMappingWithVariants(Rtag, sequenceMatchingPreferences, i));
            }
            return allMatches;
        }
        for (int i = 0; i < this.indexParts; ++i) {
            if (!this.onlyTrypticPeptides) {
                allMatches.addAll(this.getProteinMappingWithoutVariants(tag, sequenceMatchingPreferences, i));
                continue;
            }
            Tag Ktag = new Tag(tag);
            int l = Ktag.getContent().size();
            if (Ktag.getContent().get(l - 1) instanceof MassGap) {
                ((MassGap)Ktag.getContent().get(l - 1)).setMass(((MassGap)Ktag.getContent().get(l - 1)).getMass() - this.aaMasses[75]);
                Ktag.getContent().add(new AminoAcidSequence("K"));
            }
            allMatches.addAll(this.getProteinMappingWithoutVariants(Ktag, sequenceMatchingPreferences, i));
            Tag Rtag = new Tag(tag);
            if (Rtag.getContent().get(l - 1) instanceof MassGap) {
                ((MassGap)Rtag.getContent().get(l - 1)).setMass(((MassGap)Rtag.getContent().get(l - 1)).getMass() - this.aaMasses[82]);
                Rtag.getContent().add(new AminoAcidSequence("R"));
            }
            allMatches.addAll(this.getProteinMappingWithoutVariants(Rtag, sequenceMatchingPreferences, i));
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithoutVariants(Tag tag, SequenceMatchingParameters sequenceMatchingPreferences, int indexPart) {
        StringBuilder currentPeptideSearch;
        StringBuilder currentPeptide;
        MatrixContent currentContent;
        int i;
        WaveletTree occurrencePrimary;
        WaveletTree occurrenceReversed;
        int[] lessPrimary;
        int[] lessReversed;
        TagElement[] refTagContent;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int[] lessTableReversed = this.lessTablesReversed.get(indexPart);
        WaveletTree occurrenceTableReversed = this.occurrenceTablesReversed.get(indexPart);
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>(1);
        double xLimit = sequenceMatchingPreferences.getLimitX();
        int maxSequencePosition = -1;
        TagElement[] tagElements = new TagElement[tag.getContent().size()];
        for (int i2 = 0; i2 < tag.getContent().size(); ++i2) {
            if (tag.getContent().get(i2) instanceof MassGap) {
                double mass = tag.getContent().get(i2).getMass();
                tagElements[i2] = new TagElement(true, "", tag.getContent().get(i2).getMass(), (int)Math.round(mass / 120.0 * xLimit));
                continue;
            }
            if (tag.getContent().get(i2) instanceof AminoAcidSequence) {
                int len = tag.getContent().get(i2).asSequence().length();
                Integer[] modificationsList = new Integer[len];
                for (int ii = 0; ii < len; ++ii) {
                    modificationsList[ii] = -1;
                }
                for (ModificationMatch mm : ((AminoAcidSequence)tag.getContent().get(i2)).getVariableModifications()) {
                    String modString = mm.getModification();
                    if (!this.modificationLabelsToId.containsKey(modString)) {
                        System.out.println("Warning: modification '" + modString + "' is not registered in FM index, will be ignored.");
                        continue;
                    }
                    int site = mm.getSite() - 1;
                    if (site < 0 || len <= site) {
                        System.out.println("Worninng: incorrect declaration of modification site.");
                        continue;
                    }
                    modificationsList[site] = this.modificationLabelsToId.get(modString);
                }
                tagElements[i2] = new TagElement(false, tag.getContent().get(i2).asSequence(), 0.0, (int)((double)len * xLimit), modificationsList);
                if (maxSequencePosition != -1 && tagElements[i2].sequence.length() >= tagElements[i2].sequence.length()) continue;
                maxSequencePosition = i2;
                continue;
            }
            throw new UnsupportedOperationException("Unsupported tag in tag mapping for FM-Index.");
        }
        boolean turned = tagElements.length == 3 && tagElements[0].isMass && !tagElements[1].isMass && tagElements[2].isMass && tagElements[0].mass < tagElements[2].mass;
        boolean hasCTermDirection = this.hasCTermDirectionModification;
        boolean hasNTermDirection = this.hasNTermDirectionModification;
        boolean towardsC = true;
        if (turned) {
            refTagContent = new TagElement[tagElements.length];
            int i3 = tagElements.length - 1;
            int j = 0;
            while (i3 >= 0) {
                String sequenceReversed = new StringBuilder(tagElements[i3].sequence).reverse().toString();
                int len = tag.getContent().get(i3).asSequence().length();
                Integer[] modificationsList = new Integer[len];
                int ii = len - 1;
                if (tagElements[i3].modifications != null) {
                    Integer[] integerArray = tagElements[i3].modifications;
                    int n = integerArray.length;
                    for (int k = 0; k < n; ++k) {
                        int mod = integerArray[k];
                        modificationsList[ii--] = mod;
                    }
                }
                refTagContent[j] = new TagElement(tagElements[i3].isMass, sequenceReversed, tagElements[i3].mass, tagElements[i3].xNumLimit, modificationsList);
                --i3;
                ++j;
            }
            lessReversed = lessTablePrimary;
            lessPrimary = lessTableReversed;
            occurrenceReversed = occurrenceTablePrimary;
            occurrencePrimary = occurrenceTableReversed;
            hasCTermDirection = this.hasNTermDirectionModification;
            hasNTermDirection = this.hasCTermDirectionModification;
            towardsC = false;
        } else {
            refTagContent = tagElements;
            lessPrimary = lessTablePrimary;
            lessReversed = lessTableReversed;
            occurrencePrimary = occurrenceTablePrimary;
            occurrenceReversed = occurrenceTableReversed;
        }
        ArrayList cached = null;
        if (cached != null && cached.isEmpty()) {
            return allMatches;
        }
        TagElement[] tagComponents = new TagElement[maxSequencePosition];
        int i4 = maxSequencePosition - 1;
        int j = 0;
        while (i4 >= 0) {
            String sequenceReversed = new StringBuilder(refTagContent[i4].sequence).reverse().toString();
            tagComponents[j] = new TagElement(refTagContent[i4].isMass, sequenceReversed, refTagContent[i4].mass, refTagContent[i4].xNumLimit);
            --i4;
            ++j;
        }
        TagElement[] tagComponentsReverse = new TagElement[tagElements.length - maxSequencePosition];
        int i5 = maxSequencePosition;
        int j2 = 0;
        while (i5 < refTagContent.length) {
            tagComponentsReverse[j2] = refTagContent[i5];
            ++i5;
            ++j2;
        }
        TagElement[] combinations = this.createPeptideCombinations(tagComponents, sequenceMatchingPreferences);
        TagElement[] combinationsReversed = this.createPeptideCombinations(tagComponentsReverse, sequenceMatchingPreferences);
        LinkedList[] matrixReversed = new LinkedList[combinationsReversed.length + 1];
        LinkedList[] matrix = new LinkedList[combinations.length + 1];
        ArrayList<MatrixContent> cachePrimary = new ArrayList<MatrixContent>(3);
        for (i = 0; i <= combinationsReversed.length; ++i) {
            matrixReversed[i] = new LinkedList();
        }
        for (i = 0; i <= combinations.length; ++i) {
            matrix[i] = new LinkedList();
        }
        if (cached != null) {
            for (MatrixContent matrixContent : cached) {
                matrix[0].add(matrixContent);
            }
        } else {
            matrixReversed[0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
        }
        if (cached == null) {
            if (hasCTermDirection) {
                this.mappingSequenceAndMasses(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, towardsC);
            } else {
                this.mappingSequenceAndMasses(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
            }
            Iterator iterator = matrixReversed[combinationsReversed.length].iterator();
            while (iterator.hasNext()) {
                MatrixContent content;
                currentContent = content = (MatrixContent)iterator.next();
                currentPeptide = new StringBuilder(8);
                currentPeptideSearch = new StringBuilder(0);
                int leftIndexFront = 0;
                int rightIndexFront = this.indexStringLengths.get(indexPart) - 1;
                ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>(1);
                ArrayList<int[]> xComponents = new ArrayList<int[]>(0);
                HashMap<Integer, Double> xMassDiffs = new HashMap<Integer, Double>(0);
                while (currentContent.previousContent != null) {
                    int aminoAcid = currentContent.character;
                    if (aminoAcid > 0) {
                        int c = 0;
                        if (aminoAcid != DELIMITER) {
                            currentPeptide.append((char)currentContent.character);
                            int n = c = currentContent.ambiguousChar == -1 ? aminoAcid : currentContent.ambiguousChar;
                            if (currentContent.character == 88) {
                                xComponents.add(new int[]{0, currentContent.tagComponent, currentContent.length});
                                ((int[])xComponents.get((int)(xComponents.size() - 1)))[2] = currentContent.length;
                            }
                            currentPeptideSearch.append((char)c);
                        } else {
                            c = DELIMITER;
                        }
                        int lessValue = lessPrimary[c];
                        int[] range = occurrencePrimary.singleRangeQuery(leftIndexFront - 1, rightIndexFront, c);
                        leftIndexFront = lessValue + range[0];
                        rightIndexFront = lessValue + range[1] - 1;
                    }
                    if (currentContent.XMassDiff > -1.0) {
                        xMassDiffs.put(currentContent.tagComponent, currentContent.XMassDiff);
                    }
                    if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                        if (currentContent.modificationPos >= 0) {
                            if (this.modificationFlags[currentContent.modificationPos]) {
                                modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.length));
                            }
                        } else {
                            modifications.add(currentContent.modification);
                        }
                    }
                    currentContent = currentContent.previousContent;
                }
                Iterator<Serializable> reversePeptide = currentPeptide.reverse().toString();
                String reversePeptideSearch = currentPeptideSearch.reverse().toString();
                MatrixContent cell = new MatrixContent(leftIndexFront, rightIndexFront, (int)((String)((Object)reversePeptide)).charAt(0), null, 0.0, (String)((Object)reversePeptide), reversePeptideSearch, content.length, 0, 0, null, modifications, -1);
                cell.numPTMs = content.numPTMs;
                cell.allXcomponents = xComponents;
                cell.allXMassDiffs = xMassDiffs;
                cachePrimary.add(cell);
            }
            for (MatrixContent matrixContent : cachePrimary) {
                matrix[0].add(matrixContent);
            }
        }
        if (!matrix[0].isEmpty()) {
            if (hasNTermDirection) {
                this.mappingSequenceAndMasses(combinations, matrix, lessPrimary, occurrencePrimary, !towardsC);
            } else {
                this.mappingSequenceAndMasses(combinations, matrix, lessPrimary, occurrencePrimary);
            }
        }
        Iterator iterator = matrix[combinations.length].iterator();
        while (iterator.hasNext()) {
            MatrixContent content;
            currentContent = content = (MatrixContent)iterator.next();
            currentPeptide = new StringBuilder(8);
            currentPeptideSearch = new StringBuilder(0);
            ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>(1);
            ArrayList<int[]> xComponents = new ArrayList<int[]>(0);
            HashMap<Integer, Double> XmassDiffs = new HashMap<Integer, Double>(0);
            while (currentContent.previousContent != null) {
                if (currentContent.character != 0 && currentContent.character != DELIMITER) {
                    currentPeptide.append((char)currentContent.character);
                    currentPeptideSearch.append((char)(currentContent.ambiguousChar == -1 ? currentContent.character : currentContent.ambiguousChar));
                    if (currentContent.character == 88) {
                        xComponents.add(new int[]{1, currentContent.tagComponent, content.length - currentContent.length + 1});
                    }
                }
                if (currentContent.XMassDiff > -1.0) {
                    XmassDiffs.put(currentContent.tagComponent + 1024, currentContent.XMassDiff);
                }
                if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                    if (currentContent.modificationPos >= 0) {
                        if (this.modificationFlags[currentContent.modificationPos]) {
                            modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], content.length - currentContent.length + 1));
                        }
                    } else {
                        modifications.add(new ModificationMatch(currentContent.modification.getModification(), content.length - currentContent.modification.getSite() + 1));
                    }
                }
                currentContent = currentContent.previousContent;
            }
            int leftIndex = content.left;
            int rightIndex = content.right;
            for (int[] Xcomponent : currentContent.allXcomponents) {
                xComponents.add(new int[]{Xcomponent[0], Xcomponent[1], Xcomponent[2] + content.length - currentContent.length});
            }
            for (Integer key : currentContent.allXMassDiffs.keySet()) {
                XmassDiffs.put(key, currentContent.allXMassDiffs.get(key));
            }
            for (ModificationMatch modificationMatch : currentContent.modifications) {
                modifications.add(new ModificationMatch(modificationMatch.getModification(), modificationMatch.getSite() + content.length - currentContent.length));
            }
            StringBuilder peptide = new StringBuilder(currentPeptide.append(currentContent.peptideSequence));
            StringBuilder peptideSearch = new StringBuilder(currentPeptideSearch.append(currentContent.peptideSequenceSearch));
            if (turned) {
                leftIndex = 0;
                rightIndex = this.indexStringLengths.get(indexPart) - 1;
                for (int p = 0; p < peptideSearch.length(); ++p) {
                    char aminoAcid = peptideSearch.charAt(p);
                    int lessValue = lessReversed[aminoAcid];
                    int[] range = occurrenceReversed.singleRangeQuery(leftIndex - 1, rightIndex, aminoAcid);
                    leftIndex = lessValue + range[0];
                    rightIndex = lessValue + range[1] - 1;
                }
                for (ModificationMatch modificationMatch : modifications) {
                    modificationMatch.setSite(peptide.length() - modificationMatch.getSite() + 1);
                }
                for (int[] Xcomponent : xComponents) {
                    Xcomponent[2] = peptide.length() - Xcomponent[2] + 1;
                }
                peptide = peptide.reverse();
            }
            if (xComponents.isEmpty()) {
                for (int j3 = leftIndex; j3 <= rightIndex; ++j3) {
                    int pos = this.getTextPosition(j3, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, peptide.toString(), pos - this.boundaries.get(indexPart)[index], modifications.toArray(new ModificationMatch[modifications.size()]));
                    peptideProteinMapping.fmIndexPosition = j3;
                    if (!this.checkModificationPattern(peptideProteinMapping)) continue;
                    allMatches.add(peptideProteinMapping);
                }
                continue;
            }
            ArrayList xSets = new ArrayList();
            ArrayList<int[]> xOrigins = new ArrayList<int[]>();
            int nTag = -1;
            int nComponent = -1;
            for (int i6 = 0; i6 < xComponents.size(); ++i6) {
                if (nTag != ((int[])xComponents.get(i6))[0] || nComponent != ((int[])xComponents.get(i6))[1]) {
                    xOrigins.add(new int[]{((int[])xComponents.get(i6))[0], ((int[])xComponents.get(i6))[1]});
                    xSets.add(new ArrayList());
                    nTag = ((int[])xComponents.get(i6))[0];
                    nComponent = ((int[])xComponents.get(i6))[1];
                }
                ((ArrayList)xSets.get(xSets.size() - 1)).add(((int[])xComponents.get(i6))[2]);
            }
            LinkedList<String> substitutedPeptides = new LinkedList<String>();
            LinkedList<String> substitutedPeptidesTmp = new LinkedList<String>();
            substitutedPeptides.add(peptide.toString());
            LinkedList<ArrayList<ModificationMatch>> substitutedModifications = new LinkedList<ArrayList<ModificationMatch>>();
            LinkedList substitutedModificationsTmp = new LinkedList();
            substitutedModifications.add(modifications);
            for (int k = 0; k < xSets.size(); ++k) {
                ArrayList xPositions = (ArrayList)xSets.get(k);
                int len = xPositions.size();
                HashMap<String, int[][]> uniqueSubstitutions = new HashMap<String, int[][]>();
                int[] Xranges = this.computeMappingRanges((Double)XmassDiffs.get(((int[])xOrigins.get(k))[0] * 1024 + ((int[])xOrigins.get(k))[1]));
                ArrayList<int[]> possibleAAs = new ArrayList<int[]>();
                for (int i7 = Xranges[0]; i7 <= Xranges[1]; ++i7) {
                    if (this.massIndexMaps.get((int)i7).indexes.length != len) continue;
                    possibleAAs.add(this.massIndexMaps.get((int)i7).indexes);
                }
                int[][] permutations = this.allPermutations[len];
                for (int j4 = 0; j4 < possibleAAs.size(); ++j4) {
                    for (int i8 = 0; i8 < permutations.length; ++i8) {
                        String key = "";
                        for (int index : permutations[i8]) {
                            key = key + "-" + ((int[])possibleAAs.get(j4))[index];
                        }
                        int[][] zipped = new int[][]{permutations[i8], (int[])possibleAAs.get(j4)};
                        uniqueSubstitutions.put(key, zipped);
                    }
                }
                while (!substitutedPeptides.isEmpty()) {
                    String pep = (String)substitutedPeptides.removeLast();
                    ArrayList currentModifications = (ArrayList)substitutedModifications.removeLast();
                    char[] pepChars = pep.toCharArray();
                    Object object = uniqueSubstitutions.values().iterator();
                    while (object.hasNext()) {
                        int[][] uniquePermutations = (int[][])object.next();
                        ArrayList<ModificationMatch> newModifications = new ArrayList<ModificationMatch>();
                        for (ModificationMatch m : currentModifications) {
                            newModifications.add(new ModificationMatch(m.getModification(), m.getSite()));
                        }
                        for (int i9 = 0; i9 < uniquePermutations[0].length; ++i9) {
                            int pos = uniquePermutations[1][uniquePermutations[0][i9]];
                            pepChars[((Integer)xPositions.get((int)i9)).intValue() - 1] = (char)(pos & 0x7F);
                            if (!this.modificationFlags[pos]) continue;
                            newModifications.add(new ModificationMatch(this.modifictationLabels[pos], (Integer)xPositions.get(i9)));
                        }
                        substitutedPeptidesTmp.add(String.valueOf(pepChars));
                        substitutedModificationsTmp.add(newModifications);
                    }
                }
                while (!substitutedPeptidesTmp.isEmpty()) {
                    substitutedPeptides.add((String)substitutedPeptidesTmp.removeLast());
                    substitutedModifications.add((ArrayList<ModificationMatch>)substitutedModificationsTmp.removeLast());
                }
            }
            for (int i10 = 0; i10 < substitutedPeptides.size(); ++i10) {
                for (int j5 = leftIndex; j5 <= rightIndex; ++j5) {
                    int pos = this.getTextPosition(j5, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    ArrayList currenModifications = (ArrayList)substitutedModifications.get(i10);
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, (String)substitutedPeptides.get(i10), pos - this.boundaries.get(indexPart)[index], currenModifications.toArray(new ModificationMatch[currenModifications.size()]));
                    peptideProteinMapping.fmIndexPosition = j5;
                    if (!this.checkModificationPattern(peptideProteinMapping)) continue;
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    public ArrayList<PeptideProteinMapping> getProteinMappingWithVariants(Tag tag, SequenceMatchingParameters sequenceMatchingPreferences, int indexPart) {
        String currentPeptide;
        MatrixContent currentContent;
        HashSet<int[]>[] variantsPrimarySet;
        HashSet<int[]>[] variantsReversedSet;
        Rank variantPositionsPrimary;
        Rank variantPositionsReversed;
        WaveletTree occurrencePrimary;
        WaveletTree occurrenceReversed;
        int[] lessPrimary;
        int[] lessReversed;
        TagElement[] refTagContent;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int[] lessTableReversed = this.lessTablesReversed.get(indexPart);
        WaveletTree occurrenceTableReversed = this.occurrenceTablesReversed.get(indexPart);
        Rank variantPositionsListPrimary = null;
        Rank variantPositionsListReversed = null;
        HashSet<int[]>[] variantsListPrimary = null;
        HashSet<int[]>[] variantsListReversed = null;
        if (this.variantMatchingType == PeptideVariantsParameters.VariantType.FIXED) {
            variantPositionsListPrimary = this.variantBitsPrimary.get(indexPart);
            variantPositionsListReversed = this.variantBitsReversed.get(indexPart);
            variantsListPrimary = this.variantsPrimary.get(indexPart);
            variantsListReversed = this.variantsReversed.get(indexPart);
        }
        ArrayList<PeptideProteinMapping> allMatches = new ArrayList<PeptideProteinMapping>();
        double xLimit = sequenceMatchingPreferences.getLimitX();
        int maxSequencePosition = -1;
        TagElement[] tagElements = new TagElement[tag.getContent().size()];
        for (int i = 0; i < tag.getContent().size(); ++i) {
            if (tag.getContent().get(i) instanceof MassGap) {
                tagElements[i] = new TagElement(true, "", tag.getContent().get(i).getMass(), 0);
                continue;
            }
            if (tag.getContent().get(i) instanceof AminoAcidSequence) {
                int len = tag.getContent().get(i).asSequence().length();
                Integer[] modificationsList = new Integer[len];
                for (int ii = 0; ii < len; ++ii) {
                    modificationsList[ii] = -1;
                }
                for (ModificationMatch mm : ((AminoAcidSequence)tag.getContent().get(i)).getVariableModifications()) {
                    String modString = mm.getModification();
                    if (!this.modificationLabelsToId.containsKey(modString)) {
                        System.out.println("Warning: modification '" + modString + "' is not registered in FM index, will be ignored.");
                        continue;
                    }
                    int site = mm.getSite() - 1;
                    if (site < 0 || len <= site) {
                        System.out.println("Worninng: incorrect declaration of modification site.");
                        continue;
                    }
                    modificationsList[site] = this.modificationLabelsToId.get(modString);
                }
                tagElements[i] = new TagElement(false, tag.getContent().get(i).asSequence(), 0.0, (int)(xLimit * (double)tag.getContent().get(i).asSequence().length()), modificationsList);
                if (maxSequencePosition != -1 && tagElements[i].sequence.length() >= tagElements[i].sequence.length()) continue;
                maxSequencePosition = i;
                continue;
            }
            throw new UnsupportedOperationException("Unsupported tag in tag mapping for FM-Index.");
        }
        boolean turned = tagElements.length == 3 && tagElements[0].isMass && !tagElements[1].isMass && tagElements[2].isMass && tagElements[0].mass < tagElements[2].mass;
        boolean hasCTermDirection = this.hasCTermDirectionModification;
        boolean hasNTermDirection = this.hasNTermDirectionModification;
        boolean towardsC = true;
        if (turned) {
            refTagContent = new TagElement[tagElements.length];
            int i = tagElements.length - 1;
            int j = 0;
            while (i >= 0) {
                String sequenceReversed = new StringBuilder(tagElements[i].sequence).reverse().toString();
                int len = tag.getContent().get(i).asSequence().length();
                Integer[] modificationsList = new Integer[len];
                if (tagElements[i].modifications != null) {
                    int ii = len - 1;
                    Integer[] integerArray = tagElements[i].modifications;
                    int n = integerArray.length;
                    for (int k = 0; k < n; ++k) {
                        int mod = integerArray[k];
                        modificationsList[ii--] = mod;
                    }
                }
                refTagContent[j] = new TagElement(tagElements[i].isMass, sequenceReversed, tagElements[i].mass, tagElements[i].xNumLimit, modificationsList);
                --i;
                ++j;
            }
            lessReversed = lessTablePrimary;
            lessPrimary = lessTableReversed;
            occurrenceReversed = occurrenceTablePrimary;
            occurrencePrimary = occurrenceTableReversed;
            variantPositionsReversed = variantPositionsListPrimary;
            variantPositionsPrimary = variantPositionsListReversed;
            variantsReversedSet = variantsListPrimary;
            variantsPrimarySet = variantsListReversed;
            hasCTermDirection = this.hasNTermDirectionModification;
            hasNTermDirection = this.hasCTermDirectionModification;
            towardsC = false;
        } else {
            refTagContent = tagElements;
            lessPrimary = lessTablePrimary;
            lessReversed = lessTableReversed;
            occurrencePrimary = occurrenceTablePrimary;
            occurrenceReversed = occurrenceTableReversed;
            variantPositionsPrimary = variantPositionsListPrimary;
            variantPositionsReversed = variantPositionsListReversed;
            variantsPrimarySet = variantsListPrimary;
            variantsReversedSet = variantsListReversed;
        }
        ArrayList cached = null;
        if (cached != null && cached.isEmpty()) {
            return allMatches;
        }
        TagElement[] tagComponents = new TagElement[maxSequencePosition];
        int i = maxSequencePosition - 1;
        int j = 0;
        while (i >= 0) {
            String sequenceReversed = new StringBuilder(refTagContent[i].sequence).reverse().toString();
            tagComponents[j] = new TagElement(refTagContent[i].isMass, sequenceReversed, refTagContent[i].mass, refTagContent[i].xNumLimit);
            --i;
            ++j;
        }
        TagElement[] tagComponentsReverse = new TagElement[tagElements.length - maxSequencePosition];
        int i2 = maxSequencePosition;
        int j2 = 0;
        while (i2 < refTagContent.length) {
            tagComponentsReverse[j2] = refTagContent[i2];
            ++i2;
            ++j2;
        }
        TagElement[] combinations = this.createPeptideCombinations(tagComponents, sequenceMatchingPreferences);
        TagElement[] combinationsReversed = this.createPeptideCombinations(tagComponentsReverse, sequenceMatchingPreferences);
        int numErrors = 1;
        switch (this.variantMatchingType) {
            case GENERIC: {
                numErrors += this.maxNumberVariants;
                break;
            }
            case SPECIFIC: {
                numErrors += this.maxNumberDeletions + this.maxNumberInsertions + this.maxNumberSubstitutions;
                break;
            }
        }
        LinkedList[][] matrixReversed = new LinkedList[numErrors][combinationsReversed.length + 1];
        LinkedList[][] matrix = new LinkedList[numErrors][combinations.length + 1];
        ArrayList<MatrixContent> cachePrimary = new ArrayList<MatrixContent>();
        for (int k = 0; k < numErrors; ++k) {
            int j3;
            for (j3 = 0; j3 <= combinationsReversed.length; ++j3) {
                matrixReversed[k][j3] = new LinkedList();
            }
            for (j3 = 0; j3 <= combinations.length; ++j3) {
                matrix[k][j3] = new LinkedList();
            }
        }
        if (cached != null) {
            for (MatrixContent matrixContent : cached) {
                int error = 0;
                if (this.variantMatchingType == PeptideVariantsParameters.VariantType.GENERIC) {
                    error = matrixContent.numVariants;
                } else if (this.variantMatchingType == PeptideVariantsParameters.VariantType.SPECIFIC) {
                    error = matrixContent.numSpecificVariants[0] + matrixContent.numSpecificVariants[1] + matrixContent.numSpecificVariants[2];
                }
                matrix[error][0].add(matrixContent);
            }
        } else {
            matrixReversed[0][0].add(new MatrixContent(this.indexStringLengths.get(indexPart) - 1));
        }
        if (cached == null) {
            switch (this.variantMatchingType) {
                case GENERIC: {
                    if (!hasCTermDirection) {
                        this.mappingSequenceAndMassesWithVariantsGeneric(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
                        break;
                    }
                    this.mappingSequenceAndMassesWithVariantsGeneric(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, towardsC);
                    break;
                }
                case SPECIFIC: {
                    if (!hasCTermDirection) {
                        this.mappingSequenceAndMassesWithVariantsSpecific(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed);
                        break;
                    }
                    this.mappingSequenceAndMassesWithVariantsSpecific(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, towardsC);
                    break;
                }
                case FIXED: {
                    if (!hasCTermDirection) {
                        this.mappingSequenceAndMassesWithVariantsFixed(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, variantPositionsReversed, variantsReversedSet);
                        break;
                    }
                    this.mappingSequenceAndMassesWithVariantsFixed(combinationsReversed, matrixReversed, lessReversed, occurrenceReversed, variantPositionsReversed, variantsReversedSet, towardsC);
                }
            }
            for (int k = 0; k < numErrors; ++k) {
                Iterator matrixContent = matrixReversed[k][combinationsReversed.length].iterator();
                while (matrixContent.hasNext()) {
                    MatrixContent content;
                    currentContent = content = (MatrixContent)matrixContent.next();
                    currentPeptide = "";
                    int leftIndexFront = 0;
                    int rightIndexFront = this.indexStringLengths.get(indexPart) - 1;
                    ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
                    String allVariants = "";
                    while (currentContent.previousContent != null) {
                        int aminoAcidPep = currentContent.character;
                        int aminoAcidProt = currentContent.character;
                        char edit = currentContent.variant;
                        boolean update = true;
                        if (edit != '-') {
                            if (edit == '*') {
                                update = false;
                            } else if ('A' <= edit && edit <= 'Z') {
                                aminoAcidProt = edit;
                            } else if ('a' <= edit && edit <= 'z') {
                                aminoAcidProt = edit - 32;
                            }
                        }
                        if (aminoAcidPep > 0 && aminoAcidPep != DELIMITER) {
                            currentPeptide = currentPeptide + (char)aminoAcidPep;
                            allVariants = allVariants + (char)edit;
                            if (update) {
                                int lessValue = lessPrimary[aminoAcidProt];
                                int[] range = occurrencePrimary.singleRangeQuery(leftIndexFront - 1, rightIndexFront, aminoAcidProt);
                                leftIndexFront = lessValue + range[0];
                                rightIndexFront = lessValue + range[1] - 1;
                            }
                        }
                        if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                            if (currentContent.modificationPos >= 0) {
                                if (this.modificationFlags[currentContent.modificationPos]) {
                                    modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], currentContent.length));
                                }
                            } else {
                                modifications.add(currentContent.modification);
                            }
                        }
                        currentContent = currentContent.previousContent;
                    }
                    String reversePeptide = new StringBuilder(currentPeptide).reverse().toString();
                    allVariants = new StringBuilder(allVariants).reverse().toString();
                    if (this.variantMatchingType == PeptideVariantsParameters.VariantType.GENERIC) {
                        cachePrimary.add(new MatrixContent(leftIndexFront, rightIndexFront, (int)reversePeptide.charAt(0), null, 0.0, reversePeptide, content.length, 0, null, modifications, -1, k, '\u0000', allVariants));
                        continue;
                    }
                    cachePrimary.add(new MatrixContent(leftIndexFront, rightIndexFront, (int)reversePeptide.charAt(0), null, 0.0, reversePeptide, content.length, 0, null, modifications, -1, new int[]{content.numSpecificVariants[0], content.numSpecificVariants[1], content.numSpecificVariants[2]}, '\u0000', allVariants));
                }
            }
            for (MatrixContent matrixContent : cachePrimary) {
                int error = 0;
                if (this.variantMatchingType == PeptideVariantsParameters.VariantType.GENERIC) {
                    error = matrixContent.numVariants;
                } else if (this.variantMatchingType == PeptideVariantsParameters.VariantType.SPECIFIC) {
                    error = matrixContent.numSpecificVariants[0] + matrixContent.numSpecificVariants[1] + matrixContent.numSpecificVariants[2];
                }
                matrix[error][0].add(matrixContent);
            }
        }
        switch (this.variantMatchingType) {
            case GENERIC: {
                if (!hasNTermDirection) {
                    this.mappingSequenceAndMassesWithVariantsGeneric(combinations, matrix, lessPrimary, occurrencePrimary);
                    break;
                }
                this.mappingSequenceAndMassesWithVariantsGeneric(combinations, matrix, lessPrimary, occurrencePrimary, !towardsC);
                break;
            }
            case SPECIFIC: {
                if (!hasNTermDirection) {
                    this.mappingSequenceAndMassesWithVariantsSpecific(combinations, matrix, lessPrimary, occurrencePrimary);
                    break;
                }
                this.mappingSequenceAndMassesWithVariantsSpecific(combinations, matrix, lessPrimary, occurrencePrimary, !towardsC);
                break;
            }
            case FIXED: {
                if (!hasNTermDirection) {
                    this.mappingSequenceAndMassesWithVariantsFixed(combinations, matrix, lessPrimary, occurrencePrimary, variantPositionsPrimary, variantsPrimarySet);
                    break;
                }
                this.mappingSequenceAndMassesWithVariantsFixed(combinations, matrix, lessPrimary, occurrencePrimary, variantPositionsPrimary, variantsPrimarySet, !towardsC);
            }
        }
        for (int k = 0; k < numErrors; ++k) {
            Iterator iterator = matrix[k][combinations.length].iterator();
            while (iterator.hasNext()) {
                MatrixContent content;
                currentContent = content = (MatrixContent)iterator.next();
                currentPeptide = "";
                ArrayList<ModificationMatch> modifications = new ArrayList<ModificationMatch>();
                String allVariants = "";
                while (currentContent.previousContent != null) {
                    int aminoAcid = currentContent.character;
                    if (aminoAcid > 0 && aminoAcid != DELIMITER) {
                        currentPeptide = currentPeptide + (char)aminoAcid;
                        allVariants = allVariants + currentContent.variant;
                    }
                    if (currentContent.modification != null || currentContent.modificationPos >= 0) {
                        if (currentContent.modificationPos >= 0) {
                            if (this.modificationFlags[currentContent.modificationPos]) {
                                modifications.add(new ModificationMatch(this.modifictationLabels[currentContent.modificationPos], content.length - currentContent.length + 1));
                            }
                        } else {
                            modifications.add(new ModificationMatch(currentContent.modification.getModification(), currentContent.modification.getSite() + content.length - currentContent.length + 1));
                        }
                    }
                    currentContent = currentContent.previousContent;
                }
                int leftIndex = content.left;
                int rightIndex = content.right;
                for (ModificationMatch modificationMatch : currentContent.modifications) {
                    modifications.add(new ModificationMatch(modificationMatch.getModification(), modificationMatch.getSite() + content.length - currentContent.length));
                }
                String peptide = currentPeptide + currentContent.peptideSequence;
                allVariants = allVariants + currentContent.allVariants;
                HashMap<Integer, Variant> variants = new HashMap<Integer, Variant>(0);
                int lengthDifference = 0;
                if (turned) {
                    leftIndex = 0;
                    rightIndex = this.indexStringLengths.get(indexPart) - 1;
                    for (int p = 0; p < peptide.length(); ++p) {
                        boolean update = true;
                        int aminoAcid = peptide.charAt(p);
                        int edit = allVariants.charAt(p);
                        if (edit != 45) {
                            if (edit == 42) {
                                update = false;
                            } else if (65 <= edit && edit <= 90) {
                                aminoAcid = edit;
                            } else if (97 <= edit && edit <= 122) {
                                aminoAcid = edit - 32;
                            }
                        }
                        if (!update) continue;
                        int lessValue = lessReversed[aminoAcid];
                        int[] range = occurrenceReversed.singleRangeQuery(leftIndex - 1, rightIndex, aminoAcid);
                        leftIndex = lessValue + range[0];
                        rightIndex = lessValue + range[1] - 1;
                    }
                    for (ModificationMatch modificationMatch : modifications) {
                        modificationMatch.setSite(peptide.length() - modificationMatch.getSite() + 1);
                    }
                    allVariants = new StringBuilder(allVariants).reverse().toString();
                    peptide = new StringBuilder(peptide).reverse().toString();
                }
                int length = 0;
                for (int i3 = 0; i3 < allVariants.length(); ++i3) {
                    Variant variant;
                    char edit = allVariants.charAt(i3);
                    ++length;
                    if (edit == '-') continue;
                    if (edit == '*') {
                        variant = new Insertion(peptide.charAt(length - 1));
                        variants.put(length, variant);
                        --lengthDifference;
                        continue;
                    }
                    if ('A' <= edit && edit <= 'Z') {
                        variant = new Substitution(edit, peptide.charAt(length - 1));
                        variants.put(length, variant);
                        continue;
                    }
                    if ('a' > edit || edit > 'z') continue;
                    variant = new Deletion((char)(edit - 32));
                    variants.put(length, variant);
                    ++lengthDifference;
                    --length;
                }
                String cleanPeptide = peptide.replace("*", "");
                for (int j4 = leftIndex; j4 <= rightIndex; ++j4) {
                    int pos = this.getTextPosition(j4, indexPart);
                    int index = FMIndex.binarySearch(this.boundaries.get(indexPart), pos);
                    String accession = this.accessions.get(indexPart)[index];
                    int startPosition = pos - this.boundaries.get(indexPart)[index];
                    boolean newPeptide = true;
                    for (PeptideProteinMapping ppm : allMatches) {
                        if (!ppm.getProteinAccession().equals(accession) || !ppm.getPeptideSequence().equals(cleanPeptide) || Math.abs(ppm.getIndex() - startPosition) > numErrors) continue;
                        newPeptide = false;
                        break;
                    }
                    if (!newPeptide) continue;
                    PeptideVariantMatches peptideVariantMatches = variants.isEmpty() ? null : new PeptideVariantMatches(variants, lengthDifference);
                    PeptideProteinMapping peptideProteinMapping = new PeptideProteinMapping(accession, cleanPeptide, startPosition, modifications.toArray(new ModificationMatch[modifications.size()]), peptideVariantMatches);
                    peptideProteinMapping.fmIndexPosition = j4;
                    if (!this.checkModificationPattern(peptideProteinMapping)) continue;
                    allMatches.add(peptideProteinMapping);
                }
            }
        }
        return allMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstructFasta(File file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file), 0x100000);
            for (String accession : this.getAccessions()) {
                writer.write(">" + this.getHeaderAsString(accession) + "\n");
                writer.write(this.getSequence(accession) + "\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MatrixContent> isCached(TagElement[] tagComponents, int indexPart) {
        if (tagComponents.length != 3 || !tagComponents[0].isMass || tagComponents[1].isMass || !tagComponents[2].isMass) {
            return null;
        }
        ArrayList<MatrixContent> cached = null;
        Object object = cacheMutex;
        synchronized (object) {
            String key = tagComponents[1].sequence + String.format("%.5f", tagComponents[2].mass);
            CacheElement cacheElement = this.cache[indexPart].get(key);
            if (cacheElement != null) {
                cached = cacheElement.cachedPrimary;
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIt(TagElement[] tagComponents, ArrayList<MatrixContent> cachedPrimary, int indexPart) {
        if (tagComponents.length != 3 || !tagComponents[0].isMass || tagComponents[1].isMass || !tagComponents[2].isMass) {
            return;
        }
        Object object = cacheMutex;
        synchronized (object) {
            ArrayList<MatrixContent> cacheContentPrimary = new ArrayList<MatrixContent>();
            for (MatrixContent matrixContent : cachedPrimary) {
                cacheContentPrimary.add(new MatrixContent(matrixContent));
            }
            String key = tagComponents[1].sequence + String.format("%.5f", tagComponents[2].mass);
            CacheElement cacheElement = new CacheElement(tagComponents[0].mass, tagComponents[1].sequence, tagComponents[2].mass, cacheContentPrimary);
            if (!this.cache[indexPart].containsKey(key)) {
                this.cache[indexPart].put(key, cacheElement);
            }
        }
    }

    public char prefixCharacter(String proteinAccession, int index) {
        AccessionMetaData accessionMeta = this.accessionMetaData.get(proteinAccession);
        int indexPart = accessionMeta.indexPart;
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        return (char)occurrenceTablePrimary.getCharacterInfo(index)[0];
    }

    public char suffixCharacter(String proteinAccession, int index, int length) {
        AccessionMetaData accessionMeta = this.accessionMetaData.get(proteinAccession);
        int indexPart = accessionMeta.indexPart;
        int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
        WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
        int L = 0;
        for (int i = 0; i < length; ++i) {
            L = 0;
            int R = lessTablePrimary.length - 1;
            int m = -1;
            while (R - L > 1) {
                m = L + R >>> 1;
                if (lessTablePrimary[m] <= index) {
                    L = m;
                    continue;
                }
                R = m;
            }
            if (i >= length - 1) continue;
            index = occurrenceTablePrimary.select(index - lessTablePrimary[L], L);
        }
        return (char)L;
    }

    @Override
    public String getSequence(String proteinAccession) {
        AccessionMetaData accessionMeta = this.accessionMetaData.get(proteinAccession);
        if (accessionMeta != null) {
            int index = accessionMeta.index;
            int indexPart = accessionMeta.indexPart;
            int[] lessTablePrimary = this.lessTablesPrimary.get(indexPart);
            WaveletTree occurrenceTablePrimary = this.occurrenceTablesPrimary.get(indexPart);
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                int[] aminoInfo = occurrenceTablePrimary.getCharacterInfo(index);
                index = lessTablePrimary[aminoInfo[0]] + aminoInfo[1];
                if (aminoInfo[0] == DELIMITER) break;
                stringBuilder.append((char)aminoInfo[0]);
            }
            return stringBuilder.reverse().toString();
        }
        throw new UnsupportedOperationException("Protein accession '" + proteinAccession + "' not found in index.");
    }

    @Override
    public String getSubsequence(String accession, int start, int end) {
        String proteinSequence = this.getSequence(accession);
        int startI = Math.min(Math.max(start, 0), proteinSequence.length());
        int endI = Math.min(Math.max(end, 0), proteinSequence.length());
        return proteinSequence.substring(startI, endI);
    }

    @Override
    public Collection<String> getAccessions() {
        return this.accessions.stream().flatMap(f -> Arrays.stream(f)).collect(Collectors.toList());
    }

    @Override
    public HashSet<String> getDecoyAccessions() {
        return this.decoyAccessions;
    }

    public Header getHeader(String proteinAccession) {
        Header header = this.headerCache.get(proteinAccession);
        if (header == null) {
            AccessionMetaData accessionMeta = this.accessionMetaData.get(proteinAccession);
            String headerString = accessionMeta.getHeaderAsString();
            header = Header.parseFromFASTA(headerString);
            if (this.headerCache.size() >= 100000) {
                this.headerCache.clear();
            }
            this.headerCache.put(proteinAccession, header);
        }
        return header;
    }

    @Override
    public String getHeaderAsString(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getRawHeader();
    }

    @Override
    public String getDescription(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getDescription();
    }

    @Override
    public String getSimpleDescription(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getSimpleProteinDescription();
    }

    @Override
    public ProteinDatabase getProteinDatabase(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getDatabaseType();
    }

    @Override
    public String getGeneName(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getGeneName();
    }

    @Override
    public String getTaxonomy(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getTaxonomy();
    }

    @Override
    public String getOrganismIdentifier(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getOrganismIdentifier();
    }

    @Override
    public Integer getProteinEvidence(String proteinAccession) {
        Header header = this.getHeader(proteinAccession);
        return header.getProteinEvidence();
    }
}

